/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.AutoupdateClusterCreator;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.DownloadProgressPanel;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.PreparedModules;
import org.netbeans.modules.autoupdate.SignVerifier;
import org.netbeans.modules.autoupdate.Wizard;
import org.netbeans.updater.UpdateTracking;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class Downloader {
    DownloadProgressPanel progressDialog;
    private int downloadSize;
    private int totalDownloaded;
    private int moduleDownloaded;
    private long modulesCount;
    private boolean urlDownload;
    private static int TIME_TO_CONNECTION_CHECK = 20000;
    private static final String NBM_EXTENSION = "nbm";
    private Wizard.Validator validator;
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.Downloader");
    private static RequestProcessor.Task READ_TIMEOUT_CHECKER;
    private static RequestProcessor.Task DOWNLOAD_TASK;
    private static RequestProcessor AU_REQUEST_PROCESSOR;
    private static int DOWNLOADER_IS_INIT;
    private static int DOWNLOADER_RUNNING;
    private static int DOWNLOADER_WAITING;
    private static int DOWNLOADER_CANCELED;
    private static int DOWNLOADER_STOPPED;
    private static int DOWNLOADER_FINISHED;
    private static int DOWNLOADER_VERIFIED;
    private int downloadStatus = DOWNLOADER_IS_INIT;
    ProgressHandle partialHandle;
    ProgressHandle overallHandle;

    public Downloader(DownloadProgressPanel progressDialog, Wizard.Validator validator, boolean urlDownload) {
        this.validator = validator;
        this.progressDialog = progressDialog;
        this.urlDownload = urlDownload;
    }

    private static RequestProcessor getAutoupdateRequestProcessor() {
        if (AU_REQUEST_PROCESSOR == null) {
            AU_REQUEST_PROCESSOR = new RequestProcessor("org-netbeans-modules-autoupdate", 10, true);
        }
        return AU_REQUEST_PROCESSOR;
    }

    void doDownload() {
        if (READ_TIMEOUT_CHECKER != null) {
            READ_TIMEOUT_CHECKER.cancel();
        }
        assert (READ_TIMEOUT_CHECKER == null || READ_TIMEOUT_CHECKER.isFinished()) : "Only one READ_TIMEOUT_CHECKER can be active";
        if (DOWNLOAD_TASK != null) {
            DOWNLOAD_TASK.cancel();
            DOWNLOAD_TASK = null;
        }
        assert (DOWNLOAD_TASK == null || DOWNLOAD_TASK.isFinished()) : "Only one DOWNLOAD_TASK can be active";
        this.downloadSize = this.getTotalDownloadSize();
        this.progressDialog.setPartialLabel("");
        this.progressDialog.setOverallLabel("");
        this.progressDialog.setExtraLabel("");
        Runnable task = new Runnable(){

            public void run() {
                Downloader.this.progressDialog.setPartialLabel(Downloader.this.getBundle("CTL_PreparingDownload_Label"));
                err.log(Level.FINE, "Start downloading " + Downloader.this.modulesCount + " modules [" + Downloader.this.downloadSize + "]");
                Downloader.this.downloadAll();
                if (DOWNLOADER_STOPPED == Downloader.this.getStatus()) {
                    return;
                }
                Downloader.this.progressDialog.setExtraLabel(Downloader.this.getBundle("DownloadProgressPanel.jLabel1.doneText"));
                Downloader.this.validator.setValid(true);
            }
        };
        DOWNLOAD_TASK = Downloader.getAutoupdateRequestProcessor().post(task);
    }

    private int getTotalDownloadSize() {
        long result = 0L;
        this.modulesCount = 0L;
        for (ModuleUpdate mu : Wizard.getAllModules()) {
            if (!mu.isSelected() || mu.isDownloadOK()) continue;
            result += mu.getDownloadSize();
            ++this.modulesCount;
        }
        return (int)result;
    }

    private void downloadAll() {
        this.getPartialHandle(1);
        this.overallHandle = this.getOverallHandle(this.downloadSize);
        int currentModule = 0;
        this.totalDownloaded = 0;
        Iterator it = Wizard.getAllModules().iterator();
        while (it.hasNext()) {
            if (DOWNLOADER_STOPPED == this.getStatus()) {
                return;
            }
            ModuleUpdate mu = (ModuleUpdate)it.next();
            if (!mu.isSelected() || mu.isDownloadOK()) continue;
            this.progressDialog.setPartialLabel(mu.getName() + " [" + (currentModule + 1) + "/" + this.modulesCount + "]");
            if (this.urlDownload) {
                if (DOWNLOADER_FINISHED == this.getStatus() || DOWNLOADER_IS_INIT == this.getStatus()) {
                    err.log(Level.FINE, "Do download " + mu.getName());
                    this.setStatus(DOWNLOADER_IS_INIT);
                    this.downloadModule(mu);
                    err.log(Level.FINE, "Download of " + mu.getName() + " ends with status " + this.getStatus());
                } else {
                    err.log(Level.FINE, "Don't download " + mu.getName() + " due to incorrect status " + this.getStatus());
                }
            } else {
                this.downloadModuleFromLocal(mu);
            }
            this.updateOverall();
            if (this.partialHandle == null || !mu.isDownloadOK()) continue;
            this.partialHandle.finish();
            ++currentModule;
        }
        if (DOWNLOADER_STOPPED == this.getStatus()) {
            return;
        }
        this.overallHandle.progress(this.downloadSize);
        this.overallHandle.finish();
        String mssgTotal = MessageFormat.format(this.getBundle("FMT_DownloadedTotal"), new Integer(this.downloadSize / 1024), new Integer(this.downloadSize / 1024));
        this.progressDialog.setOverallLabel(mssgTotal);
        this.progressDialog.setEnableStop(false);
        this.runVerifier();
    }

    private void runVerifier() {
        err.log(Level.FINE, "Prepare SignVerifier.");
        if (DOWNLOADER_VERIFIED == this.getStatus()) {
            err.log(Level.FINE, "Error: SignVerifier has run before.");
            return;
        }
        SignVerifier signVerifier = new SignVerifier(this.progressDialog, this.validator);
        this.progressDialog.setExtraLabel(this.getBundle("DownloadProgressPanel.jLabel1.securityText"));
        signVerifier.doVerify();
        this.setStatus(DOWNLOADER_VERIFIED);
    }

    private int getStatus() {
        return this.downloadStatus;
    }

    private void setStatus(int status) {
        this.downloadStatus = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ioCopy(BufferedInputStream in, BufferedOutputStream out, int flen) throws IOException {
        try {
            int c;
            if (DOWNLOADER_IS_INIT == this.getStatus()) {
                this.setStatus(DOWNLOADER_RUNNING);
            }
            while ((DOWNLOADER_RUNNING == this.getStatus() || DOWNLOADER_WAITING == this.getStatus()) && (c = in.read()) != -1) {
                if (READ_TIMEOUT_CHECKER.getDelay() == 0) {
                    READ_TIMEOUT_CHECKER.waitFinished();
                } else if (READ_TIMEOUT_CHECKER.getDelay() < TIME_TO_CONNECTION_CHECK) {
                    READ_TIMEOUT_CHECKER.schedule(TIME_TO_CONNECTION_CHECK * 2);
                }
                out.write(c);
                ++this.moduleDownloaded;
                ++this.totalDownloaded;
                if (this.moduleDownloaded % 4096 != 0) continue;
                this.updateOverall();
                this.partialHandle.progress(this.moduleDownloaded < flen ? this.moduleDownloaded : flen);
            }
            if (DOWNLOADER_RUNNING == this.getStatus()) {
                this.setStatus(DOWNLOADER_FINISHED);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadModule(final ModuleUpdate moduleUpdate) {
        int flen = 0;
        File destFile = Downloader.getNBM(moduleUpdate);
        try {
            this.moduleDownloaded = 0;
            this.partialHandle = this.getPartialHandle(1);
            moduleUpdate.setDownloadStarted(true);
            this.progressDialog.setEnableStop(true);
            err.log(Level.FINE, "Setup checker of download " + moduleUpdate.getName());
            READ_TIMEOUT_CHECKER = Downloader.getAutoupdateRequestProcessor().post(new Runnable(){

                public void run() {
                    Downloader.this.confirmConnectionFailed(moduleUpdate);
                }
            }, TIME_TO_CONNECTION_CHECK * 4);
            err.log(Level.FINE, "Try to estabilish a conncetion to " + moduleUpdate.getDistribution());
            this.progressDialog.setExtraLabel(this.getBundle("DownloadProgressPanel.jLabel1.Establish"));
            URLConnection distrConnection = moduleUpdate.getDistribution().openConnection();
            moduleUpdate.setRemoteDistributionFilename(distrConnection);
            BufferedInputStream bsrc = new BufferedInputStream(distrConnection.getInputStream());
            BufferedOutputStream bdest = new BufferedOutputStream(new FileOutputStream(destFile));
            flen = distrConnection.getContentLength();
            if (flen == -1) {
                flen = (int)moduleUpdate.getDownloadSize();
            }
            assert (flen > 0) : "Content of distrConnection of update " + moduleUpdate.getName() + " must be known and more then 0, but was " + flen;
            this.partialHandle = this.getPartialHandle(flen);
            this.progressDialog.setExtraLabel(this.getBundle("DownloadProgressPanel.jLabel1.downloadText"));
            try {
                this.ioCopy(bsrc, bdest, flen);
                if (DOWNLOADER_FINISHED == this.getStatus()) {
                    moduleUpdate.setDownloadOK(true);
                    err.log(Level.FINE, moduleUpdate.getName() + " was downloaded correctly.");
                } else {
                    moduleUpdate.setDownloadOK(false);
                    err.log(Level.FINE, moduleUpdate.getName() + " wasn't download correctly.");
                    moduleUpdate.setSecurity(0);
                }
                moduleUpdate.setDownloadStarted(false);
                READ_TIMEOUT_CHECKER.cancel();
            }
            finally {
                if (DOWNLOADER_FINISHED != this.getStatus()) {
                    Downloader.getNBM(moduleUpdate).delete();
                }
            }
        }
        catch (IOException e) {
            if (DOWNLOADER_STOPPED == this.getStatus()) {
                return;
            }
            this.validator.setValid(false);
            err.log(Level.INFO, null, e);
            this.confirmConnectionFailed(moduleUpdate);
        }
    }

    private void confirmConnectionFailed(ModuleUpdate moduleUpdate) {
        if (DOWNLOADER_RUNNING != this.getStatus() && DOWNLOADER_IS_INIT != this.getStatus()) {
            return;
        }
        err.log(Level.FINE, "Connection failed during download " + moduleUpdate.getName());
        this.setStatus(DOWNLOADER_WAITING);
        String mssg = NbBundle.getMessage(Downloader.class, (String)"FMT_DownloadFailed", (Object)moduleUpdate.getName());
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, this.getBundle("CTL_DownloadFailed"), 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (nd.getValue().equals(NotifyDescriptor.CANCEL_OPTION)) {
            err.log(Level.FINE, "Confirm of the failed connection was canceled, continue downloading.");
            this.setStatus(DOWNLOADER_RUNNING);
            moduleUpdate.setDownloadStarted(true);
            moduleUpdate.setSecurity(0);
            if (READ_TIMEOUT_CHECKER != null) {
                READ_TIMEOUT_CHECKER.cancel();
                READ_TIMEOUT_CHECKER.schedule(TIME_TO_CONNECTION_CHECK * 2);
            }
            this.validator.setValid(false);
            return;
        }
        if (nd.getValue().equals(NotifyDescriptor.NO_OPTION)) {
            err.log(Level.FINE, "Interrupt download of " + moduleUpdate.getName());
            this.validator.setValid(true);
            this.setStatus(DOWNLOADER_CANCELED);
            moduleUpdate.setDownloadOK(false);
            moduleUpdate.setDownloadStarted(false);
            this.progressDialog.setExtraLabel(this.getBundle("DownloadProgressPanel.jLabel1.Broken"));
            moduleUpdate.setSecurity(0);
            DOWNLOAD_TASK.cancel();
            READ_TIMEOUT_CHECKER.cancel();
            this.runVerifier();
            return;
        }
        READ_TIMEOUT_CHECKER.cancel();
        DOWNLOAD_TASK.cancel();
        this.setStatus(DOWNLOADER_STOPPED);
        moduleUpdate.setDownloadStarted(false);
        err.log(Level.FINE, "Failed connection was confirmed, start download " + moduleUpdate.getName() + " again.");
        this.progressDialog.setExtraLabel(this.getBundle("DownloadProgressPanel.jLabel1.Restart"));
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                new Downloader(Downloader.this.progressDialog, Downloader.this.validator, Downloader.this.urlDownload).doDownload();
            }
        }, 100);
    }

    private void downloadModuleFromLocal(ModuleUpdate moduleUpdate) {
        this.partialHandle = this.getPartialHandle(1);
        if (Downloader.downloadFromLocal(moduleUpdate)) {
            this.totalDownloaded = (int)((long)this.totalDownloaded + moduleUpdate.getDownloadSize());
        }
        this.updateOverall();
    }

    private void updateOverall() {
        String mssgTotal = NbBundle.getMessage(Downloader.class, (String)"FMT_DownloadedTotal", (Object[])new Object[]{new Integer(this.totalDownloaded / 1024), new Integer(this.downloadSize / 1024)});
        this.overallHandle.progress(this.downloadSize > this.totalDownloaded ? this.totalDownloaded : this.downloadSize);
        this.progressDialog.setOverallLabel(mssgTotal);
    }

    private ProgressHandle getPartialHandle(int units) {
        assert (units >= 0) : "Count of units " + units + " must be positive.";
        assert (this.progressDialog != null);
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)this.getBundle("DownloadProgressPanel_partialHandle_name"));
        handle.setInitialDelay(0);
        this.progressDialog.setPartialProgressComponent(handle);
        handle.start(units);
        return handle;
    }

    private ProgressHandle getOverallHandle(int units) {
        assert (units >= 0) : "Count of units " + units + " must be positive.";
        assert (this.progressDialog != null);
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)this.getBundle("DownloadProgressPanel_overallHandle_name"));
        handle.setInitialDelay(0);
        this.progressDialog.setOverallProgressComponent(handle);
        handle.start(units);
        return handle;
    }

    void cancelDownload() {
        this.setStatus(DOWNLOADER_STOPPED);
        this.validator.setValid(false);
    }

    static boolean downloadFromLocal(ModuleUpdate moduleUpdate) {
        if (Downloader.tryCopy(moduleUpdate.getDistributionFile(), Downloader.getNBM(moduleUpdate))) {
            moduleUpdate.setDownloadOK(true);
            return true;
        }
        Downloader.getNBM(moduleUpdate).delete();
        return false;
    }

    static File getNBM(ModuleUpdate mu) {
        File destFile = new File(Autoupdater.Support.getDownloadDirectory(null), mu.getDistributionFilename());
        return destFile;
    }

    static File getMovedNBM(ModuleUpdate mu) {
        File destFile = null;
        destFile = mu.isToInstallDir() ? Autoupdater.Support.getDownloadDirectory(mu.findInstallDirectory()) : Autoupdater.Support.getDownloadDirectory(null);
        return new File(destFile, mu.getDistributionFilename());
    }

    static boolean tryMove(ModuleUpdate mu) {
        block9: {
            File toCluster = mu.findInstallDirectory();
            boolean existingCluster = false;
            for (File f : UpdateTracking.clusters((boolean)true)) {
                if (!f.equals(toCluster)) continue;
                existingCluster = true;
                break;
            }
            if (!existingCluster) {
                for (AutoupdateClusterCreator a : Lookup.getDefault().lookupAll(AutoupdateClusterCreator.class)) {
                    File[] allClusters;
                    if (!toCluster.equals(a.findCluster(toCluster.getName()))) continue;
                    try {
                        allClusters = a.registerCluster(toCluster.getName(), toCluster);
                    }
                    catch (IOException ex) {
                        return false;
                    }
                    StringBuffer sb = new StringBuffer();
                    String sep = "";
                    for (int i = 0; i < allClusters.length; ++i) {
                        sb.append(sep);
                        sb.append(allClusters[i].getPath());
                        sep = File.pathSeparator;
                    }
                    System.setProperty("netbeans.dirs", sb.toString());
                    break block9;
                }
                assert (false);
            }
        }
        File inst = new File(Autoupdater.Support.getDownloadDirectory(mu.findInstallDirectory()), mu.getDistributionFilename());
        boolean ok = Downloader.getNBM(mu).renameTo(inst);
        if (ok) {
            return true;
        }
        ok = Downloader.tryCopy(Downloader.getNBM(mu), inst);
        if (ok) {
            Downloader.getNBM(mu).delete();
        }
        return ok;
    }

    static void saveCopy(ModuleUpdate mu, File target) {
        Downloader.tryCopy(Downloader.getNBM(mu), target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryCopy(File src, File dest) {
        BufferedInputStream bsrc = null;
        FilterOutputStream bdest = null;
        try {
            try {
                int c;
                bsrc = new BufferedInputStream(new FileInputStream(src), 4096);
                bdest = new BufferedOutputStream(new FileOutputStream(dest), 4096);
                while ((c = bsrc.read()) != -1) {
                    ((BufferedOutputStream)bdest).write(c);
                }
            }
            finally {
                if (bsrc != null) {
                    bsrc.close();
                }
                if (bdest != null) {
                    bdest.close();
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    static void deleteModuleNBM(ModuleUpdate mu) {
        Downloader.getNBM(mu).delete();
    }

    static void deleteDownload() {
        boolean noTestPrepared = true;
        PreparedModules prepared = null;
        List clusters = UpdateTracking.clusters((boolean)true);
        assert (clusters != null) : "Clusters cannot be empty.";
        Iterator it = clusters.iterator();
        while (it.hasNext()) {
            if (!Autoupdater.Support.getInstall_Later((File)it.next()).exists()) continue;
            noTestPrepared = false;
            prepared = PreparedModules.getPrepared();
        }
        File[] nbms = Downloader.getNBMFiles();
        for (int i = 0; i < nbms.length; ++i) {
            if (!noTestPrepared && prepared.hasNBM(nbms[i].getName())) continue;
            nbms[i].delete();
        }
    }

    static boolean bannedWriteToInstall(ModuleUpdate mu) {
        File f = mu.findInstallDirectory();
        return f == null || !f.canWrite();
    }

    private static File[] getNBMFiles() {
        File[] dirList = Autoupdater.Support.getDownloadDirectory(null).listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(Downloader.NBM_EXTENSION);
            }
        });
        return dirList;
    }

    private String getBundle(String key) {
        return NbBundle.getMessage(Downloader.class, (String)key);
    }

    static {
        AU_REQUEST_PROCESSOR = null;
        DOWNLOADER_IS_INIT = -1;
        DOWNLOADER_RUNNING = 0;
        DOWNLOADER_WAITING = 1;
        DOWNLOADER_CANCELED = 2;
        DOWNLOADER_STOPPED = 3;
        DOWNLOADER_FINISHED = 4;
        DOWNLOADER_VERIFIED = 5;
    }
}

