/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.netbeans.modules.autoupdate.AutoupdateClusterCreator;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.netbeans.modules.autoupdate.DummyModuleInfo;
import org.netbeans.modules.autoupdate.IdeDescription;
import org.netbeans.modules.autoupdate.L10NUpdate;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.XMLAutoupdateType;
import org.netbeans.updater.UpdateTracking;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.modules.ModuleInfo;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ModuleUpdate
implements Node.Cookie {
    private static final String ATTR_HOMEPAGE = "homepage";
    private static final String ATTR_DISTRIBUTION = "distribution";
    private static final String ATTR_CODENAMEBASE = "codenamebase";
    private static final String ATTR_DOWNLOAD_SIZE = "downloadsize";
    private static final String ATTR_UNPACKED_SIZE = "unpacksize";
    private static final String ATTR_LICENSE = "license";
    private static final String ATTR_LICENSE_MISSPELLED = "licence";
    private static final String ATTR_PURCHASED = "purchased";
    private static final String ATTR_NEEDSRESTART = "needsrestart";
    private static final String ATTR_AUTHOR = "moduleauthor";
    private static final String ATTR_RELEASE_DATE = "releasedate";
    private static final String ATTR_IS_GLOBAL = "global";
    private static final String ATTR_TARGET_CLUSTER = "targetcluster";
    static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_NOTIFICATION = "module_notification";
    private static final String ELEMENT_EXTERNAL = "external_package";
    static final String ELEMENT_L10N = "l10n";
    private static final String ATTR_EXT_NAME = "name";
    private static final String ATTR_EXT_TARGET = "target_name";
    private static final String ATTR_EXT_URL = "start_url";
    private static final String ATTR_EXT_DESC = "description";
    static final String NBM_LIB = "lib";
    static final String NBM_CORE = "core";
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.autoupdate.ModuleUpdate");
    private URL xmlURL;
    private Node node;
    private Element documentElement;
    private File nbmFile;
    private URL distribution = null;
    private URL homepage = null;
    private String infoCodenamebase = null;
    private long downloadSize = -1L;
    private long unpackedSize = -1L;
    private boolean downloadOK = false;
    private String description = null;
    private String licenceID = null;
    private String licenceText = null;
    private boolean selected = false;
    private int security = -1;
    private Collection certs = null;
    private boolean installApproved = false;
    private ModuleInfo localModule = null;
    private ModuleInfo remoteModule = null;
    private boolean purchased = false;
    private String notification = null;
    private String moduleAuthor = null;
    private Date releaseDate = null;
    private boolean notificationAccepted = false;
    private String distributionFilename = null;
    private List externals;
    private boolean depending;
    private boolean toInstallDir;
    private boolean downloadStarted;
    private boolean safeToInstall;
    private Boolean isGlobal;
    private String targetCluster;
    private List jarList = new ArrayList();
    private File target;

    ModuleUpdate(URL xmlURL, Node node, Element documentElement) {
        this.xmlURL = xmlURL;
        this.node = node;
        this.documentElement = documentElement;
    }

    ModuleUpdate(File nbmFile, Node node, Element documentElement) {
        this.nbmFile = nbmFile;
        this.node = node;
        this.documentElement = documentElement;
    }

    static ModuleUpdate getModuleUpdate(URL xmlURL, Node node, Element documentElement, AutoupdateType at) {
        NodeList nodeList = ((Element)node).getElementsByTagName(ELEMENT_L10N);
        ModuleUpdate mod = nodeList != null && nodeList.getLength() > 0 ? new L10NUpdate(xmlURL, node, documentElement) : new ModuleUpdate(xmlURL, node, documentElement);
        if (mod.readModuleUpdate(at)) {
            return mod;
        }
        return null;
    }

    private static String getMessage(String key, String p1) {
        return NbBundle.getMessage(ModuleUpdate.class, (String)key, (Object)p1);
    }

    /*
     * Exception decompiling
     */
    static ModuleUpdate getModuleUpdate(File nbmFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean readModuleUpdate(AutoupdateType at) {
        try {
            String textURL = this.getAttribute(ATTR_HOMEPAGE);
            if (textURL != null) {
                this.homepage = new URL(this.xmlURL, textURL);
            }
        }
        catch (MalformedURLException e) {
            LOG.log(Level.WARNING, null, e);
        }
        this.setInfoCodenamebase(this.getAttribute(ATTR_CODENAMEBASE));
        try {
            this.setDownloadSize(Long.parseLong(this.getAttribute(ATTR_DOWNLOAD_SIZE)));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.setUnpackedSize(Long.parseLong(this.getAttribute(ATTR_UNPACKED_SIZE)));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.setDescription(this.getTextOfElement("description"));
        this.setNotification(this.getTextOfElement(ELEMENT_NOTIFICATION));
        List ext = this.externalFromXML();
        if (ext != null) {
            this.externals = ext;
        }
        try {
            String textURL = this.getAttribute(ATTR_DISTRIBUTION);
            if (textURL != null) {
                String sURL = this.xmlURL.toString();
                int qmark = sURL.indexOf(63);
                this.distribution = qmark > -1 && qmark < sURL.lastIndexOf(47) ? new URL(new URL(sURL.substring(0, qmark)), textURL) : new URL(this.xmlURL, textURL);
                if (at instanceof XMLAutoupdateType) {
                    this.distribution = ((XMLAutoupdateType)at).modifyURL(this.distribution);
                }
            }
        }
        catch (MalformedURLException e) {
            LOG.log(Level.WARNING, null, e);
        }
        this.purchased = Boolean.valueOf(this.getAttribute(ATTR_PURCHASED));
        this.processNeedsRestart();
        this.processIsGlobal();
        this.processTargetCluster();
        this.readReleaseDate();
        this.readModuleAuthor();
        try {
            this.remoteModule = this.readRemoteInfo();
        }
        catch (IllegalArgumentException e) {
            LOG.log(Level.WARNING, null, e);
        }
        this.licenceID = this.getAttribute(ATTR_LICENSE);
        if (this.licenceID == null) {
            this.licenceID = this.getAttribute(ATTR_LICENSE_MISSPELLED);
        }
        this.licenceText = this.licenseFromXML(this.licenceID, this.documentElement);
        this.localModule = this.readLocalInfo();
        return this.remoteModule != null;
    }

    ModuleInfo readRemoteInfo() throws IllegalArgumentException {
        String longDesc;
        Manifest mf = this.manifestFromXML();
        if ((this.description == null || this.description.equals("")) && (longDesc = mf.getMainAttributes().getValue("OpenIDE-Module-Long-Description")) != null) {
            this.description = longDesc;
        }
        return new DummyModuleInfo(mf.getMainAttributes());
    }

    ModuleInfo readLocalInfo() {
        ModuleInfo localinfo = null;
        ModuleInfo[] installedModules = Updates.getInstalledModules();
        ModuleInfo[] installedPatches = Updates.getInstalledPatches();
        if (this.remoteModule != null) {
            int i;
            if (this.remoteModule.getCodeName().equals(IdeDescription.getName())) {
                localinfo = IdeDescription.getIdeDescription();
            }
            for (i = 0; this.localModule == null && i < installedModules.length; ++i) {
                if (!installedModules[i].getCodeNameBase().equals(this.remoteModule.getCodeNameBase())) continue;
                localinfo = installedModules[i];
                break;
            }
            for (i = 0; this.localModule == null && i < installedPatches.length; ++i) {
                if (!installedPatches[i].getCodeNameBase().equals(this.remoteModule.getCodeNameBase())) continue;
                localinfo = installedPatches[i];
                break;
            }
        }
        return localinfo;
    }

    private static ZipEntry getLocalizedInfo(JarFile jf) {
        String locale = Locale.getDefault().getLanguage();
        ZipEntry info = jf.getEntry("Info/locale/info_" + locale + ".xml");
        if (info == null) {
            info = jf.getEntry("Info/info.xml");
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createFromDistribution() {
        Document document = null;
        JarFile jf = null;
        try {
            jf = new JarFile(this.nbmFile);
            ZipEntry info = ModuleUpdate.getLocalizedInfo(jf);
            if (info == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ModuleUpdate.class, (String)"MSG_NoInfoXml", (Object)this.nbmFile.getName()), 0));
                boolean bl = false;
                return bl;
            }
            InputStream is = jf.getInputStream(info);
            InputSource xmlInputSource = new InputSource(is);
            document = XMLUtil.parse((InputSource)xmlInputSource, (boolean)false, (boolean)false, (ErrorHandler)new ErrorCatcher(), (EntityResolver)org.netbeans.updater.XMLUtil.createAUResolver());
            this.documentElement = document.getDocumentElement();
            this.node = this.documentElement;
        }
        catch (SAXException e) {
            Exceptions.attachMessage((Throwable)e, (String)("Bad info : " + this.nbmFile.getName()));
            LOG.log(Level.WARNING, null, e);
            boolean is = false;
            return is;
        }
        catch (IOException e) {
            Exceptions.attachMessage((Throwable)e, (String)("Missing info : " + this.nbmFile.getName()));
            LOG.log(Level.WARNING, null, e);
            boolean is = false;
            return is;
        }
        finally {
            try {
                if (jf != null) {
                    jf.close();
                }
            }
            catch (IOException ie) {}
        }
        try {
            String textURL = this.getAttribute(ATTR_HOMEPAGE);
            if (textURL != null && textURL.length() > 0) {
                this.homepage = new URL(textURL);
            }
        }
        catch (MalformedURLException e) {
            LOG.log(Level.WARNING, null, e);
        }
        this.setInfoCodenamebase(this.getAttribute(ATTR_CODENAMEBASE));
        this.setDownloadSize(this.nbmFile.length());
        this.setDescription(this.getTextOfElement("description"));
        this.setNotification(this.getTextOfElement(ELEMENT_NOTIFICATION));
        List ext = this.externalFromXML();
        if (ext != null) {
            this.externals = ext;
        }
        this.purchased = Boolean.valueOf(this.getAttribute(ATTR_PURCHASED));
        this.processNeedsRestart();
        this.processIsGlobal();
        this.processTargetCluster();
        this.readReleaseDate();
        this.readModuleAuthor();
        try {
            this.remoteModule = this.readRemoteInfo();
        }
        catch (IllegalArgumentException e) {
            LOG.log(Level.WARNING, null, e);
        }
        this.licenceID = this.getAttribute(ATTR_LICENSE);
        if (this.licenceID == null) {
            this.licenceID = this.getAttribute(ATTR_LICENSE_MISSPELLED);
        }
        this.licenceText = this.licenseFromXML(this.licenceID, this.documentElement);
        this.localModule = this.readLocalInfo();
        return this.remoteModule != null;
    }

    void resolveInstalledModule(Collection installedModules) {
    }

    private void readReleaseDate() {
        String attr = this.getAttribute(ATTR_RELEASE_DATE);
        if (attr != null) {
            try {
                this.setReleaseDate(DATE_FORMAT.parse(attr));
            }
            catch (ParseException pe) {
                LOG.log(Level.WARNING, null, pe);
            }
        }
    }

    private void readModuleAuthor() {
        this.setModuleAuthor(this.getAttribute(ATTR_AUTHOR));
    }

    private void processNeedsRestart() {
        String attr = this.getAttribute(ATTR_NEEDSRESTART);
        if (attr != null && Boolean.FALSE.toString().equals(attr.toLowerCase())) {
            this.setSafeToInstall(true);
        }
    }

    private void processIsGlobal() {
        String attr = this.getAttribute(ATTR_IS_GLOBAL);
        if (attr != null) {
            if (Boolean.TRUE.toString().equals(attr.toLowerCase())) {
                this.isGlobal = Boolean.TRUE;
            } else if (Boolean.FALSE.toString().equals(attr.toLowerCase())) {
                this.isGlobal = Boolean.FALSE;
            }
        }
    }

    private void processTargetCluster() {
        String attr = this.getAttribute(ATTR_TARGET_CLUSTER);
        if (attr != null) {
            Pattern p = Pattern.compile(attr);
            for (File f : UpdateTracking.clusters((boolean)false)) {
                if (!p.matcher(f.getName()).matches()) continue;
                this.targetCluster = f.getName();
                return;
            }
            Iterator it = Lookup.getDefault().lookupAll(AutoupdateClusterCreator.class).iterator();
            while (it.hasNext() && this.targetCluster == null) {
                AutoupdateClusterCreator creator = (AutoupdateClusterCreator)it.next();
                File f = creator.findCluster(attr);
                if (f == null) continue;
                this.targetCluster = f.getName();
                return;
            }
        }
    }

    String getCodeNameBase() {
        return this.remoteModule.getCodeNameBase();
    }

    String getName() {
        return this.remoteModule.getDisplayName();
    }

    URL getDistribution() {
        return this.distribution;
    }

    void setRemoteDistributionFilename(URLConnection distrConnection) {
        if (this.distributionFilename == null) {
            String s = distrConnection.getURL().getFile();
            int i = s.indexOf(63);
            if (i > 0) {
                s = s.substring(0, i);
            }
            if ((i = s.lastIndexOf(47)) > 0 && i < s.length() - 1) {
                s = s.substring(i + 1);
            }
            this.distributionFilename = s;
        }
    }

    String getDistributionFilename() {
        if (this.distributionFilename == null) {
            if (this.nbmFile != null) {
                this.distributionFilename = this.nbmFile.getName();
            } else {
                try {
                    URLConnection distrConnection = this.getDistribution().openConnection();
                    this.setRemoteDistributionFilename(distrConnection);
                }
                catch (IOException e) {
                    this.distributionFilename = new File(this.getDistribution().getFile()).getName();
                }
            }
        }
        return this.distributionFilename;
    }

    String getLicenceID() {
        return this.licenceID;
    }

    public String getInfoCodenamebase() {
        return this.infoCodenamebase;
    }

    void setInfoCodenamebase(String infoCodenamebase) {
        this.infoCodenamebase = infoCodenamebase;
    }

    long getDownloadSize() {
        return this.downloadSize;
    }

    void setDownloadSize(long downloadSize) {
        this.downloadSize = downloadSize;
    }

    long getUnpackedSize() {
        return this.unpackedSize;
    }

    void setUnpackedSize(long unpackedSize) {
        this.unpackedSize = unpackedSize;
    }

    String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    String getModuleAuthor() {
        return this.moduleAuthor;
    }

    void setModuleAuthor(String author) {
        this.moduleAuthor = author;
    }

    Date getReleaseDate() {
        return this.releaseDate;
    }

    void setReleaseDate(Date date) {
        this.releaseDate = date;
    }

    String getNotification() {
        return this.notification;
    }

    void setNotification(String notification) {
        this.notification = notification;
    }

    boolean getNotificationAccepted() {
        return this.notificationAccepted;
    }

    void setNotificationAccepted(boolean notificationAccepted) {
        this.notificationAccepted = notificationAccepted;
    }

    boolean isSelected() {
        return this.selected;
    }

    void setSelected(boolean selected) {
        this.selected = selected;
    }

    boolean isNew() {
        return this.localModule == null;
    }

    boolean isPurchased() {
        return this.purchased;
    }

    URL getHomePage() {
        return this.homepage;
    }

    String getLicenceText() {
        return this.licenceText;
    }

    ModuleInfo getRemoteModule() {
        return this.remoteModule;
    }

    ModuleInfo getLocalModule() {
        return this.localModule;
    }

    Node getNode() {
        return this.node;
    }

    boolean isUpdateAvailable() {
        if (this.getLocalModule() == null) {
            return true;
        }
        if (this.getRemoteModule().getCodeNameRelease() > this.getLocalModule().getCodeNameRelease()) {
            return true;
        }
        if (this.getLocalModule().getSpecificationVersion() == null) {
            return true;
        }
        if (this.getRemoteModule().getSpecificationVersion() == null) {
            return false;
        }
        return this.getLocalModule().getSpecificationVersion().compareTo((Object)this.getRemoteModule().getSpecificationVersion()) < 0;
    }

    boolean isNotChecked() {
        return this.security == -1;
    }

    boolean isDownloadOK() {
        return this.downloadOK;
    }

    void setDownloadOK(boolean downloadOK) {
        this.downloadOK = downloadOK;
    }

    int getSecurity() {
        return this.security;
    }

    void setSecurity(int security) {
        this.security = security;
    }

    Collection getCerts() {
        return this.certs;
    }

    void setCerts(Collection certs) {
        this.certs = certs;
    }

    File getDistributionFile() {
        return this.nbmFile;
    }

    boolean isInstallApproved() {
        return this.installApproved;
    }

    void setInstallApproved(boolean installApproved) {
        this.installApproved = installApproved;
    }

    private String getAttribute(String attribute) {
        Node attr = this.node.getAttributes().getNamedItem(attribute);
        return attr == null ? null : attr.getNodeValue();
    }

    private String getTextOfElement(String name) {
        if (this.node.getNodeType() != 1 || !(this.node instanceof Element)) {
            return null;
        }
        NodeList nodeList = ((Element)this.node).getElementsByTagName(name);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nodeList.getLength() && nodeList.item(i).getNodeType() == 1 && nodeList.item(i) instanceof Element; ++i) {
            NodeList innerList = nodeList.item(i).getChildNodes();
            for (int j = 0; j < innerList.getLength(); ++j) {
                short type = innerList.item(j).getNodeType();
                if (type != 3 && type != 4) continue;
                sb.append(innerList.item(j).getNodeValue());
            }
        }
        return sb.toString();
    }

    private List externalFromXML() {
        if (this.node.getNodeType() != 1 || !(this.node instanceof Element)) {
            return null;
        }
        ArrayList<External> ext_list = null;
        NodeList nodeList = ((Element)this.node).getElementsByTagName(ELEMENT_EXTERNAL);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (i == 0) {
                ext_list = new ArrayList<External>();
            }
            if (nodeList.item(i).getNodeType() != 1 || !(nodeList.item(i) instanceof Element)) break;
            NamedNodeMap attrList = nodeList.item(i).getAttributes();
            External ext = new External();
            for (int j = 0; j < attrList.getLength(); ++j) {
                Attr attr = (Attr)attrList.item(j);
                if (attr.getName().equals(ATTR_EXT_NAME)) {
                    ext.setName(attr.getValue());
                    continue;
                }
                if (attr.getName().equals(ATTR_EXT_TARGET)) {
                    ext.setTarget_name(attr.getValue());
                    continue;
                }
                if (attr.getName().equals(ATTR_EXT_URL)) {
                    ext.setStart_url(attr.getValue());
                    continue;
                }
                if (!attr.getName().equals("description")) continue;
                ext.setDescription(attr.getValue());
            }
            ext_list.add(ext);
        }
        return ext_list;
    }

    private Manifest manifestFromXML() {
        if (this.node.getNodeType() != 1 || !(this.node instanceof Element)) {
            return null;
        }
        int i = 0;
        NodeList nodeList = ((Element)this.node).getElementsByTagName("manifest");
        if (i < nodeList.getLength() && nodeList.item(i).getNodeType() == 1 && nodeList.item(i) instanceof Element) {
            NamedNodeMap attrList = nodeList.item(i).getAttributes();
            Manifest mf = new Manifest();
            Attributes mfAttrs = mf.getMainAttributes();
            for (int j = 0; j < attrList.getLength(); ++j) {
                Attr attr = (Attr)attrList.item(j);
                mfAttrs.put(new Attributes.Name(attr.getName()), attr.getValue());
            }
            return mf;
        }
        return null;
    }

    private String licenseFromXML(String name, Element docElement) {
        NodeList nodeList = docElement.getElementsByTagName(ATTR_LICENSE);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node nameAttr = nodeList.item(i).getAttributes().getNamedItem(ATTR_EXT_NAME);
            if (nameAttr == null || !nameAttr.getNodeValue().equals(name)) continue;
            StringBuffer sb = new StringBuffer();
            NodeList innerList = nodeList.item(i).getChildNodes();
            for (int j = 0; j < innerList.getLength(); ++j) {
                short type = innerList.item(j).getNodeType();
                if (type != 3 && type != 4) continue;
                sb.append(innerList.item(j).getNodeValue());
            }
            return sb.toString();
        }
        if (name != null) {
            Logger.getAnonymousLogger().log(Level.WARNING, "[AutoUpdate] warning: no license found with name " + name);
        }
        return null;
    }

    List getExternals() {
        return this.externals;
    }

    public boolean isForcedGlobal() {
        return this.depending || !this.isAbleToInstallToUserDir();
    }

    public void setDepending(boolean depending) {
        this.depending = depending;
    }

    public boolean isToInstallDir() {
        if (this.isForcedGlobal()) {
            return true;
        }
        if (this.isGlobal() != null) {
            return this.isGlobal();
        }
        return this.toInstallDir;
    }

    public void setToInstallDir(boolean toInstallDir) throws IllegalArgumentException {
        if (this.isGlobal() != null && toInstallDir != this.isGlobal()) {
            throw new IllegalArgumentException("Cannot setToInstallDir (" + toInstallDir + ") when isGlobal is set to " + this.isGlobal());
        }
        if (this.isForcedGlobal() && !toInstallDir) {
            throw new IllegalArgumentException("Cannot setToInstallDir (" + toInstallDir + ") when isForderGlobal is " + this.isForcedGlobal());
        }
        this.toInstallDir = toInstallDir;
    }

    public boolean isDownloadStarted() {
        return this.downloadStarted;
    }

    public void setDownloadStarted(boolean downloadStarted) {
        this.downloadStarted = downloadStarted;
    }

    boolean isSafeToInstall() {
        return this.safeToInstall && this.isNew() && !this.isForcedGlobal();
    }

    void setSafeToInstall(boolean safeToInstall) {
        this.safeToInstall = safeToInstall;
    }

    Boolean isGlobal() {
        return this.isGlobal;
    }

    String getTargetCluster() {
        return this.targetCluster;
    }

    List getJarList() {
        return this.jarList;
    }

    void setJarList(List jarList) {
        this.jarList = jarList;
    }

    void addToJarList(String jarName) {
        this.jarList.add(jarName);
    }

    final File findInstallDirectory() {
        if (this.target == null) {
            File firstInstallable = null;
            File declaredTarget = null;
            File updateTarget = null;
            for (File f : UpdateTracking.clusters((boolean)false)) {
                UpdateTracking ut;
                if (!(firstInstallable != null || f.isDirectory() && UpdateTracking.getTracking((File)f, (boolean)false) == null)) {
                    firstInstallable = f;
                }
                if (f.getName().equals(this.getTargetCluster())) {
                    declaredTarget = f;
                }
                if ((ut = UpdateTracking.getTracking((File)f, (boolean)false)) == null || !ut.isModuleInstalled(this.getInfoCodenamebase())) continue;
                assert (declaredTarget == null || f.equals(declaredTarget)) : "Update's target cluster must be placed into as same cluster as original module.";
                updateTarget = f;
                break;
            }
            if (updateTarget != null) {
                this.target = updateTarget;
            } else {
                if (declaredTarget != null) {
                    this.target = declaredTarget;
                }
                if (this.getTargetCluster() != null) {
                    Iterator it = Lookup.getDefault().lookupAll(AutoupdateClusterCreator.class).iterator();
                    while (it.hasNext() && this.target == null) {
                        AutoupdateClusterCreator creator = (AutoupdateClusterCreator)it.next();
                        this.target = creator.findCluster(this.getTargetCluster());
                    }
                }
                if (this.target == null) {
                    this.target = firstInstallable;
                }
                if (this.target != null && !this.target.exists()) {
                    new File(this.target, "update_tracking").mkdirs();
                }
            }
        }
        return this.target;
    }

    final boolean isAbleToInstallToUserDir() {
        HashSet<String> files = new HashSet<String>();
        if (this.nbmFile == null) {
            files.addAll(this.jarList);
        } else {
            try {
                JarFile f = new JarFile(this.nbmFile);
                Enumeration<JarEntry> en = f.entries();
                while (en.hasMoreElements()) {
                    JarEntry e = en.nextElement();
                    String s = e.getName();
                    if (s.startsWith("netbeans/")) {
                        s = s.substring(9);
                    }
                    files.add(s);
                }
            }
            catch (IOException ex) {
                assert (false) : "IOException caught: " + ex.getMessage();
                return false;
            }
        }
        for (File f : UpdateTracking.clusters((boolean)false)) {
            for (String entry : files) {
                File my;
                if (!entry.startsWith("core/") && !entry.startsWith("lib/") || (my = new File(f, entry)).isDirectory() || !my.exists()) continue;
                return false;
            }
        }
        return true;
    }

    static class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String level, SAXParseException e) {
        }

        public void error(SAXParseException e) {
        }

        public void warning(SAXParseException e) {
            LOG.log(Level.WARNING, null, e);
        }

        public void fatalError(SAXParseException e) {
        }
    }

    class External {
        private String name;
        private String target_name;
        private String start_url;
        private String description;

        External() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTarget_name() {
            return this.target_name;
        }

        public void setTarget_name(String target_name) {
            this.target_name = target_name;
        }

        public String getStart_url() {
            return this.start_url;
        }

        public void setStart_url(String start_url) {
            this.start_url = start_url;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

