/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class SelectModulesPanel
extends JPanel {
    private static final FileFilter NBM_FILE_FILTER = new NbmFileFilter();
    private DefaultListModel modulesModel;
    static File defaultDir = null;
    private Wizard.Validator validator;
    static final long serialVersionUID = 8279789280479374665L;
    private JButton addButton;
    private JList jList;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea;
    private JLabel listLabel;
    private JLabel nextLabel;
    private JButton removeButton;

    public SelectModulesPanel(Wizard.Validator validator) {
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
        this.setName(SelectModulesPanel.getBundle("LAB_Select"));
        this.initComponents();
        this.validator = validator;
        this.getAccessibleContext().setAccessibleName(SelectModulesPanel.getBundle("LAB_Select"));
        this.getAccessibleContext().setAccessibleDescription(SelectModulesPanel.getBundle("LAB_21") + SelectModulesPanel.getBundle("LAB_22"));
        this.jTextArea.getAccessibleContext().setAccessibleDescription(SelectModulesPanel.getBundle("ACS_21"));
        this.addButton.getAccessibleContext().setAccessibleDescription(SelectModulesPanel.getBundle("ACS_Add"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(SelectModulesPanel.getBundle("ACS_Remove"));
        this.jList.getAccessibleContext().setAccessibleDescription(SelectModulesPanel.getBundle("ACS_InstallList"));
        this.reset();
    }

    public Dimension getPreferredSize() {
        return new Dimension(350, super.getPreferredSize().height);
    }

    private void initComponents() {
        this.jTextArea = new JTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.jList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.nextLabel = new JLabel();
        this.listLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setNextFocusableComponent(this.addButton);
        this.jTextArea.setBackground(this.nextLabel.getBackground());
        this.jTextArea.setFont(new Font("Dialog", 0, this.jTextArea.getFont().getSize()));
        this.jTextArea.setLineWrap(true);
        this.jTextArea.setText(SelectModulesPanel.getBundle("LAB_21"));
        this.jTextArea.setWrapStyleWord(true);
        this.jTextArea.setDisabledTextColor(Color.black);
        this.jTextArea.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jTextArea, gridBagConstraints);
        this.jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                SelectModulesPanel.this.jListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)SelectModulesPanel.getBundle("BTN_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectModulesPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)SelectModulesPanel.getBundle("BTN_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectModulesPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.nextLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.nextLabel, (String)SelectModulesPanel.getBundle("LAB_22"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.nextLabel, gridBagConstraints);
        this.listLabel.setLabelFor(this.jList);
        Mnemonics.setLocalizedText((JLabel)this.listLabel, (String)SelectModulesPanel.getBundle("LAB_ModulesList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.listLabel, gridBagConstraints);
    }

    private void jListValueChanged(ListSelectionEvent evt) {
        this.buttonsCheck();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        Object[] sel = this.jList.getSelectedValues();
        for (int i = 0; i < sel.length; ++i) {
            this.modulesModel.removeElement(sel[i]);
        }
        this.jList.setSelectionModel(new DefaultListSelectionModel());
        if (this.modulesModel.getSize() == 0) {
            this.validator.setValid(false);
        }
        this.buttonsCheck();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        List files = SelectModulesPanel.selectNbmFiles();
        if (files != null) {
            Iterator it = files.iterator();
            int i = 0;
            while (it.hasNext()) {
                File fn;
                if (i == 0) {
                    this.validator.setValid(true);
                }
                if (!this.selectedFile(fn = (File)it.next())) {
                    this.modulesModel.addElement(fn);
                }
                ++i;
            }
        }
        this.buttonsCheck();
    }

    private boolean selectedFile(File file) {
        for (int i = 0; i < this.modulesModel.size(); ++i) {
            if (((File)this.modulesModel.elementAt(i)).compareTo(file) != 0) continue;
            return true;
        }
        return false;
    }

    File[] getFiles() {
        File[] files = new File[this.modulesModel.size()];
        for (int i = 0; i < this.modulesModel.size(); ++i) {
            files[i] = (File)this.modulesModel.elementAt(i);
        }
        return files;
    }

    void reset() {
        if (this.modulesModel == null) {
            this.modulesModel = new DefaultListModel();
            this.jList.setModel(this.modulesModel);
        } else {
            this.modulesModel.removeAllElements();
        }
        this.buttonsCheck();
    }

    private void buttonsCheck() {
        if (this.modulesModel.getSize() > 0 && this.jList.getSelectedIndex() != -1) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
    }

    static File getDefaultDir() {
        File defDir = new File(System.getProperty("user.home"));
        try {
            if (Utilities.isUnix()) {
                return defDir;
            }
            if (Utilities.isWindows()) {
                while ((defDir = defDir.getParentFile()) != null && defDir.getParentFile() != null) {
                }
            }
        }
        catch (Exception ex) {
            defDir = null;
        }
        return defDir;
    }

    static List selectNbmFiles() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.addChoosableFileFilter(NBM_FILE_FILTER);
        chooser.setFileFilter(NBM_FILE_FILTER);
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileHidingEnabled(false);
        chooser.setDialogTitle(SelectModulesPanel.getBundle("CTL_FileChooser_Title"));
        if (defaultDir == null) {
            defaultDir = SelectModulesPanel.getDefaultDir();
        }
        if (defaultDir != null) {
            chooser.setCurrentDirectory(defaultDir);
        }
        Object files = null;
        Window focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (chooser.showDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), SelectModulesPanel.getBundle("CTL_FileChooser_Approve_Button")) != 0) {
            return null;
        }
        defaultDir = chooser.getCurrentDirectory();
        if (focusOwner != null) {
            focusOwner.toFront();
        }
        return Arrays.asList(chooser.getSelectedFiles());
    }

    private static String getBundle(String key) {
        return NbBundle.getMessage(SelectModulesPanel.class, (String)key);
    }

    private static class NbmFileFilter
    extends FileFilter {
        private NbmFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".nbm");
        }

        public String getDescription() {
            return SelectModulesPanel.getBundle("CTL_FileFilterDescription");
        }
    }
}

