/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class Settings {
    private static final Settings INSTANCE = new Settings();
    private static final String PROP_ASK_BEFORE = "askBefore";
    private static final String PROP_NEGATIVE_RESULTS = "negativeResults";
    private static final String PROP_PERIOD = "period";
    private static final String PROP_LAST_CHECK = "lastCheck";
    private static final String PROP_IDE_IDENTITY = "ideIdentity";
    private static final String PROP_ACCEPTED_NOTIFICATIONS = "acceptedNotifications";
    public static final int EVERY_STARTUP = 0;
    public static final int EVERY_DAY = 1;
    public static final int EVERY_WEEK = 2;
    public static final int EVERY_2WEEKS = 3;
    public static final int EVERY_MONTH = 4;
    public static final int EVERY_NEVER = 5;
    public static final String NODE_DEFAULT_ACTION = "nodeDefaultAction";
    private static final Random RANDOM = new Random();
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate");
    private String tempIdeIdentity = null;
    private Map notifications;
    private PropertyChangeSupport ps;

    private static Preferences getPreferences() {
        return NbPreferences.forModule(Settings.class);
    }

    public static Settings getShared() {
        if (Settings.INSTANCE.ps == null) {
            Settings.INSTANCE.ps = new PropertyChangeSupport(INSTANCE);
        }
        return INSTANCE;
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.ps.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.ps.removePropertyChangeListener(l);
    }

    public int getPeriod() {
        return Settings.getPreferences().getInt(PROP_PERIOD, 2);
    }

    public void setPeriod(int period) {
        Settings.getPreferences().putInt(PROP_PERIOD, period);
    }

    protected AutoupdateType defaultAutoupdateType() {
        return AutoupdateType.getDefault();
    }

    public void setIdeIdentity(String identity) {
        Settings.getPreferences().put(PROP_IDE_IDENTITY, identity);
    }

    public String getIdeIdentity() {
        if (this.tempIdeIdentity instanceof String) {
            return this.tempIdeIdentity;
        }
        String oldIdeIdentity = Settings.getPreferences().get(PROP_IDE_IDENTITY, null);
        String newIdeIdentity = null;
        newIdeIdentity = oldIdeIdentity == null ? Settings.modifyIdeIdentityIfNeeded(Integer.toString(Settings.generateNewId())) : Settings.modifyIdeIdentityIfNeeded(oldIdeIdentity);
        this.tempIdeIdentity = newIdeIdentity;
        if (!newIdeIdentity.equals(oldIdeIdentity)) {
            err.log(Level.FINE, "Put new value of PROP_IDE_IDENTITY to " + newIdeIdentity);
            Settings.getPreferences().put(PROP_IDE_IDENTITY, newIdeIdentity);
        }
        return this.tempIdeIdentity;
    }

    public void setAcceptedNotifications(Map notifications) {
        this.notifications = notifications;
        Settings.storeAcceptedNotifications(notifications);
    }

    public Map getAcceptedNotifications() {
        if (this.notifications == null) {
            this.notifications = Settings.initAcceptedNotifications();
        }
        return this.notifications;
    }

    private static Map initAcceptedNotifications() {
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
        String allPairs = Settings.getPreferences().get(PROP_ACCEPTED_NOTIFICATIONS, null);
        if (allPairs != null) {
            String[] pairs = allPairs.split("|");
            for (int i = 0; i < pairs.length; ++i) {
                String p = pairs[i];
                String[] elems = p.split(",");
                assert (elems.length == 2);
                m.put(Integer.valueOf(elems[0]), Integer.valueOf(elems[1]));
            }
        }
        return m;
    }

    private static void storeAcceptedNotifications(Map m) {
        StringBuffer sb = new StringBuffer();
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            sb.append(e.getKey()).append(",").append(e.getValue());
            if (!it.hasNext()) continue;
            sb.append("|");
        }
        String toStore = sb.toString();
        if (toStore.length() > 0) {
            Settings.getPreferences().put(PROP_ACCEPTED_NOTIFICATIONS, toStore);
        }
    }

    public boolean isAskBefore() {
        return Settings.getPreferences().getBoolean(PROP_ASK_BEFORE, false);
    }

    public void setAskBefore(boolean askBefore) {
        Settings.getPreferences().putBoolean(PROP_ASK_BEFORE, askBefore);
    }

    public boolean isNegativeResults() {
        return Settings.getPreferences().getBoolean(PROP_NEGATIVE_RESULTS, false);
    }

    public void setNegativeResults(boolean negativeResults) {
        Settings.getPreferences().putBoolean(PROP_NEGATIVE_RESULTS, negativeResults);
    }

    public Date getLastCheck() {
        long t = Settings.getPreferences().getLong(PROP_LAST_CHECK, -1L);
        return t > 0L ? new Date(t) : null;
    }

    public void setLastCheck(Date lastCheck) {
        if (lastCheck != null) {
            Settings.getPreferences().putLong(PROP_LAST_CHECK, lastCheck.getTime());
        } else {
            Settings.getPreferences().remove(PROP_LAST_CHECK);
        }
    }

    public void fireNodeDefaultAction() {
        this.ps.firePropertyChange(NODE_DEFAULT_ACTION, null, null);
    }

    private static String getBundle(String key) {
        return NbBundle.getMessage(Settings.class, (String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String modifyIdeIdentityIfNeeded(String oldIdeIdentity) {
        String newPrefix;
        String oldPrefix;
        String id;
        block10: {
            String[] ideIdentityArr = oldIdeIdentity.split("\\d");
            id = null;
            oldPrefix = null;
            if (ideIdentityArr.length == 0) {
                id = oldIdeIdentity;
                oldPrefix = "";
            } else {
                assert (ideIdentityArr.length == 1) : "ideIdentityArr cannot be greater then 1!";
                oldPrefix = ideIdentityArr[0];
                id = oldIdeIdentity.substring(oldPrefix.length());
            }
            err.log(Level.FINER, "Old IDE Identity Prefix: " + oldPrefix);
            err.log(Level.FINER, "Old IDE Identity ID: " + id);
            newPrefix = "";
            try {
                FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("/productid");
                if (fo == null) break block10;
                InputStream is = fo.getInputStream();
                try {
                    BufferedReader r = new BufferedReader(new InputStreamReader(is));
                    newPrefix = r.readLine().trim();
                }
                finally {
                    is.close();
                }
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        if (!newPrefix.equals(oldPrefix)) {
            err.log(Level.FINER, "New IDE Identity Prefix: " + newPrefix);
        } else {
            err.log(Level.FINER, "No new prefix.");
        }
        return newPrefix + id;
    }

    private static int generateNewId() {
        int id = RANDOM.nextInt();
        if (id < 0) {
            id = -(id + 1);
        }
        return id;
    }

    public static class LastCheckPropertyEditor
    extends PropertyEditorSupport {
        private static final SimpleDateFormat sdf = new SimpleDateFormat();

        public String getAsText() {
            Date dt = (Date)this.getValue();
            return dt == null ? "" : sdf.format(dt);
        }

        public void setAsText(String text) {
            try {
                Date newValue = sdf.parse(text);
                this.setValue(newValue);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public static class PeriodPropertyEditor
    extends PropertyEditorSupport {
        private static final String[] tags = new String[]{Settings.access$000("CTL_PeriodEditor_Startup"), Settings.access$000("CTL_PeriodEditor_Day"), Settings.access$000("CTL_PeriodEditor_Week"), Settings.access$000("CTL_PeriodEditor_2Weeks"), Settings.access$000("CTL_PeriodEditor_Month"), Settings.access$000("CTL_PeriodEditor_Never")};
        private static final int[] values = new int[]{0, 1, 2, 3, 4, 5};

        public String[] getTags() {
            return tags;
        }

        public String getAsText() {
            long value = ((Integer)this.getValue()).intValue();
            for (int i = 0; i < values.length; ++i) {
                if ((long)values[i] != value) continue;
                return tags[i];
            }
            return Settings.getBundle("CTL_PeriodEditor_Unsupported");
        }

        public void setAsText(String text) {
            for (int i = 0; i < tags.length; ++i) {
                if (tags[i] != text) continue;
                this.setValue(new Integer(values[i]));
                return;
            }
            this.setValue(new Integer(0));
        }
    }
}

