/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Action;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.netbeans.modules.autoupdate.DependencyChecker;
import org.netbeans.modules.autoupdate.L10NUpdate;
import org.netbeans.modules.autoupdate.ModuleGroup;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

class UpdateNode {
    private static final String NEW_MODULE_ICON_BASE = "org/netbeans/modules/autoupdate/resources/newModule.gif";
    private static final String UPDATE_MODULE_ICON_BASE = "org/netbeans/modules/autoupdate/resources/updateModule.png";
    private static final String MODULE_GROUP_ICON_BASE = "org/openide/loaders/defaultFolder.gif";
    private static final String WAIT_ICON_BASE = "org/openide/src/resources/wait.gif";
    private static final String PURCHASED_MODULE_ICON_BASE = "org/netbeans/modules/autoupdate/resources/purchasedModule.gif";
    private static final String SERVER_ICON_BASE = "org/netbeans/modules/autoupdate/resources/updateAction.gif";
    private static final String LOCAL_ICON_BASE = "org/openide/resources/localFS.gif";
    private static final String LOCALE_MODULE_ICON_BASE = "org/netbeans/modules/autoupdate/resources/localeModule.gif";

    private UpdateNode() {
    }

    private static String getBundle(String key) {
        return NbBundle.getMessage(UpdateNode.class, (String)key);
    }

    static AllServers getAllServers() {
        return new AllServers();
    }

    static class ASChildren
    extends FolderContent {
        public ASChildren() {
            ArrayList list = new ArrayList();
            for (Object ob : Wizard.getAllUpdates().keySet()) {
                list.add(ob);
            }
            this.setKeys(list);
        }

        protected void addNotify() {
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof AutoupdateType) {
                return new Node[]{new Server((AutoupdateType)((Object)key))};
            }
            return new Node[]{new LocalServer(key)};
        }

        void refreshContent(boolean recursive) {
            if (recursive) {
                this.refreshSubFolders();
            }
        }
    }

    static class ATChildren
    extends FolderContent {
        private Object autoupdateType;

        public ATChildren(Object obj) {
            this.autoupdateType = obj;
            this.refreshContent(false);
        }

        protected void addNotify() {
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object key) {
            Node[] result;
            if (key instanceof ModuleUpdate) {
                result = new Node[]{new Module((ModuleUpdate)key)};
            } else if (key instanceof ModuleGroup) {
                result = new Node[]{new Group((ModuleGroup)key)};
                int countOfChildren = ((ModuleGroup)key).getItems().size();
                if (countOfChildren == 0) {
                    result = new Node[]{};
                }
            } else {
                result = new Node[]{};
            }
            return result;
        }

        void refreshContent(boolean recursive) {
            ArrayList list = new ArrayList();
            ModuleGroup group = ((Updates)Wizard.getAllUpdates().get(this.autoupdateType)).getRootGroup();
            if (group != null) {
                for (Object ob : group.getItems()) {
                    if (!(ob instanceof ModuleGroup) && (!(ob instanceof ModuleUpdate) || ((ModuleUpdate)ob).isSelected() || !DependencyChecker.checkPlatformDependency(((ModuleUpdate)ob).getRemoteModule()))) continue;
                    list.add(ob);
                }
            }
            this.setKeys(list);
            if (recursive) {
                this.refreshSubFolders();
            }
        }
    }

    static class AllServers
    extends Folder {
        AllServers() {
            super(new ASChildren());
        }
    }

    static class Children
    extends FolderContent {
        protected ModuleGroup moduleGroup;

        public Children(ModuleGroup moduleGroup) {
            this.moduleGroup = moduleGroup;
            this.refreshContent(false);
        }

        protected void addNotify() {
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof ModuleUpdate) {
                return new Node[]{new Module((ModuleUpdate)key)};
            }
            if (key instanceof ModuleGroup) {
                return new Node[]{new Group((ModuleGroup)key)};
            }
            return new Node[0];
        }

        void refreshContent(boolean recursive) {
            ArrayList<ModuleUpdate> list = new ArrayList<ModuleUpdate>();
            for (Object ob : this.moduleGroup.getItems()) {
                if (ob instanceof ModuleUpdate) {
                    ModuleUpdate mu = (ModuleUpdate)ob;
                    if (mu.isSelected() || !DependencyChecker.checkPlatformDependency(mu.getRemoteModule())) continue;
                    list.add(mu);
                    continue;
                }
                list.add((ModuleUpdate)ob);
            }
            this.setKeys(list);
            if (recursive) {
                this.refreshSubFolders();
            }
        }
    }

    static class Folder
    extends AbstractNode {
        protected FolderContent folderContent;

        public Folder(FolderContent fc) {
            super((org.openide.nodes.Children)fc);
            this.folderContent = fc;
        }

        final void refreshContent(boolean recursive) {
            this.folderContent.refreshContent(recursive);
        }
    }

    static abstract class FolderContent
    extends Children.Keys {
        FolderContent() {
        }

        abstract void refreshContent(boolean var1);

        final void refreshSubFolders() {
            Node[] nodes = this.getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                if (!(nodes[i] instanceof Folder)) continue;
                ((Folder)nodes[i]).refreshContent(true);
            }
        }
    }

    static class Group
    extends Folder {
        private ModuleGroup group;

        Group(ModuleGroup group) {
            super(new Children(group));
            this.group = group;
            this.setDisplayName(group.getName());
            this.setIconBaseWithExtension(UpdateNode.MODULE_GROUP_ICON_BASE);
            this.getCookieSet().add((Node.Cookie)group);
        }
    }

    static class LocalServer
    extends Folder {
        LocalServer(Object obj) {
            super(new ATChildren(obj));
            this.setDisplayName(UpdateNode.getBundle("LBL_LocalUpdate"));
            this.setIconBaseWithExtension(UpdateNode.LOCAL_ICON_BASE);
        }
    }

    static class Module
    extends AbstractNode {
        private ModuleUpdate moduleUpdate;
        static CallableSystemAction moduleAction = null;

        Module(ModuleUpdate moduleUpdate) {
            super(org.openide.nodes.Children.LEAF);
            this.moduleUpdate = moduleUpdate;
            this.setDisplayName(moduleUpdate.getName());
            if (moduleUpdate.isPurchased()) {
                this.setIconBaseWithExtension(UpdateNode.PURCHASED_MODULE_ICON_BASE);
            } else if (moduleUpdate instanceof L10NUpdate) {
                this.setIconBaseWithExtension(UpdateNode.LOCALE_MODULE_ICON_BASE);
            } else {
                this.setIconBaseWithExtension(moduleUpdate.isNew() ? UpdateNode.NEW_MODULE_ICON_BASE : UpdateNode.UPDATE_MODULE_ICON_BASE);
            }
            this.getCookieSet().add((Node.Cookie)moduleUpdate);
        }

        CallableSystemAction getModuleAction() {
            if (moduleAction == null) {
                moduleAction = new ModuleAction();
            }
            return moduleAction;
        }

        public Action getPreferredAction() {
            return this.getModuleAction();
        }

        class ModuleAction
        extends CallableSystemAction {
            ModuleAction() {
            }

            public void performAction() {
                Settings.getShared().fireNodeDefaultAction();
            }

            public HelpCtx getHelpCtx() {
                return null;
            }

            public String getName() {
                return null;
            }

            protected boolean asynchronous() {
                return false;
            }
        }
    }

    static class Server
    extends Folder {
        Server(AutoupdateType at) {
            super(new ATChildren((Object)at));
            this.setDisplayName(at.getName());
            this.setIconBaseWithExtension(UpdateNode.SERVER_ICON_BASE);
        }
    }

    static class Wait
    extends AbstractNode {
        Wait() {
            super(org.openide.nodes.Children.LEAF);
            this.setDisplayName(UpdateNode.getBundle("CTL_WaitNode"));
            this.setIconBaseWithExtension(UpdateNode.WAIT_ICON_BASE);
        }
    }
}

