/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.XMLUpdates;
import org.netbeans.spi.autoupdate.UpdateProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class XMLAutoupdateType
extends AutoupdateType {
    static final String PROP_URL_SPEC = "urlSpec";
    static final String PROP_URL = "URL";
    private String urlSpec;
    private URL url;
    private String defaultURL;
    private static final String UPDATE_VERSION_PROP = "netbeans.autoupdate.version";
    private static final String IDE_HASH_CODE = "netbeans.hash.code";
    public static final String UPDATE_VERSION = "1.18";
    private static final String SYSPROP_COUNTRY = "netbeans.autoupdate.country";
    private static final String SYSPROP_LANGUAGE = "netbeans.autoupdate.language";
    private static final String SYSPROP_VARIANT = "netbeans.autoupdate.variant";
    private static final String TIME_STAMP_ATTRIBUTE_NAME = "timestamp";
    private static final String TIME_STAMP_FORMAT = "ss/mm/hh/dd/MM/yyyy";
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate");
    static final long serialVersionUID = 362844553432169452L;
    private String displayName = null;
    private FileObject typeFileObject = null;
    private String url_key;
    private String localizingBundleName;
    private boolean valid = true;

    public XMLAutoupdateType() {
        this.urlSpec = this.getDefaultURL();
    }

    public XMLAutoupdateType(URL url) {
        this.urlSpec = url.toExternalForm();
    }

    public XMLAutoupdateType(URL url, String displayName, String url_key, Boolean enabled) {
        this(url, displayName, null, url_key, enabled);
    }

    public XMLAutoupdateType(URL url, String displayName, FileObject fo, String url_key, Boolean enabled) {
        this(url, displayName, fo, url_key, enabled, null);
    }

    public XMLAutoupdateType(URL url, String displayName, FileObject fo, String url_key, Boolean enabled, String localizingBundleName) {
        this.typeFileObject = fo;
        this.urlSpec = url.toExternalForm();
        this.displayName = displayName;
        this.url_key = url_key;
        this.localizingBundleName = localizingBundleName;
        if (enabled != null) {
            this.setEnabled(enabled);
        }
        try {
            Class<?> clazz = Class.forName("org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogFactory", false, Thread.currentThread().getContextClassLoader());
            assert (clazz != null) : "Class AutoupdateCatalogFactory found.";
            Method m = clazz.getMethod("createUpdateProvider", FileObject.class);
            assert (m != null) : "Method createUpdateProvider(FileObject) found.";
            m.setAccessible(true);
            Object res = m.invoke(null, fo);
            assert (res != null && res instanceof UpdateProvider) : "AutoupdateCatalogFactory.createUpdateProvider (" + fo + ") returns instanceof UpdateProvider, but " + res;
        }
        catch (Exception x) {
            err.log(Level.INFO, x.getMessage(), x);
        }
    }

    public static XMLAutoupdateType createXMLAutoupdateType(FileObject fo) throws IOException {
        URL url;
        String sKey = (String)fo.getAttribute("url_key");
        String remoteBundleName = (String)fo.getAttribute("SystemFileSystem.localizingBundle");
        ResourceBundle bundle = XMLAutoupdateType.getBundleFromName(remoteBundleName);
        if (sKey != null) {
            String localizedValue;
            try {
                localizedValue = bundle.getString(sKey);
            }
            catch (MissingResourceException mre) {
                localizedValue = "http://";
            }
            url = new URL(localizedValue);
        } else {
            Object o = fo.getAttribute("url");
            url = o instanceof String ? new URL((String)o) : (URL)o;
        }
        Boolean en = (Boolean)fo.getAttribute("enabled");
        return new XMLAutoupdateType(url, null, fo, sKey, en, remoteBundleName);
    }

    public String displayName() {
        if (this.displayName == null) {
            if (this.typeFileObject != null) {
                try {
                    FileSystem fs = this.typeFileObject.getFileSystem();
                    FileSystem.Status s = fs.getStatus();
                    String x = s.annotateName("", Collections.singleton(this.typeFileObject));
                    if (!x.equals("")) {
                        this.displayName = x;
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            if (this.displayName == null) {
                this.displayName = NbBundle.getBundle(Settings.class).getString("CTL_XMLAutoupdateType_Name");
            }
        }
        return this.displayName;
    }

    public String getUrlSpec() {
        return this.urlSpec;
    }

    public void setUrlSpec(String spec) {
        try {
            new URL(spec);
        }
        catch (MalformedURLException ex) {
            class UserIllegalException
            extends IllegalArgumentException
            implements Callable {
                public UserIllegalException(String s) {
                    super(s);
                }

                public Object call() throws Exception {
                    LogRecord r = new LogRecord(OwnLevel.USER, this.getMessage());
                    return new LogRecord[]{r};
                }
            }
            UserIllegalException iae = new UserIllegalException(ex.getMessage());
            String msg = MessageFormat.format(NbBundle.getMessage(XMLAutoupdateType.class, (String)"FMT_EXC_BAD_URL"), spec);
            Exceptions.attachLocalizedMessage((Throwable)iae, (String)msg);
            throw iae;
        }
        String old = this.urlSpec;
        this.urlSpec = spec;
        this.firePropertyChange(PROP_URL_SPEC, old, this.urlSpec);
    }

    public URL getURL() {
        URL url;
        block2: {
            url = null;
            try {
                url = new URL(this.getUrlSpec());
            }
            catch (MalformedURLException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)ex);
            }
        }
        return url;
    }

    public void setURL(URL url) {
        if (url != null) {
            this.setUrlSpec(url.toExternalForm());
        } else {
            this.setUrlSpec(null);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(XMLAutoupdateType.class);
    }

    public Updates connectForUpdates() {
        URL url;
        block2: {
            url = null;
            try {
                url = new URL(this.getUrlSpec());
            }
            catch (MalformedURLException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)ex);
            }
        }
        return new XMLUpdates(this.modifyURL(url));
    }

    protected URL modifyURL(URL original) {
        URL updateURL = null;
        if (System.getProperty(UPDATE_VERSION_PROP) == null) {
            System.setProperty(UPDATE_VERSION_PROP, UPDATE_VERSION);
        }
        if (System.getProperty(IDE_HASH_CODE) == null) {
            String id = "";
            try {
                id = Settings.getShared().getIdeIdentity();
            }
            catch (NullPointerException npe) {
                Logger.getAnonymousLogger().warning("Property PROP_IDE_IDENTITY hasn't been initialized yet.");
            }
            String prefix = NbBundle.getBundle(XMLAutoupdateType.class).getString("URL_Prefix_Hash_Code");
            System.setProperty(IDE_HASH_CODE, "".equals(id) ? prefix + "0" : prefix + id);
        }
        try {
            updateURL = new URL(this.encode(this.replace(original.toString())));
        }
        catch (MalformedURLException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return updateURL;
    }

    protected String replace(String string) {
        XMLAutoupdateType.setSystemProperties();
        if (string == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int prevIndex = 0;
        int index = 0;
        while ((index = string.indexOf("{", index)) != -1 && index < string.length() - 1) {
            if (string.charAt(index + 1) == '{' || string.charAt(index + 1) != '$') {
                ++index;
                continue;
            }
            sb.append(string.substring(prevIndex, index));
            int endBracketIndex = string.indexOf("}", index);
            if (endBracketIndex != -1) {
                String whatToReplace = string.substring(index + 2, endBracketIndex);
                sb.append(this.getReplacement(whatToReplace));
            }
            prevIndex = endBracketIndex == -1 ? index + 2 : endBracketIndex + 1;
            ++index;
        }
        if (prevIndex < string.length() - 1) {
            sb.append(string.substring(prevIndex));
        }
        return sb.toString();
    }

    boolean isValid() {
        return this.valid;
    }

    protected String getReplacement(String whatToReplace) {
        return System.getProperty(whatToReplace, "");
    }

    protected String encode(String stringURL) {
        String rval = stringURL;
        int q = stringURL.indexOf(63);
        if (q > 0) {
            StringBuffer buf = new StringBuffer(stringURL.substring(0, q + 1));
            StringTokenizer st = new StringTokenizer(stringURL.substring(q + 1), "&");
            while (st.hasMoreTokens()) {
                String a = st.nextToken();
                try {
                    int ei = a.indexOf(61);
                    if (ei < 0) {
                        buf.append(URLEncoder.encode(a, "UTF-8"));
                    } else {
                        buf.append(URLEncoder.encode(a.substring(0, ei), "UTF-8"));
                        buf.append('=');
                        String tna = a.substring(ei + 1);
                        int tni = tna.indexOf("%");
                        if (tni < 0) {
                            buf.append(URLEncoder.encode(tna, "UTF-8"));
                        } else {
                            buf.append(URLEncoder.encode(tna.substring(0, tni), "UTF-8"));
                            buf.append('%');
                            buf.append(URLEncoder.encode(tna.substring(tni + 1), "UTF-8"));
                        }
                    }
                }
                catch (UnsupportedEncodingException ex) {
                    err.log(Level.INFO, ex.getMessage(), ex);
                }
                if (!st.hasMoreTokens()) continue;
                buf.append('&');
            }
            rval = buf.toString();
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean hasNewContent() {
        InputStream is = null;
        Date timeStamp = null;
        try {
            int c;
            URL url = this.modifyURL(new URL(this.getUrlSpec()));
            err.log(Level.FINER, "Found Update Center " + this.getName() + "[" + url + "]");
            URLConnection conn = url.openConnection();
            is = conn.getInputStream();
            InputStreamReader r = new InputStreamReader(is);
            StringBuffer sb = new StringBuffer(1024);
            while ((c = is.read()) != -1 && sb.length() < 1024) {
                sb.append((char)c);
            }
            err.log(Level.FINER, "Successfully checked " + url);
            String content = sb.toString();
            String time = null;
            int pos = content.indexOf(TIME_STAMP_ATTRIBUTE_NAME);
            if (pos != -1 && (pos = (content = content.substring(pos + TIME_STAMP_ATTRIBUTE_NAME.length() + 1 + 1)).indexOf(62)) != -1) {
                time = content.substring(0, pos - 1);
            }
            SimpleDateFormat format = new SimpleDateFormat(TIME_STAMP_FORMAT);
            timeStamp = format.parse(time);
            err.log(Level.FINER, "Successfully read time " + timeStamp);
            err.log(Level.FINER, "Last Time Stamp on " + this.getName() + " is " + this.getLastTimeStamp());
        }
        catch (MalformedURLException ex) {
            err.log(Level.FINE, null, ex);
        }
        catch (IOException ioe) {
            err.log(Level.FINE, null, ioe);
        }
        catch (ParseException ex) {
            err.log(Level.FINE, null, ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    err.log(Level.FINE, null, ex);
                }
            }
        }
        if (this.getLastTimeStamp() == null) {
            return Boolean.TRUE;
        }
        return timeStamp == null ? null : (timeStamp.after(this.getLastTimeStamp()) ? Boolean.TRUE : Boolean.FALSE);
    }

    private static ResourceBundle getOldLocalizingBundle() {
        return NbBundle.getBundle(XMLAutoupdateType.class);
    }

    private static ResourceBundle getBundleFromName(String name) throws MissingResourceException {
        ResourceBundle bundle = null;
        bundle = name == null ? XMLAutoupdateType.getOldLocalizingBundle() : NbBundle.getBundle((String)name);
        return bundle;
    }

    private static void setSystemProperties() {
        if (System.getProperty(SYSPROP_COUNTRY, null) == null) {
            System.setProperty(SYSPROP_COUNTRY, Locale.getDefault().getCountry());
        }
        if (System.getProperty(SYSPROP_LANGUAGE, null) == null) {
            System.setProperty(SYSPROP_LANGUAGE, Locale.getDefault().getLanguage());
        }
        if (System.getProperty(SYSPROP_VARIANT, null) == null) {
            System.setProperty(SYSPROP_VARIANT, Locale.getDefault().getVariant());
        }
    }

    protected String getDefaultURL() {
        if (this.defaultURL == null) {
            ResourceBundle remoteBundle = null;
            try {
                remoteBundle = XMLAutoupdateType.getBundleFromName(this.localizingBundleName);
                this.defaultURL = this.url_key != null ? remoteBundle.getString(this.url_key) : remoteBundle.getString("URL_Default_N");
            }
            catch (MissingResourceException mre) {
                this.valid = false;
                return null;
            }
        }
        return this.defaultURL;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.urlSpec.equals(this.getDefaultURL())) {
            out.writeObject(null);
        } else {
            out.writeObject(this.urlSpec);
        }
        out.writeObject(this.displayName);
        out.writeObject(this.url_key);
        out.writeObject(this.localizingBundleName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            String remoteBundleName;
            String key;
            String display;
            this.valid = true;
            Object urlObject = in.readObject();
            if (urlObject != null) {
                if (urlObject instanceof URL) {
                    this.urlSpec = ((URL)urlObject).toExternalForm();
                } else {
                    assert (urlObject instanceof String);
                    this.urlSpec = (String)urlObject;
                }
            }
            if ((display = (String)in.readObject()) != null) {
                this.displayName = display;
            }
            if ((key = (String)in.readObject()) != null) {
                this.url_key = key;
            }
            if ((remoteBundleName = (String)in.readObject()) != null) {
                this.localizingBundleName = remoteBundleName;
            }
        }
        catch (OptionalDataException ode) {
            if (ode.eof) {
                this.setEnabled(true);
            }
            throw ode;
        }
        if (this.urlSpec == null) {
            this.urlSpec = this.getDefaultURL();
        }
        if (!this.isValid()) {
            this.setEnabled(false);
            this.displayName = NbBundle.getMessage(XMLAutoupdateType.class, (String)"XMLAutoupdateType_InvalidSetting", (Object)this.displayName);
        }
    }

    private static final class OwnLevel
    extends Level {
        public static final Level USER = new OwnLevel("USER", 1973);

        private OwnLevel(String s, int i) {
            super(s, i);
        }
    }
}

