/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import org.netbeans.modules.autoupdate.catalog.ModuleBean;
import org.netbeans.modules.autoupdate.catalog.ModuleDeleter;
import org.netbeans.modules.autoupdate.catalog.ModuleDeleterImpl;
import org.netbeans.modules.autoupdate.catalog.ModuleNodeActions;
import org.netbeans.modules.autoupdate.catalog.ModuleNodeUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class ModuleNode
extends AbstractNode {
    private static final String MODULE_ITEM_ICON_BASE = "org/netbeans/modules/autoupdate/resources/moduleItem.gif";
    private static final String MODULE_ITEM_DISABLED_BASE = "org/netbeans/modules/autoupdate/resources/moduleItemDisabled.gif";
    private static final String MODULE_ITEM_ERROR_BASE = "org/netbeans/modules/autoupdate/resources/moduleItemError.gif";
    private static final String MODULE_TEST_ITEM_ICON_BASE = "org/netbeans/modules/autoupdate/resources/testModuleItem.gif";
    private static final String MODULES_ICON_BASE = "org/netbeans/modules/autoupdate/resources/modules.gif";
    private static ModuleDeleter deleter;
    private static final String KEY_SORT_MODE = "moduleSortMode";

    private static Preferences getPreferences() {
        return NbPreferences.forModule(ModuleNode.class);
    }

    static SortMode getModuleSortMode() {
        return SortMode.valueOf(ModuleNode.getPreferences().get(KEY_SORT_MODE, SortMode.BY_CATEGORY.name()));
    }

    static void setModuleSortMode(SortMode sortMode) {
        ModuleNode.getPreferences().put(KEY_SORT_MODE, sortMode.name());
    }

    public ModuleNode() {
        super((Children)new Modules());
        this.setName("Modules");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ModuleNode.class);
    }

    private static ModuleBean.AllModulesBean getAllModules() {
        return ModuleBean.AllModulesBean.getDefault();
    }

    private static ModuleDeleter getModuleDeleter() {
        if (deleter == null) {
            deleter = new ModuleDeleterImpl();
        }
        return deleter;
    }

    private static final class BridgeChildren
    extends DirectModuleChildren {
        private BridgeChildren() {
        }

        protected boolean contains(ModuleBean module) {
            return module.isEager();
        }
    }

    private static final class BridgeNode
    extends ModuleFolderNode {
        BridgeNode() {
            super(new BridgeChildren());
            this.setName("bridges");
            this.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"LBL_ModuleNode_bridges"));
            this.setIconBaseWithExtension(ModuleNode.MODULES_ICON_BASE);
        }

        protected boolean supportsEnabledProperty() {
            return false;
        }

        protected boolean contains(ModuleBean module) {
            throw new AssertionError();
        }
    }

    private static final class CategoryChildren
    extends DirectModuleChildren {
        private final String category;

        public CategoryChildren(String category) {
            this.category = category;
        }

        protected boolean contains(ModuleBean module) {
            return this.category.equals(module.getCategory());
        }
    }

    private static final class CategoryNode
    extends ModuleFolderNode {
        private final String category;

        CategoryNode(String category) {
            super(new CategoryChildren(category));
            this.category = category;
            this.setName(category);
            this.updateDisplayStuff();
            this.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, null));
        }

        protected boolean supportsEnabledProperty() {
            return true;
        }

        protected boolean contains(ModuleBean module) {
            return module.getJar() != null && !module.isAutoload() && !module.isEager() && this.category.equals(module.getCategory());
        }
    }

    private static final class ClusterChildren
    extends DirectModuleChildren {
        private final File cluster;

        public ClusterChildren(File cluster) {
            this.cluster = cluster;
        }

        protected boolean contains(ModuleBean module) {
            return this.cluster.equals(module.getCluster());
        }
    }

    private static final class ClusterNode
    extends ModuleFolderNode {
        private final File cluster;

        ClusterNode(File cluster) {
            super(new ClusterChildren(cluster));
            this.cluster = cluster;
            this.setName(cluster.getAbsolutePath());
            this.setDisplayName(cluster.getName());
            this.updateDisplayStuff();
            this.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, null));
        }

        protected boolean supportsEnabledProperty() {
            return true;
        }

        protected boolean contains(ModuleBean module) {
            return this.cluster.equals(module.getCluster());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class DirectModuleChildren
    extends Children.Keys<ModuleBean>
    implements PropertyChangeListener {
        private DirectModuleChildren() {
        }

        protected void addNotify() {
            this.refreshKeys();
            ModuleNode.getAllModules().addPropertyChangeListener(this);
        }

        protected void removeNotify() {
            ModuleNode.getAllModules().removePropertyChangeListener(this);
            this.setKeys(Collections.emptySet());
        }

        public Node findChild(String name) {
            ModuleNode.getAllModules().waitForModules().waitFinished();
            this.refreshKeys();
            return super.findChild(name);
        }

        protected abstract boolean contains(ModuleBean var1);

        private void refreshKeys() {
            ArrayList<ModuleBean> keys = new ArrayList<ModuleBean>();
            for (ModuleBean module : ModuleNode.getAllModules().getModules()) {
                if (!this.contains(module)) continue;
                keys.add(module);
            }
            final Collator collator = Collator.getInstance();
            Collections.sort(keys, new Comparator<ModuleBean>(){

                @Override
                public int compare(ModuleBean m1, ModuleBean m2) {
                    return collator.compare(m1.getDisplayName(), m2.getDisplayName());
                }
            });
            this.setKeys(keys);
        }

        protected Node[] createNodes(ModuleBean key) {
            return new Node[]{new Item(key)};
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            this.refreshKeys();
        }
    }

    static class Item
    extends AbstractNode
    implements PropertyChangeListener {
        private ModuleBean item;
        private boolean listeningToAllModules = false;

        public Item(ModuleBean item) {
            super(Children.LEAF, Lookups.singleton((Object)item));
            this.item = item;
            this.setName(item.getCodeNameBase());
            item.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)item));
            this.updateDisplayStuff();
        }

        ModuleBean getItem() {
            assert (this.item != null) : "Cannot be called untill item is null.";
            return this.item;
        }

        void uninstall() {
            ModuleDeleter deleter = ModuleNode.getModuleDeleter();
            assert (deleter != null) : "ModuleDeleter must be available.";
            boolean canUninstall = deleter.canDelete(this.item.getModule());
            if (canUninstall) {
                try {
                    deleter.delete(this.item.getModule());
                }
                catch (IOException ioe) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)ioe));
                }
            } else if (this.canDestroy()) {
                this.item.delete();
            }
        }

        private void updateDisplayStuff() {
            this.setDisplayName(this.item.getDisplayName());
            this.setShortDescription(this.item.getShortDescription());
            this.setIconBaseWithExtension(this.item.isEnabled() ? (this.item.isReloadable() ? ModuleNode.MODULE_TEST_ITEM_ICON_BASE : ModuleNode.MODULE_ITEM_ICON_BASE) : (this.item.isProblematic() ? ModuleNode.MODULE_ITEM_ERROR_BASE : ModuleNode.MODULE_ITEM_DISABLED_BASE));
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.updateDisplayStuff();
            this.firePropertyChange(null, null, null);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(Item.class);
        }

        public Action[] getActions(boolean context) {
            return new Action[]{SystemAction.get(ModuleNodeActions.EnableDisableAction.class), SystemAction.get(ModuleNodeActions.EnableAllAction.class), null, SystemAction.get(ModuleNodeActions.UninstallAction.class), null, SystemAction.get(ModuleNodeActions.SortAction.class), null, SystemAction.get(PropertiesAction.class)};
        }

        public Action getPreferredAction() {
            return SystemAction.get(PropertiesAction.class);
        }

        public void destroy() {
            if (ModuleNodeUtils.confirmUninstall(new Node[]{this})) {
                this.uninstall();
            }
        }

        public boolean canDestroy() {
            boolean canUninstall = ModuleNode.getModuleDeleter().canDelete(this.item.getModule());
            if (!canUninstall) {
                return this.item.getJar() != null && ModuleNodeUtils.isUninstallAllowed(this.item.getModule());
            }
            return true;
        }

        protected Sheet createSheet() {
            Sheet s = Sheet.createDefault();
            Sheet.Set ss = s.get("properties");
            Sheet.Set sse = Sheet.createExpertSet();
            s.put(sse);
            try {
                PropertySupport.Reflection p = new PropertySupport.Reflection((Object)this.item, String.class, "getDisplayName", null);
                p.setName("displayName");
                p.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_name"));
                p.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_name"));
                ss.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)this.item, String.class, "getSpecificationVersion", null);
                p.setValue("suppressCustomEditor", (Object)true);
                p.setName("specificationVersion");
                p.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_specversion"));
                p.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_specversion"));
                ss.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)this.item, String.class, "getImplementationVersion", null);
                p.setValue("suppressCustomEditor", (Object)true);
                p.setName("implementationVersion");
                p.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_implversion"));
                p.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_implversion"));
                sse.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)this.item, String.class, "getBuildVersion", null);
                p.setValue("suppressCustomEditor", (Object)true);
                p.setName("buildVersion");
                p.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_buildversion"));
                p.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_buildversion"));
                sse.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)this.item, String.class, "getShortDescription", null);
                p.setValue("suppressCustomEditor", (Object)true);
                p.setName("shortDescription");
                p.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_shortDescription"));
                p.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_shortDescription"));
                ss.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)this.item, String.class, "getLongDescription", null);
                p.setValue("suppressCustomEditor", (Object)true);
                p.setName("longDescription");
                p.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_longDescription"));
                p.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_longDescription"));
                ss.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)this.item, String.class, "getCategory", null);
                p.setValue("suppressCustomEditor", (Object)true);
                p.setName("category");
                p.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_category"));
                p.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_category"));
                sse.put((Node.Property)p);
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class EnabledOrReloadableProp
                extends PropertySupport.Reflection<Boolean> {
                    public EnabledOrReloadableProp(String getter, String setter) throws NoSuchMethodException {
                        super((Object)Item.this.item, Boolean.TYPE, getter, setter);
                    }

                    public boolean canWrite() {
                        if (!super.canWrite()) {
                            return false;
                        }
                        if (this.getName().equals("enabled")) {
                            return Item.this.item.getJar() != null && !Item.this.item.isProblematic() && !Item.this.item.isAutoload() && !Item.this.item.isEager();
                        }
                        if (this.getName().equals("reloadable")) {
                            return Item.this.item.getJar() != null && (Item.this.item.isReloadable() || Item.this.item.getJar().getParentFile().canWrite());
                        }
                        throw new IllegalStateException();
                    }
                }
                p = new EnabledOrReloadableProp("isEnabled", "setEnabled");
                p.setName("enabled");
                p.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_enabled"));
                p.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_enabled"));
                ss.put((Node.Property)p);
                p = new EnabledOrReloadableProp("isReloadable", "setReloadable");
                p.setName("reloadable");
                p.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_reloadable"));
                p.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_reloadable"));
                sse.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)this.item, String.class, "getCodeName", null);
                p.setValue("suppressCustomEditor", (Object)true);
                p.setName("codeName");
                p.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_codename"));
                p.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_codename"));
                sse.put((Node.Property)p);
                if (this.item.getJar() != null) {
                    p = new PropertySupport.Reflection((Object)this.item, File.class, "getJar", null);
                    p.setName("jar");
                    p.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_jar"));
                    p.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_jar"));
                    sse.put((Node.Property)p);
                }
                class ClasspathProperty
                extends PropertySupport.ReadOnly {
                    public ClasspathProperty() {
                        super("classpath", Item.getNbClassPathOrStringClass(), NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_classpath"), NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_classpath"));
                    }

                    public Object getValue() throws InvocationTargetException {
                        String cp = Item.this.item.getEffectiveClasspath();
                        if (this.getValueType() == String.class) {
                            return cp;
                        }
                        try {
                            Constructor c = this.getValueType().getConstructor(String.class);
                            return c.newInstance(cp);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }
                sse.put((Node.Property)new ClasspathProperty());
                p = new PropertySupport.Reflection((Object)this.item, Boolean.TYPE, "isAutoload", null);
                p.setName("autoload");
                p.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_autoload"));
                p.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_autoload"));
                sse.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)this.item, Boolean.TYPE, "isEager", null);
                p.setName("eager");
                p.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_eager"));
                p.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_eager"));
                sse.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)this.item, String[].class, "getProvides", null);
                p.setName("provides");
                p.setValue("suppressCustomEditor", (Object)true);
                p.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_provides"));
                p.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_provides"));
                sse.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)this.item, String[].class, "getProblemDescriptions", null);
                p.setName("problemDescriptions");
                p.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_problemDescriptions"));
                p.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_problemDescriptions"));
                sse.put((Node.Property)p);
            }
            catch (NoSuchMethodException nsme) {
                Exceptions.printStackTrace((Throwable)nsme);
            }
            sse.put((Node.Property)new UsedByProp());
            return s;
        }

        private static Class getNbClassPathOrStringClass() {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            try {
                return l.loadClass("org.openide.execution.NbClassPath");
            }
            catch (ClassNotFoundException cnfe) {
                return String.class;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class UsedByProp
        extends PropertySupport.ReadOnly<String[]>
        implements ModuleBean.AllModulesBean.RelationCallback,
        PropertyChangeListener {
            private String[] value;

            public UsedByProp() {
                super("usedBy", String[].class, NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_usedby"), NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_usedby"));
                this.value = null;
            }

            public String[] getValue() {
                if (this.value != null) {
                    return this.value;
                }
                ModuleBean.AllModulesBean amb = ModuleBean.AllModulesBean.getDefault();
                amb.getRelations(Item.this.item, 3, this);
                if (!Item.this.listeningToAllModules) {
                    Item.this.listeningToAllModules = true;
                    amb.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)amb));
                    ModuleBean[] mods = amb.getModules();
                    for (int i = 0; i < mods.length; ++i) {
                        if (mods[i] == Item.this.item) continue;
                        mods[i].addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)mods[i]));
                    }
                }
                return new String[]{NbBundle.getMessage(ModuleNode.class, (String)"LBL_please_wait_modules_usedby")};
            }

            @Override
            public void result(Set<ModuleBean> modules) {
                ArrayList<String> l = new ArrayList<String>(Math.max(modules.size(), 1));
                if (Item.this.item.isEnabled()) {
                    for (ModuleBean mb : modules) {
                        if (!mb.isEnabled()) continue;
                        l.add(mb.getDisplayName());
                    }
                    Collections.sort(l, Collator.getInstance());
                }
                String[] old = this.value;
                this.value = l.toArray(new String[l.size()]);
                Item.this.firePropertyChange("usedBy", old, this.value);
            }

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                this.value = null;
                Item.this.firePropertyChange("usedBy", null, null);
            }
        }
    }

    private static final class LibraryChildren
    extends DirectModuleChildren {
        private LibraryChildren() {
        }

        protected boolean contains(ModuleBean module) {
            return module.getJar() == null || module.isAutoload();
        }
    }

    private static final class LibraryNode
    extends ModuleFolderNode {
        LibraryNode() {
            super(new LibraryChildren());
            this.setName("libraries");
            this.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"LBL_ModuleNode_libraries"));
            this.setIconBaseWithExtension(ModuleNode.MODULES_ICON_BASE);
        }

        protected boolean supportsEnabledProperty() {
            return false;
        }

        protected boolean contains(ModuleBean module) {
            throw new AssertionError();
        }
    }

    private static abstract class ModuleFolderNode
    extends AbstractNode
    implements PropertyChangeListener {
        protected ModuleFolderNode(DirectModuleChildren ch) {
            super((Children)ch);
        }

        public boolean canDestroy() {
            return ModuleNodeUtils.canUninstall(new Node[]{this});
        }

        public void destroy() {
            ModuleNodeUtils.doUninstall(new Node[]{this});
        }

        public boolean canRename() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(ModuleNode.class);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("enabled".equals(evt.getPropertyName())) {
                this.updateDisplayStuff();
            }
        }

        protected void updateDisplayStuff() {
            Boolean b = ModuleNodeUtils.isEnableCandidate(this.getChildren().getNodes());
            this.setIconBaseWithExtension(b != null && b != false ? ModuleNode.MODULE_ITEM_DISABLED_BASE : ModuleNode.MODULES_ICON_BASE);
        }

        public Action[] getActions(boolean context) {
            return new Action[]{SystemAction.get(ModuleNodeActions.EnableDisableAction.class), SystemAction.get(ModuleNodeActions.EnableAllAction.class), null, SystemAction.get(ModuleNodeActions.UninstallAction.class), null, SystemAction.get(ModuleNodeActions.SortAction.class), null, SystemAction.get(PropertiesAction.class)};
        }

        protected abstract boolean supportsEnabledProperty();

        protected abstract boolean contains(ModuleBean var1);

        protected Sheet createSheet() {
            if (!this.supportsEnabledProperty()) {
                return super.createSheet();
            }
            Sheet s = Sheet.createDefault();
            Sheet.Set ss = s.get("properties");
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class EnabledProp
            extends PropertySupport.ReadWrite<Boolean>
            implements PropertyChangeListener {
                private Set<ModuleBean> modules;
                private PropertyEditor editor;

                public EnabledProp() {
                    super("enabled", Boolean.TYPE, NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_enabled"), NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_enabled"));
                    this.modules = new HashSet<ModuleBean>();
                    this.editor = null;
                    this.calculateModules();
                    ModuleNode.getAllModules().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)ModuleNode.getAllModules()));
                }

                public Boolean getValue() {
                    Boolean val = null;
                    for (ModuleBean m : this.modules) {
                        if (m.isEnabled()) {
                            if (val == null) {
                                val = true;
                                continue;
                            }
                            if (val.booleanValue()) continue;
                            return null;
                        }
                        if (val == null) {
                            val = false;
                            continue;
                        }
                        if (!val.booleanValue()) continue;
                        return null;
                    }
                    return val;
                }

                public void setValue(Boolean val) {
                    ModuleNode.getAllModules().pause();
                    for (ModuleBean m : this.modules) {
                        m.setEnabled(val);
                    }
                    ModuleNode.getAllModules().resume();
                }

                public boolean canWrite() {
                    for (ModuleBean m : this.modules) {
                        if (!m.isAutoload() && m.getJar() != null && !m.isEager() && !m.isProblematic()) continue;
                        return false;
                    }
                    return true;
                }

                private void calculateModules() {
                    HashSet<ModuleBean> modules2 = new HashSet<ModuleBean>();
                    for (ModuleBean testing : ModuleNode.getAllModules().getModules()) {
                        if (!ModuleFolderNode.this.contains(testing)) continue;
                        modules2.add(testing);
                        if (this.modules.contains(testing)) continue;
                        testing.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)testing));
                    }
                    this.modules = modules2;
                }

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ModuleFolderNode.this.firePropertyChange("enabled", null, null);
                    this.calculateModules();
                }

                public PropertyEditor getPropertyEditor() {
                    if (this.editor == null) {
                        this.editor = super.getPropertyEditor();
                    }
                    return this.editor;
                }
            }
            ss.put((Node.Property)new EnabledProp());
            return s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Modules
    extends Children.Keys<Object>
    implements PropertyChangeListener {
        private static final Object LIBRARY_KEY = new Object();
        private static final Object BRIDGE_KEY = new Object();
        private static final Object NO_CLUSTER_KEY = new Object();
        private PreferenceChangeListener prefsListener;

        private void refreshKeys() {
            if (this.prefsListener == null) {
                this.addNotify();
            }
            ModuleBean[] items = ModuleNode.getAllModules().getModules();
            switch (ModuleNode.getModuleSortMode()) {
                case BY_CATEGORY: {
                    final Collator collator = Collator.getInstance();
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class CategoryComparator
                    implements Comparator<Object> {
                        CategoryComparator() {
                        }

                        @Override
                        public int compare(Object o1, Object o2) {
                            if (o1 == LIBRARY_KEY) {
                                if (o2 == LIBRARY_KEY) {
                                    return 0;
                                }
                                return 1;
                            }
                            if (o2 == LIBRARY_KEY) {
                                return -1;
                            }
                            if (o1 == BRIDGE_KEY) {
                                if (o2 == BRIDGE_KEY) {
                                    return 0;
                                }
                                return 1;
                            }
                            if (o2 == BRIDGE_KEY) {
                                return -1;
                            }
                            String name1 = o1 instanceof ModuleBean ? ((ModuleBean)o1).getDisplayName() : (String)o1;
                            String name2 = o2 instanceof ModuleBean ? ((ModuleBean)o2).getDisplayName() : (String)o2;
                            return collator.compare(name1, name2);
                        }
                    }
                    TreeSet<Object> categories = new TreeSet<Object>(new CategoryComparator());
                    for (ModuleBean item : items) {
                        if (item.getJar() == null || item.isAutoload()) {
                            categories.add(LIBRARY_KEY);
                            continue;
                        }
                        if (item.isEager()) {
                            categories.add(BRIDGE_KEY);
                            continue;
                        }
                        String category = item.getCategory();
                        if (category != null) {
                            categories.add(category);
                            continue;
                        }
                        categories.add(item);
                    }
                    this.setKeys(categories);
                    break;
                }
                case BY_DISPLAY_NAME: {
                    ArrayList<ModuleBean> itemsL = new ArrayList<ModuleBean>(Arrays.asList(items));
                    Collections.sort(itemsL, new Comparator<ModuleBean>(){
                        Collator coll = Collator.getInstance();

                        @Override
                        public int compare(ModuleBean m1, ModuleBean m2) {
                            return this.coll.compare(m1.getDisplayName(), m2.getDisplayName());
                        }
                    });
                    this.setKeys(itemsL);
                    break;
                }
                case BY_CLUSTER: {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class ClusterComparator
                    implements Comparator<Object> {
                        ClusterComparator() {
                        }

                        @Override
                        public int compare(Object o1, Object o2) {
                            if (o1 == NO_CLUSTER_KEY) {
                                if (o2 == NO_CLUSTER_KEY) {
                                    return 0;
                                }
                                return 1;
                            }
                            if (o2 == NO_CLUSTER_KEY) {
                                return -1;
                            }
                            return ((File)o1).compareTo((File)o2);
                        }
                    }
                    TreeSet<Object> clusters = new TreeSet<Object>(new ClusterComparator());
                    for (ModuleBean item : items) {
                        File cluster = item.getCluster();
                        if (cluster == null) {
                            clusters.add(NO_CLUSTER_KEY);
                            continue;
                        }
                        clusters.add(cluster);
                    }
                    this.setKeys(clusters);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        public void addNotify() {
            this.prefsListener = new PreferenceChangeListener(){

                public void preferenceChange(PreferenceChangeEvent evt) {
                    Modules.this.refreshKeys();
                }
            };
            ModuleNode.getPreferences().addPreferenceChangeListener(this.prefsListener);
            ModuleNode.getAllModules().addPropertyChangeListener(this);
            this.refreshKeys();
        }

        public void removeNotify() {
            if (this.prefsListener != null) {
                ModuleNode.getPreferences().removePreferenceChangeListener(this.prefsListener);
            }
            ModuleNode.getAllModules().removePropertyChangeListener(this);
            ModuleBean[] items = ModuleNode.getAllModules().getModules();
            for (int i = 0; i < items.length; ++i) {
                items[i].removePropertyChangeListener(this);
            }
        }

        public Node findChild(String name) {
            ModuleNode.getAllModules().waitForModules().waitFinished();
            this.refreshKeys();
            return super.findChild(name);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            this.refreshKeys();
        }

        protected Node[] createNodes(Object key) {
            if (key == LIBRARY_KEY) {
                return new Node[]{new LibraryNode()};
            }
            if (key == BRIDGE_KEY) {
                return new Node[]{new BridgeNode()};
            }
            if (key == NO_CLUSTER_KEY) {
                return new Node[]{new NoClusterNode()};
            }
            if (key instanceof String) {
                return new Node[]{new CategoryNode((String)key)};
            }
            if (key instanceof File) {
                return new Node[]{new ClusterNode((File)key)};
            }
            return new Node[]{new Item((ModuleBean)key)};
        }
    }

    private static final class NoClusterChildren
    extends DirectModuleChildren {
        protected boolean contains(ModuleBean module) {
            return module.getCluster() == null;
        }
    }

    private static final class NoClusterNode
    extends ModuleFolderNode {
        NoClusterNode() {
            super(new NoClusterChildren());
            this.setName("noCluster");
            this.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"LBL_ModuleNode_no_cluster"));
            this.updateDisplayStuff();
            this.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, null));
        }

        protected boolean supportsEnabledProperty() {
            return true;
        }

        protected boolean contains(ModuleBean module) {
            return module.getCluster() == null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SortMode {
        BY_CATEGORY,
        BY_DISPLAY_NAME,
        BY_CLUSTER;

    }
}

