/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.Module;
import org.netbeans.modules.autoupdate.catalog.ModuleBean;
import org.netbeans.modules.autoupdate.catalog.ModuleNode;
import org.netbeans.modules.autoupdate.catalog.ModuleNodeUtils;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;

public class ModuleNodeActions {

    public static class EnableAllAction
    extends NodeAction {
        protected void performAction(Node[] activatedNodes) {
            assert (activatedNodes != null) : "Cannot performAction when activatedNodes is null";
            ModuleBean.AllModulesBean.getDefault().pause();
            for (ModuleBean bean : ModuleBean.AllModulesBean.getDefault().getModules()) {
                if (bean.isEnabled() || !ModuleNodeUtils.isEnableAllowed(bean.getModule())) continue;
                bean.setEnabled(true);
            }
            ModuleBean.AllModulesBean.getDefault().resume();
        }

        protected boolean enable(Node[] activatedNodes) {
            return activatedNodes != null && activatedNodes.length > 0;
        }

        public String getName() {
            return NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_EnableAllAction");
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return true;
        }
    }

    public static class EnableDisableAction
    extends NodeAction {
        private String name;

        protected void performAction(Node[] activatedNodes) {
            assert (activatedNodes != null) : "Cannot performAction when activatedNodes is null";
            Boolean b = ModuleNodeUtils.isEnableCandidate(activatedNodes);
            assert (b != null) : "Cannot performAction if mixed statuses on activatedNodes " + Arrays.asList(activatedNodes);
            ModuleBean.AllModulesBean.getDefault().pause();
            Set<ModuleBean> beans = ModuleNodeUtils.getAllSelectedModuleBeans(activatedNodes);
            for (ModuleBean bean : beans) {
                bean.setEnabled(b);
            }
            ModuleBean.AllModulesBean.getDefault().resume();
        }

        protected boolean enable(Node[] activatedNodes) {
            if (activatedNodes == null) {
                return false;
            }
            Set<ModuleNode.Item> items = ModuleNodeUtils.getAllSelectedModuleItems(activatedNodes);
            boolean allowed = !items.isEmpty();
            String moduleName = "";
            for (ModuleNode.Item item : items) {
                Module m = item.getItem().getModule();
                moduleName = m.getDisplayName();
                if (ModuleNodeUtils.isEnableAllowed(m)) continue;
                allowed = false;
                break;
            }
            Boolean b = ModuleNodeUtils.isEnableCandidate(activatedNodes);
            this.name = activatedNodes.length == 1 && !(activatedNodes[0] instanceof ModuleNode.Item) ? NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_EnableDisableAction_format", (Object)(b == null || b != false ? NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_EnableDisableAction_enable") : NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_EnableDisableAction_disable")), (Object)activatedNodes[0].getDisplayName()) : NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_EnableDisableAction_format", (Object)(b == null || b != false ? NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_EnableDisableAction_enable") : NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_EnableDisableAction_disable")), (Object)(items.size() > 1 ? NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_EnableDisableAction_many") : moduleName));
            return allowed && ModuleNodeUtils.isEnableCandidate(activatedNodes) != null;
        }

        public String getName() {
            return this.name;
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return true;
        }
    }

    public static class SortAction
    extends NodeAction
    implements Presenter.Popup {
        JMenu subMenu;
        JRadioButtonMenuItem sortByCategory;
        JRadioButtonMenuItem sortByName;
        JRadioButtonMenuItem sortByCluster;

        protected void performAction(Node[] activatedNodes) {
        }

        protected boolean enable(Node[] activatedNodes) {
            return true;
        }

        public String getName() {
            return NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_SortAction");
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        public JMenuItem getPopupPresenter() {
            return this.getSubmenuPopupPresenter();
        }

        public JMenuItem getSubmenuPopupPresenter() {
            if (this.subMenu == null) {
                this.subMenu = new JMenu();
                Mnemonics.setLocalizedText((AbstractButton)this.subMenu, (String)NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_SortAction"));
                this.sortByCategory = new JRadioButtonMenuItem();
                Mnemonics.setLocalizedText((AbstractButton)this.sortByCategory, (String)NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_SortByCategory"));
                this.sortByCategory.addActionListener(new MenuListener());
                this.subMenu.add(this.sortByCategory);
                this.sortByName = new JRadioButtonMenuItem();
                Mnemonics.setLocalizedText((AbstractButton)this.sortByName, (String)NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_SortByName"));
                this.sortByName.addActionListener(new MenuListener());
                this.subMenu.add(this.sortByName);
                this.sortByCluster = new JRadioButtonMenuItem();
                Mnemonics.setLocalizedText((AbstractButton)this.sortByCluster, (String)NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_SortByCluster"));
                this.sortByCluster.addActionListener(new MenuListener());
                this.subMenu.add(this.sortByCluster);
            }
            this.sortByCategory.setSelected(ModuleNode.getModuleSortMode() == ModuleNode.SortMode.BY_CATEGORY);
            this.sortByName.setSelected(ModuleNode.getModuleSortMode() == ModuleNode.SortMode.BY_DISPLAY_NAME);
            this.sortByCluster.setSelected(ModuleNode.getModuleSortMode() == ModuleNode.SortMode.BY_CLUSTER);
            return this.subMenu;
        }

        private class MenuListener
        implements ActionListener {
            private MenuListener() {
            }

            public void actionPerformed(ActionEvent e) {
                JMenuItem source = (JMenuItem)e.getSource();
                if (SortAction.this.sortByCategory.equals(source)) {
                    ModuleNode.setModuleSortMode(ModuleNode.SortMode.BY_CATEGORY);
                } else if (SortAction.this.sortByName.equals(source)) {
                    ModuleNode.setModuleSortMode(ModuleNode.SortMode.BY_DISPLAY_NAME);
                } else if (SortAction.this.sortByCluster.equals(source)) {
                    ModuleNode.setModuleSortMode(ModuleNode.SortMode.BY_CLUSTER);
                } else assert (false) : "Invalid source " + source + " in actionPerformed()";
            }
        }
    }

    public static class UninstallAction
    extends NodeAction {
        private String name;

        protected void performAction(Node[] activatedNodes) {
            ModuleNodeUtils.doUninstall(activatedNodes);
        }

        protected boolean enable(Node[] activatedNodes) {
            this.name = ModuleNodeUtils.getUninstallActionName(activatedNodes, this.name);
            return ModuleNodeUtils.canUninstall(activatedNodes);
        }

        public String getName() {
            return this.name;
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return true;
        }
    }
}

