/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.CharConversionException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.catalog.ModuleBean;
import org.netbeans.modules.autoupdate.catalog.ModuleDeleter;
import org.netbeans.modules.autoupdate.catalog.ModuleNode;
import org.netbeans.modules.autoupdate.catalog.ModuleNodeUtils;
import org.netbeans.modules.autoupdate.catalog.ModuleUpdaterProgress;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.AsyncGUIJob;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.xml.XMLUtil;

public class ModuleSelectionPanel
extends JPanel
implements PropertyChangeListener {
    private TreeTableView treeTableView;
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.catalog.ModuleSelectionPanel");
    private static final int DEF_TREE_WIDTH = 420;
    private static final int DEF_0_COL_WIDTH = 60;
    private static final int DEF_1_COL_WIDTH = 150;
    private static final int DEF_HEIGHT = 350;
    private static ModuleDeleter deleter;
    private Cursor cursor = null;
    private static ModuleSelectionPanel panel;
    private boolean isWaiting = false;
    private Dialog d = null;
    private ChangeListener statusTextListener = null;
    private JEditorPane description;
    private JLabel descriptionLabel;
    private JScrollPane descriptionPane;
    private JLabel modulesLabel;
    private JPanel modulesPane;
    private JButton uninstallButton;
    private ExplorerManager manager;

    public static ModuleSelectionPanel getGUI(boolean create) {
        assert (create || panel != null);
        if (panel == null && create) {
            panel = new ModuleSelectionPanel();
        }
        return panel;
    }

    private ModuleSelectionPanel() {
        this.initComponents();
        this.treeTableView = new TreeTableView();
        this.treeTableView.setRootVisible(false);
        ExplorerPanel explorerPanel = new ExplorerPanel();
        explorerPanel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(ModuleSelectionPanel.class).getString("ACN_ModuleSelectionPanel_ExplorerPanel"));
        explorerPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ModuleSelectionPanel.class).getString("ACD_ModuleSelectionPanel_ExplorerPanel"));
        explorerPanel.setLayout(new BorderLayout());
        explorerPanel.add((Component)this.treeTableView, "Center");
        this.modulesPane.add((Component)((Object)explorerPanel), "Center");
        this.manager = explorerPanel.getExplorerManager();
        Font f = UIManager.getFont("controlFont");
        Integer i = (Integer)UIManager.get("nbDefaultFontSize");
        if (i == null) {
            i = new Integer(11);
        }
        if (f == null) {
            f = this.getFont();
        }
        Node.Property[] properties = new Node.Property[]{new PropertySupport.ReadWrite("enabled", Boolean.TYPE, NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_enabled"), NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_enabled")){

            public Object getValue() {
                return null;
            }

            public void setValue(Object o) {
            }
        }, new PropertySupport.ReadOnly("specificationVersion", String.class, NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_specversion"), NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_specversion")){

            public Object getValue() {
                return null;
            }
        }};
        this.treeTableView.setProperties(properties);
        if (f.getSize() > i) {
            this.sizeTTVCarefully();
        } else {
            this.treeTableView.setPreferredSize(new Dimension(630, 350));
            this.treeTableView.setTreePreferredWidth(420);
            this.treeTableView.setTableColumnPreferredWidth(0, 60);
            this.treeTableView.setTableColumnPreferredWidth(1, 150);
        }
        this.treeTableView.setPopupAllowed(true);
        this.treeTableView.setDefaultActionAllowed(false);
        this.treeTableView.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
        this.treeTableView.setVerticalScrollBarPolicy(20);
        this.initAccessibility();
        Utilities.attachInitJob((Component)this, (AsyncGUIJob)new WarmupJob());
        this.setWaitingState(true, false);
    }

    public void setWaitingState(boolean wait, final boolean showProgress) {
        if (this.isWaiting == wait) {
            return;
        }
        this.isWaiting = wait;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ModuleSelectionPanel.this.doSetWaitingState(ModuleSelectionPanel.this.isWaiting, showProgress);
            }
        });
    }

    private void doSetWaitingState(boolean wait, boolean showProgress) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.isVisible()) {
            return;
        }
        err.log(Level.FINE, "Set waiting state on ModuleSelectionPanel to (wait:" + wait + ", showProgress: " + showProgress + ")");
        this.uninstallButton.setEnabled(!wait);
        if (wait) {
            if (this.cursor == null) {
                this.cursor = this.getCursor();
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (showProgress && this.d == null) {
                final ProgressHandle handle = ProgressHandleFactory.createHandle((String)"modules-update");
                ModuleUpdaterProgress progressPanel = new ModuleUpdaterProgress(handle);
                DialogDescriptor dd = new DialogDescriptor((Object)progressPanel, NbBundle.getMessage(ModuleUpdaterProgress.class, (String)"CTL_ModuleUpdaterProgress_Title"), true, new Object[0], null, 0, null, null, true);
                this.statusTextListener = new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        handle.progress(StatusDisplayer.getDefault().getStatusText());
                    }
                };
                StatusDisplayer.getDefault().addChangeListener(this.statusTextListener);
                this.d = DialogDisplayer.getDefault().createDialog(dd);
                handle.start();
                this.d.setVisible(true);
            }
        } else {
            if (this.cursor != null) {
                this.setCursor(this.cursor);
                this.cursor = null;
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
            if (this.d != null && this.d.isVisible()) {
                this.d.setVisible(false);
                this.d.dispose();
                this.d = null;
                this.requestFocus();
            }
            if (this.statusTextListener != null) {
                StatusDisplayer.getDefault().removeChangeListener(this.statusTextListener);
            }
        }
    }

    public boolean isWaitingState() {
        return this.isWaiting;
    }

    private void prepareComponents() {
        block4: {
            this.uninstallButton.setEnabled(false);
            HTMLEditorKit htmlkit = new HTMLEditorKit();
            StyleSheet css = htmlkit.getStyleSheet();
            if (css.getStyleSheets() == null) {
                StyleSheet css2 = new StyleSheet();
                Font f = this.treeTableView.getFont();
                int size = this.treeTableView.getFont().getSize();
                css2.addRule(new StringBuffer("body { font-size: ").append(size).append("; font-family: ").append(f.getName()).append("; }").toString());
                css2.addStyleSheet(css);
                htmlkit.setStyleSheet(css2);
            }
            this.description.setEditorKit(htmlkit);
            ModuleNode node = new ModuleNode();
            this.manager.setRootContext((Node)node);
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            Node[] kids = node.getChildren().getNodes(true);
            if (kids.length > 0) {
                try {
                    this.manager.setSelectedNodes(new Node[]{kids[0]});
                }
                catch (PropertyVetoException ex) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)ex);
                }
            }
        }
    }

    private void sizeTTVCarefully() {
        Font headerFont = (Font)UIManager.getDefaults().get("TableHeader.font");
        Font tableFont = (Font)UIManager.getDefaults().get("Table.font");
        FontMetrics headerFm = this.getFontMetrics(headerFont);
        int enabledColWidth = Math.max(60, headerFm.stringWidth(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_enabled")) + 20);
        int specColWidth = Math.max(150, headerFm.stringWidth(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_specversion")) + 20);
        int defFontSize = UIManager.getDefaults().getInt("nbDefaultFontSize");
        int treeWidth = 420 + 10 * (tableFont.getSize() - defFontSize);
        this.treeTableView.setPreferredSize(new Dimension(treeWidth + enabledColWidth + specColWidth, 350 + 10 * (tableFont.getSize() - defFontSize)));
        this.treeTableView.setTreePreferredWidth(treeWidth);
        this.treeTableView.setTableColumnPreferredWidth(0, enabledColWidth);
        this.treeTableView.setTableColumnPreferredWidth(1, specColWidth);
    }

    private void initComponents() {
        this.modulesLabel = new JLabel();
        this.uninstallButton = new JButton();
        this.descriptionLabel = new JLabel();
        this.descriptionPane = new JScrollPane();
        this.description = new JEditorPane();
        this.modulesPane = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setName(NbBundle.getMessage(ModuleSelectionPanel.class, (String)"LBL_ModuleSelectionPanel_Name"));
        this.modulesLabel.setLabelFor(this.modulesPane);
        Mnemonics.setLocalizedText((JLabel)this.modulesLabel, (String)NbBundle.getBundle(ModuleSelectionPanel.class).getString("ModuleSelectionPanel_ModuleLabel_text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(7, 11, 0, 0);
        this.add((Component)this.modulesLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.uninstallButton, (String)NbBundle.getMessage(ModuleSelectionPanel.class, (String)"BTN_ModuleSelectionPanel_Uninstall"));
        this.uninstallButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModuleSelectionPanel.this.uninstallButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 8, 0, 12);
        this.add((Component)this.uninstallButton, gridBagConstraints);
        this.descriptionLabel.setLabelFor(this.descriptionPane);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(ModuleSelectionPanel.class, (String)"LBL_ModuleSelectionPanel_descriptionLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(8, 11, 0, 0);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
        this.descriptionPane.setMinimumSize(new Dimension(400, 70));
        this.descriptionPane.setPreferredSize(new Dimension(400, 70));
        this.description.setEditable(false);
        this.descriptionPane.setViewportView(this.description);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.85;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(2, 11, 0, 0);
        this.add((Component)this.descriptionPane, gridBagConstraints);
        this.modulesPane.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.85;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.insets = new Insets(2, 11, 0, 0);
        this.add((Component)this.modulesPane, gridBagConstraints);
    }

    private void uninstallButtonActionPerformed(ActionEvent evt) {
        ModuleNodeUtils.doUninstall(this.manager.getSelectedNodes());
    }

    private void prevButtonActionPerformed(ActionEvent evt) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        block5: {
            ModuleBean bean;
            block6: {
                if (evt.getSource() != this.manager) break block5;
                if ("selectedNodes".equals(evt.getPropertyName())) break block6;
                if (!"nodeChange".equals(evt.getPropertyName())) break block5;
            }
            final Node[] nodes = this.manager.getSelectedNodes();
            String text = "";
            if (nodes.length == 1 && (bean = (ModuleBean)nodes[0].getLookup().lookup(ModuleBean.class)) != null) {
                try {
                    text = "<b>" + XMLUtil.toElementContent((String)bean.getModule().getDisplayName()) + "</b>";
                    String longDesc = bean.getLongDescription();
                    if (longDesc != null) {
                        text = text + "<br>" + XMLUtil.toElementContent((String)longDesc);
                    }
                }
                catch (CharConversionException e) {
                    err.log(Level.WARNING, null, e);
                }
            }
            this.description.setText(text);
            this.description.setCaretPosition(0);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModuleSelectionPanel.this.treeTableView.requestFocus();
                    ModuleSelectionPanel.this.uninstallButton.setEnabled(!ModuleSelectionPanel.this.isWaitingState() && ModuleNodeUtils.canUninstall(nodes));
                }
            });
        }
    }

    public void initAccessibility() {
        ResourceBundle b = NbBundle.getBundle(this.getClass());
        this.getAccessibleContext().setAccessibleDescription(b.getString("ACSD_ModuleSelectionPanel"));
    }

    static {
        panel = null;
    }

    private static class ExplorerPanel
    extends TopComponent
    implements ExplorerManager.Provider {
        private ExplorerManager mgr = new ExplorerManager();

        public ExplorerPanel() {
            ActionMap map = this.getActionMap();
            map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.mgr, (boolean)false));
            this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.mgr, (ActionMap)map));
        }

        public ExplorerManager getExplorerManager() {
            return this.mgr;
        }

        protected void componentActivated() {
            ExplorerUtils.activateActions((ExplorerManager)this.mgr, (boolean)true);
        }

        protected void componentDeactivated() {
            ExplorerUtils.activateActions((ExplorerManager)this.mgr, (boolean)false);
        }
    }

    private class WarmupJob
    implements AsyncGUIJob {
        private WarmupJob() {
        }

        public void construct() {
            ModuleSelectionPanel.this.prepareComponents();
        }

        public void finished() {
            ModuleSelectionPanel.this.setWaitingState(false, false);
            ModuleSelectionPanel.this.treeTableView.requestFocus();
        }
    }
}

