/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openide.ErrorManager;

public final class Diagnostics {
    private static PrintWriter log;
    private static String path;
    public static final boolean ON;
    private static final SimpleDateFormat defaultFormat;

    public static synchronized void println(String msg) {
        if (log != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(defaultFormat.format(new Date(System.currentTimeMillis())));
            sb.append(":");
            sb.append(msg);
            sb.append('\t');
            sb.append(Thread.currentThread().getName());
            log.println(sb.toString());
            log.flush();
        }
    }

    public static synchronized void logCreate(File file, File storeFile, long ts, String from, String to) {
        StringBuffer sb = new StringBuffer();
        sb.append("create");
        sb.append('\t');
        sb.append(file.getAbsolutePath());
        sb.append('\t');
        sb.append(storeFile.getAbsolutePath());
        sb.append('\t');
        sb.append(ts);
        sb.append('\t');
        sb.append(from);
        sb.append('\t');
        sb.append(to);
        Diagnostics.println(sb.toString());
    }

    public static synchronized void logChange(File file, File storeFile, long ts) {
        StringBuffer sb = new StringBuffer();
        sb.append("change");
        sb.append('\t');
        sb.append(file.getAbsolutePath());
        sb.append('\t');
        sb.append(storeFile.getAbsolutePath());
        sb.append('\t');
        sb.append(ts);
        Diagnostics.println(sb.toString());
    }

    public static synchronized void logDelete(File file, File storeFile, long ts) {
        StringBuffer sb = new StringBuffer();
        sb.append("delete");
        sb.append('\t');
        sb.append(file.getAbsolutePath());
        sb.append('\t');
        sb.append(storeFile.getAbsolutePath());
        sb.append('\t');
        sb.append(ts);
        Diagnostics.println(sb.toString());
    }

    public String toString() {
        return "" + path;
    }

    static {
        defaultFormat = new SimpleDateFormat("dd-MM-yyyy:HH-mm-ss.S");
        path = System.getProperty("netbeans.debug.localHistoryLog");
        if (path != null && !path.trim().equals("")) {
            try {
                log = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(path, true)), "utf8"));
                System.err.println("LocalHistory diagnostics: ON");
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                log = null;
            }
        }
        ON = log != null;
    }
}

