/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory;

import java.io.File;
import org.netbeans.modules.localhistory.Diagnostics;
import org.netbeans.modules.localhistory.LocalHistoryVCSAnnotator;
import org.netbeans.modules.localhistory.LocalHistoryVCSInterceptor;
import org.netbeans.modules.localhistory.store.LocalHistoryStore;
import org.netbeans.modules.localhistory.store.LocalHistoryStoreFactory;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSInterceptor;

public class LocalHistory {
    private static LocalHistory instance;
    private VCSInterceptor vcsInterceptor;
    private VCSAnnotator vcsAnnotator;
    private LocalHistoryStore store;
    private static String userDir;

    public static synchronized LocalHistory getInstance() {
        if (instance == null) {
            instance = new LocalHistory();
        }
        return instance;
    }

    VCSInterceptor getVCSInterceptor() {
        if (this.vcsInterceptor == null) {
            this.vcsInterceptor = new LocalHistoryVCSInterceptor();
        }
        return this.vcsInterceptor;
    }

    VCSAnnotator getVCSAnnotator() {
        if (this.vcsAnnotator == null) {
            this.vcsAnnotator = new LocalHistoryVCSAnnotator();
        }
        return this.vcsAnnotator;
    }

    public LocalHistoryStore getLocalHistoryStore() {
        if (this.store == null) {
            this.store = LocalHistoryStoreFactory.getInstance().createLocalHistoryStorage();
        }
        return this.store;
    }

    private String getUserDir() {
        if (userDir == null) {
            userDir = System.getProperty("netbeans.user");
        }
        return userDir;
    }

    File isManagedByParent(File file) {
        File parent = file.getParentFile();
        while (parent != null) {
            if (parent.getAbsolutePath().equals(this.getUserDir())) {
                return null;
            }
            file = parent;
            parent = file.getParentFile();
        }
        return file;
    }

    boolean isManaged(File file) {
        if (Diagnostics.ON) {
            Diagnostics.println(".isManaged() " + file);
        }
        return true;
    }
}

