/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory;

import java.io.File;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class LocalHistorySettings {
    private static final LocalHistorySettings INSTANCE = new LocalHistorySettings();
    private static final String LAST_SELECTED_ENTRY = "RevertFileChanges.lastSelected";
    private static final String PROP_TTL = "timeToLive";
    private static final String PROP_KEEP_STORED = "filesToKeepStored";

    private LocalHistorySettings() {
    }

    public static LocalHistorySettings getInstance() {
        return INSTANCE;
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(LocalHistorySettings.class);
    }

    public void setKeepStored(int keep) {
        this.getPreferences().putInt(PROP_KEEP_STORED, keep);
    }

    public int getKeepStored() {
        return this.getPreferences().getInt(PROP_KEEP_STORED, 5);
    }

    public void setTTL(int ttl) {
        this.getPreferences().putInt(PROP_TTL, ttl);
    }

    public int getTTL() {
        return this.getPreferences().getInt(PROP_TTL, 7);
    }

    public int getTTLMillis() {
        return this.getTTL() * 24 * 60 * 60 * 1000;
    }

    public void setLastSelectedEntry(File file, long ts) {
        this.getPreferences().putLong("RevertFileChanges.lastSelected#" + file.getAbsoluteFile(), ts);
    }

    public long getLastSelectedEntry(File file) {
        return this.getPreferences().getLong("RevertFileChanges.lastSelected#" + file.getAbsoluteFile(), -1L);
    }
}

