/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.options;

import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.netbeans.modules.localhistory.LocalHistorySettings;
import org.netbeans.modules.localhistory.options.LocalHistoryOptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public final class LocalHistoryOptionsController
extends OptionsPanelController {
    private final LocalHistoryOptionsPanel panel = new LocalHistoryOptionsPanel();

    public void update() {
        this.panel.keepStoredTextField.setText(Long.toString(LocalHistorySettings.getInstance().getKeepStored()));
        this.panel.daysTextField.setText(Long.toString(LocalHistorySettings.getInstance().getTTL()));
    }

    public void applyChanges() {
        LocalHistorySettings.getInstance().setKeepStored(Integer.parseInt(this.panel.keepStoredTextField.getText()));
        LocalHistorySettings.getInstance().setTTL(Integer.parseInt(this.panel.daysTextField.getText()));
    }

    public void cancel() {
    }

    public boolean isValid() {
        try {
            Integer.parseInt(this.panel.keepStoredTextField.getText());
            Long.parseLong(this.panel.daysTextField.getText());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public boolean isChanged() {
        String keep = Long.toString(LocalHistorySettings.getInstance().getKeepStored());
        String ttl = Long.toString(LocalHistorySettings.getInstance().getTTL());
        return keep.equals(this.panel.keepStoredTextField.getText()) && ttl.equals(this.panel.daysTextField.getText());
    }

    public JComponent getComponent(Lookup masterLookup) {
        return this.panel;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("netbeans.optionsDialog.advanced.localhistory");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }
}

