/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.store;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.localhistory.Diagnostics;
import org.netbeans.modules.localhistory.store.LocalHistoryStore;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.utils.FileUtils;
import org.netbeans.modules.turbo.CustomProviders;
import org.netbeans.modules.turbo.Turbo;
import org.netbeans.modules.turbo.TurboProvider;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalHistoryStoreImpl
implements LocalHistoryStore {
    private static final int DELETED = 0;
    private static final int TOUCHED = 1;
    private static final String DATA_FILE = "data";
    private static final String HISTORY_FILE = "history";
    private static final String LABELS_FILE = "labels";
    private File storage;
    private Turbo turbo;
    private DataFilesTurboProvider cacheProvider;
    private final PropertyChangeSupport propertyChangeSupport;
    private static List<HistoryEntry> emptyHistory = new ArrayList<HistoryEntry>(0);
    private static Map<Long, String> emptyLabels = new HashMap<Long, String>();
    private static StoreEntry[] emptyStoreEntryArray = new StoreEntry[0];
    private static FilenameFilter fileEntriesFilter = new FilenameFilter(){

        public boolean accept(File dir, String fileName) {
            return !fileName.endsWith(LocalHistoryStoreImpl.DATA_FILE) && !fileName.endsWith(LocalHistoryStoreImpl.HISTORY_FILE) && !fileName.endsWith(LocalHistoryStoreImpl.LABELS_FILE);
        }
    };

    LocalHistoryStoreImpl() {
        this.initStorage();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.cacheProvider = new DataFilesTurboProvider();
        this.turbo = Turbo.createCustom((CustomProviders)new CustomProviders(){
            private final Set providers;
            {
                this.providers = Collections.singleton(LocalHistoryStoreImpl.this.cacheProvider);
            }

            public Iterator providers() {
                return this.providers.iterator();
            }
        }, (int)20, (int)-1);
    }

    @Override
    public synchronized void fileCreate(File file, long ts) {
        try {
            this.fileCreateImpl(file, ts, null, file.getAbsolutePath());
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
        }
    }

    private void fileCreateImpl(File file, long ts, String from, String to) throws IOException {
        if (this.lastModified(file) > 0L) {
            return;
        }
        String tsString = Long.toString(ts);
        File storeFile = null;
        if (file.isFile()) {
            storeFile = this.getStoreFile(file, tsString, true);
            FileUtils.copy(file, StoreEntry.createStoreFileOutputSteam(storeFile));
            if (Diagnostics.ON) {
                Diagnostics.logCreate(file, storeFile, ts, from, to);
            }
        }
        this.touch(file, new StoreDataFile(file.getAbsolutePath(), 1, ts, file.isFile()));
        File parent = file.getParentFile();
        if (parent != null) {
            this.writeHistoryForFile(parent, new HistoryEntry[]{new HistoryEntry(ts, from, to, 1)});
        }
        this.fireChanged(null, file);
    }

    @Override
    public synchronized void fileChange(File file, long ts) {
        long lastModified = this.lastModified(file);
        if (lastModified == ts) {
            return;
        }
        if (file.isFile()) {
            try {
                File storeFile = this.getStoreFile(file, Long.toString(ts), true);
                FileUtils.copy(file, StoreEntry.createStoreFileOutputSteam(storeFile));
                if (Diagnostics.ON) {
                    Diagnostics.logChange(file, storeFile, ts);
                }
                this.touch(file, new StoreDataFile(file.getAbsolutePath(), 1, ts, file.isFile()));
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(16, (Throwable)ioe);
            }
        } else {
            try {
                this.touch(file, new StoreDataFile(file.getAbsolutePath(), 1, ts, file.isFile()));
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(16, (Throwable)ioe);
            }
        }
        this.fireChanged(null, file);
    }

    @Override
    public synchronized void fileDelete(File file, long ts) {
        try {
            this.fileDeleteImpl(file, null, file.getAbsolutePath(), ts);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
        }
        this.fireChanged(null, file);
    }

    private void fileDeleteImpl(File file, String from, String to, long ts) throws IOException {
        StoreDataFile data = this.readStoreData(file, true);
        if (data == null) {
            if (Diagnostics.ON) {
                Diagnostics.println("deleting without data for file : " + file);
            }
            return;
        }
        long lastModified = data.getLastModified();
        boolean isFile = data.isFile();
        if (Diagnostics.ON) {
            File storeFile = this.getDataFile(file);
            Diagnostics.logDelete(file, storeFile, ts);
        }
        this.touch(file, new StoreDataFile(file.getAbsolutePath(), 0, lastModified, isFile));
        File parent = file.getParentFile();
        if (parent != null) {
            this.writeHistoryForFile(parent, new HistoryEntry[]{new HistoryEntry(ts, from, to, 0)});
        }
    }

    @Override
    public synchronized void fileCreateFromMove(File from, File to, long ts) {
        if (this.lastModified(to) > 0L) {
            return;
        }
        try {
            this.fileCreateImpl(to, ts, from.getAbsolutePath(), to.getAbsolutePath());
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
        }
        this.fireChanged(null, to);
    }

    @Override
    public synchronized void fileDeleteFromMove(File from, File to, long ts) {
        try {
            this.fileDeleteImpl(from, from.getAbsolutePath(), to.getAbsolutePath(), ts);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
        }
        this.fireChanged(null, from);
    }

    private long lastModified(File file) {
        StoreDataFile data = this.readStoreData(file, true);
        return data != null && data.getStatus() != 0 ? data.getLastModified() : -1L;
    }

    @Override
    public synchronized StoreEntry[] getStoreEntries(File file) {
        return this.getStoreEntriesImpl(file);
    }

    private StoreEntry[] getStoreEntriesImpl(File file) {
        File storeFolder = this.getStoreFolder(file);
        File[] storeFiles = storeFolder.listFiles(fileEntriesFilter);
        if (storeFiles != null && storeFiles.length > 0) {
            ArrayList<StoreEntry> ret = new ArrayList<StoreEntry>(storeFiles.length);
            if (storeFiles.length > 0) {
                Map<Long, String> labels = this.getLabels(this.getLabelsFile(file));
                for (int i = 0; i < storeFiles.length; ++i) {
                    long ts = Long.parseLong(storeFiles[i].getName());
                    String label = labels.get(ts);
                    ret.add(StoreEntry.createStoreEntry(file, storeFiles[i], ts, label));
                }
                return ret.toArray(new StoreEntry[storeFiles.length]);
            }
            return emptyStoreEntryArray;
        }
        return emptyStoreEntryArray;
    }

    @Override
    public StoreEntry[] getFolderState(File root, File[] files, long ts) {
        List<HistoryEntry> parentHistory;
        File parentFile = root.getParentFile();
        if (parentFile != null && this.wasDeleted(root, parentHistory = this.readHistoryForFile(parentFile), ts)) {
            return emptyStoreEntryArray;
        }
        List<HistoryEntry> history = this.readHistoryForFile(root);
        ArrayList<StoreEntry> ret = new ArrayList<StoreEntry>();
        HashMap<File, HistoryEntry> beforeRevert = new HashMap<File, HistoryEntry>();
        HashMap<File, HistoryEntry> afterRevert = new HashMap<File, HistoryEntry>();
        for (HistoryEntry historyEntry : history) {
            File file = new File(historyEntry.getTo());
            if (historyEntry.getTimestamp() < ts) {
                beforeRevert.put(file, historyEntry);
                continue;
            }
            if (afterRevert.containsKey(file)) continue;
            afterRevert.put(file, historyEntry);
        }
        for (File file : files) {
            HistoryEntry before = (HistoryEntry)beforeRevert.get(file);
            HistoryEntry after = (HistoryEntry)afterRevert.get(file);
            beforeRevert.remove(file);
            afterRevert.remove(file);
            if (before != null && before.getStatus() == 0) {
                ret.add(StoreEntry.createDeletedStoreEntry(file, ts));
                continue;
            }
            StoreDataFile data = this.readStoreData(file, true);
            if (data == null) continue;
            if (data.isFile()) {
                StoreEntry se = this.getStoreEntry(file, ts);
                if (se != null) {
                    ret.add(se);
                    continue;
                }
                if (after == null || after.getStatus() != 1) continue;
                ret.add(StoreEntry.createDeletedStoreEntry(file, ts));
                continue;
            }
            if (after == null || after.getStatus() != 1) continue;
            ret.add(StoreEntry.createDeletedStoreEntry(file, ts));
        }
        for (Map.Entry entry : beforeRevert.entrySet()) {
            StoreDataFile data;
            File file = (File)entry.getKey();
            afterRevert.remove(file);
            if (((HistoryEntry)entry.getValue()).getStatus() == 0 || (data = this.readStoreData(file, true)) == null) continue;
            if (data.isFile()) {
                StoreEntry se = this.getStoreEntry(file, ts);
                if (se == null) continue;
                ret.add(se);
                continue;
            }
            File storeFile = this.getStoreFolder(root);
            StoreEntry folderEntry = StoreEntry.createStoreEntry(new File(data.getAbsolutePath()), storeFile, data.getLastModified(), "");
            ret.add(folderEntry);
        }
        return ret.toArray(new StoreEntry[ret.size()]);
    }

    private boolean wasDeleted(File file, List<HistoryEntry> history, long ts) {
        String path = file.getAbsolutePath();
        boolean deleted = false;
        for (int i = 0; i < history.size(); ++i) {
            HistoryEntry he = history.get(i);
            if (he.getTo().equals(path)) {
                deleted = he.getStatus() == 0;
            }
            if (he.ts >= ts) break;
        }
        return deleted;
    }

    @Override
    public synchronized StoreEntry getStoreEntry(File file, long ts) {
        return this.getStoreEntryImpl(file, ts, this.readStoreData(file, true));
    }

    private StoreEntry getStoreEntryImpl(File file, long ts, StoreDataFile data) {
        StoreEntry entry = null;
        if (data == null) {
            return null;
        }
        if (data.isFile()) {
            StoreEntry[] entries;
            for (StoreEntry se : entries = this.getStoreEntriesImpl(file)) {
                if (se.getTimestamp() > ts || entry != null && se.getTimestamp() <= entry.getTimestamp()) continue;
                entry = se;
            }
        }
        return entry;
    }

    @Override
    public synchronized void deleteEntry(File file, long ts) {
        File storeFile = this.getStoreFile(file, Long.toString(ts), false);
        if (storeFile.exists()) {
            storeFile.delete();
        }
        this.fireChanged(file, null);
    }

    @Override
    public synchronized StoreEntry[] getDeletedFiles(File root) {
        if (root.isFile()) {
            return null;
        }
        HashMap<String, StoreEntry> deleted = new HashMap<String, StoreEntry>();
        List<HistoryEntry> entries = this.readHistoryForFile(root);
        for (HistoryEntry he : entries) {
            StoreDataFile data;
            String filePath;
            if (he.getStatus() != 0 || deleted.containsKey(filePath = he.getTo()) || (data = this.readStoreData(new File(he.getTo()), true)) == null || data.getStatus() != 0) continue;
            File storeFile = data.isFile ? this.getStoreFile(new File(data.getAbsolutePath()), Long.toString(data.getLastModified()), false) : this.getStoreFolder(root);
            deleted.put(filePath, StoreEntry.createStoreEntry(new File(data.getAbsolutePath()), storeFile, data.getLastModified(), ""));
        }
        return deleted.values().toArray(new StoreEntry[deleted.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setLabel(File file, long ts, String label) {
        File labelsFile = this.getLabelsFile(file);
        File parent = labelsFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        File labelsNew = null;
        FilterInputStream dis = null;
        FilterOutputStream oos = null;
        boolean foundLabel = false;
        try {
            block35: {
                if (!labelsFile.exists()) {
                    oos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(labelsFile)));
                    ((DataOutputStream)oos).writeLong(ts);
                    LocalHistoryStoreImpl.writeString((DataOutputStream)oos, label);
                } else {
                    labelsNew = new File(labelsFile.getParentFile(), labelsFile.getName() + ".new");
                    oos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(labelsNew)));
                    dis = LocalHistoryStoreImpl.getInputStream(labelsFile);
                    long readTs = -1L;
                    try {
                        while (true) {
                            if ((readTs = ((DataInputStream)dis).readLong()) == ts) {
                                ((DataOutputStream)oos).writeLong(readTs);
                                LocalHistoryStoreImpl.writeString((DataOutputStream)oos, label);
                                int len = ((DataInputStream)dis).readInt();
                                LocalHistoryStoreImpl.skip(dis, len * 2);
                                LocalHistoryStoreImpl.copyStreams(oos, dis);
                                break;
                            }
                            ((DataOutputStream)oos).writeLong(readTs);
                            String l = LocalHistoryStoreImpl.readString((DataInputStream)dis);
                            LocalHistoryStoreImpl.writeString((DataOutputStream)oos, l);
                        }
                    }
                    catch (EOFException e) {
                        if (foundLabel) break block35;
                        ((DataOutputStream)oos).writeLong(ts);
                        LocalHistoryStoreImpl.writeString((DataOutputStream)oos, label);
                    }
                }
            }
            ((DataOutputStream)oos).flush();
        }
        catch (EOFException e) {
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {}
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {}
            }
        }
        try {
            if (labelsNew != null) {
                FileUtils.renameFile(labelsNew, labelsFile);
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void cleanUp(final long ttl) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                if (Diagnostics.ON) {
                    Diagnostics.println("Cleanup Start");
                }
                LocalHistoryStoreImpl.this.cleanUpImpl(ttl);
                if (Diagnostics.ON) {
                    Diagnostics.println("Cleanup End");
                }
            }
        });
    }

    private void cleanUpImpl(long ttl) {
        long now = System.currentTimeMillis();
        File[] topLevelFiles = this.storage.listFiles();
        if (topLevelFiles == null || topLevelFiles.length == 0) {
            return;
        }
        for (File topLevelFile : topLevelFiles) {
            File[] secondLevelFiles = topLevelFile.listFiles();
            if (secondLevelFiles == null || secondLevelFiles.length == 0) {
                FileUtils.deleteRecursively(topLevelFile);
                continue;
            }
            boolean allEmpty = true;
            for (File secondLevelFile : secondLevelFiles) {
                boolean empty = this.cleanUpFolder(secondLevelFile, ttl, now);
                if (empty) {
                    if (!secondLevelFile.exists()) continue;
                    FileUtils.deleteRecursively(secondLevelFile);
                    continue;
                }
                allEmpty = false;
            }
            if (!allEmpty) continue;
            FileUtils.deleteRecursively(topLevelFile);
        }
    }

    private synchronized boolean cleanUpFolder(File folder, long ttl, long now) {
        File dataFile = new File(folder, DATA_FILE);
        if (!dataFile.exists()) {
            return this.cleanUpStoredFolder(folder, ttl, now);
        }
        StoreDataFile data = this.readStoreData(dataFile, false);
        if (data.getAbsolutePath() == null) {
            return true;
        }
        if (data.isFile()) {
            return this.cleanUpStoredFile(folder, ttl, now);
        }
        return this.cleanUpStoredFolder(folder, ttl, now);
    }

    private boolean cleanUpStoredFile(File store, long ttl, long now) {
        File dataFile = new File(store, DATA_FILE);
        if (!dataFile.exists()) {
            return true;
        }
        if (dataFile.lastModified() < now - ttl) {
            this.purgeDataFile(dataFile);
            return true;
        }
        File[] files = store.listFiles(fileEntriesFilter);
        boolean skipped = false;
        File labelsFile = new File(store, LABELS_FILE);
        Map<Long, String> labels = emptyLabels;
        if (labelsFile.exists()) {
            labels = this.getLabels(labelsFile);
        }
        for (File f : files) {
            long ts = Long.parseLong(f.getName());
            if (ts < now - ttl) {
                if (labels.size() > 0) {
                    labels.remove(ts);
                }
                f.delete();
                continue;
            }
            skipped = true;
        }
        if (!skipped) {
            labelsFile.delete();
            this.writeStoreData(dataFile, null, false);
        } else if (labels.size() > 0) {
            this.writeLabels(labelsFile, labels);
        }
        return !skipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLabels(File labelsFile, Map<Long, String> labels) {
        File parent = labelsFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        FilterInputStream dis = null;
        DataOutputStream oos = null;
        try {
            for (Map.Entry<Long, String> label : labels.entrySet()) {
                oos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(labelsFile)));
                oos.writeLong(label.getKey());
                LocalHistoryStoreImpl.writeString(oos, label.getValue());
            }
            oos.flush();
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {}
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private boolean cleanUpStoredFolder(File store, long ttl, long now) {
        boolean historyObsolete;
        File historyFile = new File(store, HISTORY_FILE);
        File dataFile = new File(store, DATA_FILE);
        boolean dataObsolete = !dataFile.exists() || dataFile.lastModified() < now - ttl;
        boolean bl = historyObsolete = !historyFile.exists() || historyFile.lastModified() < now - ttl;
        if (!historyObsolete) {
            List<HistoryEntry> entries = this.readHistory(historyFile);
            historyFile.delete();
            ArrayList<HistoryEntry> newEntries = new ArrayList<HistoryEntry>();
            for (HistoryEntry entry : entries) {
                if (entry.getTimestamp() <= now - ttl) continue;
                newEntries.add(entry);
            }
            if (newEntries.size() > 0) {
                this.writeHistory(historyFile, newEntries.toArray(new HistoryEntry[newEntries.size()]));
            } else {
                historyObsolete = true;
            }
        }
        if (dataObsolete) {
            this.purgeDataFile(dataFile);
        }
        if (historyObsolete) {
            historyFile.delete();
        }
        return dataObsolete && historyObsolete;
    }

    private void purgeDataFile(File dataFile) {
        if (dataFile.exists()) {
            this.writeStoreData(dataFile, null, false);
        }
    }

    private void fireChanged(File oldValue, File newValue) {
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "LocalHistoryStore.changed", oldValue, newValue));
    }

    private void touch(File file, StoreDataFile data) throws IOException {
        this.writeStoreData(file, data, true);
    }

    private void initStorage() {
        String userDir = System.getProperty("netbeans.user");
        this.storage = new File(new File(userDir, "var"), "filehistory");
        if (!this.storage.exists()) {
            this.storage.mkdirs();
        }
    }

    private File getStoreFolder(File file) {
        StoreDataFile data;
        String filePath = file.getAbsolutePath();
        File storeFolder = this.getStoreFolderName(filePath);
        int i = 0;
        while (storeFolder.exists() && (data = this.readStoreData(new File(storeFolder, DATA_FILE), false)) != null && !data.getAbsolutePath().equals(filePath)) {
            storeFolder = this.getStoreFolderName(filePath + "." + i++);
        }
        return storeFolder;
    }

    private File getStoreFolderName(String filePath) {
        int fileHash = filePath.hashCode();
        String storeFileName = this.getMD5(filePath);
        String storeIndex = this.storage.getAbsolutePath() + "/" + Integer.toString(fileHash % 173 + 172);
        return new File(storeIndex + "/" + storeFileName);
    }

    private String getMD5(String name) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        digest.update(name.getBytes());
        byte[] hash = digest.digest();
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(hash[i] & 0xFF);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            ret.append(hex);
        }
        return ret.toString();
    }

    private File getStoreFile(File file, String name, boolean mkdirs) {
        File storeFolder = this.getStoreFolder(file);
        if (mkdirs && !storeFolder.exists()) {
            storeFolder.mkdirs();
        }
        return new File(storeFolder, name);
    }

    private File getHistoryFile(File file) {
        File storeFolder = this.getStoreFolder(file);
        if (!storeFolder.exists()) {
            storeFolder.mkdirs();
        }
        return new File(storeFolder, HISTORY_FILE);
    }

    private File getDataFile(File file) {
        File storeFolder = this.getStoreFolder(file);
        return new File(storeFolder, DATA_FILE);
    }

    private File getLabelsFile(File file) {
        File storeFolder = this.getStoreFolder(file);
        return new File(storeFolder, LABELS_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, String> getLabels(File labelsFile) {
        if (!labelsFile.exists()) {
            return emptyLabels;
        }
        DataInputStream dis = null;
        HashMap<Long, String> ret = new HashMap<Long, String>();
        try {
            dis = LocalHistoryStoreImpl.getInputStream(labelsFile);
            while (true) {
                long ts = dis.readLong();
                String label = LocalHistoryStoreImpl.readString(dis);
                ret.put(ts, label);
            }
        }
        catch (EOFException e) {
            HashMap<Long, String> hashMap = ret;
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            return hashMap;
        }
        catch (Exception e) {
            try {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException e3) {}
                }
            }
        }
        return emptyLabels;
    }

    private void writeHistoryForFile(File file, HistoryEntry[] entries) {
        if (Diagnostics.ON && this.getDataFile(file) == null) {
            Diagnostics.println("writing history for file without data : " + file);
        }
        File history = this.getHistoryFile(file);
        this.writeHistory(history, entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHistory(File history, HistoryEntry[] entries) {
        DataOutputStream dos = null;
        try {
            dos = LocalHistoryStoreImpl.getOutputStream(history, true);
            for (HistoryEntry entry : entries) {
                dos.writeLong(entry.getTimestamp());
                LocalHistoryStoreImpl.writeString(dos, entry.getFrom());
                LocalHistoryStoreImpl.writeString(dos, entry.getTo());
                dos.writeInt(entry.getStatus());
            }
            dos.flush();
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return;
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private List<HistoryEntry> readHistoryForFile(File file) {
        return this.readHistory(this.getHistoryFile(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HistoryEntry> readHistory(File history) {
        if (!history.exists()) {
            return emptyHistory;
        }
        DataInputStream dis = null;
        ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        try {
            dis = LocalHistoryStoreImpl.getInputStream(history);
            while (true) {
                long ts = dis.readLong();
                String from = LocalHistoryStoreImpl.readString(dis);
                String to = LocalHistoryStoreImpl.readString(dis);
                int action = dis.readInt();
                entries.add(new HistoryEntry(ts, from, to, action));
            }
        }
        catch (EOFException e) {
            ArrayList<HistoryEntry> arrayList = entries;
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            return arrayList;
        }
        catch (Exception e) {
            try {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException e3) {}
                }
            }
        }
        return emptyHistory;
    }

    private StoreDataFile readStoreData(File file, boolean isOriginalFile) {
        if (isOriginalFile) {
            file = this.getDataFile(file);
        }
        return (StoreDataFile)this.turbo.readEntry((Object)file, "localhistory.ATTR_DATA_FILES");
    }

    private void writeStoreData(File file, StoreDataFile data, boolean isOriginalFile) {
        if (isOriginalFile) {
            file = this.getDataFile(file);
        }
        this.turbo.writeEntry((Object)file, "localhistory.ATTR_DATA_FILES", (Object)data);
    }

    private static void writeString(DataOutputStream dos, String str) throws IOException {
        if (str != null) {
            dos.writeInt(str.length());
            dos.writeChars(str);
        } else {
            dos.writeInt(0);
        }
    }

    private static String readString(DataInputStream dis) throws IOException {
        int len = dis.readInt();
        if (len == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        while (len-- > 0) {
            char c = dis.readChar();
            sb.append(c);
        }
        return sb.toString();
    }

    private static void skip(InputStream is, long len) throws IOException {
        while (len > 0L) {
            long n = is.skip(len);
            if (n < 0L) {
                throw new EOFException("Missing " + len + " bytes.");
            }
            len -= n;
        }
    }

    private static void copyStreams(OutputStream out, InputStream in) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while ((n = in.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
    }

    private static DataOutputStream getOutputStream(File file, boolean append) throws IOException, InterruptedException {
        int retry = 0;
        while (true) {
            try {
                return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file, append)));
            }
            catch (IOException ioex) {
                if (++retry > 7) {
                    throw ioex;
                }
                Thread.sleep(retry * 30);
                continue;
            }
            break;
        }
    }

    private static DataInputStream getInputStream(File file) throws IOException, InterruptedException {
        int retry = 0;
        while (true) {
            try {
                return new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            }
            catch (IOException ioex) {
                if (++retry > 7) {
                    throw ioex;
                }
                Thread.sleep(retry * 30);
                continue;
            }
            break;
        }
    }

    private class DataFilesTurboProvider
    implements TurboProvider {
        static final String ATTR_DATA_FILES = "localhistory.ATTR_DATA_FILES";

        private DataFilesTurboProvider() {
        }

        public boolean recognizesAttribute(String name) {
            return ATTR_DATA_FILES.equals(name);
        }

        public boolean recognizesEntity(Object key) {
            return key instanceof File;
        }

        public synchronized Object readEntry(Object key, String name, TurboProvider.MemoryCache memoryCache) {
            assert (key instanceof File);
            assert (name != null);
            File storeFile = (File)key;
            if (!storeFile.exists()) {
                return null;
            }
            return StoreDataFile.read(storeFile);
        }

        public synchronized boolean writeEntry(Object key, String name, Object value) {
            assert (key instanceof File);
            assert (value == null || value instanceof StoreDataFile);
            assert (name != null);
            File storeFile = (File)key;
            if (value == null) {
                if (storeFile.exists()) {
                    storeFile.delete();
                }
                return true;
            }
            File parent = storeFile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            StoreDataFile.write(storeFile, (StoreDataFile)value);
            return true;
        }
    }

    private class HistoryEntry {
        private long ts;
        private String from;
        private String to;
        private int status;

        HistoryEntry(long ts, String from, String to, int action) {
            this.ts = ts;
            this.from = from;
            this.to = to;
            this.status = action;
        }

        long getTimestamp() {
            return this.ts;
        }

        String getFrom() {
            return this.from;
        }

        String getTo() {
            return this.to;
        }

        int getStatus() {
            return this.status;
        }
    }

    private static class StoreDataFile {
        private final int status;
        private final long lastModified;
        private final String absolutePath;
        private final boolean isFile;

        private StoreDataFile(String absolutePath, int action, long lastModified, boolean isFile) {
            this.status = action;
            this.lastModified = lastModified;
            this.absolutePath = absolutePath;
            this.isFile = isFile;
        }

        int getStatus() {
            return this.status;
        }

        long getLastModified() {
            return this.lastModified;
        }

        String getAbsolutePath() {
            return this.absolutePath;
        }

        boolean isFile() {
            return this.isFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static synchronized StoreDataFile read(File storeFile) {
            DataInputStream dis = null;
            try {
                dis = LocalHistoryStoreImpl.getInputStream(storeFile);
                boolean isFile = dis.readBoolean();
                int action = dis.readInt();
                long modified = dis.readLong();
                String fileName = LocalHistoryStoreImpl.readString(dis);
                StoreDataFile storeDataFile = new StoreDataFile(fileName, action, modified, isFile);
                return storeDataFile;
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            finally {
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static synchronized void write(File storeFile, StoreDataFile value) {
            DataOutputStream dos = null;
            try {
                dos = LocalHistoryStoreImpl.getOutputStream(storeFile, false);
                StoreDataFile data = value;
                dos.writeBoolean(data.isFile);
                dos.writeInt(data.getStatus());
                dos.writeLong(data.getLastModified());
                dos.writeInt(data.getAbsolutePath().length());
                dos.writeChars(data.getAbsolutePath());
                dos.flush();
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            finally {
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

