/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.ui.view.LocalHistoryRootNode;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class LocalHistoryFileView
implements PropertyChangeListener {
    private FileTablePanel tablePanel = new FileTablePanel();
    private File[] files;
    private RequestProcessor.Task refreshTask;
    private RefreshTable refreshTable;

    public LocalHistoryFileView() {
        LocalHistory.getInstance().getLocalHistoryStore().addPropertyChangeListener(this);
    }

    public void refresh(File[] files) {
        this.refresh(files, -1L);
    }

    public void refresh(File[] files, long toSelect) {
        this.files = files;
        this.refreshTablePanel(toSelect);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("LocalHistoryStore.changed".equals(evt.getPropertyName())) {
            this.storeChanged(evt);
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.tablePanel.getExplorerManager();
    }

    public StoreEntry[] getSelectedEntries() {
        Node[] nodes = this.tablePanel.getExplorerManager().getSelectedNodes();
        if (nodes != null && nodes.length > 0) {
            ArrayList<Object> entries = new ArrayList<Object>();
            for (Node node : nodes) {
                entries.add(node.getLookup().lookup(StoreEntry.class));
            }
            return entries.toArray(new StoreEntry[entries.size()]);
        }
        return new StoreEntry[0];
    }

    public JPanel getPanel() {
        return this.tablePanel;
    }

    public void close() {
        LocalHistory.getInstance().getLocalHistoryStore().removePropertyChangeListener(this);
    }

    private Node getNode(long ts) {
        if (ts == -1L) {
            return null;
        }
        Node root = this.tablePanel.getExplorerManager().getRootContext();
        Node[] dayNodes = root.getChildren().getNodes();
        if (dayNodes != null && dayNodes.length > 0) {
            for (Node dayNode : dayNodes) {
                Node[] entryNodes = dayNode.getChildren().getNodes();
                if (entryNodes == null || entryNodes.length <= 0) continue;
                for (Node entryNode : entryNodes) {
                    StoreEntry se = (StoreEntry)entryNode.getLookup().lookup(StoreEntry.class);
                    if (se == null || se.getTimestamp() != ts) continue;
                    return entryNode;
                }
            }
        }
        return null;
    }

    private void storeChanged(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        if (newValue != null && this.contains((File)newValue) || oldValue != null && this.contains((File)oldValue)) {
            this.refreshTablePanel(-1L);
        }
    }

    private boolean contains(File file) {
        for (File f : this.files) {
            if (!f.equals(file)) continue;
            return true;
        }
        return false;
    }

    private void refreshTablePanel(long toSelect) {
        if (this.refreshTask == null) {
            this.refreshTable = new RefreshTable();
            RequestProcessor rp = new RequestProcessor();
            this.refreshTask = rp.create((Runnable)this.refreshTable);
        }
        this.refreshTable.setup(toSelect);
        this.refreshTask.schedule(100);
    }

    private void selectNodes(final Node[] nodes) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    LocalHistoryFileView.this.tablePanel.getExplorerManager().setSelectedNodes(nodes);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnDescriptor<T>
    extends PropertySupport.ReadOnly<T> {
        public ColumnDescriptor(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }

    private class FileTablePanel
    extends JPanel
    implements ExplorerManager.Provider {
        private final BrowserTreeTableView treeView;
        private final ExplorerManager manager = new ExplorerManager();

        public FileTablePanel() {
            this.setLayout(new GridBagLayout());
            this.treeView = new BrowserTreeTableView();
            this.setLayout(new BorderLayout());
            this.add((Component)((Object)this.treeView), "Center");
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        int rowAtPoint(Point point) {
            return this.treeView.getTable().rowAtPoint(point);
        }

        private class BrowserTreeTableView
        extends TreeTableView {
            BrowserTreeTableView() {
                this.setupColumns();
                this.tree.setShowsRootHandles(true);
                this.tree.setRootVisible(false);
                this.setDefaultActionAllowed(false);
                this.setBorder(BorderFactory.createEtchedBorder());
                this.setSelectionMode(1);
                this.setPopupAllowed(true);
                DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
                renderer.setLeafIcon(null);
                this.tree.setCellRenderer(renderer);
            }

            JTree getTree() {
                return this.tree;
            }

            JTable getTable() {
                return this.treeTable;
            }

            public void startEditingAtPath(TreePath path) {
                this.tree.startEditingAtPath(path);
            }

            public void addNotify() {
                super.addNotify();
                this.setDefaultColumnSizes();
            }

            private void setupColumns() {
                ResourceBundle loc = NbBundle.getBundle(FileTablePanel.class);
                Node.Property[] columns = new Node.Property[1];
                columns = new Node.Property[]{new ColumnDescriptor<String>("label", String.class, loc.getString("LBL_LocalHistory_Column_Label"), loc.getString("LBL_LocalHistory_Column_Label_Desc"))};
                this.setProperties(columns);
            }

            private void setDefaultColumnSizes() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int width = BrowserTreeTableView.this.getWidth();
                        BrowserTreeTableView.this.treeTable.getColumnModel().getColumn(0).setPreferredWidth(width * 35 / 100);
                        BrowserTreeTableView.this.treeTable.getColumnModel().getColumn(1).setPreferredWidth(width * 65 / 100);
                    }
                });
            }
        }
    }

    private class RefreshTable
    implements Runnable {
        private long toSelect;

        private RefreshTable() {
        }

        void setup(long toSelect) {
            this.toSelect = toSelect;
        }

        public void run() {
            Node oldExploredContext = LocalHistoryFileView.this.getExplorerManager().getExploredContext();
            Node root = LocalHistoryRootNode.createRootNode(LocalHistoryFileView.this.files);
            Node[] oldSelection = LocalHistoryFileView.this.getExplorerManager().getSelectedNodes();
            LocalHistoryFileView.this.tablePanel.getExplorerManager().setRootContext(root);
            if (root.getChildren().getNodesCount() > 0) {
                Node node;
                if (this.toSelect > -1L && (node = LocalHistoryFileView.this.getNode(this.toSelect)) != null) {
                    oldSelection = new Node[]{node};
                }
                if (oldSelection != null && oldSelection.length > 0) {
                    Node[] newExploredContext;
                    Node[] newSelection = this.getEqualNodes(root, oldSelection);
                    if (newSelection.length > 0) {
                        LocalHistoryFileView.this.selectNodes(newSelection);
                    } else if (oldExploredContext != null && (newExploredContext = this.getEqualNodes(root, new Node[]{oldExploredContext})).length > 0) {
                        this.selectFirstNeighborNode(newExploredContext[0], oldSelection[0]);
                    }
                } else {
                    this.selectFirstNode(root);
                }
            } else {
                LocalHistoryFileView.this.selectNodes(new Node[0]);
            }
            LocalHistoryFileView.this.tablePanel.revalidate();
            LocalHistoryFileView.this.tablePanel.repaint();
        }

        private Node[] getEqualNodes(Node root, Node[] oldNodes) {
            ArrayList<Node> ret = new ArrayList<Node>();
            for (Node on : oldNodes) {
                Node node = this.findEqualInChildren(root, on);
                if (node == null) continue;
                ret.add(node);
            }
            return ret.toArray(new Node[ret.size()]);
        }

        private Node findEqualInChildren(Node node, Node toFind) {
            Node[] children;
            for (Node child : children = node.getChildren().getNodes()) {
                if (toFind.getName().equals(child.getName())) {
                    return child;
                }
                Node n = this.findEqualInChildren(child, toFind);
                if (n == null) continue;
                return n;
            }
            return null;
        }

        private void selectFirstNode(Node root) {
            Node[] nodes;
            Node[] dateFolders = root.getChildren().getNodes();
            if (dateFolders != null && dateFolders.length > 0 && (nodes = dateFolders[0].getChildren().getNodes()) != null && nodes.length > 0) {
                LocalHistoryFileView.this.selectNodes(new Node[]{nodes[0]});
            }
        }

        private void selectFirstNeighborNode(Node context, Node oldSelection) {
            LocalHistoryFileView.this.tablePanel.getExplorerManager().setExploredContext(context);
            Node[] children = context.getChildren().getNodes();
            if (children.length > 0 && children[0] instanceof Comparable) {
                Node[] newSelection = new Node[]{children[0]};
                for (int i = 1; i < children.length; ++i) {
                    Comparable c = (Comparable)children[i];
                    if (c.compareTo(oldSelection) >= 0) continue;
                    newSelection[0] = children[i];
                }
                LocalHistoryFileView.this.selectNodes(newSelection);
            }
        }
    }
}

