/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.view;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.UIManager;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.ui.view.StoreEntryNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalHistoryRootNode
extends AbstractNode {
    static final Action[] NO_ACTION = new Action[0];

    private LocalHistoryRootNode(Children children) {
        super(children);
    }

    static Node createRootNode(File[] files) {
        Children.SortedArray children = new Children.SortedArray();
        children.add((Node[])LocalHistoryRootNode.createDateFolders(files));
        return new LocalHistoryRootNode((Children)children);
    }

    private static DateFolderNode[] createDateFolders(File[] files) {
        HashMap<Long, ArrayList<StoreEntry>> entriesMap = new HashMap<Long, ArrayList<StoreEntry>>();
        for (File f : files) {
            StoreEntry[] ses;
            for (StoreEntry se : ses = LocalHistory.getInstance().getLocalHistoryStore().getStoreEntries(f)) {
                ArrayList<StoreEntry> storeEntries = (ArrayList<StoreEntry>)entriesMap.get(se.getTimestamp());
                if (storeEntries == null) {
                    storeEntries = new ArrayList<StoreEntry>();
                    entriesMap.put(se.getTimestamp(), storeEntries);
                }
                storeEntries.add(se);
            }
        }
        HashMap storeEntryNodesToDays = new HashMap();
        for (Long ts : entriesMap.keySet()) {
            int day = LocalHistoryRootNode.getDay(ts);
            ArrayList<Node> nodesFromADay = (ArrayList<Node>)storeEntryNodesToDays.get(day);
            if (nodesFromADay == null) {
                nodesFromADay = new ArrayList<Node>();
                storeEntryNodesToDays.put(day, nodesFromADay);
            }
            List storeEntries = (List)entriesMap.get(ts);
            nodesFromADay.add(LocalHistoryRootNode.createStoreEntryNode(storeEntries, files));
        }
        ArrayList<DateFolderNode> dateFolderNodes = new ArrayList<DateFolderNode>(storeEntryNodesToDays.keySet().size());
        Iterator it = storeEntryNodesToDays.keySet().iterator();
        while (it.hasNext()) {
            int key = (Integer)it.next();
            List l = (List)storeEntryNodesToDays.get(key);
            Children.SortedArray children = new Children.SortedArray();
            children.add(l.toArray(new Node[l.size()]));
            dateFolderNodes.add(new DateFolderNode(key, (Children)children));
        }
        return dateFolderNodes.toArray(new DateFolderNode[dateFolderNodes.size()]);
    }

    private static int getDay(long ts) {
        Date date = new Date(ts);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        int todayMillis = c.get(11) * 60 * 60 * 1000 + c.get(12) * 60 * 1000 + c.get(13) * 1000 + c.get(14);
        c.add(14, -1 * todayMillis);
        if (c.getTime().compareTo(date) < 0) {
            return 0;
        }
        return (int)((c.getTimeInMillis() - ts) / 86400000L) + 1;
    }

    private static Node createStoreEntryNode(List<StoreEntry> entries, File[] files) {
        if (files.length == 1) {
            return StoreEntryNode.create(entries);
        }
        long ts = entries.get(0).getTimestamp();
        ArrayList<StoreEntry> entriesList = new ArrayList<StoreEntry>();
        for (File f : files) {
            boolean fileInEntries = false;
            for (StoreEntry se : entries) {
                if (!f.equals(se.getFile())) continue;
                entriesList.add(se);
                fileInEntries = true;
                break;
            }
            if (fileInEntries) continue;
            StoreEntry e = LocalHistory.getInstance().getLocalHistoryStore().getStoreEntry(f, ts);
            if (e != null) {
                entriesList.add(e);
                continue;
            }
            entriesList.add(StoreEntry.createFakeStoreEntry(f, ts));
        }
        return StoreEntryNode.create(entriesList);
    }

    public String getName() {
        return "rootnode";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(LocalHistoryRootNode.class, (String)"LBL_LocalHistory_Column_Version");
    }

    public Action[] getActions(boolean context) {
        return NO_ACTION;
    }

    static class DateFolderNode
    extends AbstractNode
    implements Comparable {
        private final int day;

        DateFolderNode(int day, Children children) {
            super(children);
            this.day = day;
        }

        int getDay() {
            return this.day;
        }

        public Image getIcon(int type) {
            Image img = null;
            if (type == 1) {
                img = (Image)UIManager.get("Nb.Explorer.Folder.icon");
            }
            if (img == null) {
                img = super.getIcon(type);
            }
            return img;
        }

        public Image getOpenedIcon(int type) {
            Image img = null;
            if (type == 1) {
                img = (Image)UIManager.get("Nb.Explorer.Folder.openedIcon");
            }
            if (img == null) {
                img = super.getIcon(type);
            }
            return img;
        }

        public Action[] getActions(boolean context) {
            return NO_ACTION;
        }

        public String getName() {
            switch (this.day) {
                case 0: {
                    return NbBundle.getMessage(LocalHistoryRootNode.class, (String)"DateFolderName_0");
                }
                case 1: {
                    return NbBundle.getMessage(LocalHistoryRootNode.class, (String)"DateFolderName_1");
                }
                case 2: {
                    return NbBundle.getMessage(LocalHistoryRootNode.class, (String)"DateFolderName_2");
                }
                case 3: {
                    return NbBundle.getMessage(LocalHistoryRootNode.class, (String)"DateFolderName_3");
                }
                case 4: {
                    return NbBundle.getMessage(LocalHistoryRootNode.class, (String)"DateFolderName_4");
                }
                case 5: {
                    return NbBundle.getMessage(LocalHistoryRootNode.class, (String)"DateFolderName_5");
                }
                case 6: {
                    return NbBundle.getMessage(LocalHistoryRootNode.class, (String)"DateFolderName_6");
                }
            }
            return NbBundle.getMessage(LocalHistoryRootNode.class, (String)"DateFolderName_other");
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof DateFolderNode) || obj == null) {
                return -1;
            }
            DateFolderNode lhNode = (DateFolderNode)obj;
            if (lhNode.getDay() > this.getDay()) {
                return -1;
            }
            if (lhNode.getDay() < this.getDay()) {
                return 1;
            }
            return 0;
        }
    }
}

