/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.Mark;
import org.netbeans.editor.MarkChain;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.Utilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public class Annotations
implements DocumentListener {
    private HashMap lineAnnotationsByMark = new HashMap(30);
    private ArrayList lineAnnotationsArray = new ArrayList(20);
    private DrawLayerFactory.AnnotationLayer drawLayer = null;
    private BaseDocument doc;
    private EventListenerList listenerList = new EventListenerList();
    private PropertyChangeListener l;
    private PropertyChangeListener annoTypesListener;
    private boolean glyphColumn = false;
    private boolean glyphButtonColumn = false;
    private boolean menuInitialized = false;
    public static final Comparator MENU_COMPARATOR = new MenuComparator();

    public Annotations(BaseDocument doc) {
        this.doc = doc;
        doc.addLayer(new DrawLayerFactory.AnnotationLayer(doc), 2100);
        this.doc.addDocumentListener(this);
        this.l = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AnnotationDesc anno;
                if (evt.getPropertyName() == "annotationType") {
                    anno = (AnnotationDesc)evt.getSource();
                    LineAnnotations lineAnnos = (LineAnnotations)Annotations.this.lineAnnotationsByMark.get(anno.getMark());
                    lineAnnos.refreshAnnotations();
                    Annotations.this.refreshLine(lineAnnos.getLine());
                }
                if (evt.getPropertyName() == "moveToFront") {
                    anno = (AnnotationDesc)evt.getSource();
                    Annotations.this.frontAnnotation(anno);
                }
            }
        };
        this.annoTypesListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "combineGlyphs") {
                    for (LineAnnotations lineAnnos : Annotations.this.lineAnnotationsArray) {
                        lineAnnos.refreshAnnotations();
                    }
                }
                if (evt.getPropertyName() == "annotationTypes") {
                    for (LineAnnotations lineAnnos : Annotations.this.lineAnnotationsArray) {
                        Iterator it2 = lineAnnos.getAnnotations();
                        while (it2.hasNext()) {
                            AnnotationDesc anno = (AnnotationDesc)it2.next();
                            anno.updateAnnotationType();
                        }
                    }
                }
                Annotations.this.fireChangedAll();
            }
        };
        AnnotationTypes.getTypes().addPropertyChangeListener(this.annoTypesListener);
    }

    public synchronized DrawLayerFactory.AnnotationLayer getLayer() {
        if (this.drawLayer == null) {
            this.drawLayer = (DrawLayerFactory.AnnotationLayer)this.doc.findLayer("annotation-layer");
        }
        return this.drawLayer;
    }

    public void addAnnotation(AnnotationDesc anno) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Must be run in EQ");
        }
        MarkChain chain = this.getLayer().getMarkChain();
        try {
            chain.addMark(anno.getOffset(), true);
        }
        catch (BadLocationException e) {
            throw new IllegalStateException("offset=" + anno.getOffset() + ", docLen=" + this.doc.getLength());
        }
        MarkFactory.ChainDrawMark annoMark = chain.getAddedMark();
        if (annoMark == null) {
            throw new NullPointerException();
        }
        anno.setMark(annoMark);
        LineAnnotations lineAnnos = (LineAnnotations)this.lineAnnotationsByMark.get(annoMark);
        if (lineAnnos == null) {
            lineAnnos = this.getLineAnnotations(anno.getLine());
            if (lineAnnos == null) {
                lineAnnos = new LineAnnotations();
                lineAnnos.addAnnotation(anno);
                if (this.lineAnnotationsByMark.put(anno.getMark(), lineAnnos) != null) {
                    throw new IllegalStateException("Mark already in the map.");
                }
                boolean inserted = false;
                for (int i = 0; i < this.lineAnnotationsArray.size(); ++i) {
                    if (((LineAnnotations)this.lineAnnotationsArray.get(i)).getLine() <= lineAnnos.getLine()) continue;
                    this.lineAnnotationsArray.add(i, lineAnnos);
                    inserted = true;
                    break;
                }
                if (!inserted) {
                    this.lineAnnotationsArray.add(lineAnnos);
                }
            } else {
                lineAnnos.addAnnotation(anno);
                if (this.lineAnnotationsByMark.get(anno.getMark()) == null) {
                    this.lineAnnotationsByMark.put(anno.getMark(), lineAnnos);
                }
            }
        } else {
            lineAnnos.addAnnotation(anno);
        }
        anno.addPropertyChangeListener(this.l);
        if (anno.isVisible() && (!anno.isDefaultGlyph() || anno.isDefaultGlyph() && lineAnnos.getCount() > 1)) {
            this.glyphColumn = true;
        }
        if (lineAnnos.getCount() > 1) {
            this.glyphButtonColumn = true;
        }
        this.refreshLine(lineAnnos.getLine());
    }

    public void removeAnnotation(AnnotationDesc anno) {
        int index;
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Must be run in EQ");
        }
        MarkFactory.ChainDrawMark annoMark = (MarkFactory.ChainDrawMark)anno.getMark();
        if (annoMark == null) {
            throw new NullPointerException();
        }
        LineAnnotations lineAnnos = (LineAnnotations)this.lineAnnotationsByMark.get(annoMark);
        int line = lineAnnos.getLine();
        lineAnnos.removeAnnotation(anno);
        if (!lineAnnos.isMarkStillReferenced(annoMark)) {
            if (this.lineAnnotationsByMark.remove(annoMark) != lineAnnos) {
                throw new IllegalStateException();
            }
            MarkChain chain = this.getLayer().getMarkChain();
            if (!chain.removeMark(annoMark)) {
                throw new IllegalStateException("Mark not removed");
            }
        }
        if (lineAnnos.getCount() == 0 && (index = this.lineAnnotationsArray.indexOf(lineAnnos)) != -1) {
            this.lineAnnotationsArray.remove(index);
        }
        anno.setMark(null);
        anno.removePropertyChangeListener(this.l);
        this.refreshLine(line);
    }

    public AnnotationDesc getActiveAnnotation(Mark mark) {
        LineAnnotations annos = (LineAnnotations)this.lineAnnotationsByMark.get(mark);
        if (annos == null) {
            return null;
        }
        AnnotationDesc anno = annos.getActive();
        if (anno == null || anno.getMark() != mark) {
            return null;
        }
        return anno;
    }

    AnnotationDesc getLineActiveAnnotation(Mark mark) {
        LineAnnotations annos = (LineAnnotations)this.lineAnnotationsByMark.get(mark);
        if (annos == null) {
            return null;
        }
        AnnotationDesc anno = annos.getActive();
        return anno;
    }

    protected LineAnnotations getLineAnnotations(int line) {
        int low = 0;
        int high = this.lineAnnotationsArray.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            LineAnnotations annos = (LineAnnotations)this.lineAnnotationsArray.get(mid);
            int annosLine = annos.getLine();
            if (line < annosLine) {
                high = mid - 1;
                continue;
            }
            if (line > annosLine) {
                low = mid + 1;
                continue;
            }
            return annos;
        }
        return null;
    }

    public AnnotationDesc getActiveAnnotation(int line) {
        LineAnnotations annos = this.getLineAnnotations(line);
        if (annos == null) {
            return null;
        }
        return annos.getActive();
    }

    public void frontAnnotation(AnnotationDesc anno) {
        int line = anno.getLine();
        LineAnnotations annos = this.getLineAnnotations(line);
        if (annos == null) {
            return;
        }
        annos.activate(anno);
        this.refreshLine(line);
    }

    public AnnotationDesc activateNextAnnotation(int line) {
        LineAnnotations annos = this.getLineAnnotations(line);
        if (annos == null) {
            return null;
        }
        AnnotationDesc aa = annos.activateNext();
        this.refreshLine(line);
        return aa;
    }

    public int getNextLineWithAnnotation(int line) {
        int annosLine;
        LineAnnotations annos;
        int low = 0;
        int high = this.lineAnnotationsArray.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            annos = (LineAnnotations)this.lineAnnotationsArray.get(mid);
            annosLine = annos.getLine();
            if (line < annosLine) {
                high = mid - 1;
                continue;
            }
            if (line > annosLine) {
                low = mid + 1;
                continue;
            }
            return annosLine;
        }
        for (int i = low; i < this.lineAnnotationsArray.size(); ++i) {
            annos = (LineAnnotations)this.lineAnnotationsArray.get(i);
            annosLine = annos.getLine();
            if (annosLine < line) continue;
            return annosLine;
        }
        return -1;
    }

    public AnnotationDesc getAnnotation(int line, String type) {
        return null;
    }

    public AnnotationDesc[] getPasiveAnnotations(int line) {
        LineAnnotations annos = this.getLineAnnotations(line);
        if (annos == null) {
            return null;
        }
        if (annos.getCount() <= 1) {
            return null;
        }
        return annos.getPasive();
    }

    public AnnotationDesc[] getPassiveAnnotations(int offset) {
        int lineIndex = this.doc.getDefaultRootElement().getElementIndex(offset);
        return lineIndex >= 0 ? this.getPasiveAnnotations(lineIndex) : null;
    }

    public int getNumberOfAnnotations(int line) {
        LineAnnotations annos = this.getLineAnnotations(line);
        if (annos == null) {
            return 0;
        }
        return annos.getCount();
    }

    protected void refreshLine(int line) {
        this.fireChangedLine(line);
        int start = Utilities.getRowStartFromLineOffset(this.doc, line);
        int end = Utilities.getRowStartFromLineOffset(this.doc, line + 1);
        if (end == -1) {
            end = this.doc.getLength();
        }
        this.doc.repaintBlock(start, end);
    }

    public void removeUpdate(DocumentEvent e) {
        BaseDocumentEvent be = (BaseDocumentEvent)e;
        int countOfDeletedLines = be.getLFCount();
        if (countOfDeletedLines == 0) {
            return;
        }
        int changedLine = be.getLine();
        this.fireChangedAll();
    }

    public void insertUpdate(DocumentEvent e) {
        BaseDocumentEvent be = (BaseDocumentEvent)e;
        int countOfInsertedLines = be.getLFCount();
        if (countOfInsertedLines == 0) {
            return;
        }
        this.fireChangedAll();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void addAnnotationsListener(AnnotationsListener listener) {
        this.listenerList.add(AnnotationsListener.class, listener);
    }

    public void removeAnnotationsListener(AnnotationsListener listener) {
        this.listenerList.remove(AnnotationsListener.class, listener);
    }

    protected void fireChangedLine(int line) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != AnnotationsListener.class) continue;
            ((AnnotationsListener)listeners[i + 1]).changedLine(line);
        }
    }

    protected void fireChangedAll() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != AnnotationsListener.class) continue;
            ((AnnotationsListener)listeners[i + 1]).changedAll();
        }
    }

    public boolean isGlyphColumn() {
        return this.glyphColumn;
    }

    public boolean isGlyphButtonColumn() {
        return this.glyphButtonColumn;
    }

    private void addAcceleretors(Action a, JMenuItem item, BaseKit kit) {
        JTextComponent target = Utilities.getFocusedComponent();
        if (target == null) {
            return;
        }
        Keymap km = target.getKeymap();
        if (km != null) {
            KeyStroke[] keys = km.getKeyStrokesForAction(a);
            if (keys != null && keys.length > 0) {
                item.setAccelerator(keys[0]);
            } else {
                String actionName = (String)a.getValue("Name");
                if (actionName == null) {
                    return;
                }
                BaseAction action = (BaseAction)kit.getActionByName(actionName);
                if (action == null) {
                    return;
                }
                keys = km.getKeyStrokesForAction(action);
                if (keys != null && keys.length > 0) {
                    item.setAccelerator(keys[0]);
                }
            }
        }
    }

    private JMenuItem createMenuItem(Action action, BaseKit kit) {
        JMenuItem item;
        if (action instanceof BaseAction) {
            item = new JMenuItem(((BaseAction)action).getPopupMenuText(null));
            item.addActionListener(action);
            this.addAcceleretors(action, item, kit);
        } else if (action instanceof Presenter.Popup) {
            item = ((Presenter.Popup)action).getPopupPresenter();
        } else {
            item = new JMenuItem((String)action.getValue("Name"));
            item.addActionListener(action);
            this.addAcceleretors(action, item, kit);
        }
        return item;
    }

    public JPopupMenu createPopupMenu(BaseKit kit, int line) {
        return this.createMenu(kit, line, false).getPopupMenu();
    }

    private void initMenu(JMenu pm, BaseKit kit, int line) {
        JMenu subMenu2;
        Action[] actions;
        LineAnnotations annos = this.getLineAnnotations(line);
        HashMap<String, String> types = new HashMap<String, String>(AnnotationTypes.getTypes().getVisibleAnnotationTypeNamesCount() * 4 / 3);
        boolean separator = false;
        boolean added = false;
        TreeSet<JMenu> orderedSubMenus = new TreeSet<JMenu>(MENU_COMPARATOR);
        if (annos != null) {
            AnnotationDesc anno = annos.getActive();
            if (anno != null && (actions = anno.getActions()) != null) {
                subMenu2 = new JMenu(anno.getAnnotationTypeInstance().getDescription());
                for (int j = 0; j < actions.length; ++j) {
                    subMenu2.add(this.createMenuItem(actions[j], kit));
                }
                if (subMenu2.getItemCount() > 0) {
                    orderedSubMenus.add(subMenu2);
                    separator = true;
                }
                types.put(anno.getAnnotationType(), anno.getAnnotationType());
            }
            AnnotationDesc[] pasiveAnnos = annos.getPasive();
            added = false;
            if (pasiveAnnos != null) {
                for (int i = 0; i < pasiveAnnos.length; ++i) {
                    actions = pasiveAnnos[i].getActions();
                    if (actions == null) continue;
                    subMenu2 = new JMenu(pasiveAnnos[i].getAnnotationTypeInstance().getDescription());
                    for (int j = 0; j < actions.length; ++j) {
                        subMenu2.add(this.createMenuItem(actions[j], kit));
                    }
                    if (separator) {
                        separator = false;
                    }
                    if (subMenu2.getItemCount() > 0) {
                        orderedSubMenus.add(subMenu2);
                        added = true;
                    }
                    types.put(pasiveAnnos[i].getAnnotationType(), pasiveAnnos[i].getAnnotationType());
                }
                if (added) {
                    separator = true;
                }
            }
        }
        added = false;
        Iterator i = AnnotationTypes.getTypes().getAnnotationTypeNames();
        while (i.hasNext()) {
            AnnotationType type = AnnotationTypes.getTypes().getType((String)i.next());
            if (type == null || !type.isVisible() || types.get(type.getName()) != null || (actions = type.getActions()) == null) continue;
            subMenu2 = new JMenu(type.getDescription());
            for (int j = 0; j < actions.length; ++j) {
                if (!actions[j].isEnabled()) continue;
                subMenu2.add(this.createMenuItem(actions[j], kit));
            }
            if (separator) {
                separator = false;
            }
            if (subMenu2.getItemCount() <= 0) continue;
            orderedSubMenus.add(subMenu2);
            added = true;
        }
        if (added) {
            separator = true;
        }
        if (!orderedSubMenus.isEmpty()) {
            for (JMenu subMenu2 : orderedSubMenus) {
                pm.add(subMenu2);
            }
            pm.addSeparator();
        }
        BaseAction action = (BaseAction)kit.getActionByName("toggle-line-numbers");
        pm.add(action.getPopupMenuItem(null));
        BaseAction action2 = (BaseAction)kit.getActionByName("toggle-toolbar");
        if (action2 != null) {
            pm.add(action2.getPopupMenuItem(null));
        }
        this.menuInitialized = true;
    }

    private JMenu createMenu(BaseKit kit, int line, boolean backgroundInit) {
        final DelayedMenu pm = new DelayedMenu(NbBundle.getBundle(BaseKit.class).getString("generate-gutter-popup"));
        final BaseKit fKit = kit;
        final int fLine = line;
        if (backgroundInit) {
            RequestProcessor rp = RequestProcessor.getDefault();
            RequestProcessor.Task task = rp.create(new Runnable(){

                public void run() {
                    Annotations.this.initMenu(pm, fKit, fLine);
                    pm.clearTask();
                }
            });
            pm.setTask(task);
            task.schedule(0);
        } else {
            this.initMenu(pm, fKit, fLine);
        }
        return pm;
    }

    public JMenu createMenu(BaseKit kit, int line) {
        boolean bkgInit = this.menuInitialized;
        this.menuInitialized = true;
        return this.createMenu(kit, line, !bkgInit);
    }

    private String dumpAnnotaionDesc(AnnotationDesc ad) {
        return "offset=" + ad.getOffset() + "(ls=" + this.doc.getParagraphElement(ad.getOffset()).getStartOffset() + "), line=" + ad.getLine() + ", type=" + ad.getAnnotationType();
    }

    private String dumpLineAnnotationsArray() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.lineAnnotationsArray.size(); ++i) {
            LineAnnotations la = (LineAnnotations)this.lineAnnotationsArray.get(i);
            LinkedList annos = la.annos;
            sb.append("[" + i + "]: line=" + la.getLine() + ", anos:");
            for (int j = 0; j < annos.size(); ++j) {
                sb.append("\n    [" + j + "]: " + this.dumpAnnotaionDesc((AnnotationDesc)annos.get(j)));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private static class AnnotationCombination
    extends AnnotationDesc {
        private AnnotationDesc delegate;
        private String type;
        private LinkedList list;

        public AnnotationCombination(String type, AnnotationDesc delegate) {
            super(delegate.getOffset(), delegate.getLength());
            this.delegate = delegate;
            this.type = type;
            this.updateAnnotationType();
            this.list = new LinkedList();
            this.list.add(delegate);
        }

        public int getOffset() {
            return this.delegate.getOffset();
        }

        public int getLine() {
            return this.delegate.getLine();
        }

        public String getShortDescription() {
            return this.getAnnotationTypeInstance().getDescription();
        }

        public String getAnnotationType() {
            return this.type;
        }

        public void addCombinedAnnotation(AnnotationDesc anno) {
            this.list.add(anno);
        }

        public boolean isAnnotationCombined(AnnotationDesc anno) {
            return this.list.indexOf(anno) != -1;
        }

        Mark getMark() {
            return this.delegate.getMark();
        }
    }

    public static interface AnnotationsListener
    extends EventListener {
        public void changedLine(int var1);

        public void changedAll();
    }

    private static class DelayedMenu
    extends JMenu {
        RequestProcessor.Task task;

        public DelayedMenu(String s) {
            super(s);
        }

        public JPopupMenu getPopupMenu() {
            RequestProcessor.Task t = this.task;
            if (t != null && !t.isFinished()) {
                t.waitFinished();
            }
            return super.getPopupMenu();
        }

        void setTask(RequestProcessor.Task task) {
            this.task = task;
        }

        void clearTask() {
            this.task = null;
        }
    }

    public static class LineAnnotations {
        private LinkedList annos = new LinkedList();
        private LinkedList annosVisible = new LinkedList();
        private AnnotationDesc active;

        protected LineAnnotations() {
        }

        public void addAnnotation(AnnotationDesc anno) {
            this.annos.add(anno);
            if (anno.isVisible()) {
                this.active = anno;
            }
            this.refreshAnnotations();
        }

        public void removeAnnotation(AnnotationDesc anno) {
            if (anno == this.active) {
                this.activateNext();
            }
            this.annos.remove(anno);
            if (this.active == anno) {
                this.active = null;
            }
            this.refreshAnnotations();
        }

        public AnnotationDesc getActive() {
            return this.active;
        }

        public int getLine() {
            return this.annos.size() > 0 ? ((AnnotationDesc)this.annos.get(0)).getLine() : 0;
        }

        public void setLine(int line) {
            throw new IllegalStateException("Setting of line number not allowed");
        }

        public AnnotationDesc[] getPasive() {
            int startIndex;
            AnnotationDesc[] pasives = new AnnotationDesc[this.getCount() - 1];
            int index = startIndex = this.annosVisible.indexOf(this.getActive());
            int i = 0;
            while (true) {
                if (++index >= this.annosVisible.size()) {
                    index = 0;
                }
                if (index == startIndex) break;
                pasives[i] = (AnnotationDesc)this.annosVisible.get(index);
                ++i;
            }
            return pasives;
        }

        public boolean activate(AnnotationDesc anno) {
            int i = this.annosVisible.indexOf(anno);
            if (i == -1) {
                for (int j = 0; j < this.annosVisible.size(); ++j) {
                    if (!(this.annosVisible.get(j) instanceof AnnotationCombination) || !((AnnotationCombination)this.annosVisible.get(j)).isAnnotationCombined(anno)) continue;
                    i = j;
                    anno = (AnnotationCombination)this.annosVisible.get(j);
                    break;
                }
            }
            if (i == -1) {
                return false;
            }
            if (this.annosVisible.get(i) == null) {
                return false;
            }
            if (anno == this.active || !anno.isVisible()) {
                return false;
            }
            this.active = anno;
            return true;
        }

        public int getCount() {
            return this.annosVisible.size();
        }

        public AnnotationDesc activateNext() {
            if (this.getCount() <= 1) {
                return this.active;
            }
            int current = this.annosVisible.indexOf(this.active);
            if (++current >= this.getCount()) {
                current = 0;
            }
            this.active = (AnnotationDesc)this.annosVisible.get(current);
            return this.active;
        }

        private void fillInCombinationsAndOrderThem(LinkedList combTypes) {
            Iterator it = AnnotationTypes.getTypes().getAnnotationTypeNames();
            while (it.hasNext()) {
                AnnotationType.CombinationMember[] combs;
                AnnotationType type = AnnotationTypes.getTypes().getType((String)it.next());
                if (type == null || (combs = type.getCombinations()) == null || !type.isWholeLine() || combs.length < 2 && (combs.length != 1 || !combs[0].isAbsorbAll())) continue;
                if (type.getCombinationOrder() == 0) {
                    combTypes.add(type);
                    continue;
                }
                boolean inserted = false;
                for (int i = 0; i < combTypes.size(); ++i) {
                    if (((AnnotationType)combTypes.get(i)).getCombinationOrder() <= type.getCombinationOrder()) continue;
                    combTypes.add(i, type);
                    inserted = true;
                    break;
                }
                if (inserted) continue;
                combTypes.add(type);
            }
        }

        private boolean combineType(AnnotationType combType, LinkedList annosDupl) {
            int i;
            int countOfAnnos = 0;
            int valid_optional_count = 0;
            LinkedList<AnnotationDesc> combinedAnnos = new LinkedList<AnnotationDesc>();
            AnnotationType.CombinationMember[] combs = combType.getCombinations();
            boolean matchedComb = true;
            for (i = 0; i < combs.length; ++i) {
                AnnotationType.CombinationMember comb = combs[i];
                boolean matchedType = false;
                for (int j = 0; j < annosDupl.size(); ++j) {
                    int k;
                    AnnotationDesc anno = (AnnotationDesc)annosDupl.get(j);
                    if (anno == null || !comb.getName().equals(anno.getAnnotationType())) continue;
                    ++countOfAnnos;
                    if (comb.getMinimumCount() == 0) {
                        matchedType = true;
                        ++countOfAnnos;
                        combinedAnnos.add(anno);
                        if (comb.isAbsorbAll()) continue;
                        break;
                    }
                    int requiredCount = comb.getMinimumCount() - 1;
                    for (k = j + 1; k < annosDupl.size() && requiredCount > 0; ++k) {
                        if (annosDupl.get(k) == null || !comb.getName().equals(((AnnotationDesc)annosDupl.get(k)).getAnnotationType())) continue;
                        --requiredCount;
                    }
                    if (requiredCount != 0) break;
                    matchedType = true;
                    combinedAnnos.add(anno);
                    for (k = j + 1; k < annosDupl.size(); ++k) {
                        if (annosDupl.get(k) == null || !comb.getName().equals(((AnnotationDesc)annosDupl.get(k)).getAnnotationType())) continue;
                        ++countOfAnnos;
                        combinedAnnos.add((AnnotationDesc)annosDupl.get(k));
                    }
                    break;
                }
                if (matchedType) {
                    if (!comb.isOptional()) continue;
                    ++valid_optional_count;
                    continue;
                }
                if (comb.isOptional()) continue;
                matchedComb = false;
                break;
            }
            if (combType.getMinimumOptionals() > valid_optional_count) {
                matchedComb = false;
            }
            AnnotationCombination annoComb = null;
            if (matchedComb) {
                boolean activateComb = false;
                for (i = 0; i < combinedAnnos.size(); ++i) {
                    if (combinedAnnos.get(i) == this.active) {
                        activateComb = true;
                    }
                    if (annoComb == null) {
                        annoComb = new AnnotationCombination(combType.getName(), (AnnotationDesc)combinedAnnos.get(i));
                        annosDupl.set(annosDupl.indexOf(combinedAnnos.get(i)), annoComb);
                        continue;
                    }
                    annoComb.addCombinedAnnotation((AnnotationDesc)combinedAnnos.get(i));
                    annosDupl.set(annosDupl.indexOf(combinedAnnos.get(i)), null);
                }
                if (activateComb) {
                    this.active = annoComb;
                }
                return true;
            }
            return false;
        }

        public void refreshAnnotations() {
            if (!AnnotationTypes.getTypes().isCombineGlyphs().booleanValue()) {
                this.annosVisible = new LinkedList();
                for (int i = 0; i < this.annos.size(); ++i) {
                    if (!((AnnotationDesc)this.annos.get(i)).isVisible()) continue;
                    this.annosVisible.add(this.annos.get(i));
                }
            } else {
                LinkedList annosDupl = (LinkedList)this.annos.clone();
                LinkedList combTypes = new LinkedList();
                this.fillInCombinationsAndOrderThem(combTypes);
                for (int ct = 0; ct < combTypes.size(); ++ct) {
                    this.combineType((AnnotationType)combTypes.get(ct), annosDupl);
                }
                this.annosVisible = new LinkedList();
                for (int i = 0; i < annosDupl.size(); ++i) {
                    if (annosDupl.get(i) == null || !((AnnotationDesc)annosDupl.get(i)).isVisible()) continue;
                    this.annosVisible.add(annosDupl.get(i));
                }
            }
            if (this.annosVisible.indexOf(this.active) == -1) {
                this.active = this.annosVisible.size() > 0 ? (AnnotationDesc)this.annosVisible.get(0) : null;
            }
        }

        public boolean isMarkStillReferenced(Mark mark) {
            ListIterator it = this.annos.listIterator();
            while (it.hasNext()) {
                AnnotationDesc anno = (AnnotationDesc)it.next();
                if (anno.getMark() != mark) continue;
                return true;
            }
            return false;
        }

        public Iterator getAnnotations() {
            return this.annos.iterator();
        }
    }

    public static final class MenuComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            JMenu menuOne = (JMenu)o1;
            JMenu menuTwo = (JMenu)o2;
            if (menuTwo == null || menuOne == null) {
                return 0;
            }
            String menuOneText = menuOne.getText();
            String menuTwoText = menuTwo.getText();
            if (menuTwoText == null || menuOneText == null) {
                return 0;
            }
            return menuOneText.compareTo(menuTwoText);
        }
    }
}

