/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.AdjustFinder;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.AtomicLockDocument;
import org.netbeans.editor.AtomicLockEvent;
import org.netbeans.editor.AtomicLockListener;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.CharSeq;
import org.netbeans.editor.DocumentContent;
import org.netbeans.editor.DocumentUtilities;
import org.netbeans.editor.DrawEngine;
import org.netbeans.editor.DrawGraphics;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.DrawLayerList;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.Finder;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.FixLineSyntaxState;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.GapStart;
import org.netbeans.editor.LineRootElement;
import org.netbeans.editor.MarkVector;
import org.netbeans.editor.MultiMark;
import org.netbeans.editor.PrintContainer;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TextBatchProcessor;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;

public class BaseDocument
extends AbstractDocument
implements SettingsChangeListener,
AtomicLockDocument {
    private static final Logger LOG = Logger.getLogger(BaseDocument.class.getName());
    public static final String ID_PROP = "id";
    public static final String READ_LINE_SEPARATOR_PROP = "__EndOfLine__";
    public static final String WRITE_LINE_SEPARATOR_PROP = "write-line-separator";
    public static final String FILE_NAME_PROP = "file-name";
    public static final String WRAP_SEARCH_MARK_PROP = "wrap-search-mark";
    public static final String UNDO_MANAGER_PROP = "undo-manager";
    public static final String KIT_CLASS_PROP = "kit-class";
    public static final String STRING_FINDER_PROP = "string-finder";
    public static final String STRING_BWD_FINDER_PROP = "string-bwd-finder";
    public static final String BLOCKS_FINDER_PROP = "blocks-finder";
    public static final String LINE_LIMIT_PROP = "line-limit";
    public static final String LINE_BATCH_SIZE = "line-batch-size";
    public static final String LS_CR = "\r";
    public static final String LS_LF = "\n";
    public static final String LS_CRLF = "\r\n";
    private static final String BEFORE_MODIFICATION_LISTENER = "modificationListener";
    private static final int MAX_READ_THREADS = 10;
    private static final String WRITE_LOCK_MISSING = "extWriteUnlock() without extWriteLock()";
    private static final Object annotationsLock = new Object();
    private static final Object getVisColFromPosLock = new Object();
    private static final Object getOffsetFromVisColLock = new Object();
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.document");
    private static final boolean debugStack = Boolean.getBoolean("netbeans.debug.editor.document.stack");
    private static final boolean debugNoText = Boolean.getBoolean("netbeans.debug.editor.document.notext");
    private static final boolean debugRead = Boolean.getBoolean("netbeans.debug.editor.document.read");
    public static final ThreadLocal THREAD_LOCAL_LOCK_DEPTH = new ThreadLocal();
    private static final Integer[] lockIntegers = new Integer[]{null, new Integer(1), new Integer(2), new Integer(3)};
    private int tabSize = SettingsDefaults.defaultTabSize;
    private Integer shiftWidth;
    private int writeDepth;
    private int atomicDepth;
    protected boolean inited;
    protected boolean modified;
    PropertyChangeListener findSupportListener;
    protected Element defaultRootElem;
    private SyntaxSupport syntaxSupport;
    private DrawLayerList drawLayerList = new DrawLayerList();
    boolean undoMergeReset;
    Class kitClass;
    private AtomicCompoundEdit atomicEdits;
    private Acceptor identifierAcceptor;
    private Acceptor whitespaceAcceptor;
    private ArrayList syntaxList = new ArrayList();
    protected LineRootElement lineRootElement;
    UndoableEdit lastModifyUndoEdit;
    private Annotations annotations;
    private boolean composedText = false;
    final Map marks = new HashMap();
    final MarkVector marksStorage = new MarkVector();
    private FinderFactory.VisColPosFwdFinder visColPosFwdFinder;
    private FinderFactory.PosVisColFwdFinder posVisColFwdFinder;
    private AtomicLockEvent atomicLockEventInstance = new AtomicLockEvent(this);
    private FixLineSyntaxState fixLineSyntaxState;
    private UndoableEdit removeUpdateLineUndo;
    private Object[] atomicLockListenerList;
    private final ThreadLocal STATUS = new ThreadLocal();
    private boolean modsUndoneOrRedone;
    private DocumentListener postModificationDocumentListener;
    private Position lastPositionEditedByTyping = null;

    public BaseDocument(Class kitClass, boolean addToRegistry) {
        super(new DocumentContent());
        this.kitClass = kitClass;
        this.setDocumentProperties(this.createDocumentProperties(this.getDocumentProperties()));
        super.addDocumentListener(org.netbeans.lib.editor.util.swing.DocumentUtilities.initPriorityListening((Document)this));
        this.putProperty(GapStart.class, this.getDocumentContent());
        this.putProperty(CharSequence.class, this.getDocumentContent().createCharSequenceView());
        this.putProperty("supportsModificationListener", Boolean.TRUE);
        this.lineRootElement = new LineRootElement(this);
        this.settingsChange(null);
        Settings.addSettingsChangeListener(this);
        this.putProperty(READ_LINE_SEPARATOR_PROP, Analyzer.getPlatformLS());
        BaseKit kit = BaseKit.getKit(kitClass);
        if (kit != null) {
            kit.initDocument(this);
        }
        if (addToRegistry) {
            Registry.addDocument(this);
        }
        this.findSupportListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                BaseDocument.this.findSupportChange(evt);
            }
        };
        FindSupport.getFindSupport().addPropertyChangeListener(this.findSupportListener);
        this.findSupportChange(null);
    }

    private DocumentContent getDocumentContent() {
        return (DocumentContent)this.getContent();
    }

    public CharSeq getText() {
        return this.getDocumentContent();
    }

    private void findSupportChange(PropertyChangeEvent evt) {
        this.putProperty(STRING_FINDER_PROP, null);
        this.putProperty(STRING_BWD_FINDER_PROP, null);
        this.putProperty(BLOCKS_FINDER_PROP, null);
    }

    public void settingsChange(SettingsChangeEvent evt) {
        Object shw;
        String settingName;
        String string = settingName = evt != null ? evt.getSettingName() : null;
        if (settingName == null || "tab-size".equals(settingName)) {
            this.tabSize = SettingsUtil.getPositiveInteger(this.kitClass, "tab-size", SettingsDefaults.defaultTabSize);
        }
        if ((settingName == null || "indent-shift-width".equals(settingName)) && (shw = Settings.getValue(this.kitClass, "indent-shift-width")) instanceof Integer) {
            this.shiftWidth = (Integer)shw;
        }
        if (settingName == null || "read-buffer-size".equals(settingName)) {
            int readBufferSize = SettingsUtil.getPositiveInteger(this.kitClass, "read-buffer-size", SettingsDefaults.defaultReadBufferSize);
            this.putProperty("read-buffer-size", new Integer(readBufferSize));
        }
        if (settingName == null || "write-buffer-size".equals(settingName)) {
            int writeBufferSize = SettingsUtil.getPositiveInteger(this.kitClass, "write-buffer-size", SettingsDefaults.defaultWriteBufferSize);
            this.putProperty("write-buffer-size", new Integer(writeBufferSize));
        }
        if (settingName == null || "mark-distance".equals(settingName)) {
            int markDistance = SettingsUtil.getPositiveInteger(this.kitClass, "mark-distance", SettingsDefaults.defaultMarkDistance);
            this.putProperty("mark-distance", new Integer(markDistance));
        }
        if (settingName == null || "max-mark-distance".equals(settingName)) {
            int maxMarkDistance = SettingsUtil.getPositiveInteger(this.kitClass, "max-mark-distance", SettingsDefaults.defaultMaxMarkDistance);
            this.putProperty("max-mark-distance", new Integer(maxMarkDistance));
        }
        if (settingName == null || "min-mark-distance".equals(settingName)) {
            int minMarkDistance = SettingsUtil.getPositiveInteger(this.kitClass, "min-mark-distance", SettingsDefaults.defaultMinMarkDistance);
            this.putProperty("min-mark-distance", new Integer(minMarkDistance));
        }
        if (settingName == null || "read-mark-distance".equals(settingName)) {
            int readMarkDistance = SettingsUtil.getPositiveInteger(this.kitClass, "read-mark-distance", SettingsDefaults.defaultReadMarkDistance);
            this.putProperty("read-mark-distance", new Integer(readMarkDistance));
        }
        if (settingName == null || "syntax-update-batch-size".equals(settingName)) {
            int syntaxUpdateBatchSize = SettingsUtil.getPositiveInteger(this.kitClass, "syntax-update-batch-size", SettingsDefaults.defaultSyntaxUpdateBatchSize);
            this.putProperty("syntax-update-batch-size", new Integer(syntaxUpdateBatchSize));
        }
        if (settingName == null || LINE_BATCH_SIZE.equals(settingName)) {
            int lineBatchSize = SettingsUtil.getPositiveInteger(this.kitClass, LINE_BATCH_SIZE, SettingsDefaults.defaultLineBatchSize);
            this.putProperty(LINE_BATCH_SIZE, new Integer(lineBatchSize));
        }
        if (settingName == null || "identifier-acceptor".equals(settingName)) {
            this.identifierAcceptor = SettingsUtil.getAcceptor(this.kitClass, "identifier-acceptor", AcceptorFactory.LETTER_DIGIT);
        }
        if (settingName == null || "whitespace-acceptor".equals(settingName)) {
            this.whitespaceAcceptor = SettingsUtil.getAcceptor(this.kitClass, "whitespace-acceptor", AcceptorFactory.WHITESPACE);
        }
        boolean stopOnEOL = SettingsUtil.getBoolean(this.kitClass, "word-move-newline-stop", true);
        if (settingName == null || "next-word-finder".equals(settingName)) {
            this.putProperty("next-word-finder", SettingsUtil.getValue(this.kitClass, "next-word-finder", new FinderFactory.NextWordFwdFinder(this, stopOnEOL, false)));
        }
        if (settingName == null || "previous-word-finder".equals(settingName)) {
            this.putProperty("previous-word-finder", SettingsUtil.getValue(this.kitClass, "previous-word-finder", new FinderFactory.PreviousWordBwdFinder(this, stopOnEOL, false)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Syntax getFreeSyntax() {
        BaseKit kit = BaseKit.getKit(this.kitClass);
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            int cnt = this.syntaxList.size();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return cnt > 0 ? (Syntax)this.syntaxList.remove(cnt - 1) : kit.createSyntax(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseSyntax(Syntax syntax) {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            this.syntaxList.add(syntax);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Formatter getFormatter() {
        return Formatter.getFormatter(this.kitClass);
    }

    public SyntaxSupport getSyntaxSupport() {
        if (this.syntaxSupport == null) {
            this.syntaxSupport = BaseKit.getKit(this.kitClass).createSyntaxSupport(this);
        }
        return this.syntaxSupport;
    }

    public int processText(TextBatchProcessor tbp, int startPos, int endPos) throws BadLocationException {
        if (endPos == -1) {
            endPos = this.getLength();
        }
        int batchLineCnt = (Integer)this.getProperty(LINE_BATCH_SIZE);
        int batchStart = startPos;
        int ret = -1;
        if (startPos < endPos) {
            while (ret < 0 && batchStart < endPos) {
                int batchEnd = Math.min(Utilities.getRowStart(this, batchStart, batchLineCnt), endPos);
                if (batchEnd == -1) {
                    batchEnd = endPos;
                }
                ret = tbp.processTextBatch(this, batchStart, batchEnd, batchEnd == endPos);
                batchLineCnt *= 2;
                batchStart = batchEnd;
            }
        } else {
            while (ret < 0 && batchStart > endPos) {
                int batchEnd;
                ret = tbp.processTextBatch(this, batchStart, batchEnd, (batchEnd = Math.max(Utilities.getRowStart(this, batchStart, -batchLineCnt), endPos)) == endPos);
                batchLineCnt *= 2;
                batchStart = batchEnd;
            }
        }
        return ret;
    }

    public boolean isIdentifierPart(char ch) {
        return this.identifierAcceptor.accept(ch);
    }

    public boolean isWhitespace(char ch) {
        return this.whitespaceAcceptor.accept(ch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertString(int offset, String text, AttributeSet a) throws BadLocationException {
        boolean activePostModification;
        if (text == null || text.length() == 0) {
            return;
        }
        if (offset < 0 || offset > this.getLength()) {
            throw new BadLocationException("Wrong insert position " + offset, offset);
        }
        text = Analyzer.convertLSToLF(text);
        BaseDocumentEvent postModificationEvent = null;
        BaseDocument baseDocument = this;
        synchronized (baseDocument) {
            boolean bl = activePostModification = this.postModificationDocumentListener != null;
            if (activePostModification) {
                this.atomicLock();
            }
        }
        try {
            boolean notifyMod = this.notifyModifyCheckStart(offset, "insertString() vetoed");
            boolean modFinished = false;
            this.extWriteLock();
            try {
                boolean isComposedText;
                this.preInsertCheck(offset, text, a);
                UndoableEdit edit = this.getContent().insertString(offset, text);
                if (debug) {
                    System.err.println("BaseDocument.insertString(): doc=" + this + (this.modified ? "" : " - first modification") + ", offset=" + Utilities.offsetToLineColumnString(this, offset) + (debugNoText ? "" : ", text='" + text + "'"));
                }
                if (debugStack) {
                    Thread.dumpStack();
                }
                BaseDocumentEvent evt = this.createDocumentEvent(offset, text.length(), DocumentEvent.EventType.INSERT);
                this.preInsertUpdate(evt, a);
                if (edit != null) {
                    evt.addEdit(edit);
                    this.lastModifyUndoEdit = edit;
                }
                this.modified = true;
                if (this.atomicDepth > 0) {
                    if (this.atomicEdits == null) {
                        this.atomicEdits = new AtomicCompoundEdit();
                    }
                    this.atomicEdits.addEdit(evt);
                }
                this.insertUpdate(evt, a);
                evt.end();
                this.fireInsertUpdate(evt);
                boolean bl = isComposedText = a != null && a.isDefined(StyleConstants.ComposedTextAttribute);
                if (this.composedText && !isComposedText) {
                    this.composedText = false;
                }
                if (!this.composedText && isComposedText) {
                    this.composedText = true;
                }
                if (this.atomicDepth == 0 && !isComposedText) {
                    this.fireUndoableEditUpdate(new UndoableEditEvent(this, evt));
                }
                modFinished = true;
                postModificationEvent = evt;
            }
            finally {
                this.extWriteUnlock();
                if (notifyMod) {
                    this.notifyModifyCheckEnd(modFinished);
                }
            }
            if (activePostModification) {
                if (postModificationEvent != null && this.postModificationDocumentListener != null) {
                    this.postModificationDocumentListener.insertUpdate(postModificationEvent);
                }
                this.atomicUnlock();
            }
        }
        catch (Throwable throwable) {
            if (activePostModification) {
                if (postModificationEvent != null && this.postModificationDocumentListener != null) {
                    this.postModificationDocumentListener.insertUpdate(postModificationEvent);
                }
                this.atomicUnlock();
            }
            throw throwable;
        }
    }

    public void checkTrailingSpaces(int offset) {
        try {
            int lastEditedLine;
            int lineNum = Utilities.getLineOffset(this, offset);
            int n = lastEditedLine = this.lastPositionEditedByTyping != null ? Utilities.getLineOffset(this, this.lastPositionEditedByTyping.getOffset()) : -1;
            if (lastEditedLine != -1 && lastEditedLine != lineNum) {
                int startIndex;
                int end;
                Element root = this.getDefaultRootElement();
                Element elem = root.getElement(lastEditedLine);
                int start = elem.getStartOffset();
                String line = this.getText(start, (end = elem.getEndOffset()) - start);
                int endIndex = line.length() - 1;
                if (endIndex >= 0 && line.charAt(endIndex) == '\n' && --endIndex >= 0 && line.charAt(endIndex) == '\r') {
                    --endIndex;
                }
                for (startIndex = endIndex; startIndex >= 0 && Character.isWhitespace(line.charAt(startIndex)) && line.charAt(startIndex) != '\n' && line.charAt(startIndex) != '\r'; --startIndex) {
                }
                if (++startIndex >= 0 && startIndex <= endIndex) {
                    this.remove(start + startIndex, endIndex - startIndex + 1);
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int offset, int len) throws BadLocationException {
        if (len > 0) {
            boolean activePostModification;
            if (offset < 0) {
                throw new BadLocationException("Wrong remove position " + offset, offset);
            }
            BaseDocumentEvent postModificationEvent = null;
            BaseDocument baseDocument = this;
            synchronized (baseDocument) {
                boolean bl = activePostModification = this.postModificationDocumentListener != null;
                if (activePostModification) {
                    this.atomicLock();
                }
            }
            try {
                boolean notifyMod = this.notifyModifyCheckStart(offset, "remove() vetoed");
                boolean modFinished = false;
                this.extWriteLock();
                try {
                    int docLen = this.getLength();
                    if (offset < 0 || offset > docLen) {
                        throw new BadLocationException("Wrong remove position " + offset, offset);
                    }
                    if (offset + len > docLen) {
                        throw new BadLocationException("End offset of removed text " + (offset + len) + " > getLength()=" + docLen, offset + len);
                    }
                    this.preRemoveCheck(offset, len);
                    BaseDocumentEvent evt = this.createDocumentEvent(offset, len, DocumentEvent.EventType.REMOVE);
                    this.removeUpdate(evt);
                    UndoableEdit edit = this.getContent().remove(offset, len);
                    if (edit != null) {
                        evt.addEdit(edit);
                        this.lastModifyUndoEdit = edit;
                    }
                    if (debug) {
                        System.err.println("BaseDocument.remove(): doc=" + this + ", origDocLen=" + docLen + ", offset=" + Utilities.offsetToLineColumnString(this, offset) + ", len=" + len + (debugNoText ? "" : ", removedText='" + ((DocumentContent.Edit)edit).getUndoRedoText() + "'"));
                    }
                    if (debugStack) {
                        Thread.dumpStack();
                    }
                    if (this.atomicDepth > 0) {
                        if (this.atomicEdits == null) {
                            this.atomicEdits = new AtomicCompoundEdit();
                        }
                        this.atomicEdits.addEdit(evt);
                    }
                    this.postRemoveUpdate(evt);
                    evt.end();
                    this.fireRemoveUpdate(evt);
                    if (this.atomicDepth == 0 && !this.composedText) {
                        this.fireUndoableEditUpdate(new UndoableEditEvent(this, evt));
                    }
                    modFinished = true;
                    postModificationEvent = evt;
                }
                finally {
                    this.extWriteUnlock();
                    if (notifyMod) {
                        this.notifyModifyCheckEnd(modFinished);
                    }
                }
                if (activePostModification) {
                    if (postModificationEvent != null && this.postModificationDocumentListener != null) {
                        this.postModificationDocumentListener.removeUpdate(postModificationEvent);
                    }
                    this.atomicUnlock();
                }
            }
            catch (Throwable throwable) {
                if (activePostModification) {
                    if (postModificationEvent != null && this.postModificationDocumentListener != null) {
                        this.postModificationDocumentListener.removeUpdate(postModificationEvent);
                    }
                    this.atomicUnlock();
                }
                throw throwable;
            }
        }
    }

    boolean notifyModifyCheckStart(int offset, String vetoExceptionText) throws BadLocationException {
        boolean notifyMod;
        NotifyModifyStatus notifyModifyStatus = (NotifyModifyStatus)this.STATUS.get();
        if (notifyModifyStatus == null) {
            notifyModifyStatus = new NotifyModifyStatus(this);
            this.STATUS.set(notifyModifyStatus);
            this.notifyModify(notifyModifyStatus);
            notifyMod = true;
        } else {
            notifyMod = false;
        }
        if (notifyModifyStatus.isModificationVetoed()) {
            if (notifyMod) {
                this.STATUS.set(null);
            }
            throw new BadLocationException(vetoExceptionText, offset);
        }
        return notifyMod;
    }

    void notifyModifyCheckEnd(boolean modFinished) {
        NotifyModifyStatus notifyModifyStatus = (NotifyModifyStatus)this.STATUS.get();
        this.STATUS.set(null);
        if (!modFinished) {
            this.notifyUnmodify(notifyModifyStatus);
        }
    }

    protected void preInsertCheck(int offset, String text, AttributeSet a) throws BadLocationException {
    }

    protected void preRemoveCheck(int offset, int len) throws BadLocationException {
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        super.insertUpdate(chng, attr);
        org.netbeans.lib.editor.util.swing.DocumentUtilities.addEventPropertyStorage((DocumentEvent)chng);
        org.netbeans.lib.editor.util.swing.DocumentUtilities.putEventProperty((DocumentEvent)chng, String.class, (Object)((BaseDocumentEvent)chng).getText());
        MarksStorageUndo marksStorageUndo = new MarksStorageUndo(chng);
        marksStorageUndo.updateMarksStorage();
        chng.addEdit(marksStorageUndo);
        UndoableEdit lineUndo = this.lineRootElement.insertUpdate(chng.getOffset(), chng.getLength());
        if (lineUndo != null) {
            chng.addEdit(lineUndo);
        }
        this.fixLineSyntaxState.update(false);
        chng.addEdit(this.fixLineSyntaxState.createAfterLineUndo());
        this.fixLineSyntaxState = null;
        org.netbeans.lib.editor.util.swing.DocumentUtilities.addEventPropertyStorage((DocumentEvent)chng);
        BaseDocumentEvent bEvt = (BaseDocumentEvent)chng;
        org.netbeans.lib.editor.util.swing.DocumentUtilities.putEventProperty((DocumentEvent)chng, String.class, (Object)bEvt.getText());
    }

    protected void preInsertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        this.fixLineSyntaxState = new FixLineSyntaxState(chng);
        chng.addEdit(this.fixLineSyntaxState.createBeforeLineUndo());
    }

    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        String removedText;
        super.removeUpdate(chng);
        org.netbeans.lib.editor.util.swing.DocumentUtilities.addEventPropertyStorage((DocumentEvent)chng);
        try {
            removedText = this.getText(chng.getOffset(), chng.getLength());
        }
        catch (BadLocationException e) {
            removedText = null;
        }
        org.netbeans.lib.editor.util.swing.DocumentUtilities.putEventProperty((DocumentEvent)chng, String.class, (Object)removedText);
        this.removeUpdateLineUndo = this.lineRootElement.removeUpdate(chng.getOffset(), chng.getLength());
        this.fixLineSyntaxState = new FixLineSyntaxState(chng);
        chng.addEdit(this.fixLineSyntaxState.createBeforeLineUndo());
    }

    protected void postRemoveUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        super.postRemoveUpdate(chng);
        MarksStorageUndo marksStorageUndo = new MarksStorageUndo(chng);
        marksStorageUndo.updateMarksStorage();
        chng.addEdit(marksStorageUndo);
        if (this.removeUpdateLineUndo != null) {
            chng.addEdit(this.removeUpdateLineUndo);
            this.removeUpdateLineUndo = null;
        }
        this.fixLineSyntaxState.update(false);
        chng.addEdit(this.fixLineSyntaxState.createAfterLineUndo());
        this.fixLineSyntaxState = null;
        org.netbeans.lib.editor.util.swing.DocumentUtilities.addEventPropertyStorage((DocumentEvent)chng);
        BaseDocumentEvent bEvt = (BaseDocumentEvent)chng;
        org.netbeans.lib.editor.util.swing.DocumentUtilities.putEventProperty((DocumentEvent)chng, String.class, (Object)bEvt.getText());
    }

    public String getText(int[] block) throws BadLocationException {
        return this.getText(block[0], block[1] - block[0]);
    }

    public char[] getChars(int pos, int len) throws BadLocationException {
        char[] chars = new char[len];
        this.getChars(pos, chars, 0, len);
        return chars;
    }

    public char[] getChars(int[] block) throws BadLocationException {
        return this.getChars(block[0], block[1] - block[0]);
    }

    public void getChars(int pos, char[] ret, int offset, int len) throws BadLocationException {
        DocumentUtilities.copyText(this, pos, pos + len, ret, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(Finder finder, int startPos, int limitPos) throws BadLocationException {
        int docLen = this.getLength();
        if (limitPos == -1) {
            limitPos = docLen;
        }
        if (startPos == -1) {
            startPos = docLen;
        }
        if (finder instanceof AdjustFinder) {
            boolean voidSearch;
            if (startPos == limitPos) {
                finder.reset();
                return -1;
            }
            boolean forwardAdjustedSearch = startPos < limitPos;
            startPos = ((AdjustFinder)finder).adjustStartPos(this, startPos);
            limitPos = ((AdjustFinder)finder).adjustLimitPos(this, limitPos);
            boolean bl = forwardAdjustedSearch ? startPos >= limitPos : (voidSearch = startPos <= limitPos);
            if (voidSearch) {
                finder.reset();
                return -1;
            }
        }
        finder.reset();
        if (startPos == limitPos) {
            return -1;
        }
        Segment text = DocumentUtilities.SEGMENT_CACHE.getSegment();
        try {
            int p0;
            boolean fwdSearch;
            int gapStart = DocumentUtilities.getGapStart(this);
            if (gapStart == -1) {
                throw new IllegalStateException("Cannot get gapStart");
            }
            int pos = startPos;
            boolean bl = fwdSearch = startPos <= limitPos;
            if (fwdSearch) {
                while (pos >= startPos && pos < limitPos) {
                    int p1;
                    if (pos < gapStart) {
                        p0 = startPos;
                        p1 = Math.min(gapStart, limitPos);
                    } else {
                        p0 = Math.max(gapStart, startPos);
                        p1 = limitPos;
                    }
                    this.getText(p0, p1 - p0, text);
                    pos = finder.find(p0 - text.offset, text.array, text.offset, text.offset + text.count, pos, limitPos);
                    if (!finder.isFound()) continue;
                    int n = pos;
                    return n;
                }
            } else {
                --pos;
                while (limitPos <= pos && pos <= startPos) {
                    int p1;
                    if (pos < gapStart) {
                        p0 = limitPos;
                        p1 = Math.min(gapStart, startPos);
                    } else {
                        p0 = Math.max(gapStart, limitPos);
                        p1 = startPos;
                    }
                    this.getText(p0, p1 - p0, text);
                    pos = finder.find(p0 - text.offset, text.array, text.offset, text.offset + text.count, pos, limitPos);
                    if (!finder.isFound()) continue;
                    int n = pos;
                    return n;
                }
            }
            int n = -1;
            return n;
        }
        finally {
            DocumentUtilities.SEGMENT_CACHE.releaseSegment(text);
        }
    }

    public void repaintBlock(int startOffset, int endOffset) {
        BaseDocumentEvent evt = this.createDocumentEvent(startOffset, endOffset - startOffset, DocumentEvent.EventType.CHANGE);
        this.fireChangedUpdate(evt);
    }

    public void print(PrintContainer container) {
        this.print(container, true, true, 0, this.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrintContainer container, boolean usePrintColoringMap, boolean lineNumberEnabled, int startOffset, int endOffset) {
        this.readLock();
        try {
            EditorUI editorUI = BaseKit.getKit(this.kitClass).createPrintEditorUI(this, usePrintColoringMap, lineNumberEnabled);
            DrawGraphics.PrintDG printDG = new DrawGraphics.PrintDG(container);
            DrawEngine.getDrawEngine().draw(printDG, editorUI, startOffset, endOffset, 0, 0, Integer.MAX_VALUE);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrintContainer container, boolean usePrintColoringMap, Boolean lineNumberEnabled, int startOffset, int endOffset) {
        this.readLock();
        try {
            boolean lineNumberEnabledPar = true;
            boolean forceLineNumbers = false;
            if (lineNumberEnabled != null) {
                lineNumberEnabledPar = lineNumberEnabled;
                forceLineNumbers = lineNumberEnabled;
            }
            EditorUI editorUI = BaseKit.getKit(this.kitClass).createPrintEditorUI(this, usePrintColoringMap, lineNumberEnabledPar);
            if (forceLineNumbers) {
                editorUI.setLineNumberVisibleSetting(true);
                editorUI.setLineNumberEnabled(true);
                editorUI.updateLineNumberWidth(0);
            }
            DrawGraphics.PrintDG printDG = new DrawGraphics.PrintDG(container);
            DrawEngine.getDrawEngine().draw(printDG, editorUI, startOffset, endOffset, 0, 0, Integer.MAX_VALUE);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        finally {
            this.readUnlock();
        }
    }

    public Position createPosition(int offset, Position.Bias bias) throws BadLocationException {
        return this.getDocumentContent().createBiasPosition(offset, bias);
    }

    MultiMark createMark(int offset) throws BadLocationException {
        return this.getDocumentContent().createMark(offset);
    }

    MultiMark createBiasMark(int offset, Position.Bias bias) throws BadLocationException {
        return this.getDocumentContent().createBiasMark(offset, bias);
    }

    public Element[] getRootElements() {
        Element[] elems = new Element[]{this.getDefaultRootElement()};
        return elems;
    }

    public Element getDefaultRootElement() {
        if (this.defaultRootElem == null) {
            this.defaultRootElem = this.getLineRootElement();
        }
        return this.defaultRootElem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Runnable r) {
        this.readLock();
        assert (this.incrementThreadLocalLockDepth());
        try {
            r.run();
        }
        finally {
            assert (this.decrementThreadLocalLockDepth());
            this.readUnlock();
        }
    }

    private boolean incrementThreadLocalLockDepth() {
        int newDepth;
        Integer depthInteger = (Integer)THREAD_LOCAL_LOCK_DEPTH.get();
        depthInteger = depthInteger == null ? lockIntegers[1] : ((newDepth = depthInteger + 1) < lockIntegers.length ? lockIntegers[newDepth] : new Integer(newDepth));
        THREAD_LOCAL_LOCK_DEPTH.set(depthInteger);
        return true;
    }

    private boolean decrementThreadLocalLockDepth() {
        Integer depthInteger = (Integer)THREAD_LOCAL_LOCK_DEPTH.get();
        assert (depthInteger != null);
        int newDepth = depthInteger - 1;
        assert (newDepth >= 0);
        THREAD_LOCAL_LOCK_DEPTH.set(newDepth < lockIntegers.length ? lockIntegers[newDepth] : new Integer(newDepth));
        return true;
    }

    public void runAtomic(Runnable r) {
        this.runAtomicAsUser(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAtomicAsUser(Runnable r) {
        boolean completed = false;
        this.atomicLock();
        try {
            r.run();
            completed = true;
        }
        finally {
            try {
                if (!completed) {
                    this.breakAtomicLock();
                }
            }
            finally {
                this.atomicUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Reader reader, int pos) throws IOException, BadLocationException {
        this.extWriteLock();
        try {
            AbstractDocument.Content content;
            if (pos < 0 || pos > this.getLength()) {
                throw new BadLocationException("BaseDocument.read()", pos);
            }
            if (this.inited || this.modified) {
                Analyzer.read(this, reader, pos);
            } else {
                Analyzer.initialRead(this, reader, true);
                this.inited = true;
            }
            if (debugRead) {
                System.err.println("BaseDocument.read(): StreamDescriptionProperty: " + this.getProperty("stream"));
            }
            if ((content = this.getContent()) instanceof DocumentContent) {
                DocumentContent docContent = (DocumentContent)content;
                if (!docContent.isConservativeReallocation()) {
                    docContent.compact();
                }
                docContent.setConservativeReallocation(true);
            }
        }
        finally {
            this.extWriteUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer writer, int pos, int len) throws IOException, BadLocationException {
        this.readLock();
        try {
            if (pos < 0 || pos + len > this.getLength()) {
                throw new BadLocationException("BaseDocument.write()", pos);
            }
            Analyzer.write(this, writer, pos, len);
            writer.flush();
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateSyntaxMarks() {
        this.extWriteLock();
        try {
            FixLineSyntaxState.invalidateAllSyntaxStateInfos(this);
            this.repaintBlock(0, this.getLength());
        }
        finally {
            this.extWriteUnlock();
        }
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public int getShiftWidth() {
        if (this.shiftWidth != null) {
            return this.shiftWidth;
        }
        return this.getFormatter().getSpacesPerTab();
    }

    public final Class getKitClass() {
        return this.kitClass;
    }

    public void resetUndoMerge() {
        this.undoMergeReset = true;
    }

    protected void fireChangedUpdate(DocumentEvent e) {
        super.fireChangedUpdate(e);
    }

    protected void fireInsertUpdate(DocumentEvent e) {
        super.fireInsertUpdate(e);
    }

    protected void fireRemoveUpdate(DocumentEvent e) {
        super.fireRemoveUpdate(e);
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent e) {
        Object[] listeners = this.atomicLockListenerList != null ? this.atomicLockListenerList : this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != UndoableEditListener.class) continue;
            ((UndoableEditListener)listeners[i + 1]).undoableEditHappened(e);
        }
    }

    public final synchronized void extWriteLock() {
        if (Thread.currentThread() != this.getCurrentWriter()) {
            super.writeLock();
            assert (this.incrementThreadLocalLockDepth());
        } else {
            ++this.writeDepth;
        }
    }

    public final synchronized void extWriteUnlock() {
        if (Thread.currentThread() != this.getCurrentWriter()) {
            throw new RuntimeException(WRITE_LOCK_MISSING);
        }
        if (this.writeDepth == 0) {
            assert (this.decrementThreadLocalLockDepth());
            super.writeUnlock();
        } else {
            --this.writeDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void atomicLock() {
        BaseDocument baseDocument = this;
        synchronized (baseDocument) {
            NotifyModifyStatus notifyModifyStatus = (NotifyModifyStatus)this.STATUS.get();
            if (notifyModifyStatus == null) {
                notifyModifyStatus = new NotifyModifyStatus(this);
                this.STATUS.set(notifyModifyStatus);
            }
            this.extWriteLock();
            ++this.atomicDepth;
            if (this.atomicDepth == 1) {
                this.fireAtomicLock(this.atomicLockEventInstance);
                this.atomicLockListenerList = this.listenerList.getListenerList();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void atomicUnlock() {
        boolean modsDone = false;
        boolean lastAtomic = false;
        BaseDocument baseDocument = this;
        synchronized (baseDocument) {
            this.extWriteUnlock();
            if (this.atomicDepth == 0) {
                throw new IllegalStateException("atomicUnlock() without atomicLock()");
            }
            if (--this.atomicDepth == 0) {
                lastAtomic = true;
                this.fireAtomicUnlock(this.atomicLockEventInstance);
                if (this.atomicEdits != null && this.atomicEdits.size() > 0) {
                    modsDone = true;
                    this.atomicEdits.end();
                    this.fireUndoableEditUpdate(new UndoableEditEvent(this, this.atomicEdits));
                    this.atomicEdits = null;
                }
                if (this.modsUndoneOrRedone) {
                    this.modsUndoneOrRedone = false;
                    modsDone = true;
                }
                this.atomicLockListenerList = null;
            }
        }
        if (modsDone) {
            NotifyModifyStatus notifyModifyStatus = (NotifyModifyStatus)this.STATUS.get();
            this.notifyModify(notifyModifyStatus);
        }
        if (lastAtomic) {
            this.STATUS.set(null);
        }
    }

    void markModsUndoneOrRedone() {
        this.modsUndoneOrRedone = true;
    }

    public final boolean isAtomicLock() {
        return this.atomicDepth > 0;
    }

    public final void breakAtomicLock() {
        if (this.atomicEdits != null && this.atomicEdits.size() > 0) {
            this.atomicEdits.end();
            this.atomicEdits.undo();
            this.atomicEdits = null;
        }
    }

    private void notifyModify(NotifyModifyStatus notifyModifyStatus) {
        notifyModifyStatus.setModificationVetoed(false);
        VetoableChangeListener bml = notifyModifyStatus.getBeforeModificationListener();
        if (bml != null) {
            try {
                bml.vetoableChange(new PropertyChangeEvent(this, "modified", null, Boolean.TRUE));
            }
            catch (PropertyVetoException ex) {
                notifyModifyStatus.setModificationVetoed(true);
            }
        }
    }

    private void notifyUnmodify(NotifyModifyStatus notifyModifyStatus) {
        VetoableChangeListener bml = notifyModifyStatus.getBeforeModificationListener();
        if (bml != null) {
            try {
                bml.vetoableChange(new PropertyChangeEvent(this, "modified", null, Boolean.FALSE));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            notifyModifyStatus.setModificationVetoed(false);
        }
    }

    public void atomicUndo() {
        this.breakAtomicLock();
    }

    public void addAtomicLockListener(AtomicLockListener l) {
        this.listenerList.add(AtomicLockListener.class, l);
    }

    public void removeAtomicLockListener(AtomicLockListener l) {
        this.listenerList.remove(AtomicLockListener.class, l);
    }

    private void fireAtomicLock(AtomicLockEvent evt) {
        EventListener[] listeners = this.listenerList.getListeners(AtomicLockListener.class);
        int cnt = listeners.length;
        for (int i = 0; i < cnt; ++i) {
            ((AtomicLockListener)listeners[i]).atomicLock(evt);
        }
    }

    private void fireAtomicUnlock(AtomicLockEvent evt) {
        EventListener[] listeners = this.listenerList.getListeners(AtomicLockListener.class);
        int cnt = listeners.length;
        for (int i = 0; i < cnt; ++i) {
            ((AtomicLockListener)listeners[i]).atomicUnlock(evt);
        }
    }

    protected final int getAtomicDepth() {
        return this.atomicDepth;
    }

    public void addDocumentListener(DocumentListener listener) {
        if (!org.netbeans.lib.editor.util.swing.DocumentUtilities.addPriorityDocumentListener((Document)this, (DocumentListener)listener, (DocumentListenerPriority)DocumentListenerPriority.DEFAULT)) {
            super.addDocumentListener(listener);
        }
    }

    public void removeDocumentListener(DocumentListener listener) {
        if (!org.netbeans.lib.editor.util.swing.DocumentUtilities.removePriorityDocumentListener((Document)this, (DocumentListener)listener, (DocumentListenerPriority)DocumentListenerPriority.DEFAULT)) {
            super.removeDocumentListener(listener);
        }
    }

    protected BaseDocumentEvent createDocumentEvent(int pos, int length, DocumentEvent.EventType type) {
        return new BaseDocumentEvent(this, pos, length, type);
    }

    public void setPostModificationDocumentListener(DocumentListener listener) {
        this.postModificationDocumentListener = listener;
    }

    public boolean isModified() {
        return this.modified;
    }

    public DrawLayer findLayer(String layerName) {
        return this.drawLayerList.findLayer(layerName);
    }

    public boolean addLayer(DrawLayer layer, int visibility) {
        if (this.drawLayerList.add(layer, visibility)) {
            BaseDocumentEvent evt = this.createDocumentEvent(0, 0, DocumentEvent.EventType.CHANGE);
            evt.addEdit(new BaseDocumentEvent.DrawLayerChange(layer.getName(), visibility));
            this.fireChangedUpdate(evt);
            return true;
        }
        return false;
    }

    final DrawLayerList getDrawLayerList() {
        return this.drawLayerList;
    }

    private LineRootElement getLineRootElement() {
        return this.lineRootElement;
    }

    public Element getParagraphElement(int pos) {
        return this.getLineRootElement().getElement(this.getLineRootElement().getElementIndex(pos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Annotations getAnnotations() {
        Object object = annotationsLock;
        synchronized (object) {
            if (this.annotations == null) {
                this.annotations = new Annotations(this);
            }
            return this.annotations;
        }
    }

    void prepareSyntax(Segment text, Syntax syntax, int reqPos, int reqLen, boolean forceLastBuffer, boolean forceNotLastBuffer) throws BadLocationException {
        FixLineSyntaxState.prepareSyntax(this, text, syntax, reqPos, reqLen, forceLastBuffer, forceNotLastBuffer);
    }

    int getTokenSafeOffset(int offset) {
        return FixLineSyntaxState.getTokenSafeOffset(this, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getOffsetFromVisCol(int visCol, int startLinePos) throws BadLocationException {
        Object object = getOffsetFromVisColLock;
        synchronized (object) {
            if (startLinePos < 0 || startLinePos >= this.getLength()) {
                throw new BadLocationException("Invalid start line offset", startLinePos);
            }
            if (visCol <= 0) {
                return startLinePos;
            }
            if (this.visColPosFwdFinder == null) {
                this.visColPosFwdFinder = new FinderFactory.VisColPosFwdFinder();
            }
            this.visColPosFwdFinder.setVisCol(visCol);
            this.visColPosFwdFinder.setTabSize(this.getTabSize());
            int pos = this.find(this.visColPosFwdFinder, startLinePos, -1);
            return pos != -1 ? pos : Utilities.getRowEnd(this, startLinePos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getVisColFromPos(int pos) throws BadLocationException {
        Object object = getVisColFromPosLock;
        synchronized (object) {
            if (pos < 0 || pos > this.getLength()) {
                throw new BadLocationException("Invalid offset", pos);
            }
            if (this.posVisColFwdFinder == null) {
                this.posVisColFwdFinder = new FinderFactory.PosVisColFwdFinder();
            }
            int startLinePos = Utilities.getRowStart(this, pos);
            this.posVisColFwdFinder.setTabSize(this.getTabSize());
            this.find(this.posVisColFwdFinder, startLinePos, pos);
            return this.posVisColFwdFinder.getVisCol();
        }
    }

    protected Dictionary createDocumentProperties(Dictionary origDocumentProperties) {
        return new LazyPropertyMap(origDocumentProperties);
    }

    public String toString() {
        return super.toString() + ", kitClass=" + this.getKitClass() + ", docLen=" + this.getLength();
    }

    public String toStringDetail() {
        return this.toString();
    }

    class AtomicCompoundEdit
    extends CompoundEdit {
        private UndoableEdit previousEdit;

        AtomicCompoundEdit() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undo() throws CannotUndoException {
            BaseDocument.this.atomicLock();
            try {
                super.undo();
            }
            finally {
                BaseDocument.this.atomicUnlock();
            }
            if (this.previousEdit != null) {
                this.previousEdit.undo();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void redo() throws CannotRedoException {
            if (this.previousEdit != null) {
                this.previousEdit.redo();
            }
            BaseDocument.this.atomicLock();
            try {
                super.redo();
            }
            finally {
                BaseDocument.this.atomicUnlock();
            }
        }

        public void die() {
            super.die();
            if (this.previousEdit != null) {
                this.previousEdit.die();
                this.previousEdit = null;
            }
        }

        public int size() {
            return this.edits.size();
        }

        public boolean replaceEdit(UndoableEdit anEdit) {
            UndoableEdit childEdit;
            if (this.size() == 1 && (childEdit = (UndoableEdit)this.getEdits().get(0)) instanceof BaseDocumentEvent) {
                BaseDocumentEvent childEvt = (BaseDocumentEvent)childEdit;
                if (anEdit instanceof AtomicCompoundEdit) {
                    UndoableEdit edit;
                    AtomicCompoundEdit compEdit = (AtomicCompoundEdit)anEdit;
                    if (!BaseDocument.this.undoMergeReset && compEdit.getEdits().size() == 1 && (edit = (UndoableEdit)compEdit.getEdits().get(0)) instanceof BaseDocumentEvent && childEvt.canMerge((BaseDocumentEvent)edit)) {
                        this.previousEdit = anEdit;
                        return true;
                    }
                } else if (anEdit instanceof BaseDocumentEvent) {
                    BaseDocumentEvent evt = (BaseDocumentEvent)anEdit;
                    if (!BaseDocument.this.undoMergeReset && childEvt.canMerge(evt)) {
                        this.previousEdit = anEdit;
                        return true;
                    }
                }
            }
            BaseDocument.this.undoMergeReset = false;
            return false;
        }

        Vector getEdits() {
            return this.edits;
        }
    }

    protected static class LazyPropertyMap
    extends Hashtable {
        protected LazyPropertyMap(Dictionary dict) {
            super(5);
            Enumeration en = dict.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                this.put(key, dict.get(key));
            }
        }

        public Object get(Object key) {
            Object val = super.get(key);
            if (val instanceof PropertyEvaluator) {
                val = ((PropertyEvaluator)val).getValue();
            }
            return val;
        }
    }

    private static final class MarksStorageUndo
    extends AbstractUndoableEdit {
        private DocumentEvent evt;

        MarksStorageUndo(DocumentEvent evt) {
            this.evt = evt;
        }

        private int getLength() {
            int length = this.evt.getLength();
            if (this.evt.getType() == DocumentEvent.EventType.REMOVE) {
                length = -length;
            }
            return length;
        }

        void updateMarksStorage() {
            BaseDocument doc = (BaseDocument)this.evt.getDocument();
            doc.marksStorage.update(this.evt.getOffset(), this.getLength(), null);
        }

        public void undo() throws CannotUndoException {
            BaseDocument doc = (BaseDocument)this.evt.getDocument();
            doc.marksStorage.update(this.evt.getOffset(), -this.getLength(), null);
            super.undo();
        }

        public void redo() throws CannotRedoException {
            this.updateMarksStorage();
            super.redo();
        }
    }

    private static final class NotifyModifyStatus {
        private final VetoableChangeListener beforeModificationListener;
        private boolean modificationVetoed;

        NotifyModifyStatus(BaseDocument document) {
            this.beforeModificationListener = (VetoableChangeListener)document.getProperty(BaseDocument.BEFORE_MODIFICATION_LISTENER);
        }

        public boolean isModificationVetoed() {
            return this.modificationVetoed;
        }

        public void setModificationVetoed(boolean modificationVetoed) {
            this.modificationVetoed = modificationVetoed;
        }

        public VetoableChangeListener getBeforeModificationListener() {
            return this.beforeModificationListener;
        }
    }

    public static interface PropertyEvaluator {
        public Object getValue();
    }
}

