/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawEngineLineView;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.Utilities;
import org.openide.util.NbBundle;

public class CodeFoldingSideBar
extends JComponent
implements SettingsChangeListener,
Accessible {
    protected JTextComponent component;
    protected Font font;
    protected Color foreColor;
    protected Color backColor;
    private boolean enabled;
    protected List visibleMarks = new ArrayList();
    public static final int PAINT_NOOP = 0;
    public static final int PAINT_MARK = 1;
    public static final int PAINT_LINE = 2;
    public static final int PAINT_END_MARK = 3;
    public static final int SINGLE_PAINT_MARK = 4;

    public CodeFoldingSideBar() {
        this.setOpaque(true);
    }

    public CodeFoldingSideBar(JTextComponent component) {
        this.component = component;
        Settings.addSettingsChangeListener(this);
        this.settingsChange(null);
        FoldingMouseListener listener = new FoldingMouseListener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)component);
        foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)new SideBarFoldHierarchyListener());
        Document doc = this.getDocument();
        doc.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent evt) {
                if (!(evt instanceof BaseDocumentEvent)) {
                    return;
                }
                BaseDocumentEvent bevt = (BaseDocumentEvent)evt;
                if (bevt.getLFCount() > 0) {
                    CodeFoldingSideBar.this.repaint();
                }
            }

            public void removeUpdate(DocumentEvent evt) {
                if (!(evt instanceof BaseDocumentEvent)) {
                    return;
                }
                BaseDocumentEvent bevt = (BaseDocumentEvent)evt;
                if (bevt.getLFCount() > 0) {
                    CodeFoldingSideBar.this.repaint();
                }
            }

            public void changedUpdate(DocumentEvent evt) {
            }
        });
        this.setOpaque(true);
    }

    private boolean enableSideBarComponent(boolean enable) {
        if (enable == this.enabled) {
            return false;
        }
        this.enabled = enable;
        this.updatePreferredSize();
        return true;
    }

    private void updatePreferredSize() {
        if (this.enabled) {
            this.setPreferredSize(new Dimension(this.getColoringFont().getSize(), this.component.getHeight()));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        } else {
            this.setPreferredSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
        this.revalidate();
    }

    private Font getDefaultColoringFont() {
        Coloring defaultColoring = this.getEditorUI().getDefaultColoring();
        if (defaultColoring != null && defaultColoring.getFont() != null) {
            return defaultColoring.getFont();
        }
        return SettingsDefaults.defaultFont;
    }

    protected Font getColoringFont() {
        if (this.font != null) {
            return this.font;
        }
        Coloring foldColoring = this.getEditorUI().getColoring("code-folding-bar");
        if (foldColoring != null && foldColoring.getFont() != null) {
            this.font = foldColoring.getFont();
            return this.font;
        }
        this.font = this.getDefaultColoringFont();
        return this.font;
    }

    public void update(Graphics g) {
    }

    protected Color getForeColor() {
        if (this.foreColor != null) {
            return this.foreColor;
        }
        Coloring foldColoring = this.getEditorUI().getColoring("code-folding-bar");
        if (foldColoring != null && foldColoring.getForeColor() != null) {
            this.foreColor = foldColoring.getForeColor();
            return this.foreColor;
        }
        this.foreColor = this.getDefaultForeColor();
        return this.foreColor;
    }

    private Color getDefaultForeColor() {
        Coloring defaultColoring = this.getEditorUI().getDefaultColoring();
        if (defaultColoring != null && defaultColoring.getForeColor() != null) {
            return defaultColoring.getForeColor();
        }
        return SettingsDefaults.defaultForeColor;
    }

    private Color getDefaultBackColor() {
        Coloring defaultColoring = this.getEditorUI().getDefaultColoring();
        if (defaultColoring != null) {
            return defaultColoring.getBackColor();
        }
        return SettingsDefaults.defaultBackColor;
    }

    protected Color getBackColor() {
        if (this.backColor != null) {
            return this.backColor;
        }
        Coloring foldColoring = this.getEditorUI().getColoring("code-folding-bar");
        if (foldColoring != null && foldColoring.getBackColor() != null) {
            this.backColor = foldColoring.getBackColor();
            return this.backColor;
        }
        this.backColor = this.getDefaultBackColor();
        return this.backColor;
    }

    public void settingsChange(SettingsChangeEvent evt) {
        Boolean newEnabled;
        boolean change;
        EditorUI editorUI = this.getEditorUI();
        if (editorUI == null) {
            return;
        }
        Document doc = this.component.getDocument();
        Class kitClass = doc instanceof BaseDocument ? Utilities.getKitClass(this.component) : BaseKit.class;
        Font origFont = this.font;
        Coloring foldingColoring = editorUI.getColoring("code-folding-bar");
        if (foldingColoring != null) {
            this.font = foldingColoring.getFont();
            this.foreColor = foldingColoring.getForeColor();
            this.backColor = foldingColoring.getBackColor();
        }
        if (this.font == null) {
            this.font = this.getDefaultColoringFont();
        }
        if (this.foreColor == null) {
            this.foreColor = this.getDefaultForeColor();
        }
        if (this.backColor == null) {
            this.backColor = this.getDefaultBackColor();
        }
        if (!(change = this.enableSideBarComponent((newEnabled = (Boolean)Settings.getValue(kitClass, "code-folding-enable")) != null ? newEnabled : false))) {
            if (this.font != null && this.font.equals(origFont)) {
                this.repaint();
            } else {
                this.updatePreferredSize();
                this.revalidate();
            }
        }
    }

    protected void collectPaintInfos(Fold fold, Map map, int level, int startIndex, int endIndex) {
        int docLength;
        View rootView = Utilities.getDocumentView(this.component);
        if (rootView == null) {
            return;
        }
        for (int i = 0; i < fold.getFoldCount(); ++i) {
            int startViewIndex = rootView.getViewIndex(fold.getFold(i).getStartOffset(), Position.Bias.Forward);
            int endViewIndex = rootView.getViewIndex(fold.getFold(i).getEndOffset(), Position.Bias.Forward);
            if (endViewIndex < startIndex || startViewIndex > endIndex) continue;
            this.collectPaintInfos(fold.getFold(i), map, level + 1, startIndex, endIndex);
        }
        int foldStartOffset = fold.getStartOffset();
        int foldEndOffset = fold.getEndOffset();
        if (foldEndOffset > (docLength = rootView.getDocument().getLength())) {
            return;
        }
        int startViewIndex = rootView.getViewIndex(foldStartOffset, Position.Bias.Forward);
        int endViewIndex = rootView.getViewIndex(foldEndOffset, Position.Bias.Forward);
        try {
            Rectangle viewRect;
            View view;
            Rectangle viewShape;
            BaseTextUI textUI = (BaseTextUI)this.component.getUI();
            int markY = -1;
            int y = -1;
            if (startIndex <= startViewIndex && (viewShape = textUI.modelToView(this.component, (view = rootView.getView(startViewIndex)).getStartOffset())) != null) {
                boolean isSingleLineFold;
                viewRect = viewShape.getBounds();
                y = viewRect.y + viewRect.height;
                boolean bl = isSingleLineFold = startViewIndex == endViewIndex;
                if (fold.isCollapsed() || isSingleLineFold) {
                    map.put(new Integer(viewRect.y), new PaintInfo(isSingleLineFold ? 4 : 1, level, viewRect.y, viewRect.height, fold.isCollapsed()));
                    return;
                }
                markY = viewRect.y;
                map.put(new Integer(viewRect.y), new PaintInfo(1, level, viewRect.y, viewRect.height, fold.isCollapsed()));
            }
            if (level == 0) {
                int loopStart = startViewIndex < startIndex ? startIndex : startViewIndex + 1;
                int loopEnd = endViewIndex > endIndex ? endIndex : endViewIndex;
                viewRect = null;
                for (int i = loopStart; i <= loopEnd; ++i) {
                    view = rootView.getView(i);
                    if (view instanceof DrawEngineLineView && y > -1) {
                        int h = (int)((DrawEngineLineView)view).getLayoutMajorAxisPreferredSpan();
                        viewRect = new Rectangle(0, y, 0, h);
                        if (i < loopEnd && loopEnd > loopStart) {
                            y += h;
                        }
                    } else {
                        viewShape = textUI.modelToView(this.component, view.getStartOffset());
                        if (viewShape != null) {
                            viewRect = viewShape.getBounds();
                            if (i < loopEnd && loopEnd > loopStart) {
                                y = viewRect.y + viewRect.height;
                            }
                        }
                    }
                    if (viewRect == null || map.containsKey(new Integer(viewRect.y))) continue;
                    map.put(new Integer(viewRect.y), new PaintInfo(2, level, viewRect.y, viewRect.height));
                }
            }
            if (endViewIndex <= endIndex) {
                PaintInfo pi;
                view = rootView.getView(endViewIndex);
                viewRect = null;
                if (view instanceof DrawEngineLineView && y > -1 && level == 0) {
                    int h = (int)((DrawEngineLineView)view).getLayoutMajorAxisPreferredSpan();
                    viewRect = new Rectangle(0, y, 0, h);
                    y += h;
                } else {
                    viewShape = textUI.modelToView(this.component, view.getStartOffset());
                    if (viewShape != null) {
                        viewRect = viewShape.getBounds();
                        y = viewRect.y + viewRect.height;
                    }
                }
                if (viewRect != null && markY != viewRect.y && ((pi = (PaintInfo)map.get(new Integer(viewRect.y))) == null || pi.getPaintOperation() != 1 && pi.getPaintOperation() != 4 || level >= pi.getInnerLevel())) {
                    map.put(new Integer(viewRect.y), new PaintInfo(3, level, viewRect.y, viewRect.height));
                }
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getPaintInfo(int startPos, int endPos) {
        ArrayList ret = new ArrayList();
        List foldList = this.getFoldList(startPos, endPos);
        if (foldList.size() == 0) {
            return ret;
        }
        BaseTextUI textUI = (BaseTextUI)this.component.getUI();
        Element rootElem = textUI.getRootView(this.component).getElement();
        View rootView = Utilities.getDocumentView(this.component);
        if (rootView == null) {
            return ret;
        }
        Document doc = this.component.getDocument();
        if (!(doc instanceof BaseDocument)) {
            return ret;
        }
        BaseDocument bDoc = (BaseDocument)doc;
        HashMap map = new HashMap();
        bDoc.readLock();
        try {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)this.component);
            hierarchy.lock();
            try {
                int startViewIndex = rootView.getViewIndex(startPos, Position.Bias.Forward);
                int endViewIndex = rootView.getViewIndex(endPos, Position.Bias.Forward);
                for (int i = 0; i < foldList.size(); ++i) {
                    Fold fold = (Fold)foldList.get(i);
                    this.collectPaintInfos(fold, map, 0, startViewIndex, endViewIndex);
                }
            }
            finally {
                hierarchy.unlock();
            }
        }
        finally {
            bDoc.readUnlock();
        }
        return new ArrayList(map.values());
    }

    protected EditorUI getEditorUI() {
        return Utilities.getEditorUI(this.component);
    }

    protected Document getDocument() {
        return this.component.getDocument();
    }

    private Fold getLastLineFold(FoldHierarchy hierarchy, int rowStart, int rowEnd) {
        Fold fold = FoldUtilities.findNearestFold((FoldHierarchy)hierarchy, (int)rowStart);
        while (fold != null && fold.getStartOffset() < rowEnd) {
            Fold nextFold = FoldUtilities.findNearestFold((FoldHierarchy)hierarchy, (int)(fold.isCollapsed() ? fold.getEndOffset() : fold.getStartOffset() + 1));
            if (nextFold == fold) {
                return fold;
            }
            if (nextFold != null && nextFold.getStartOffset() < rowEnd) {
                fold = nextFold;
                continue;
            }
            return fold;
        }
        return fold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Mark mark) {
        BaseTextUI textUI = (BaseTextUI)this.component.getUI();
        Element rootElem = textUI.getRootView(this.component).getElement();
        View rootView = Utilities.getDocumentView(this.component);
        if (rootView == null) {
            return;
        }
        try {
            int startViewIndex = rootView.getViewIndex(textUI.getPosFromY(mark.y + mark.size / 2), Position.Bias.Forward);
            View view = rootView.getView(startViewIndex);
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)this.component);
            AbstractDocument adoc = (AbstractDocument)foldHierarchy.getComponent().getDocument();
            adoc.readLock();
            try {
                foldHierarchy.lock();
                try {
                    int viewStartOffset = view.getStartOffset();
                    int rowStart = javax.swing.text.Utilities.getRowStart(this.component, viewStartOffset);
                    int rowEnd = javax.swing.text.Utilities.getRowEnd(this.component, viewStartOffset);
                    Fold clickedFold = this.getLastLineFold(foldHierarchy, rowStart, rowEnd);
                    if (clickedFold != null && clickedFold.getStartOffset() < view.getEndOffset()) {
                        foldHierarchy.toggle(clickedFold);
                    }
                }
                finally {
                    foldHierarchy.unlock();
                }
            }
            finally {
                adoc.readUnlock();
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    protected int getMarkSize(Graphics g) {
        FontMetrics fm;
        if (g != null && (fm = g.getFontMetrics(this.getColoringFont())) != null) {
            int ret = fm.getAscent() - fm.getDescent();
            return ret - ret % 2;
        }
        return -1;
    }

    protected void paintComponent(Graphics g) {
        if (!this.enabled) {
            return;
        }
        Rectangle clip = this.getVisibleRect();
        this.visibleMarks.clear();
        g.setColor(this.getBackColor());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        g.setColor(this.getForeColor());
        TextUI ui = this.component.getUI();
        if (!(ui instanceof BaseTextUI)) {
            return;
        }
        BaseTextUI textUI = (BaseTextUI)ui;
        try {
            int startPos = textUI.getPosFromY(clip.y);
            int endPos = textUI.viewToModel(this.component, 16383, clip.y + clip.height);
            List ps = this.getPaintInfo(startPos, endPos);
            Font defFont = this.getColoringFont();
            for (int i = 0; i < ps.size(); ++i) {
                PaintInfo paintInfo = (PaintInfo)ps.get(i);
                if (paintInfo.getPaintOperation() == 0 && paintInfo.getInnerLevel() == 0) continue;
                boolean isFolded = paintInfo.isCollapsed();
                int y = paintInfo.getPaintY();
                int height = paintInfo.getPaintHeight();
                int markSize = this.getMarkSize(g);
                int halfMarkSize = markSize / 2;
                int markX = (defFont.getSize() - markSize) / 2;
                int markY = y + g.getFontMetrics(defFont).getDescent();
                int plusGap = (int)Math.round((double)markSize / 3.8);
                int lineX = markX + halfMarkSize;
                int paintOperation = paintInfo.getPaintOperation();
                if (paintOperation == 1 || paintOperation == 4) {
                    g.drawRect(markX, markY, markSize, markSize);
                    g.drawLine(plusGap + markX, markY + halfMarkSize, markSize + markX - plusGap, markY + halfMarkSize);
                    if (isFolded) {
                        g.drawLine(lineX, markY + plusGap, lineX, markY + markSize - plusGap);
                    } else if (paintOperation != 4) {
                        g.drawLine(lineX, markY + markSize, lineX, y + height);
                    }
                    if (paintInfo.getInnerLevel() > 0) {
                        g.drawLine(lineX, y, lineX, markY);
                        g.drawLine(lineX, markY + markSize, lineX, y + height);
                    }
                    this.visibleMarks.add(new Mark(markX, markY, markSize, isFolded));
                    continue;
                }
                if (paintOperation == 2) {
                    g.drawLine(lineX, y, lineX, y + height);
                    continue;
                }
                if (paintOperation != 3) continue;
                g.drawLine(lineX, y, lineX, y + height / 2);
                g.drawLine(lineX, y + height / 2, lineX + halfMarkSize, y + height / 2);
                if (paintInfo.getInnerLevel() <= 0) continue;
                g.drawLine(lineX, y + height / 2, lineX, y + height);
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getFoldList(int start, int end) {
        FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)this.component);
        hierarchy.lock();
        try {
            Fold f;
            ArrayList<Fold> ret = new ArrayList<Fold>();
            Fold rootFold = hierarchy.getRootFold();
            int foldCount = rootFold.getFoldCount();
            for (int index = FoldUtilities.findFoldEndIndex((Fold)rootFold, (int)start); index < foldCount && (f = rootFold.getFold(index)).getStartOffset() <= end; ++index) {
                ret.add(f);
            }
            ArrayList<Fold> arrayList = ret;
            return arrayList;
        }
        finally {
            hierarchy.unlock();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
            this.accessibleContext.setAccessibleName(NbBundle.getMessage(CodeFoldingSideBar.class, (String)"ACSN_CodeFoldingSideBar"));
            this.accessibleContext.setAccessibleDescription(NbBundle.getMessage(CodeFoldingSideBar.class, (String)"ACSD_CodeFoldingSideBar"));
        }
        return this.accessibleContext;
    }

    class FoldingMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private Mark getClickedMark(MouseEvent e) {
            if (e == null || !SwingUtilities.isLeftMouseButton(e)) {
                return null;
            }
            int x = e.getX();
            int y = e.getY();
            for (int i = 0; i < CodeFoldingSideBar.this.visibleMarks.size(); ++i) {
                Mark mark = (Mark)CodeFoldingSideBar.this.visibleMarks.get(i);
                if (x < mark.x || x > mark.x + mark.size || y < mark.y || y > mark.y + mark.size) continue;
                return mark;
            }
            return null;
        }

        private MouseEvent createNewMouseEvent(MouseEvent oldEvent) {
            int x = oldEvent.getX() - CodeFoldingSideBar.this.getWidth();
            return new MouseEvent(CodeFoldingSideBar.this.component, oldEvent.getID(), oldEvent.getWhen(), oldEvent.getModifiers(), x, oldEvent.getY(), oldEvent.getClickCount(), oldEvent.isPopupTrigger(), oldEvent.getButton());
        }

        public void mousePressed(MouseEvent e) {
            Mark mark = this.getClickedMark(e);
            if (mark != null) {
                CodeFoldingSideBar.this.performAction(mark);
            } else {
                CodeFoldingSideBar.this.component.dispatchEvent(this.createNewMouseEvent(e));
            }
        }

        public void mouseReleased(MouseEvent e) {
            Mark mark = this.getClickedMark(e);
            if (mark == null) {
                CodeFoldingSideBar.this.component.dispatchEvent(this.createNewMouseEvent(e));
            }
        }

        public void mouseEntered(MouseEvent e) {
            Mark mark = this.getClickedMark(e);
            if (mark == null) {
                CodeFoldingSideBar.this.component.dispatchEvent(this.createNewMouseEvent(e));
            }
        }

        public void mouseExited(MouseEvent e) {
            Mark mark = this.getClickedMark(e);
            if (mark == null) {
                CodeFoldingSideBar.this.component.dispatchEvent(this.createNewMouseEvent(e));
            }
        }

        public void mouseMoved(MouseEvent e) {
            Mark mark = this.getClickedMark(e);
            if (mark == null) {
                CodeFoldingSideBar.this.component.dispatchEvent(this.createNewMouseEvent(e));
            }
        }

        public void mouseDragged(MouseEvent e) {
            Mark mark = this.getClickedMark(e);
            if (mark == null) {
                CodeFoldingSideBar.this.component.dispatchEvent(this.createNewMouseEvent(e));
            }
        }
    }

    public class Mark {
        public int x;
        public int y;
        public int size;
        public boolean isFolded;

        public Mark(int x, int y, int size, boolean isFolded) {
            this.x = x;
            this.y = y;
            this.size = size;
            this.isFolded = isFolded;
        }
    }

    public class PaintInfo {
        int paintOperation;
        int innerLevel;
        int paintY;
        int paintHeight;
        boolean isCollapsed;

        public PaintInfo(int paintOperation, int innerLevel, int paintY, int paintHeight, boolean isCollapsed) {
            this.paintOperation = paintOperation;
            this.innerLevel = innerLevel;
            this.paintY = paintY;
            this.paintHeight = paintHeight;
            this.isCollapsed = isCollapsed;
        }

        public PaintInfo(int paintOperation, int innerLevel, int paintY, int paintHeight) {
            this(paintOperation, innerLevel, paintY, paintHeight, false);
        }

        public int getPaintOperation() {
            return this.paintOperation;
        }

        public int getInnerLevel() {
            return this.innerLevel;
        }

        public int getPaintY() {
            return this.paintY;
        }

        public int getPaintHeight() {
            return this.paintHeight;
        }

        public boolean isCollapsed() {
            return this.isCollapsed;
        }

        public void setPaintOperation(int paintOperation) {
            this.paintOperation = paintOperation;
        }

        public void setInnerLevel(int innerLevel) {
            this.innerLevel = innerLevel;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("");
            if (this.paintOperation == 0) {
                sb.append("PAINT_NOOP\n");
            } else if (this.paintOperation == 1) {
                sb.append("PAINT_MARK\n");
            } else if (this.paintOperation == 2) {
                sb.append("PAINT_LINE\n");
            } else if (this.paintOperation == 3) {
                sb.append("PAINT_END_MARK\n");
            }
            sb.append("level:" + this.innerLevel);
            sb.append("\ncollapsedFold:" + this.isCollapsed);
            return sb.toString();
        }
    }

    class SideBarFoldHierarchyListener
    implements FoldHierarchyListener {
        public void foldHierarchyChanged(FoldHierarchyEvent evt) {
            CodeFoldingSideBar.this.repaint();
        }
    }
}

