/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawEngineFakeDocView;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FoldingToolTip;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.editor.view.spi.LockView;

class CollapsedView
extends View
implements SettingsChangeListener {
    private Position startPos;
    private Position endPos;
    private String foldDescription;
    private Font font;
    private Color foreColor;
    private Color backColor;

    public CollapsedView(Element elem, Position startPos, Position endPos, String foldDescription) {
        super(elem);
        this.startPos = startPos;
        this.endPos = endPos;
        this.foldDescription = foldDescription;
        Settings.addSettingsChangeListener(this);
    }

    private JTextComponent getComponent() {
        return (JTextComponent)this.getContainer();
    }

    private BaseTextUI getBaseTextUI() {
        JTextComponent comp = this.getComponent();
        return comp != null ? (BaseTextUI)comp.getUI() : null;
    }

    private EditorUI getEditorUI() {
        BaseTextUI btui = this.getBaseTextUI();
        return btui != null ? btui.getEditorUI() : null;
    }

    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
    }

    public Document getDocument() {
        View parent = this.getParent();
        return parent == null ? null : parent.getDocument();
    }

    public int getStartOffset() {
        return this.startPos.getOffset();
    }

    public int getEndOffset() {
        return this.endPos.getOffset();
    }

    protected void forwardUpdate(DocumentEvent.ElementChange ec, DocumentEvent e, Shape a, ViewFactory f) {
    }

    protected void forwardUpdateToView(View v, DocumentEvent e, Shape a, ViewFactory f) {
    }

    public float getAlignment(int axis) {
        return 0.0f;
    }

    public float getPreferredSpan(int axis) {
        switch (axis) {
            case 1: {
                return this.getEditorUI().getLineHeight();
            }
            case 0: {
                return this.getCollapsedFoldStringWidth();
            }
        }
        return 1.0f;
    }

    private int getCollapsedFoldStringWidth() {
        JTextComponent comp = this.getComponent();
        if (comp == null) {
            return 0;
        }
        FontMetrics fm = FontMetricsCache.getFontMetrics(this.getColoringFont(), comp);
        if (fm == null) {
            return 0;
        }
        return fm.stringWidth(this.foldDescription);
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        return new Rectangle(a.getBounds().x, a.getBounds().y, this.getCollapsedFoldStringWidth(), this.getEditorUI().getLineHeight());
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        return this.getStartOffset();
    }

    public void paint(Graphics g, Shape allocation) {
        Rectangle allocRect = allocation.getBounds();
        g.setColor(this.getBackColor());
        int x = allocRect.x + 2;
        int y = allocRect.y;
        int width = allocRect.width - 1;
        int height = allocRect.height - 1;
        g.fillRect(x, y, width, height);
        g.setColor(this.getForeColor());
        g.setFont(this.getColoringFont());
        g.drawRect(x, y, width, height);
        g.drawString(this.foldDescription, x, y + this.getEditorUI().getLineAscent() - 1);
    }

    public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        biasRet[0] = Position.Bias.Forward;
        switch (direction) {
            case 1: 
            case 5: {
                Rectangle loc;
                JTextComponent target = (JTextComponent)this.getContainer();
                Caret c = target != null ? target.getCaret() : null;
                Point mcp = c != null ? c.getMagicCaretPosition() : null;
                int x = mcp == null ? ((loc = target.modelToView(pos)) == null ? 0 : loc.x) : mcp.x;
                if (direction == 1) {
                    pos = Utilities.getPositionAbove(target, pos, x);
                    break;
                }
                pos = Utilities.getPositionBelow(target, pos, x);
                break;
            }
            case 7: {
                if (pos == -1) {
                    pos = Math.max(0, this.getStartOffset());
                    break;
                }
                if (b == Position.Bias.Backward) {
                    pos = Math.max(0, this.getStartOffset());
                    break;
                }
                pos = Math.max(0, this.getStartOffset() - 1);
                break;
            }
            case 3: {
                if (pos == -1) {
                    pos = this.getStartOffset();
                    break;
                }
                pos = Math.min(this.getEndOffset(), this.getDocument().getLength());
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + direction);
            }
        }
        return pos;
    }

    private View getExpandedView() {
        Element parentElem = this.getElement().getParentElement();
        int sei = parentElem.getElementIndex(this.getStartOffset());
        int so = parentElem.getElement(sei).getStartOffset();
        int eei = parentElem.getElementIndex(this.getEndOffset());
        int eo = parentElem.getElement(eei).getEndOffset();
        LockView fakeView = new LockView(new DrawEngineFakeDocView(parentElem, so, eo, false));
        RootView rootView = new RootView();
        rootView.setView(fakeView);
        return fakeView;
    }

    public String getToolTipText(float x, float y, Shape allocation) {
        ToolTipSupport tts = ((ExtEditorUI)this.getEditorUI()).getToolTipSupport();
        FoldingToolTip toolTip = new FoldingToolTip(this.getExpandedView(), this.getEditorUI());
        tts.setToolTip(toolTip, PopupManager.ScrollBarBounds, PopupManager.Largest, -2, 0);
        return "";
    }

    public void settingsChange(SettingsChangeEvent evt) {
        if (evt == null || Utilities.getKitClass(this.getComponent()) != evt.getKitClass()) {
            return;
        }
        String defaultColoringName = "default-coloring";
        String foldingColoringName = "code-folding-coloring";
        EditorUI editorUI = this.getEditorUI();
        if (editorUI == null) {
            return;
        }
        Coloring foldingColoring = editorUI.getColoring("code-folding");
        Coloring defaultColoring = editorUI.getDefaultColoring();
        Font foldingFont = null;
        Color foldingForeColor = null;
        Color foldingBackColor = null;
        if (foldingColoring != null) {
            foldingFont = foldingColoring.getFont();
            foldingForeColor = foldingColoring.getForeColor();
            foldingBackColor = foldingColoring.getBackColor();
        }
        if (defaultColoringName.equals(evt.getSettingName())) {
            Font tempFont;
            Color tempColor;
            if (foldingForeColor == null && !(tempColor = this.getDefaultForeColor()).equals(this.foreColor)) {
                this.foreColor = tempColor;
            }
            if (foldingBackColor == null && !(tempColor = this.getDefaultBackColor()).equals(this.backColor)) {
                this.backColor = tempColor;
            }
            if (!(tempFont = this.getDefaultColoringFont()).equals(this.font) && foldingFont == null) {
                this.font = tempFont;
            }
        } else if (foldingColoringName.equals(evt.getSettingName())) {
            if (foldingColoring == null) {
                return;
            }
            Color tempColor = foldingColoring.getForeColor();
            this.foreColor = tempColor != null ? tempColor : this.getDefaultForeColor();
            tempColor = foldingColoring.getBackColor();
            Color color = this.backColor = tempColor != null ? tempColor : this.getDefaultBackColor();
            if (foldingFont == null) {
                Font tempFont = this.getDefaultColoringFont();
                if (!tempFont.equals(this.font)) {
                    this.font = tempFont;
                }
            } else if (!foldingFont.equals(this.font)) {
                this.font = foldingFont;
            }
        }
    }

    private Font getDefaultColoringFont() {
        Coloring defaultColoring;
        EditorUI editorUI = this.getEditorUI();
        if (editorUI != null && (defaultColoring = editorUI.getDefaultColoring()) != null && defaultColoring.getFont() != null) {
            return defaultColoring.getFont();
        }
        return SettingsDefaults.defaultFont;
    }

    protected Font getColoringFont() {
        Coloring foldColoring;
        if (this.font != null) {
            return this.font;
        }
        EditorUI editorUI = this.getEditorUI();
        if (editorUI != null && (foldColoring = editorUI.getColoring("code-folding")) != null && foldColoring.getFont() != null) {
            this.font = foldColoring.getFont();
            return this.font;
        }
        this.font = this.getDefaultColoringFont();
        return this.font;
    }

    protected Color getForeColor() {
        Coloring foldColoring;
        if (this.foreColor != null) {
            return this.foreColor;
        }
        EditorUI editorUI = this.getEditorUI();
        if (editorUI != null && (foldColoring = editorUI.getColoring("code-folding")) != null && foldColoring.getForeColor() != null) {
            this.foreColor = foldColoring.getForeColor();
            return this.foreColor;
        }
        this.foreColor = this.getDefaultForeColor();
        return this.foreColor;
    }

    private Color getDefaultForeColor() {
        Coloring defaultColoring;
        EditorUI editorUI = this.getEditorUI();
        if (editorUI != null && (defaultColoring = editorUI.getDefaultColoring()) != null && defaultColoring.getForeColor() != null) {
            return defaultColoring.getForeColor();
        }
        return SettingsDefaults.defaultForeColor;
    }

    private Color getDefaultBackColor() {
        Coloring defaultColoring;
        EditorUI editorUI = this.getEditorUI();
        if (editorUI != null && (defaultColoring = editorUI.getDefaultColoring()) != null) {
            return defaultColoring.getBackColor();
        }
        return SettingsDefaults.defaultBackColor;
    }

    protected Color getBackColor() {
        Coloring foldColoring;
        if (this.backColor != null) {
            return this.backColor;
        }
        EditorUI editorUI = this.getEditorUI();
        if (editorUI != null && (foldColoring = editorUI.getColoring("code-folding")) != null && foldColoring.getBackColor() != null) {
            this.backColor = foldColoring.getBackColor();
            return this.backColor;
        }
        this.backColor = this.getDefaultBackColor();
        return this.backColor;
    }

    class RootView
    extends View {
        private View view;

        RootView() {
            super(null);
        }

        void setView(View v) {
            if (this.view != null) {
                this.view.setParent(null);
            }
            this.view = v;
            if (this.view != null) {
                this.view.setParent(this);
            }
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public float getPreferredSpan(int axis) {
            if (this.view != null) {
                return this.view.getPreferredSpan(axis);
            }
            return 10.0f;
        }

        public float getMinimumSpan(int axis) {
            if (this.view != null) {
                return this.view.getMinimumSpan(axis);
            }
            return 10.0f;
        }

        public float getMaximumSpan(int axis) {
            return 2.1474836E9f;
        }

        public void preferenceChanged(View child, boolean width, boolean height) {
        }

        public float getAlignment(int axis) {
            if (this.view != null) {
                return this.view.getAlignment(axis);
            }
            return 0.0f;
        }

        public void paint(Graphics g, Shape allocation) {
            if (this.view != null) {
                Rectangle alloc = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
                this.setSize(alloc.width, alloc.height);
                this.view.paint(g, allocation);
            }
        }

        public void setParent(View parent) {
            throw new Error("Can't set parent on root view");
        }

        public int getViewCount() {
            return 1;
        }

        public View getView(int n) {
            return this.view;
        }

        public int getViewIndex(int pos, Position.Bias b) {
            return 0;
        }

        public Shape getChildAllocation(int index, Shape a) {
            return a;
        }

        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(pos, a, b);
            }
            return null;
        }

        public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(p0, b0, p1, b1, a);
            }
            return null;
        }

        public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
            if (this.view != null) {
                int retValue = this.view.viewToModel(x, y, a, bias);
                return retValue;
            }
            return -1;
        }

        public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
            if (this.view != null) {
                int nextPos = this.view.getNextVisualPositionFrom(pos, b, a, direction, biasRet);
                if (nextPos != -1) {
                    pos = nextPos;
                } else {
                    biasRet[0] = b;
                }
            }
            return pos;
        }

        public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.view != null) {
                this.view.insertUpdate(e, a, f);
            }
        }

        public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.view != null) {
                this.view.removeUpdate(e, a, f);
            }
        }

        public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.view != null) {
                this.view.changedUpdate(e, a, f);
            }
        }

        public Document getDocument() {
            EditorUI editorUI = CollapsedView.this.getEditorUI();
            return editorUI == null ? null : editorUI.getDocument();
        }

        public int getStartOffset() {
            if (this.view != null) {
                return this.view.getStartOffset();
            }
            return this.getElement().getStartOffset();
        }

        public int getEndOffset() {
            if (this.view != null) {
                return this.view.getEndOffset();
            }
            return this.getElement().getEndOffset();
        }

        public Element getElement() {
            if (this.view != null) {
                return this.view.getElement();
            }
            return this.view.getDocument().getDefaultRootElement();
        }

        public View breakView(int axis, float len, Shape a) {
            throw new Error("Can't break root view");
        }

        public int getResizeWeight(int axis) {
            if (this.view != null) {
                return this.view.getResizeWeight(axis);
            }
            return 0;
        }

        public void setSize(float width, float height) {
            if (this.view != null) {
                this.view.setSize(width, height);
            }
        }

        public Container getContainer() {
            EditorUI editorUI = CollapsedView.this.getEditorUI();
            return editorUI == null ? null : editorUI.getComponent();
        }

        public ViewFactory getViewFactory() {
            BaseKit kit;
            ViewFactory f;
            EditorUI editorUI = CollapsedView.this.getEditorUI();
            if (editorUI != null && (f = (kit = Utilities.getKit(editorUI.getComponent())).getViewFactory()) != null) {
                return f;
            }
            return CollapsedView.this.getBaseTextUI();
        }
    }
}

