/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.MacroSavePanel;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class MacroDialogSupport
implements ActionListener {
    JButton okButton;
    JButton cancelButton;
    MacroSavePanel panel;
    Dialog macroDialog;
    Class kitClass;

    public MacroDialogSupport(Class kitClass) {
        this.kitClass = kitClass;
        this.panel = new MacroSavePanel(kitClass);
        ResourceBundle bundle = NbBundle.getBundle(MacroDialogSupport.class);
        this.okButton = new JButton(bundle.getString("MDS_ok"));
        this.cancelButton = new JButton(bundle.getString("MDS_cancel"));
        this.okButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_MDS_ok"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_MDS_cancel"));
    }

    public void setBody(String body) {
        this.panel.setBody(body);
    }

    public void showMacroDialog() {
        this.macroDialog = DialogSupport.createDialog(NbBundle.getBundle(MacroDialogSupport.class).getString("MDS_title"), this.panel, true, new JButton[]{this.okButton, this.cancelButton}, false, 0, 1, this);
        this.macroDialog.pack();
        this.panel.popupNotify();
        this.macroDialog.requestFocus();
        this.macroDialog.show();
    }

    private List getKBList() {
        Settings.KitAndValue[] kav = Settings.getValueHierarchy(this.kitClass, "key-bindings");
        List<MultiKeyBinding> kbList = null;
        for (int i = 0; i < kav.length; ++i) {
            if (kav[i].kitClass != this.kitClass) continue;
            kbList = (List)kav[i].value;
        }
        if (kbList == null) {
            kbList = new ArrayList();
        }
        int cnt = kbList.size();
        for (int i = 0; i < cnt; ++i) {
            Object o = kbList.get(i);
            if (o instanceof MultiKeyBinding || o == null) continue;
            JTextComponent.KeyBinding b = (JTextComponent.KeyBinding)o;
            kbList.set(i, new MultiKeyBinding(b.key, b.actionName));
        }
        return new ArrayList(kbList);
    }

    private void saveMacro(boolean overwriting) {
        MultiKeyBinding multiKey;
        Map macroMap = (Map)Settings.getValue(this.kitClass, "macro-map");
        HashMap<String, String> newMap = new HashMap<String, String>(macroMap);
        newMap.put(this.panel.getName(), this.panel.getBody());
        Settings.setValue(this.kitClass, "macro-map", newMap);
        List listBindings = this.panel.getKeySequences();
        List keybindings = this.getKBList();
        if (overwriting) {
            int i;
            ArrayList<MultiKeyBinding> removed = new ArrayList<MultiKeyBinding>();
            String macroName = "macro-" + this.panel.getName();
            for (i = 0; i < keybindings.size(); ++i) {
                multiKey = (MultiKeyBinding)keybindings.get(i);
                if (multiKey.actionName == null || !multiKey.actionName.equals(macroName)) continue;
                removed.add(multiKey);
            }
            for (i = 0; i < removed.size(); ++i) {
                keybindings.remove(removed.get(i));
            }
        }
        if (listBindings.size() > 0) {
            String actionName = new String("macro-" + this.panel.getName());
            for (int i = 0; i < listBindings.size(); ++i) {
                KeyStroke[] keyStrokes = (KeyStroke[])listBindings.get(i);
                multiKey = new MultiKeyBinding(keyStrokes, actionName);
                keybindings.add(multiKey);
            }
        }
        Settings.setValue(this.kitClass, "key-bindings", keybindings);
    }

    protected int showConfirmDialog(String macroName) {
        return JOptionPane.showConfirmDialog(this.panel, MessageFormat.format(NbBundle.getBundle(MacroDialogSupport.class).getString("MDS_Overwrite"), this.panel.getName()), NbBundle.getBundle(MacroDialogSupport.class).getString("MDS_Warning"), 1, 2);
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.okButton) {
            if (this.panel.getName() == null || this.panel.getName().length() == 0 || this.panel.getName().trim().length() == 0) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getBundle(MacroDialogSupport.class).getString("MDS_Empty_Name"), 0));
                this.panel.nameField.requestFocusInWindow();
                return;
            }
            Map macroMap = (Map)Settings.getValue(this.kitClass, "macro-map");
            if (!macroMap.containsKey(this.panel.getName())) {
                this.saveMacro(false);
            } else {
                int retVal = this.showConfirmDialog(this.panel.getName());
                if (retVal == 2 || retVal == -1) {
                    return;
                }
                if (retVal == 0) {
                    this.saveMacro(true);
                }
            }
        }
        this.macroDialog.setVisible(false);
        this.macroDialog.dispose();
    }
}

