/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.Comparator;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.MultiMark;

public class Mark {
    private static final MarkComparator MARK_COMPARATOR = new MarkComparator();
    private BaseDocument doc;
    private MultiMark multiMark;
    private Position.Bias bias;

    public Mark() {
        this(Position.Bias.Forward);
    }

    public Mark(Position.Bias bias) {
        this.bias = bias;
    }

    public Mark(boolean backwardBias) {
        this(backwardBias ? Position.Bias.Backward : Position.Bias.Forward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insert(BaseDocument doc, int offset) throws InvalidMarkException, BadLocationException {
        Map docMarks;
        BaseDocument ldoc = this.doc;
        if (ldoc != null) {
            throw new InvalidMarkException("Mark already inserted: mark=" + this + ", class=" + this.getClass());
        }
        ldoc = this.doc = doc;
        Map map = docMarks = ldoc.marks;
        synchronized (map) {
            if (this.multiMark != null) {
                throw new IllegalStateException("Mark already inserted: mark=" + this + ", class=" + this.getClass());
            }
            if (offset < 0 || offset > ldoc.getLength() + 1) {
                throw new BadLocationException("Invalid offset", offset);
            }
            this.multiMark = doc.marksStorage.createBiasMark(offset, this.bias);
            doc.marksStorage.insert(this.multiMark);
            docMarks.put(this.multiMark, this);
        }
    }

    private void checkMarks(Map docMarks) {
        for (Map.Entry me : docMarks.entrySet()) {
            MultiMark mm = (MultiMark)me.getKey();
            Mark m = (Mark)me.getValue();
            if (m.multiMark == mm) continue;
            throw new IllegalStateException("m.class" + m.getClass() + " mapped to wrong mark=" + mm);
        }
    }

    void move(BaseDocument doc, int newOffset) throws InvalidMarkException, BadLocationException {
        this.dispose();
        this.insert(doc, newOffset);
    }

    public final int getOffset() throws InvalidMarkException {
        BaseDocument ldoc = this.doc;
        if (ldoc != null) {
            Map docMarks;
            Map map = docMarks = ldoc.marks;
            synchronized (map) {
                if (this.multiMark != null) {
                    return this.multiMark.getOffset();
                }
                throw new InvalidMarkException();
            }
        }
        throw new InvalidMarkException();
    }

    public final int getLine() throws InvalidMarkException {
        BaseDocument ldoc = this.doc;
        if (ldoc != null) {
            Map docMarks;
            Map map = docMarks = ldoc.marks;
            synchronized (map) {
                if (this.multiMark != null) {
                    int offset = this.multiMark.getOffset();
                    Element lineRoot = ldoc.getParagraphElement(0).getParentElement();
                    return lineRoot.getElementIndex(offset);
                }
                throw new InvalidMarkException();
            }
        }
        throw new InvalidMarkException();
    }

    public final boolean getInsertAfter() {
        return this.bias == Position.Bias.Backward;
    }

    public final boolean getBackwardBias() {
        return this.getInsertAfter();
    }

    public final Position.Bias getBias() {
        return this.bias;
    }

    int getBiasAsInt() {
        return this.bias == Position.Bias.Backward ? -1 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        BaseDocument ldoc = this.doc;
        if (ldoc != null) {
            Map docMarks;
            Map map = docMarks = ldoc.marks;
            synchronized (map) {
                if (this.multiMark != null) {
                    if (docMarks.remove(this.multiMark) != this) {
                        throw new IllegalStateException("Mark cannot be disposed mark=" + this + ", class=" + this.getClass());
                    }
                    this.multiMark.dispose();
                    this.multiMark = null;
                    this.doc = null;
                    return;
                }
            }
        }
        throw new IllegalStateException("Mark already disposed: mark=" + this + ", class=" + this.getClass());
    }

    public final void remove() throws InvalidMarkException {
        this.dispose();
    }

    public final int compare(int pos) throws InvalidMarkException {
        return this.getOffset() - pos;
    }

    protected void removeUpdateAction(int pos, int len) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isValid() {
        BaseDocument ldoc = this.doc;
        if (ldoc != null) {
            Map docMarks;
            Map map = docMarks = ldoc.marks;
            synchronized (map) {
                return this.multiMark != null && this.multiMark.isValid();
            }
        }
        return false;
    }

    public String toString() {
        return "offset=" + (this.isValid() ? Integer.toString(this.multiMark.getOffset()) : "<invalid>") + ", bias=" + this.bias;
    }

    private static final class MarkComparator
    implements Comparator {
        private MarkComparator() {
        }

        public int compare(Object o1, Object o2) {
            Mark m1 = (Mark)o1;
            Mark m2 = (Mark)o2;
            try {
                int offDiff = m1.getOffset() - m2.getOffset();
                if (offDiff != 0) {
                    return offDiff;
                }
                return m1.getBiasAsInt() - m2.getBiasAsInt();
            }
            catch (InvalidMarkException e) {
                throw new IllegalStateException(e.toString());
            }
        }
    }
}

