/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.HTMLJavaDocView;
import org.netbeans.editor.ext.JDCPopupPanel;
import org.netbeans.editor.ext.JavaDocPane;
import org.netbeans.editor.ext.JavaDocView;
import org.netbeans.editor.ext.ScrollJavaDocPane;
import org.openide.util.NbBundle;

public abstract class CompletionJavaDoc
implements ActionListener,
SettingsChangeListener,
PropertyChangeListener {
    protected ExtEditorUI extEditorUI;
    private List history = new ArrayList(5);
    private int curHistoryItem = -1;
    private JavaDocPane pane;
    private JavaDocView view;
    private int javaDocDelay;
    private Timer timer;
    protected Object currentContent;
    protected boolean addToHistory;
    private ListSelectionListener completionListener;
    private boolean javaDocAutoPopup;
    private CaretListener caretL;
    public static final String BUNDLE_PREFIX = "javadoc-tag-";
    public static final String LOADING = "javadoc-loading";
    private static final int POPUP_DELAY = 200;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionJavaDoc(ExtEditorUI extEditorUI) {
        this.extEditorUI = extEditorUI;
        if (extEditorUI == null) {
            return;
        }
        this.timer = new Timer(0, new WeakTimerListener(this));
        this.timer.setRepeats(false);
        Settings.addSettingsChangeListener(this);
        this.javaDocDelay = this.getJavaDocDelay();
        this.javaDocAutoPopup = this.getJavaDocAutoPopup();
        final ExtEditorUI extUI = extEditorUI;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyCaretListener
        implements CaretListener {
            MyCaretListener() {
            }

            @Override
            public void caretUpdate(CaretEvent e) {
                Completion com = extUI.getCompletion();
                if (com == null) {
                    return;
                }
                JDCPopupPanel panel = com.getJDCPopupPanelIfExists();
                if (panel == null) {
                    return;
                }
                if (panel.isVisible() && !com.isPaneVisible()) {
                    CompletionJavaDoc.this.setJavaDocVisible(false);
                }
            }
        }
        this.caretL = new MyCaretListener();
        Object object = extEditorUI.getComponentLock();
        synchronized (object) {
            JTextComponent component = extEditorUI.getComponent();
            if (component != null) {
                this.propertyChange(new PropertyChangeEvent(extEditorUI, "component", null, component));
            }
            extEditorUI.addPropertyChangeListener(this);
        }
    }

    protected Object convertCompletionObject(Object obj) {
        return obj;
    }

    protected boolean alwaysDisplayPopup() {
        return true;
    }

    protected Comparator getContentComparator() {
        return null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        final ExtEditorUI extUI = this.extEditorUI;
        if ("component".equals(propName)) {
            JTextComponent component = (JTextComponent)evt.getNewValue();
            if (component != null) {
                component.addCaretListener(this.caretL);
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class SelectionObserver
                implements ListSelectionListener {
                    SelectionObserver() {
                    }

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        /*
                         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                         */
                        class ClearTask
                        implements Runnable {
                            final /* synthetic */ ExtEditorUI val$extUI;
                            final /* synthetic */ CompletionJavaDoc this$0;

                            ClearTask() {
                                this.this$0 = completionJavaDoc;
                                this.val$extUI = extEditorUI;
                            }

                            public void run() {
                                Completion com = this.val$extUI.getCompletion();
                                if (com != null && com.isPaneVisible()) {
                                    Object selectedCompletionObject = com.getSelectedValue();
                                    CompletionJavaDoc completionJavaDoc = this.val$extUI.getCompletionJavaDoc();
                                    if (selectedCompletionObject == null) {
                                        if (completionJavaDoc != null && this.this$0.isVisible()) {
                                            completionJavaDoc.setContent(null);
                                        }
                                        return;
                                    }
                                    Object selectedValue = this.this$0.convertCompletionObject(selectedCompletionObject);
                                    if (!this.this$0.alwaysDisplayPopup()) {
                                        this.this$0.setJavaDocVisible(false);
                                    }
                                    if (completionJavaDoc != null) {
                                        if (completionJavaDoc.autoPopup()) {
                                            Comparator comparator = this.this$0.getContentComparator();
                                            if (this.this$0.currentContent != null && !"javadoc-loading".equals(this.this$0.currentContent) && (comparator != null ? comparator.compare(this.this$0.currentContent, selectedValue) == 0 : this.this$0.currentContent.equals(selectedValue))) {
                                                if (!this.this$0.isVisible() && this.this$0.alwaysDisplayPopup()) {
                                                    this.this$0.setJavaDocVisible(true);
                                                }
                                                return;
                                            }
                                            if (!"javadoc-loading".equals(this.this$0.currentContent) && this.this$0.alwaysDisplayPopup()) {
                                                completionJavaDoc.setContent(NbBundle.getBundle(BaseKit.class).getString("javadoc-loading"));
                                            }
                                            this.this$0.clearHistory();
                                            completionJavaDoc.setContent(selectedValue);
                                            this.this$0.addToHistory(selectedValue);
                                        } else if (this.this$0.isVisible()) {
                                            completionJavaDoc.setContent(null);
                                        }
                                    }
                                }
                            }
                        }
                        SwingUtilities.invokeLater(new ClearTask(CompletionJavaDoc.this, extUI));
                    }
                }
                this.completionListener = new SelectionObserver();
                Completion completion = this.extEditorUI.getCompletion();
                if (completion != null && completion.getView() instanceof JList) {
                    JList completionList = (JList)((Object)completion.getView());
                    completionList.addListSelectionListener(this.completionListener);
                }
            } else {
                Completion completion;
                this.cancelPerformingThread();
                component = (JTextComponent)evt.getOldValue();
                if (component != null) {
                    component.removeCaretListener(this.caretL);
                }
                if ((completion = this.extEditorUI.getCompletion()) != null && completion.getView() instanceof JList) {
                    JList completionList = (JList)((Object)completion.getView());
                    completionList.removeListSelectionListener(this.completionListener);
                }
            }
        }
    }

    private JDCPopupPanel getJDCPopupPanel() {
        Completion completion = this.extEditorUI.getCompletion();
        if (completion != null) {
            return completion.getJDCPopupPanelIfExists();
        }
        return null;
    }

    public JavaDocPane getJavaDocPane() {
        Completion completion = this.extEditorUI.getCompletion();
        if (completion != null) {
            return completion.getJDCPopupPanel().getJavaDocPane();
        }
        if (this.pane == null) {
            this.pane = new ScrollJavaDocPane(this.extEditorUI);
        }
        return this.pane;
    }

    public JavaDocView getJavaDocView() {
        if (this.view == null) {
            this.view = new HTMLJavaDocView(this.getJavaDocBGColor());
        }
        return this.view;
    }

    public void setJavaDocVisible(final boolean visible) {
        final JDCPopupPanel jdc = this.getJDCPopupPanel();
        if (jdc != null) {
            if (visible) {
                this.getJavaDocPane().setShowWebEnabled(this.isExternalJavaDocMounted());
            }
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jdc.setJavaDocVisible(visible);
                    }
                });
            } else {
                jdc.setJavaDocVisible(visible);
            }
        }
    }

    public synchronized void addToHistory(Object url) {
        int histSize = this.history.size();
        for (int i = this.curHistoryItem + 1; i < histSize; ++i) {
            this.history.remove(this.history.size() - 1);
        }
        this.history.add(url);
        this.curHistoryItem = this.history.size() - 1;
        if (this.curHistoryItem > 0) {
            this.getJavaDocPane().setBackEnabled(true);
        }
        this.getJavaDocPane().setForwardEnabled(false);
    }

    public synchronized void backHistory() {
        if (this.curHistoryItem > 0) {
            --this.curHistoryItem;
            this.setContent(this.history.get(this.curHistoryItem), false, false);
            if (this.curHistoryItem == 0) {
                this.getJavaDocPane().setBackEnabled(false);
            }
            this.getJavaDocPane().setForwardEnabled(true);
        }
    }

    public synchronized void forwardHistory() {
        if (this.curHistoryItem < this.history.size() - 1) {
            ++this.curHistoryItem;
            this.setContent(this.history.get(this.curHistoryItem), false, false);
            if (this.curHistoryItem == this.history.size() - 1) {
                this.getJavaDocPane().setForwardEnabled(false);
            }
            this.getJavaDocPane().setBackEnabled(true);
        }
    }

    public synchronized void clearHistory() {
        this.curHistoryItem = -1;
        this.history.clear();
        this.getJavaDocPane().setBackEnabled(false);
        this.getJavaDocPane().setForwardEnabled(false);
    }

    public boolean isVisible() {
        return this.getJavaDocPane().getComponent().isVisible();
    }

    public void cancelPerformingThread() {
        this.timer.stop();
    }

    protected Object getCurrentContent() {
        if (this.currentContent instanceof CompletionQuery.ResultItemAssociatedObject) {
            return ((CompletionQuery.ResultItemAssociatedObject)this.currentContent).getAssociatedObject();
        }
        return this.currentContent;
    }

    synchronized void clearContent() {
        this.cancelPerformingThread();
        this.currentContent = null;
    }

    public synchronized void setContent(Object content, boolean postRequest, boolean addToHistory) {
        this.timer.stop();
        if (content == null) {
            this.currentContent = null;
            this.setJavaDocVisible(false);
            return;
        }
        this.currentContent = content;
        this.addToHistory = addToHistory;
        if (postRequest) {
            this.timer.setInitialDelay(200);
            this.timer.setDelay(200);
            this.timer.start();
        } else {
            this.actionPerformed(null);
        }
    }

    public synchronized void setContent(Object content, boolean postRequest) {
        this.setContent(content, postRequest, true);
    }

    public void setContent(Object content) {
        this.setContent(content, true);
    }

    public void setContent(String content) {
        if (content == null) {
            this.setJavaDocVisible(false);
            return;
        }
        this.getJavaDocView().setContent(content);
    }

    public synchronized void actionPerformed(ActionEvent e) {
    }

    private Color getJavaDocBGColor() {
        Class kitClass = Utilities.getKitClass(this.extEditorUI.getComponent());
        if (kitClass != null) {
            return (Color)SettingsUtil.getValue(kitClass, "javadoc-bg-color", ExtSettingsDefaults.defaultJavaDocBGColor);
        }
        return ExtSettingsDefaults.defaultJavaDocBGColor;
    }

    private int getJavaDocDelay() {
        Class kitClass = Utilities.getKitClass(this.extEditorUI.getComponent());
        if (kitClass != null) {
            return (Integer)SettingsUtil.getValue(kitClass, "javadoc-auto-popup-delay", ExtSettingsDefaults.defaultJavaDocAutoPopupDelay);
        }
        return ExtSettingsDefaults.defaultJavaDocAutoPopupDelay;
    }

    private boolean getJavaDocAutoPopup() {
        Class kitClass = Utilities.getKitClass(this.extEditorUI.getComponent());
        if (kitClass != null) {
            return (Boolean)SettingsUtil.getValue(kitClass, "javadoc-auto-popup", ExtSettingsDefaults.defaultJavaDocAutoPopup);
        }
        return ExtSettingsDefaults.defaultJavaDocAutoPopup;
    }

    public boolean autoPopup() {
        return this.javaDocAutoPopup;
    }

    public void settingsChange(SettingsChangeEvent evt) {
        if ("javadoc-bg-color".equals(evt.getSettingName())) {
            this.getJavaDocView().setBGColor(this.getJavaDocBGColor());
        }
        if ("javadoc-auto-popup-delay".equals(evt.getSettingName())) {
            this.javaDocDelay = this.getJavaDocDelay();
        }
        if ("javadoc-auto-popup".equals(evt.getSettingName())) {
            this.javaDocAutoPopup = this.getJavaDocAutoPopup();
        }
    }

    public Object parseLink(String link, Object baseObj) {
        return null;
    }

    protected String getTagName(JavaDocTagItem tag) {
        try {
            return NbBundle.getBundle(BaseKit.class).getString(BUNDLE_PREFIX + tag.getName());
        }
        catch (MissingResourceException e) {
            return tag.getName();
        }
    }

    public void goToSource() {
    }

    public void openInExternalBrowser() {
    }

    public boolean isExternalJavaDocMounted() {
        return false;
    }

    public static interface JavaDocTagItem
    extends Comparable {
        public String getName();

        public String getText();
    }
}

