/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.MarkFactory;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingManager;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingSpiPackageAccessor;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsLayerAccessor;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsLayerFilter;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighlightingDrawLayer
extends DrawLayer.AbstractLayer
implements HighlightsChangeListener {
    private static final Logger LOG = Logger.getLogger(HighlightingDrawLayer.class.getName());
    private static final String LAYER_A_NAME = "org-netbeans-lib-editor-nview-HighlightingDrawLayer/A";
    private static final String LAYER_B_NAME = "highlight-row-layer";
    private static final String LAYER_C_NAME = "org-netbeans-lib-editor-nview-HighlightingDrawLayer/C";
    private static final HighlightsLayerFilter FILTER_A = new HighlightsLayerFilter(){

        public List<? extends HighlightsLayer> filterLayers(List<? extends HighlightsLayer> layers) {
            ArrayList<HighlightsLayer> filteredLayers = new ArrayList<HighlightsLayer>();
            boolean add = false;
            for (HighlightsLayer highlightsLayer : layers) {
                HighlightsLayerAccessor layerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                if ("org.netbeans.modules.editor.lib2.highlighting.CaretRowHighlighting".equals(layerAccessor.getLayerTypeId())) {
                    add = true;
                    continue;
                }
                if (!add) continue;
                filteredLayers.add(highlightsLayer);
            }
            return filteredLayers;
        }
    };
    private static final HighlightsLayerFilter FILTER_B = new HighlightsLayerFilter(){

        public List<? extends HighlightsLayer> filterLayers(List<? extends HighlightsLayer> layers) {
            ArrayList<HighlightsLayer> filteredLayers = new ArrayList<HighlightsLayer>();
            for (HighlightsLayer highlightsLayer : layers) {
                HighlightsLayerAccessor layerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                if (!"org.netbeans.modules.editor.lib2.highlighting.CaretRowHighlighting".equals(layerAccessor.getLayerTypeId())) continue;
                filteredLayers.add(highlightsLayer);
                break;
            }
            return filteredLayers;
        }
    };
    private static final HighlightsLayerFilter FILTER_C = new HighlightsLayerFilter(){

        public List<? extends HighlightsLayer> filterLayers(List<? extends HighlightsLayer> layers) {
            ArrayList<HighlightsLayer> filteredLayers = new ArrayList<HighlightsLayer>();
            for (HighlightsLayer highlightsLayer : layers) {
                HighlightsLayerAccessor layerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                if ("org.netbeans.modules.editor.lib2.highlighting.CaretRowHighlighting".equals(layerAccessor.getLayerTypeId())) break;
                filteredLayers.add(highlightsLayer);
            }
            return filteredLayers;
        }
    };
    private final HighlightsLayerFilter filter;
    private WeakReference<JTextComponent> paneRef = null;
    private HighlightsContainer highlights = null;
    private AttributeSet lastAttributeSet = null;
    private AttributeSet lastEOLAttribs = null;
    private AttributeSet lastELAttribs = null;
    private boolean theLittleSpitAtTheBeginningOfAnEmptyLineDrawn = false;

    public static void hookUp(EditorUI eui) {
        DrawLayer layerC;
        DrawLayer layerB;
        DrawLayer layerA = eui.findLayer(LAYER_A_NAME);
        if (layerA == null) {
            layerA = new HighlightingDrawLayer(LAYER_A_NAME, FILTER_A);
            eui.addLayer(layerA, 10000);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Successfully registered layerA in " + HighlightingDrawLayer.simpleToString(eui));
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("LayerA is already registered in " + HighlightingDrawLayer.simpleToString(eui));
        }
        if ((layerB = eui.findLayer(LAYER_B_NAME)) == null) {
            layerB = new HighlightingDrawLayer(LAYER_B_NAME, FILTER_B);
            eui.addLayer(layerB, 2050);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Successfully registered layerB in " + HighlightingDrawLayer.simpleToString(eui));
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("LayerB is already registered in " + HighlightingDrawLayer.simpleToString(eui));
        }
        if ((layerC = eui.findLayer(LAYER_C_NAME)) == null) {
            layerC = new HighlightingDrawLayer(LAYER_C_NAME, FILTER_C);
            eui.addLayer(layerC, 1000);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Successfully registered layerC in " + HighlightingDrawLayer.simpleToString(eui));
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("LayerC is already registered in " + HighlightingDrawLayer.simpleToString(eui));
        }
    }

    private HighlightingDrawLayer(String name, HighlightsLayerFilter filter) {
        super(name);
        this.filter = filter;
    }

    @Override
    public void init(DrawContext ctx) {
        super.init(ctx);
        if (this.highlights == null) {
            JTextComponent pane = ctx.getEditorUI().getComponent();
            if (pane == null) {
                BaseDocument doc = ctx.getEditorUI().getDocument();
                String mimeType = (String)doc.getProperty("mimeType");
                assert (mimeType != null) : "Document's mime type can't be null: " + doc;
                JEditorPane fakePane = new JEditorPane();
                fakePane.setDocument(doc);
                fakePane.putClientProperty("HighlightsLayerIncludes", new String[]{"^.*NonLexerSyntaxHighlighting$", "^.*SyntaxHighlighting$"});
                pane = fakePane;
            }
            this.paneRef = new WeakReference<JTextComponent>(pane);
            HighlightingManager hm = HighlightingManager.getInstance();
            this.highlights = hm.getHighlights(pane, this.filter);
            this.highlights.addHighlightsChangeListener((HighlightsChangeListener)this);
        }
        this.lastAttributeSet = null;
        this.lastEOLAttribs = null;
        this.lastELAttribs = null;
        this.theLittleSpitAtTheBeginningOfAnEmptyLineDrawn = false;
    }

    @Override
    public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
        if (this.highlights != null) {
            return this.processOffset(ctx, false);
        }
        return false;
    }

    @Override
    public void updateContext(DrawContext ctx) {
        if (this.highlights != null) {
            if (ctx.isEOL() && ctx.isBOL()) {
                if (this.extendsEmptyLine() && !this.theLittleSpitAtTheBeginningOfAnEmptyLineDrawn) {
                    this.theLittleSpitAtTheBeginningOfAnEmptyLineDrawn = true;
                    Coloring coloring = Coloring.fromAttributeSet(this.lastELAttribs);
                    coloring.apply(ctx);
                } else if (this.extendsEOL()) {
                    Coloring coloring = Coloring.fromAttributeSet(this.lastEOLAttribs);
                    coloring.apply(ctx);
                }
            } else if (ctx.isEOL()) {
                if (this.extendsEOL()) {
                    Coloring coloring = Coloring.fromAttributeSet(this.lastEOLAttribs);
                    coloring.apply(ctx);
                }
            } else {
                this.processOffset(ctx, true);
            }
        }
    }

    @Override
    public boolean extendsEOL() {
        if (this.lastEOLAttribs == null && this.lastAttributeSet != null) {
            List<AttributeSet> allSets = (List<AttributeSet>)this.lastAttributeSet.getAttribute("dismantled-structure");
            AttributeSet[] arr = this.filter(allSets != null ? allSets : Collections.singletonList(this.lastAttributeSet));
            this.lastEOLAttribs = arr[0];
            this.lastELAttribs = arr[1];
        }
        return this.lastEOLAttribs != null && this.lastEOLAttribs != SimpleAttributeSet.EMPTY;
    }

    @Override
    public boolean extendsEmptyLine() {
        if (this.lastELAttribs == null && this.lastAttributeSet != null) {
            List<AttributeSet> allSets = (List<AttributeSet>)this.lastAttributeSet.getAttribute("dismantled-structure");
            AttributeSet[] arr = this.filter(allSets != null ? allSets : Collections.singletonList(this.lastAttributeSet));
            this.lastEOLAttribs = arr[0];
            this.lastELAttribs = arr[1];
        }
        return this.lastELAttribs != null && this.lastELAttribs != SimpleAttributeSet.EMPTY;
    }

    public void highlightChanged(HighlightsChangeEvent event) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("BRIDGE-LAYER: changed area [" + event.getStartOffset() + ", " + event.getEndOffset() + "]");
        }
        this.setNextActivityChangeOffset(0);
        JTextComponent pane = (JTextComponent)this.paneRef.get();
        if (pane != null) {
            int rangeStart;
            int rangeEnd = Math.min(event.getEndOffset(), pane.getDocument().getLength());
            int n = rangeStart = event.getStartOffset() >= rangeEnd ? 0 : event.getStartOffset();
            if (rangeStart < rangeEnd) {
                try {
                    pane.getUI().damageRange(pane, rangeStart, rangeEnd);
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "Can't update view: range = [" + rangeStart + ", " + rangeEnd + "]", e);
                }
            }
        }
    }

    private boolean processOffset(DrawContext ctx, boolean applyAttributes) {
        HighlightsSequence hs;
        boolean hasHighlight;
        int currentOffset;
        BaseDocument doc = ctx.getEditorUI().getDocument();
        int endOffset = doc.getParagraphElement(currentOffset = ctx.getFragmentOffset()).getEndOffset();
        if (endOffset >= doc.getLength()) {
            endOffset = Integer.MAX_VALUE;
        }
        if (hasHighlight = (hs = this.highlights.getHighlights(currentOffset, endOffset)).moveNext()) {
            if (hs.getStartOffset() <= currentOffset) {
                if (applyAttributes) {
                    Coloring coloring = Coloring.fromAttributeSet(hs.getAttributes());
                    coloring.apply(ctx);
                }
                this.lastAttributeSet = hs.getAttributes();
                this.setNextActivityChangeOffset(hs.getEndOffset());
            } else {
                this.setNextActivityChangeOffset(hs.getStartOffset());
            }
            return true;
        }
        return false;
    }

    private AttributeSet[] filter(List<AttributeSet> sets) {
        ArrayList<AttributeSet> eolSets = new ArrayList<AttributeSet>();
        ArrayList<AttributeSet> elSets = new ArrayList<AttributeSet>();
        for (AttributeSet set : sets) {
            Object value = set.getAttribute(HighlightsContainer.ATTR_EXTENDS_EOL);
            if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                eolSets.add(set);
            }
            if (!((value = set.getAttribute(HighlightsContainer.ATTR_EXTENDS_EMPTY_LINE)) instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            elSets.add(set);
        }
        AttributeSet eolAttribs = eolSets.size() > 1 ? AttributesUtilities.createComposite((AttributeSet[])eolSets.toArray(new AttributeSet[eolSets.size()])) : (eolSets.size() == 1 ? (AttributeSet)eolSets.get(0) : SimpleAttributeSet.EMPTY);
        AttributeSet elAttribs = elSets.size() > 1 ? AttributesUtilities.createComposite((AttributeSet[])elSets.toArray(new AttributeSet[elSets.size()])) : (elSets.size() == 1 ? (AttributeSet)elSets.get(0) : SimpleAttributeSet.EMPTY);
        return new AttributeSet[]{eolAttribs, elAttribs};
    }

    private static String simpleToString(Object o) {
        return o == null ? "null" : o.getClass() + "@" + Integer.toHexString(System.identityHashCode(o));
    }
}

