/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.project.uiapi.ActionsFactory;
import org.netbeans.modules.project.uiapi.CategoryChangeSupport;
import org.netbeans.modules.project.uiapi.OpenProjectsTrampoline;
import org.netbeans.modules.project.uiapi.ProjectChooserFactory;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;

public class Utilities {
    private static final Map<ProjectCustomizer.Category, CategoryChangeSupport> CATEGORIES = new HashMap<ProjectCustomizer.Category, CategoryChangeSupport>();

    private Utilities() {
    }

    public static ActionsFactory getActionsFactory() {
        ActionsFactory instance = (ActionsFactory)Lookup.getDefault().lookup(ActionsFactory.class);
        assert (instance != null) : "Need to have " + ActionsFactory.class.getName() + " instance in the default lookup";
        return instance;
    }

    public static ProjectChooserFactory getProjectChooserFactory() {
        ProjectChooserFactory instance = (ProjectChooserFactory)Lookup.getDefault().lookup(ProjectChooserFactory.class);
        assert (instance != null) : "Need to have " + ProjectChooserFactory.class.getName() + " instance in the default lookup";
        return instance;
    }

    public static OpenProjectsTrampoline getOpenProjectsTrampoline() {
        OpenProjectsTrampoline instance = (OpenProjectsTrampoline)Lookup.getDefault().lookup(OpenProjectsTrampoline.class);
        assert (instance != null) : "Need to have " + OpenProjectsTrampoline.class.getName() + " instance in the default lookup";
        return instance;
    }

    public static CategoryChangeSupport getCategoryChangeSupport(ProjectCustomizer.Category category) {
        CategoryChangeSupport cw = CATEGORIES.get(category);
        return cw == null ? CategoryChangeSupport.NULL_INSTANCE : cw;
    }

    public static void putCategoryChangeSupport(ProjectCustomizer.Category category, CategoryChangeSupport wrapper) {
        CATEGORIES.put(category, wrapper);
    }

    public static void removeCategoryChangeSupport(ProjectCustomizer.Category category) {
        CATEGORIES.remove(category);
    }
}

