/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.ui.support;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.netbeans.spi.project.LookupMerger;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.util.Lookup;

public final class UILookupMergerSupport {
    private UILookupMergerSupport() {
    }

    public static LookupMerger createRecommendedTemplatesMerger() {
        return new RecommendedMerger();
    }

    public static LookupMerger createPrivilegedTemplatesMerger() {
        return new PrivilegedMerger();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrivilegedMerger
    implements LookupMerger<PrivilegedTemplates> {
        private PrivilegedMerger() {
        }

        public Class<PrivilegedTemplates> getMergeableClass() {
            return PrivilegedTemplates.class;
        }

        public PrivilegedTemplates merge(Lookup lookup) {
            return new PrivilegedTemplatesImpl(lookup);
        }
    }

    private static class PrivilegedTemplatesImpl
    implements PrivilegedTemplates {
        private Lookup lkp;

        public PrivilegedTemplatesImpl(Lookup lkp) {
            this.lkp = lkp;
        }

        public String[] getPrivilegedTemplates() {
            LinkedHashSet<String> templates = new LinkedHashSet<String>();
            for (PrivilegedTemplates pt : this.lkp.lookupAll(PrivilegedTemplates.class)) {
                templates.addAll(Arrays.asList(pt.getPrivilegedTemplates()));
            }
            return templates.toArray(new String[templates.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecommendedMerger
    implements LookupMerger<RecommendedTemplates> {
        private RecommendedMerger() {
        }

        public Class<RecommendedTemplates> getMergeableClass() {
            return RecommendedTemplates.class;
        }

        public RecommendedTemplates merge(Lookup lookup) {
            return new RecommendedTemplatesImpl(lookup);
        }
    }

    private static class RecommendedTemplatesImpl
    implements RecommendedTemplates {
        private Lookup lkp;

        public RecommendedTemplatesImpl(Lookup lkp) {
            this.lkp = lkp;
        }

        public String[] getRecommendedTypes() {
            LinkedHashSet<String> templates = new LinkedHashSet<String>();
            for (RecommendedTemplates pt : this.lkp.lookupAll(RecommendedTemplates.class)) {
                templates.addAll(Arrays.asList(pt.getRecommendedTypes()));
            }
            return templates.toArray(new String[templates.size()]);
        }
    }
}

