/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.bookmarks.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.netbeans.lib.editor.bookmarks.BookmarksApiPackageAccessor;
import org.netbeans.lib.editor.bookmarks.BookmarksSpiPackageAccessor;
import org.netbeans.lib.editor.bookmarks.api.Bookmark;
import org.netbeans.lib.editor.bookmarks.spi.BookmarkImplementation;
import org.netbeans.lib.editor.bookmarks.spi.BookmarkManager;
import org.netbeans.lib.editor.bookmarks.spi.BookmarkManagerFactory;
import org.netbeans.lib.editor.bookmarks.spi.BookmarkManagerSupport;
import org.netbeans.modules.editor.bookmarks.PersistentBookmarks;
import org.openide.util.Lookup;

public final class BookmarkList {
    private static BookmarkManagerFactory bookmarkManagerFactory;
    private static final String PROP_BOOKMARKS = "bookmarks";
    private Document doc;
    private BookmarkManager manager;
    private BookmarkManagerSupport managerSupport;
    private List bookmarks;
    private final PropertyChangeSupport PCS = new PropertyChangeSupport(this);
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BookmarkList get(Document doc) {
        Class clazz = PersistentBookmarks.class;
        synchronized (clazz) {
            BookmarkList bookmarkList = (BookmarkList)doc.getProperty(BookmarkList.class);
            if (bookmarkList == null) {
                BookmarkManager mgr = BookmarkList.getBookmarkManagerFactory().createBookmarkManager(doc);
                bookmarkList = new BookmarkList(doc, mgr);
                doc.putProperty(BookmarkList.class, bookmarkList);
            }
            return bookmarkList;
        }
    }

    private static BookmarkManagerFactory getBookmarkManagerFactory() {
        if (bookmarkManagerFactory == null) {
            bookmarkManagerFactory = (BookmarkManagerFactory)Lookup.getDefault().lookup(BookmarkManagerFactory.class);
            if (!$assertionsDisabled && bookmarkManagerFactory == null) {
                throw new AssertionError((Object)"No BookmarkManagerFactory available");
            }
        }
        return bookmarkManagerFactory;
    }

    private BookmarkList(Document doc, BookmarkManager manager) {
        if (doc == null) {
            throw new NullPointerException("Document cannot be null");
        }
        this.doc = doc;
        this.bookmarks = new ArrayList();
        this.manager = manager;
        this.managerSupport = BookmarksSpiPackageAccessor.get().createBookmarkManagerSupport(this);
        this.manager.init(this.managerSupport);
    }

    public Document getDocument() {
        return this.doc;
    }

    public int getBookmarkCount() {
        return this.bookmarks.size();
    }

    public Bookmark getBookmark(int index) {
        return (Bookmark)this.bookmarks.get(index);
    }

    public Bookmark getNextBookmark(int offset, boolean wrapSearch) {
        this.checkOffsetNonNegative(++offset);
        int index = this.getBookmarkIndex(offset);
        return index < this.getBookmarkCount() ? this.getBookmark(index) : (wrapSearch ? this.getNextBookmark(-1, false) : null);
    }

    public Bookmark getPreviousBookmark(int offset, boolean wrapSearch) {
        Bookmark bookmark;
        this.checkOffsetNonNegative(offset);
        int bookmarkCount = this.getBookmarkCount();
        if (bookmarkCount > 0) {
            int index;
            if ((index = this.getBookmarkIndex(--offset)) == bookmarkCount || (bookmark = this.getBookmark(index)).getOffset() != offset) {
                bookmark = --index >= 0 ? this.getBookmark(index) : (wrapSearch ? this.getPreviousBookmark(Integer.MAX_VALUE, false) : null);
            }
        } else {
            bookmark = null;
        }
        return bookmark;
    }

    public int getBookmarkIndex(int offset) {
        int low = 0;
        int high = this.getBookmarkCount() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int midOffset = this.getBookmark(mid).getOffset();
            if (midOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (midOffset > offset) {
                high = mid - 1;
                continue;
            }
            --mid;
            while (mid >= 0 && this.getBookmark(mid).getOffset() == offset) {
                --mid;
            }
            return ++mid;
        }
        return low;
    }

    public Bookmark toggleLineBookmark(int offset) {
        this.checkOffsetInDocument(offset);
        Element lineRoot = this.doc.getDefaultRootElement();
        int lineIndex = lineRoot.getElementIndex(offset);
        Bookmark bookmark = null;
        if (lineIndex < lineRoot.getElementCount()) {
            Element lineElem = lineRoot.getElement(lineIndex);
            int lineStartOffset = lineElem.getStartOffset();
            int index = this.getBookmarkIndex(lineStartOffset);
            bookmark = index < this.getBookmarkCount() && this.getBookmark(index).getOffset() < lineElem.getEndOffset() ? this.removeBookmarkAtIndex(index) : this.addBookmark(this.manager.createBookmarkImplementation(lineStartOffset));
            this.manager.saveBookmarks();
        }
        return bookmark;
    }

    public Bookmark removeBookmarkAtIndex(int index) {
        Bookmark bookmark = (Bookmark)this.bookmarks.remove(index);
        bookmark.release();
        this.PCS.firePropertyChange(PROP_BOOKMARKS, null, null);
        return bookmark;
    }

    public void removeAllBookmarks() {
        if (!this.bookmarks.isEmpty()) {
            for (int i = 0; i < this.bookmarks.size(); ++i) {
                Bookmark bookmark = (Bookmark)this.bookmarks.get(i);
                bookmark.release();
            }
            this.bookmarks.clear();
            this.PCS.firePropertyChange(PROP_BOOKMARKS, null, null);
        }
    }

    BookmarkManager getManager() {
        return this.manager;
    }

    Bookmark addBookmark(BookmarkImplementation impl) {
        Bookmark bookmark = new Bookmark(this, impl);
        int index = this.getBookmarkIndex(impl.getOffset() + 1);
        this.bookmarks.add(index, bookmark);
        this.PCS.firePropertyChange(PROP_BOOKMARKS, null, null);
        return bookmark;
    }

    private void checkOffsetNonNegative(int offset) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset=" + offset + " < 0");
        }
    }

    private void checkOffsetInDocument(int offset) {
        this.checkOffsetNonNegative(offset);
        int docLen = this.doc.getLength();
        if (offset > docLen) {
            throw new IndexOutOfBoundsException("offset=" + offset + " > doc.getLength()=" + docLen);
        }
    }

    public String toString() {
        return "Bookmarks: " + this.bookmarks;
    }

    void addPropertyChangeListener(PropertyChangeListener l) {
        this.PCS.addPropertyChangeListener(l);
    }

    void removePropertyChangeListener(PropertyChangeListener l) {
        this.PCS.removePropertyChangeListener(l);
    }

    static {
        $assertionsDisabled = !BookmarkList.class.desiredAssertionStatus();
        BookmarksApiPackageAccessor.register(new ApiAccessor());
        BookmarkManagerSupport.initPackageAccess();
    }

    private static final class ApiAccessor
    extends BookmarksApiPackageAccessor {
        private ApiAccessor() {
        }

        public BookmarkManager getBookmarkManager(BookmarkList bookmarkList) {
            return bookmarkList.getManager();
        }

        public BookmarkImplementation getBookmarkImplementation(Bookmark bookmark) {
            return bookmark.getImplementation();
        }

        public Bookmark addBookmark(BookmarkList list, BookmarkImplementation impl) {
            return list.addBookmark(impl);
        }

        public void addBookmarkListPcl(BookmarkList list, PropertyChangeListener l) {
            list.addPropertyChangeListener(l);
        }

        public void removeBookmarkListPcl(BookmarkList list, PropertyChangeListener l) {
            list.removePropertyChangeListener(l);
        }
    }
}

