/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.util.Utilities;

public class ExtIcon {
    private Image image;

    public ExtIcon() {
    }

    public ExtIcon(byte[] content) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        ColorModel cm = ColorModel.getRGBdefault();
        this.image = toolkit.createImage(new MemoryImageSource(16, 16, cm, content, 0, 64));
    }

    public void setIcon(Icon icn) {
        this.image = icn != null ? Utilities.icon2Image((Icon)icn) : null;
    }

    public Icon getIcon() {
        return this.image != null ? new ImageIcon(this.image) : null;
    }

    public byte[] getBytes() throws IOException {
        if (this.image == null) {
            return null;
        }
        PixelGrabber pg = new PixelGrabber(this.image, 0, 0, 16, 16, false);
        try {
            pg.grabPixels();
            if ((pg.getStatus() & 0x80) != 0) {
                throw new IOException("Cannot load image data");
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Loading image interrupted");
        }
        Object obj = pg.getPixels();
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        return ExtIcon.intToByteArray((int[])obj);
    }

    public static byte[] intToByteArray(int[] value) {
        byte[] b = new byte[value.length * 4];
        for (int j = 0; j < b.length; j += 4) {
            int val = value[j / 4];
            b[j] = (byte)(val >>> 24);
            b[j + 1] = (byte)(val >> 16 & 0xFF);
            b[j + 2] = (byte)(val >> 8 & 0xFF);
            b[j + 3] = (byte)(val & 0xFF);
        }
        return b;
    }
}

