/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashSet;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class Hacks {
    private static final String BUILD_NUMBER = System.getProperty("netbeans.buildnumber");

    static void keepCurrentProjectNameUpdated() {
        final TopComponent.Registry r = TopComponent.getRegistry();
        final RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                String pname;
                Project p;
                Node[] sel = r.getActivatedNodes();
                HashSet<Project> projects = new HashSet<Project>();
                for (int i = 0; i < sel.length; ++i) {
                    FileObject f;
                    Lookup l = sel[i].getLookup();
                    Project p2 = (Project)l.lookup(Project.class);
                    if (p2 != null) {
                        projects.add(p2);
                        continue;
                    }
                    DataObject d = (DataObject)l.lookup(DataObject.class);
                    if (d == null || (p2 = FileOwnerQuery.getOwner((FileObject)(f = d.getPrimaryFile()))) == null) continue;
                    projects.add(p2);
                }
                if (projects.size() == 1) {
                    p = (Project)projects.iterator().next();
                    pname = ProjectUtils.getInformation((Project)p).getDisplayName();
                    assert (pname != null) : p;
                } else {
                    pname = projects.isEmpty() ? null : NbBundle.getMessage(Hacks.class, (String)"LBL_MultipleProjects");
                }
                p = OpenProjectList.getDefault().getMainProject();
                final String mname = p != null ? ProjectUtils.getInformation((Project)p).getDisplayName() : NbBundle.getMessage(Hacks.class, (String)"LBL_NoMainProject");
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        String format = NbBundle.getBundle((String)"org.netbeans.core.windows.view.ui.Bundle").getString(pname != null ? "CTL_MainWindow_Title" : "CTL_MainWindow_Title_No_Project");
                        String title = pname != null ? MessageFormat.format(format, BUILD_NUMBER, pname, mname) : MessageFormat.format(format, BUILD_NUMBER, mname);
                        WindowManager.getDefault().getMainWindow().setTitle(title);
                    }
                });
            }
        });
        r.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                if ("activatedNodes".equals(ev.getPropertyName())) {
                    task.schedule(200);
                }
            }
        });
    }

    static void reloadPanelsInWizard(TemplateWizard tw, DataObject dobj) {
        try {
            Class<?> twClazz = Class.forName("org.openide.loaders.TemplateWizard", true, Thread.currentThread().getContextClassLoader());
            if (twClazz != null) {
                Method reloadPanels = twClazz.getDeclaredMethod("reload", DataObject.class);
                reloadPanels.setAccessible(true);
                reloadPanels.invoke((Object)tw, dobj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

