/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.project.ui.SimpleTargetChooserPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public class NewFileIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final long serialVersionUID = 1L;
    private transient boolean isLibrary;
    private transient WizardDescriptor.Iterator simpleIterator;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;
    private transient Project currentProject;
    private transient boolean isFolder;

    private NewFileIterator(boolean isFolderIterator) {
        this.isFolder = isFolderIterator;
    }

    public static NewFileIterator genericFileIterator() {
        return new NewFileIterator(false);
    }

    public static NewFileIterator folderIterator() {
        return new NewFileIterator(true);
    }

    public static NewFileIterator emptyFileIterator() {
        return new NewFileIterator(false);
    }

    private WizardDescriptor.Iterator getSimpleIterator() {
        if (this.simpleIterator == null) {
            assert (this.panels != null && this.panels.length > 0);
            this.simpleIterator = new WizardDescriptor.ArrayIterator(this.panels);
        }
        return this.simpleIterator;
    }

    private WizardDescriptor.Panel[] getPanels(WizardDescriptor wizardDescriptor) {
        Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        assert (project != null) : wizardDescriptor;
        if (!project.equals(this.currentProject) || this.panels == null) {
            this.currentProject = project;
            Sources sources = ProjectUtils.getSources((Project)project);
            this.panels = this.isFolder ? new WizardDescriptor.Panel[]{new SimpleTargetChooserPanel(project, sources.getSourceGroups("generic"), null, true)} : new WizardDescriptor.Panel[]{Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sources.getSourceGroups("generic"))};
        }
        return this.panels;
    }

    private String[] createSteps(String[] before) {
        assert (this.panels != null);
        if (before == null) {
            before = new String[]{};
        }
        String[] res = new String[before.length - 1 + this.panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - 1 ? before[i] : this.panels[i - before.length + 1].getComponent().getName();
        }
        return res;
    }

    public Set instantiate() throws IOException {
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        DataObject dTemplate = DataObject.find((FileObject)template);
        DataObject dobj = dTemplate.createFromTemplate(df, Templates.getTargetName((WizardDescriptor)this.wiz));
        return Collections.singleton(dobj.getPrimaryFile());
    }

    public void initialize(WizardDescriptor wiz) {
        this.panels = this.getPanels(wiz);
        this.wiz = wiz;
        String[] beforeSteps = null;
        Object prop = wiz.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.simpleIterator = null;
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return this.getSimpleIterator().name();
    }

    public boolean hasNext() {
        return this.getSimpleIterator().hasNext();
    }

    public boolean hasPrevious() {
        return this.getSimpleIterator().hasPrevious();
    }

    public void nextPanel() {
        this.getSimpleIterator().nextPanel();
    }

    public void previousPanel() {
        this.getSimpleIterator().previousPanel();
    }

    public WizardDescriptor.Panel current() {
        return this.getSimpleIterator().current();
    }

    public final void addChangeListener(ChangeListener l) {
        this.getSimpleIterator().addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.getSimpleIterator().removeChangeListener(l);
    }
}

