/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.ExtIcon;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.OpeningProjectPanel;
import org.netbeans.modules.project.ui.ProjectInfoAccessor;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.api.UnloadedProjectInformation;
import org.netbeans.modules.project.uiapi.ProjectOpenedTrampoline;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenProjectList {
    public static final Comparator<Project> PROJECT_BY_DISPLAYNAME = new ProjectByDisplayNameComparator();
    public static final String PROPERTY_OPEN_PROJECTS = "OpenProjects";
    public static final String PROPERTY_MAIN_PROJECT = "MainProject";
    public static final String PROPERTY_RECENT_PROJECTS = "RecentProjects";
    private static OpenProjectList INSTANCE;
    private static final int NUM_TEMPLATES = 15;
    private static final ErrorManager ERR;
    private static final RequestProcessor OPENING_RP;
    private List<Project> openProjects;
    private HashMap<ModuleInfo, List<Project>> openProjectsModuleInfos;
    private Project mainProject;
    private final RecentProjectList recentProjects;
    private List<String> recentTemplates;
    private final PropertyChangeSupport pchSupport;
    private ProjectDeletionListener deleteListener = new ProjectDeletionListener();
    private PropertyChangeListener infoListener;

    OpenProjectList() {
        this.openProjects = new ArrayList<Project>();
        this.openProjectsModuleInfos = new HashMap();
        this.infoListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evn) {
                if ("enabled".equals(evn.getPropertyName())) {
                    OpenProjectList.this.checkModuleInfo((ModuleInfo)evn.getSource());
                }
            }
        };
        this.pchSupport = new PropertyChangeSupport(this);
        this.recentProjects = new RecentProjectList(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenProjectList getDefault() {
        boolean needNotify = false;
        Project[] inital = null;
        Class<OpenProjectList> clazz = OpenProjectList.class;
        synchronized (OpenProjectList.class) {
            if (INSTANCE == null) {
                needNotify = true;
                INSTANCE = new OpenProjectList();
                OpenProjectList.INSTANCE.openProjects = OpenProjectList.loadProjectList();
                inital = OpenProjectList.INSTANCE.openProjects.toArray(new Project[0]);
                OpenProjectList.INSTANCE.recentTemplates = new ArrayList<String>(OpenProjectListSettings.getInstance().getRecentTemplates());
                URL mainProjectURL = OpenProjectListSettings.getInstance().getMainProjectURL();
                OpenProjectList.INSTANCE.recentProjects.load();
                for (Project p : OpenProjectList.INSTANCE.openProjects) {
                    INSTANCE.addModuleInfo(p);
                    try {
                        if (mainProjectURL == null || !mainProjectURL.equals(p.getProjectDirectory().getURL())) continue;
                        OpenProjectList.INSTANCE.mainProject = p;
                    }
                    catch (FileStateInvalidException e) {}
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (needNotify) {
                for (Project p : new ArrayList<Project>(OpenProjectList.INSTANCE.openProjects)) {
                    OpenProjectList.notifyOpened(p);
                }
            }
            if (inital != null) {
                OpenProjectList.log(OpenProjectList.createRecord("UI_INIT_PROJECTS", inital));
            }
            return INSTANCE;
        }
    }

    public void open(Project p) {
        this.open(new Project[]{p}, false);
    }

    public void open(Project p, boolean openSubprojects) {
        this.open(new Project[]{p}, openSubprojects);
    }

    public void open(Project[] projects, boolean openSubprojects) {
        this.open(projects, openSubprojects, false);
    }

    public void open(final Project[] projects, final boolean openSubprojects, final boolean asynchronously) {
        if (projects.length == 0) {
            return;
        }
        long start = System.currentTimeMillis();
        if (asynchronously) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        OpenProjectList.this.open(projects, openSubprojects, asynchronously);
                    }
                });
                return;
            }
            final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(OpenProjectList.class, (String)"CAP_Opening_Projects"));
            Frame mainWindow = WindowManager.getDefault().getMainWindow();
            final JDialog dialog = new JDialog(mainWindow, NbBundle.getMessage(OpenProjectList.class, (String)"LBL_Opening_Projects_Progress"), true);
            final OpeningProjectPanel panel = new OpeningProjectPanel(handle);
            dialog.getContentPane().add(panel);
            dialog.setDefaultCloseOperation(0);
            dialog.pack();
            Rectangle bounds = mainWindow.getBounds();
            int middleX = bounds.x + bounds.width / 2;
            int middleY = bounds.y + bounds.height / 2;
            Dimension size = dialog.getPreferredSize();
            dialog.setBounds(middleX - size.width / 2, middleY - size.height / 2, size.width, size.height);
            OPENING_RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        OpenProjectList.this.doOpen(projects, openSubprojects, handle, panel);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                try {
                                    Thread.currentThread();
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                dialog.setVisible(false);
                                dialog.dispose();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
            dialog.setVisible(true);
        } else {
            this.doOpen(projects, openSubprojects, null, null);
        }
        long end = System.currentTimeMillis();
        if (ERR.isLoggable(1)) {
            ERR.log(1, "opening projects took: " + (end - start) + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOpen(Project[] projects, boolean openSubprojects, ProgressHandle handle, OpeningProjectPanel panel) {
        assert (!Arrays.asList(projects).contains(null)) : "Projects can't be null";
        boolean recentProjectsChanged = false;
        int maxWork = 1000;
        int workForSubprojects = maxWork / 2;
        double currentWork = 0.0;
        LinkedHashSet<Project> projectsToOpen = new LinkedHashSet<Project>();
        if (handle != null) {
            handle.start(maxWork);
            handle.progress(0);
        }
        if (panel != null) {
            assert (projects.length > 0) : "at least one project to open";
            panel.setProjectName(ProjectUtils.getInformation((Project)projects[0]).getDisplayName());
        }
        HashMap<Project, Set> subprojectsCache = new HashMap<Project, Set>();
        LinkedList<Project> toHandle = new LinkedList<Project>(Arrays.asList(projects));
        while (!toHandle.isEmpty()) {
            Set subprojects;
            Project p = (Project)toHandle.remove(0);
            Set set = subprojects = openSubprojects ? (Set)subprojectsCache.get(p) : Collections.emptySet();
            if (subprojects == null) {
                SubprojectProvider spp = (SubprojectProvider)p.getLookup().lookup(SubprojectProvider.class);
                subprojects = spp != null ? spp.getSubprojects() : Collections.emptySet();
                subprojectsCache.put(p, subprojects);
            }
            projectsToOpen.add(p);
            for (Project sub : subprojects) {
                if (projectsToOpen.contains(sub) || toHandle.contains(sub)) continue;
                toHandle.add(sub);
            }
            double workPerOneProject = ((double)workForSubprojects - currentWork) / (double)(toHandle.size() + 1);
            int lastState = (int)currentWork;
            if (handle == null || lastState >= (int)(currentWork += workPerOneProject)) continue;
            handle.progress((int)currentWork);
        }
        double workPerProject = (maxWork - workForSubprojects) / projectsToOpen.size();
        final ArrayList<Project> oldprjs = new ArrayList<Project>();
        final ArrayList<Project> newprjs = new ArrayList<Project>();
        OpenProjectList lastState = this;
        synchronized (lastState) {
            oldprjs.addAll(this.openProjects);
        }
        for (Project p : projectsToOpen) {
            if (panel != null) {
                panel.setProjectName(ProjectUtils.getInformation((Project)p).getDisplayName());
            }
            recentProjectsChanged |= this.doOpenProject(p);
            int lastState2 = (int)currentWork;
            if (handle == null || lastState2 >= (int)(currentWork += workPerProject)) continue;
            handle.progress((int)currentWork);
        }
        OpenProjectList i$ = this;
        synchronized (i$) {
            newprjs.addAll(this.openProjects);
            OpenProjectList.saveProjectList(this.openProjects);
            if (recentProjectsChanged) {
                this.recentProjects.save();
            }
        }
        if (handle != null) {
            handle.finish();
        }
        final boolean recentProjectsChangedCopy = recentProjectsChanged;
        LogRecord[] addedRec = OpenProjectList.createRecord("UI_OPEN_PROJECTS", projectsToOpen.toArray(new Project[0]));
        OpenProjectList.log(addedRec);
        Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                OpenProjectList.this.pchSupport.firePropertyChange(OpenProjectList.PROPERTY_OPEN_PROJECTS, oldprjs.toArray(new Project[oldprjs.size()]), newprjs.toArray(new Project[newprjs.size()]));
                if (recentProjectsChangedCopy) {
                    OpenProjectList.this.pchSupport.firePropertyChange(OpenProjectList.PROPERTY_RECENT_PROJECTS, null, null);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Project[] projects, boolean notifyUI) {
        if (!ProjectUtilities.closeAllDocuments(projects, notifyUI)) {
            return;
        }
        boolean mainClosed = false;
        boolean someClosed = false;
        ArrayList<Project> oldprjs = new ArrayList<Project>();
        ArrayList<Project> newprjs = new ArrayList<Project>();
        OpenProjectList openProjectList = this;
        synchronized (openProjectList) {
            oldprjs.addAll(this.openProjects);
            for (int i = 0; i < projects.length; ++i) {
                if (!this.openProjects.contains(projects[i])) continue;
                if (!mainClosed) {
                    mainClosed = this.isMainProject(projects[i]);
                }
                this.openProjects.remove(projects[i]);
                this.removeModuleInfo(projects[i]);
                projects[i].getProjectDirectory().removeFileChangeListener((FileChangeListener)this.deleteListener);
                this.recentProjects.add(projects[i]);
                OpenProjectList.notifyClosed(projects[i]);
                someClosed = true;
            }
            if (someClosed) {
                newprjs.addAll(this.openProjects);
                OpenProjectList.saveProjectList(this.openProjects);
            }
            if (mainClosed) {
                this.mainProject = null;
                OpenProjectList.saveMainProject(this.mainProject);
            }
            if (someClosed) {
                this.recentProjects.save();
            }
        }
        if (someClosed) {
            this.pchSupport.firePropertyChange(PROPERTY_OPEN_PROJECTS, oldprjs.toArray(new Project[oldprjs.size()]), newprjs.toArray(new Project[newprjs.size()]));
        }
        if (mainClosed) {
            this.pchSupport.firePropertyChange(PROPERTY_MAIN_PROJECT, null, null);
        }
        if (someClosed) {
            this.pchSupport.firePropertyChange(PROPERTY_RECENT_PROJECTS, null, null);
        }
        for (int i = 0; i < projects.length; ++i) {
            try {
                ProjectManager.getDefault().saveProject(projects[i]);
                continue;
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        LogRecord[] removedRec = OpenProjectList.createRecord("UI_CLOSED_PROJECTS", projects);
        OpenProjectList.log(removedRec);
    }

    public synchronized Project[] getOpenProjects() {
        Project[] projects = new Project[this.openProjects.size()];
        this.openProjects.toArray(projects);
        return projects;
    }

    public synchronized boolean isOpen(Project p) {
        for (Project cp : this.openProjects) {
            if (!p.getProjectDirectory().equals(cp.getProjectDirectory())) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isMainProject(Project p) {
        return this.mainProject != null && p != null && this.mainProject.getProjectDirectory().equals(p.getProjectDirectory());
    }

    public synchronized Project getMainProject() {
        return this.mainProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainProject(Project mainProject) {
        OpenProjectList openProjectList = this;
        synchronized (openProjectList) {
            if (mainProject != null && !this.openProjects.contains(mainProject)) {
                throw new IllegalArgumentException("Project " + ProjectUtils.getInformation((Project)mainProject).getDisplayName() + " is not open and cannot be set as main.");
            }
            this.mainProject = mainProject;
            OpenProjectList.saveMainProject(mainProject);
        }
        this.pchSupport.firePropertyChange(PROPERTY_MAIN_PROJECT, null, null);
    }

    public synchronized List<Project> getRecentProjects() {
        return this.recentProjects.getProjects();
    }

    public synchronized boolean isRecentProjectsEmpty() {
        return this.recentProjects.isEmpty();
    }

    public synchronized List<UnloadedProjectInformation> getRecentProjectsInformation() {
        return this.recentProjects.getRecentProjectsInfo();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pchSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pchSupport.removePropertyChangeListener(l);
    }

    public List<DataObject> getTemplatesLRU(Project project) {
        ArrayList<FileObject> pLRU = this.getTemplateNamesLRU(project);
        ArrayList<DataObject> templates = new ArrayList<DataObject>();
        FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
        Iterator it = pLRU.iterator();
        while (it.hasNext()) {
            FileObject fo = (FileObject)it.next();
            if (fo != null) {
                try {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    templates.add(dobj);
                }
                catch (DataObjectNotFoundException e) {
                    it.remove();
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                continue;
            }
            it.remove();
        }
        return templates;
    }

    public void updateTemplatesLRU(FileObject template) {
        String templateName = template.getPath();
        if (this.recentTemplates.contains(templateName)) {
            this.recentTemplates.remove(templateName);
        }
        this.recentTemplates.add(0, templateName);
        if (this.recentTemplates.size() > 100) {
            this.recentTemplates.remove(100);
        }
        OpenProjectListSettings.getInstance().setRecentTemplates(new ArrayList<String>(this.recentTemplates));
    }

    static void shutdown() {
        if (INSTANCE != null) {
            for (Project p : OpenProjectList.INSTANCE.openProjects) {
                OpenProjectList.notifyClosed(p);
            }
        }
    }

    public static Project fileToProject(File projectDir) {
        try {
            FileObject fo = FileUtil.toFileObject((File)projectDir);
            if (fo != null && fo.isFolder()) {
                return ProjectManager.getDefault().findProject(fo);
            }
            return null;
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return null;
        }
    }

    private static List<Project> URLs2Projects(Collection<URL> URLs) {
        ArrayList<Project> result = new ArrayList<Project>(URLs.size());
        for (URL url : URLs) {
            FileObject dir = URLMapper.findFileObject((URL)url);
            if (dir == null || !dir.isFolder()) continue;
            try {
                Project p = ProjectManager.getDefault().findProject(dir);
                if (p == null) continue;
                result.add(p);
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                ErrorManager.getDefault().notify(1, t);
            }
        }
        return result;
    }

    private static List<URL> projects2URLs(Collection<Project> projects) {
        ArrayList<URL> URLs = new ArrayList<URL>(projects.size());
        for (Project p : projects) {
            try {
                URL root = p.getProjectDirectory().getURL();
                if (root == null) continue;
                URLs.add(root);
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return URLs;
    }

    private static void notifyOpened(Project p) {
        for (ProjectOpenedHook hook : p.getLookup().lookupAll(ProjectOpenedHook.class)) {
            try {
                ProjectOpenedTrampoline.DEFAULT.projectOpened(hook);
            }
            catch (RuntimeException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                OpenProjectList.INSTANCE.openProjects.remove(p);
                INSTANCE.removeModuleInfo(p);
            }
            catch (Error e) {
                ErrorManager.getDefault().notify((Throwable)e);
                OpenProjectList.INSTANCE.openProjects.remove(p);
                INSTANCE.removeModuleInfo(p);
            }
        }
    }

    private static void notifyClosed(Project p) {
        for (ProjectOpenedHook hook : p.getLookup().lookupAll(ProjectOpenedHook.class)) {
            try {
                ProjectOpenedTrampoline.DEFAULT.projectClosed(hook);
            }
            catch (RuntimeException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (Error e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doOpenProject(final Project p) {
        boolean recentProjectsChanged;
        OpenProjectList openProjectList = this;
        synchronized (openProjectList) {
            if (this.openProjects.contains(p)) {
                return false;
            }
            this.openProjects.add(p);
            this.addModuleInfo(p);
            p.getProjectDirectory().addFileChangeListener((FileChangeListener)this.deleteListener);
            recentProjectsChanged = this.recentProjects.remove(p);
        }
        OpenProjectList.notifyOpened(p);
        Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                ProjectUtilities.openProjectFiles(p);
                return null;
            }
        });
        return recentProjectsChanged;
    }

    private static List<Project> loadProjectList() {
        List<URL> URLs = OpenProjectListSettings.getInstance().getOpenProjectsURLs();
        List<Project> projects = OpenProjectList.URLs2Projects(URLs);
        return projects;
    }

    private static void saveProjectList(List<Project> projects) {
        List<URL> URLs = OpenProjectList.projects2URLs(projects);
        OpenProjectListSettings.getInstance().setOpenProjectsURLs(URLs);
    }

    private static void saveMainProject(Project mainProject) {
        try {
            URL mainRoot = mainProject == null ? null : mainProject.getProjectDirectory().getURL();
            OpenProjectListSettings.getInstance().setMainProjectURL(mainRoot);
        }
        catch (FileStateInvalidException e) {
            OpenProjectListSettings.getInstance().setMainProjectURL(null);
        }
    }

    private ArrayList<FileObject> getTemplateNamesLRU(Project project) {
        FileObject fo;
        int i;
        ArrayList<FileObject> result = new ArrayList<FileObject>(15);
        RecommendedTemplates rt = (RecommendedTemplates)project.getLookup().lookup(RecommendedTemplates.class);
        String[] rtNames = rt == null ? new String[]{} : rt.getRecommendedTypes();
        PrivilegedTemplates pt = (PrivilegedTemplates)project.getLookup().lookup(PrivilegedTemplates.class);
        String[] ptNames = pt == null ? null : pt.getPrivilegedTemplates();
        ArrayList<String> privilegedTemplates = new ArrayList<String>(Arrays.asList(pt == null ? new String[]{} : ptNames));
        FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
        Iterator<String> it = this.recentTemplates.iterator();
        for (i = 0; i < 15 && it.hasNext(); ++i) {
            String templateName = it.next();
            fo = sfs.findResource(templateName);
            if (fo == null) {
                it.remove();
                continue;
            }
            if (!OpenProjectList.isRecommended(project, fo)) continue;
            result.add(fo);
            privilegedTemplates.remove(templateName);
        }
        it = privilegedTemplates.iterator();
        for (i = result.size(); i < 15 && it.hasNext(); ++i) {
            String path = it.next();
            fo = sfs.findResource(path);
            if (fo == null) continue;
            result.add(fo);
        }
        return result;
    }

    static boolean isRecommended(Project p, FileObject primaryFile) {
        if (OpenProjectList.getRecommendedTypes(p) == null || OpenProjectList.getRecommendedTypes(p).length == 0) {
            return true;
        }
        Object o = primaryFile.getAttribute("templateCategory");
        if (o != null) {
            assert (o instanceof String) : primaryFile + " attr templateCategory = " + o;
            Iterator<String> categoriesIt = OpenProjectList.getCategories((String)o).iterator();
            boolean ok = false;
            while (categoriesIt.hasNext()) {
                String category = categoriesIt.next();
                if (!Arrays.asList(OpenProjectList.getRecommendedTypes(p)).contains(category)) continue;
                ok = true;
                break;
            }
            return ok;
        }
        return true;
    }

    private static String[] getRecommendedTypes(Project project) {
        RecommendedTemplates rt = (RecommendedTemplates)project.getLookup().lookup(RecommendedTemplates.class);
        return rt == null ? null : rt.getRecommendedTypes();
    }

    private static List<String> getCategories(String source) {
        ArrayList<String> categories = new ArrayList<String>();
        StringTokenizer cattok = new StringTokenizer(source, ",");
        while (cattok.hasMoreTokens()) {
            categories.add(cattok.nextToken().trim());
        }
        return categories;
    }

    private static ModuleInfo findModuleForProject(Project prj) {
        Collection instances = Lookup.getDefault().lookupAll(ModuleInfo.class);
        ModuleInfo info = null;
        for (ModuleInfo cur : instances) {
            if (!cur.isEnabled() || cur.getClassLoader() != prj.getClass().getClassLoader()) continue;
            info = cur;
            break;
        }
        return info;
    }

    private void addModuleInfo(Project prj) {
        ModuleInfo info = OpenProjectList.findModuleForProject(prj);
        if (info != null) {
            if (!this.openProjectsModuleInfos.containsKey(info)) {
                this.openProjectsModuleInfos.put(info, new ArrayList());
                info.addPropertyChangeListener(this.infoListener);
            }
            this.openProjectsModuleInfos.get(info).add(prj);
        }
    }

    private void removeModuleInfo(Project prj) {
        ModuleInfo info = OpenProjectList.findModuleForProject(prj);
        this.removeModuleInfo(prj, info);
    }

    private void removeModuleInfo(Project prj, ModuleInfo info) {
        if (info != null) {
            this.openProjectsModuleInfos.get(info).remove(prj);
            if (this.openProjectsModuleInfos.get(info).size() == 0) {
                info.removePropertyChangeListener(this.infoListener);
                this.openProjectsModuleInfos.remove(info);
            }
        }
    }

    private void checkModuleInfo(ModuleInfo info) {
        if (info.isEnabled()) {
            return;
        }
        ArrayList toRemove = new ArrayList(this.openProjectsModuleInfos.get(info));
        if (toRemove != null && toRemove.size() > 0) {
            for (Project prj : toRemove) {
                this.removeModuleInfo(prj, info);
            }
            this.close(toRemove.toArray(new Project[toRemove.size()]), false);
        }
    }

    private static LogRecord[] createRecord(String msg, Project[] projects) {
        if (projects.length == 0) {
            return null;
        }
        HashMap<String, int[]> counts = new HashMap<String, int[]>();
        for (Project p : projects) {
            String n = p.getClass().getName();
            int[] cnt = (int[])counts.get(n);
            if (cnt == null) {
                cnt = new int[1];
                counts.put(n, cnt);
            }
            cnt[0] = cnt[0] + 1;
        }
        Logger logger = Logger.getLogger("org.netbeans.ui.projects");
        LogRecord[] arr = new LogRecord[counts.size()];
        int i = 0;
        for (Map.Entry entry : counts.entrySet()) {
            LogRecord rec = new LogRecord(Level.CONFIG, msg);
            rec.setParameters(new Object[]{entry.getKey(), OpenProjectList.afterLastDot((String)entry.getKey()), ((int[])entry.getValue())[0]});
            rec.setLoggerName(logger.getName());
            rec.setResourceBundle(NbBundle.getBundle(OpenProjectList.class));
            rec.setResourceBundleName(OpenProjectList.class.getPackage().getName() + ".Bundle");
            arr[i++] = rec;
        }
        return arr;
    }

    private static void log(LogRecord[] arr) {
        if (arr == null) {
            return;
        }
        Logger logger = Logger.getLogger("org.netbeans.ui.projects");
        for (LogRecord r : arr) {
            logger.log(r);
        }
    }

    private static String afterLastDot(String s) {
        int index = s.lastIndexOf(46);
        if (index == -1) {
            return s;
        }
        return s.substring(index + 1);
    }

    static {
        ERR = ErrorManager.getDefault().getInstance(OpenProjectList.class.getName());
        OPENING_RP = new RequestProcessor("Opening projects", 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProjectByDisplayNameComparator
    implements Comparator<Project> {
        private static Comparator<Object> COLLATOR = Collator.getInstance();

        @Override
        public int compare(Project p1, Project p2) {
            String n1 = ProjectUtils.getInformation((Project)p1).getDisplayName();
            String n2 = ProjectUtils.getInformation((Project)p2).getDisplayName();
            if (n1 != null && n2 != null) {
                return COLLATOR.compare(n1, n2);
            }
            if (n1 == null && n2 != null) {
                ERR.log(16, p1 + ": ProjectInformation.getDisplayName() should not return null!");
                return -1;
            }
            if (n1 != null && n2 == null) {
                ERR.log(16, p2 + ": ProjectInformation.getDisplayName() should not return null!");
                return 1;
            }
            return 0;
        }
    }

    private final class ProjectDeletionListener
    extends FileChangeAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileDeleted(FileEvent fe) {
            OpenProjectList openProjectList = OpenProjectList.this;
            synchronized (openProjectList) {
                Project toRemove = null;
                for (Project prj : OpenProjectList.this.openProjects) {
                    if (!fe.getFile().equals(prj.getProjectDirectory())) continue;
                    toRemove = prj;
                    break;
                }
                if (toRemove != null) {
                    OpenProjectList.this.close(new Project[]{toRemove}, false);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecentProjectList {
        private List<ProjectReference> recentProjects;
        private List<UnloadedProjectInformation> recentProjectsInfos;
        private int size;

        public RecentProjectList(int size) {
            this.size = size;
            this.recentProjects = new ArrayList<ProjectReference>(size);
            this.recentProjectsInfos = new ArrayList<UnloadedProjectInformation>(size);
            if (ERR.isLoggable(1)) {
                ERR.log("created a RecentProjectList: size=" + size);
            }
        }

        public void add(Project p) {
            int index = this.getIndex(p);
            if (index == -1) {
                if (ERR.isLoggable(1)) {
                    ERR.log("add new recent project: " + p);
                }
                if (this.recentProjects.size() == this.size) {
                    this.recentProjects.remove(this.size - 1);
                    this.recentProjectsInfos.remove(this.size - 1);
                }
                this.recentProjects.add(0, new ProjectReference(p));
                try {
                    this.recentProjectsInfos.add(0, ProjectInfoAccessor.DEFAULT.getProjectInfo(ProjectUtils.getInformation((Project)p).getDisplayName(), ProjectUtils.getInformation((Project)p).getIcon(), p.getProjectDirectory().getURL()));
                }
                catch (FileStateInvalidException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            } else {
                if (ERR.isLoggable(1)) {
                    ERR.log("re-add recent project: " + p);
                }
                this.recentProjects.remove(index);
                this.recentProjects.add(0, new ProjectReference(p));
                this.recentProjectsInfos.remove(index);
                try {
                    this.recentProjectsInfos.add(0, ProjectInfoAccessor.DEFAULT.getProjectInfo(ProjectUtils.getInformation((Project)p).getDisplayName(), ProjectUtils.getInformation((Project)p).getIcon(), p.getProjectDirectory().getURL()));
                }
                catch (FileStateInvalidException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }

        public boolean remove(Project p) {
            int index = this.getIndex(p);
            if (index != -1) {
                if (ERR.isLoggable(1)) {
                    ERR.log("remove recent project: " + p);
                }
                this.recentProjects.remove(index);
                this.recentProjectsInfos.remove(index);
                return true;
            }
            return false;
        }

        public List<Project> getProjects() {
            ArrayList<Project> result = new ArrayList<Project>(this.recentProjects.size());
            ArrayList<ProjectReference> references = new ArrayList<ProjectReference>(this.recentProjects);
            for (ProjectReference pRef : references) {
                Project p = pRef.getProject();
                if (p == null || !p.getProjectDirectory().isValid()) {
                    this.remove(p);
                    if (!ERR.isLoggable(1)) continue;
                    ERR.log("removing dead recent project: " + p);
                    continue;
                }
                result.add(p);
            }
            if (ERR.isLoggable(1)) {
                ERR.log("recent projects: " + result);
            }
            return result;
        }

        public boolean isEmpty() {
            boolean empty = this.recentProjects.isEmpty();
            if (ERR.isLoggable(1)) {
                ERR.log("recent projects empty? " + empty);
            }
            return empty;
        }

        public void load() {
            List<URL> URLs = OpenProjectListSettings.getInstance().getRecentProjectsURLs();
            List<String> names = OpenProjectListSettings.getInstance().getRecentProjectsDisplayNames();
            List<ExtIcon> icons = OpenProjectListSettings.getInstance().getRecentProjectsIcons();
            if (ERR.isLoggable(1)) {
                ERR.log("recent project list load: " + URLs);
            }
            this.recentProjects.clear();
            Iterator<URL> it = URLs.iterator();
            while (it.hasNext()) {
                this.recentProjects.add(new ProjectReference(it.next()));
            }
            this.recentProjectsInfos.clear();
            Iterator<String> iterNames = names.iterator();
            Iterator<URL> iterURLs = URLs.iterator();
            Iterator<ExtIcon> iterIcons = icons.iterator();
            while (iterNames.hasNext() && iterURLs.hasNext() && iterIcons.hasNext()) {
                String name = iterNames.next();
                URL url = iterURLs.next();
                Icon icon = iterIcons.next().getIcon();
                this.recentProjectsInfos.add(ProjectInfoAccessor.DEFAULT.getProjectInfo(name, icon, url));
            }
            if (this.recentProjects.size() != this.recentProjectsInfos.size()) {
                this.recentProjects.clear();
                this.recentProjectsInfos.clear();
            }
        }

        public void save() {
            ArrayList<URL> URLs = new ArrayList<URL>(this.recentProjects.size());
            for (ProjectReference pRef : this.recentProjects) {
                URL pURL = pRef.getURL();
                if (pURL == null) continue;
                URLs.add(pURL);
            }
            if (ERR.isLoggable(1)) {
                ERR.log("recent project list save: " + URLs);
            }
            OpenProjectListSettings.getInstance().setRecentProjectsURLs(URLs);
            int listSize = this.recentProjectsInfos.size();
            ArrayList<String> names = new ArrayList<String>(listSize);
            ArrayList<ExtIcon> icons = new ArrayList<ExtIcon>(listSize);
            for (UnloadedProjectInformation prjInfo : this.recentProjectsInfos) {
                names.add(prjInfo.getDisplayName());
                ExtIcon extIcon = new ExtIcon();
                extIcon.setIcon(prjInfo.getIcon());
                icons.add(extIcon);
            }
            OpenProjectListSettings.getInstance().setRecentProjectsDisplayNames(names);
            OpenProjectListSettings.getInstance().setRecentProjectsIcons(icons);
        }

        private int getIndex(Project p) {
            URL pURL;
            try {
                if (p == null || p.getProjectDirectory() == null) {
                    return -1;
                }
                pURL = p.getProjectDirectory().getURL();
            }
            catch (FileStateInvalidException e) {
                return -1;
            }
            int i = 0;
            Iterator<ProjectReference> it = this.recentProjects.iterator();
            while (it.hasNext()) {
                URL p2URL = it.next().getURL();
                if (pURL.equals(p2URL)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private List<UnloadedProjectInformation> getRecentProjectsInfo() {
            return this.recentProjectsInfos;
        }

        private static class ProjectReference {
            private WeakReference<Project> projectReference;
            private URL projectURL;

            public ProjectReference(URL url) {
                this.projectURL = url;
            }

            public ProjectReference(Project p) {
                block2: {
                    this.projectReference = new WeakReference<Project>(p);
                    try {
                        this.projectURL = p.getProjectDirectory().getURL();
                    }
                    catch (FileStateInvalidException e) {
                        if (!ERR.isLoggable(1)) break block2;
                        ERR.log("FSIE getting URL for project: " + p.getProjectDirectory());
                    }
                }
            }

            public Project getProject() {
                block9: {
                    FileObject dir;
                    Project p = null;
                    if (this.projectReference != null && (p = (Project)this.projectReference.get()) != null) {
                        if (ProjectManager.getDefault().isValid(p)) {
                            return p;
                        }
                        return null;
                    }
                    if (ERR.isLoggable(1)) {
                        ERR.log("no active project reference for " + this.projectURL);
                    }
                    if (this.projectURL != null && (dir = URLMapper.findFileObject((URL)this.projectURL)) != null && dir.isFolder()) {
                        try {
                            p = ProjectManager.getDefault().findProject(dir);
                            if (p != null) {
                                this.projectReference = new WeakReference<Project>(p);
                                if (ERR.isLoggable(1)) {
                                    ERR.log("found " + p);
                                }
                                return p;
                            }
                        }
                        catch (IOException e) {
                            if (!ERR.isLoggable(1)) break block9;
                            ERR.log("could not load recent project from " + this.projectURL);
                        }
                    }
                }
                if (ERR.isLoggable(1)) {
                    ERR.log("no recent project in " + this.projectURL);
                }
                return null;
            }

            public URL getURL() {
                return this.projectURL;
            }
        }
    }
}

