/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class OpenSubprojects
extends NodeAction {
    private static final String ICON = "org/netbeans/modules/project/ui/resources/openProject.png";

    public String getName() {
        return NbBundle.getMessage(OpenSubprojects.class, (String)"LBL_OpenSubprojectsAction_Name");
    }

    public String iconResource() {
        return ICON;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        boolean someSubprojects = false;
        for (int i = 0; i < activatedNodes.length; ++i) {
            Project p = (Project)activatedNodes[i].getLookup().lookup(Project.class);
            if (p == null) {
                return false;
            }
            SubprojectProvider spp = (SubprojectProvider)p.getLookup().lookup(SubprojectProvider.class);
            if (spp == null || spp.getSubprojects().isEmpty()) continue;
            someSubprojects = true;
        }
        return someSubprojects;
    }

    protected void performAction(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            Project p = (Project)activatedNodes[i].getLookup().lookup(Project.class);
            if (p == null) continue;
            OpenProjectList.getDefault().open(new Project[]{p}, true, true);
        }
    }
}

