/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.groups.AdHocGroupEditPanel;
import org.netbeans.modules.project.ui.groups.AdHocGroupEditPanelBasic;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.GroupEditPanel;
import org.openide.filesystems.FileStateInvalidException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdHocGroup
extends Group {
    private static final Logger LOG = Logger.getLogger(AdHocGroup.class.getName());
    private static final String KEY_AUTO_SYNCH = "autoSynch";
    static final String KIND = "adHoc";

    public static AdHocGroup create(String name, boolean autoSynch) {
        String id = AdHocGroup.sanitizeNameAndUniquifyForId(name);
        LOG.log(Level.FINE, "Creating: {0}", id);
        Preferences p = NODE.node(id);
        p.put("name", name);
        p.put("kind", KIND);
        p.putBoolean(KEY_AUTO_SYNCH, autoSynch);
        return new AdHocGroup(id);
    }

    AdHocGroup(String id) {
        super(id);
    }

    @Override
    protected void findProjects(Set<Project> projects, ProgressHandle h, int start, int end) {
        String paths = this.prefs().get("path", "");
        if (paths.length() > 0) {
            String[] items;
            for (String path : items = paths.split(" ")) {
                Project p = AdHocGroup.projectForPath(path);
                if (p == null) continue;
                if (h != null) {
                    start += (end - start) / items.length;
                    h.progress(AdHocGroup.progressMessage(p), start);
                }
                projects.add(p);
            }
        }
    }

    public void setProjects(Set<Project> projects) {
        TreeSet<String> projectPaths = new TreeSet<String>();
        for (Project prj : projects) {
            try {
                projectPaths.add(prj.getProjectDirectory().getURL().toExternalForm());
            }
            catch (FileStateInvalidException x) {
                LOG.log(Level.WARNING, null, x);
            }
        }
        this.prefs().put("path", AdHocGroup.joinPaths(projectPaths));
        LOG.log(Level.FINE, "updating projects for {0} to {1}", new Object[]{this.id, projects});
    }

    private static String joinPaths(Collection<String> paths) {
        StringBuilder b = new StringBuilder();
        for (String p : paths) {
            if (b.length() > 0) {
                b.append(' ');
            }
            b.append(p);
        }
        return b.toString();
    }

    public boolean isAutoSynch() {
        return this.prefs().getBoolean(KEY_AUTO_SYNCH, false);
    }

    public void setAutoSynch(boolean b) {
        this.prefs().putBoolean(KEY_AUTO_SYNCH, b);
    }

    public void synch() {
        OpenProjects op = OpenProjects.getDefault();
        this.setProjects(new HashSet<Project>(Arrays.asList(op.getOpenProjects())));
        this.setMainProject(op.getMainProject());
    }

    @Override
    public GroupEditPanel createPropertiesPanel() {
        return Group.isAdvancedMode() ? new AdHocGroupEditPanel(this) : new AdHocGroupEditPanelBasic(this);
    }

    @Override
    protected void closed() {
        if (this.isAutoSynch()) {
            this.setProjects(new HashSet<Project>(Arrays.asList(OpenProjects.getDefault().getOpenProjects())));
        }
        super.closed();
    }

    @Override
    public boolean isPristine() {
        if (this.isAutoSynch()) {
            return true;
        }
        return super.isPristine();
    }

    @Override
    protected String toString(boolean scrubPersonalInfo) {
        return super.toString(scrubPersonalInfo) + (this.isAutoSynch() ? "" : "[!autoSynch]");
    }
}

