/*
 * Decompiled with CFR 0.152.
 */
package org.JGM.roomeditor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class RoomCanvas
extends JComponent
implements MouseListener,
MouseMotionListener {
    private int diam = 10;
    private Paint paint = Color.BLUE;
    private BufferedImage backingImage;

    public RoomCanvas() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(Color.WHITE);
    }

    public void clear() {
        this.backingImage = null;
        this.repaint();
    }

    public BufferedImage getImage() {
        if (this.backingImage == null || this.backingImage.getWidth() != this.getWidth() || this.backingImage.getHeight() != this.getHeight()) {
            BufferedImage old = this.backingImage;
            this.backingImage = new BufferedImage(this.getWidth(), this.getHeight(), 3);
            Graphics g = this.backingImage.getGraphics();
            g.setColor(Color.LIGHT_GRAY);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (old != null) {
                ((Graphics2D)this.backingImage.getGraphics()).drawRenderedImage(old, AffineTransform.getTranslateInstance(0.0, 0.0));
            }
        }
        return this.backingImage;
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.drawRenderedImage(this.getImage(), AffineTransform.getTranslateInstance(0.0, 0.0));
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseClicked(e);
    }

    public void mouseMoved(MouseEvent e) {
    }

    private class BrushSizeView
    extends JComponent {
        private BrushSizeView() {
        }

        public boolean isOpaque() {
            return true;
        }

        public void paint(Graphics g) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            Point p = new Point(this.getWidth() / 2, this.getHeight() / 2);
        }

        public Dimension getPreferredSize() {
            return new Dimension(32, 32);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }
}

