/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.tasklist.filter.AppliedFilterCondition;
import org.netbeans.modules.tasklist.filter.KeywordsFilter;
import org.netbeans.modules.tasklist.filter.TaskProperty;
import org.openide.util.NbBundle;

final class ConditionPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private KeywordsFilter filter;
    private JComponent valueField;
    final JPanel emptyPanel = new JPanel();
    final JComboBox propertyCombo = new JComboBox();
    final JComboBox relationCombo = new JComboBox();

    public ConditionPanel(KeywordsFilter filter, AppliedFilterCondition cond) {
        this.filter = filter;
        this.initComponents();
        this.initA11y();
        this.valueField = this.emptyPanel;
        TaskProperty[] props = filter.getProperties();
        int selectedIndex = -1;
        DefaultComboBoxModel<Object> m = new DefaultComboBoxModel<Object>();
        for (int i = 0; i < props.length; ++i) {
            AppliedFilterCondition[] c = filter.createConditions(props[i]);
            if (c.length != 0) {
                m.addElement(props[i]);
                if (cond == null) {
                    cond = c[0];
                }
            }
            if (!props[i].getName().equals(cond.getProperty().getName())) continue;
            selectedIndex = i;
        }
        this.propertyCombo.setModel(m);
        this.propertyCombo.addActionListener(this);
        this.propertyCombo.setSelectedIndex(selectedIndex);
        this.propertyCombo.setRenderer(new PropertyCellRenderer());
        AppliedFilterCondition[] conditions = filter.createConditions(cond.getProperty());
        m = new DefaultComboBoxModel();
        for (int i = 0; i < conditions.length; ++i) {
            if (conditions[i].sameType(cond)) {
                m.addElement(cond);
                continue;
            }
            m.addElement(conditions[i]);
        }
        this.relationCombo.setModel(m);
        this.relationCombo.addActionListener(this);
        this.relationCombo.setSelectedItem(cond);
        this.relationCombo.setRenderer(new ConditionCellRenderer());
        this.setValueComponent(cond.getCondition().createConstantComponent());
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.propertyCombo) {
            AppliedFilterCondition[] c = this.filter.createConditions((TaskProperty)this.propertyCombo.getSelectedItem());
            this.relationCombo.setModel(new DefaultComboBoxModel<AppliedFilterCondition>(c));
            if (c.length != 0) {
                this.relationCombo.setSelectedIndex(0);
                AppliedFilterCondition cond = (AppliedFilterCondition)this.relationCombo.getSelectedItem();
                this.setValueComponent(cond.getCondition().createConstantComponent());
            } else {
                this.setValueComponent(null);
            }
        } else if (evt.getSource() == this.relationCombo) {
            AppliedFilterCondition cond = (AppliedFilterCondition)this.relationCombo.getSelectedItem();
            this.setValueComponent(cond.getCondition().createConstantComponent());
        }
    }

    public AppliedFilterCondition getCondition() {
        AppliedFilterCondition cond = (AppliedFilterCondition)this.relationCombo.getSelectedItem();
        if (this.valueField != this.emptyPanel) {
            cond.getCondition().getConstantFrom(this.valueField);
        }
        return cond;
    }

    private void initA11y() {
        this.propertyCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConditionPanel.class, (String)"ACSN_Property"));
        this.propertyCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConditionPanel.class, (String)"ACSD_Property"));
        this.relationCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConditionPanel.class, (String)"ACSN_Relation"));
        this.relationCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConditionPanel.class, (String)"ACSD_Relation"));
    }

    private void setValueComponent(JComponent cmp) {
        if (this.valueField == this.emptyPanel && cmp == null || this.valueField == cmp) {
            return;
        }
        this.remove(this.valueField);
        if (cmp == null) {
            this.valueField = this.emptyPanel;
        } else {
            if (cmp instanceof JTextComponent && this.valueField instanceof JTextComponent && ((JTextComponent)cmp).getText().length() == 0) {
                ((JTextComponent)cmp).setText(((JTextComponent)this.valueField).getText());
            }
            this.valueField = cmp;
            if (cmp.getAccessibleContext().getAccessibleName() == null) {
                cmp.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConditionPanel.class, (String)"ACSN_Value"));
            }
            if (cmp.getAccessibleContext().getAccessibleDescription() == null) {
                cmp.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConditionPanel.class, (String)"ACSD_Value"));
            }
            cmp.addPropertyChangeListener("value-valid", this);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.add((Component)this.valueField, gridBagConstraints);
        this.revalidate();
        this.repaint();
    }

    public void focusPropertyCombo() {
        this.propertyCombo.requestFocusInWindow();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.putClientProperty("value-valid", this.isValueValid());
    }

    public boolean isValueValid() {
        AppliedFilterCondition cond = (AppliedFilterCondition)this.relationCombo.getSelectedItem();
        return this.valueField != this.emptyPanel && cond.getCondition().isValueValid(this.valueField);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.propertyCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.relationCombo, gridBagConstraints);
        this.emptyPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.emptyPanel, gridBagConstraints);
    }

    private static class ConditionCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            AppliedFilterCondition c = (AppliedFilterCondition)value;
            if (c != null) {
                this.setText(c.getCondition().getDisplayName());
            }
            return this;
        }
    }

    private static class PropertyCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            TaskProperty prop = (TaskProperty)value;
            if (prop != null) {
                this.setText(prop.getName());
            }
            return this;
        }
    }
}

