/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

class TypesFilter {
    private Set<String> disabledProviders = new HashSet<String>();
    private int countLimit = 100;

    public TypesFilter() {
    }

    private TypesFilter(TypesFilter src) {
        this.countLimit = src.countLimit;
        this.disabledProviders.addAll(src.disabledProviders);
    }

    public boolean isEnabled(String type) {
        return !this.disabledProviders.contains(type);
    }

    public void setEnabled(String type, boolean enabled) {
        if (!enabled) {
            this.disabledProviders.add(type);
        } else {
            this.disabledProviders.remove(type);
        }
    }

    public boolean isTaskCountLimitReached(int taskCount) {
        return taskCount >= this.countLimit;
    }

    public void setTaskCountLimit(int limit) {
        this.countLimit = limit;
    }

    public int getTaskCountLimit() {
        return this.countLimit;
    }

    public TypesFilter clone() {
        return new TypesFilter(this);
    }

    void load(Preferences prefs, String prefix) throws BackingStoreException {
        this.countLimit = prefs.getInt(prefix + "_countLimit", 100);
        this.disabledProviders.clear();
        String disabled = prefs.get(prefix + "_disabled", "");
        StringTokenizer tokenizer = new StringTokenizer(disabled, "\n");
        while (tokenizer.hasMoreTokens()) {
            this.disabledProviders.add(tokenizer.nextToken());
        }
    }

    void save(Preferences prefs, String prefix) throws BackingStoreException {
        prefs.putInt(prefix + "_countLimit", this.countLimit);
        StringBuffer buffer = new StringBuffer();
        Iterator<String> type = this.disabledProviders.iterator();
        while (type.hasNext()) {
            buffer.append(type.next());
            if (!type.hasNext()) continue;
            buffer.append("\n");
        }
        prefs.put(prefix + "_disabled", buffer.toString());
    }
}

