/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.tasklist.filter.TypesFilter;
import org.netbeans.modules.tasklist.impl.ScannerDescriptor;
import org.netbeans.modules.tasklist.ui.checklist.CheckList;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class TypesPanel
extends JPanel {
    private CheckList lstTypes;
    private List<? extends ScannerDescriptor> providers;
    private boolean[] providerState;
    private TypesFilter filter;
    private JButton btnOptions;
    private JLabel lblVisibleLimit;
    private JScrollPane scrollTypes;
    private JTextField txtVisibleLimit;

    public TypesPanel(TypesFilter filter) {
        this.filter = filter;
        this.init();
    }

    public boolean isValueValid() {
        boolean atLeastOneTypeSelected = false;
        for (int i = 0; i < this.providerState.length; ++i) {
            if (!this.providerState[i]) continue;
            atLeastOneTypeSelected = true;
            break;
        }
        return atLeastOneTypeSelected && this.checkVisibleLimit();
    }

    private void init() {
        this.initComponents();
        this.providers = ScannerDescriptor.getDescriptors();
        this.providerState = new boolean[this.providers.size()];
        Object[] names = new String[this.providers.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.providers.get(i).getDisplayName();
        }
        this.lstTypes = new CheckList(this.providerState, names);
        this.lstTypes.setSelectionMode(0);
        this.lstTypes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                int selIndex = TypesPanel.this.lstTypes.getSelectedIndex();
                boolean enableOptions = false;
                if (selIndex >= 0) {
                    ScannerDescriptor tp = (ScannerDescriptor)TypesPanel.this.providers.get(selIndex);
                    enableOptions = null != tp.getOptionsPath();
                }
                TypesPanel.this.btnOptions.setEnabled(enableOptions);
            }
        });
        this.lstTypes.getModel().addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent arg0) {
            }

            public void intervalRemoved(ListDataEvent arg0) {
            }

            public void contentsChanged(ListDataEvent arg0) {
                TypesPanel.this.putClientProperty("value-valid", new Boolean(TypesPanel.this.isValueValid()));
            }
        });
        this.btnOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScannerDescriptor tp;
                int selIndex = TypesPanel.this.lstTypes.getSelectedIndex();
                if (selIndex >= 0 && null != (tp = (ScannerDescriptor)TypesPanel.this.providers.get(selIndex)).getOptionsPath()) {
                    OptionsDisplayer.getDefault().open(tp.getOptionsPath());
                }
            }
        });
        this.scrollTypes.setViewportView(this.lstTypes);
        this.showFilter(this.filter);
    }

    private void showFilter(TypesFilter filter) {
        for (int i = 0; i < this.providerState.length; ++i) {
            ScannerDescriptor tp = this.providers.get(i);
            this.providerState[i] = null != filter && filter.isEnabled(tp.getType());
        }
        this.txtVisibleLimit.setText(null == filter ? "" : String.valueOf(filter.getTaskCountLimit()));
        this.lstTypes.setEnabled(null != filter);
        this.txtVisibleLimit.setEnabled(null != filter);
        this.btnOptions.setEnabled(null != filter);
    }

    private void initComponents() {
        this.lblVisibleLimit = new JLabel();
        this.txtVisibleLimit = new JTextField();
        this.btnOptions = new JButton();
        this.scrollTypes = new JScrollPane();
        this.setOpaque(false);
        this.lblVisibleLimit.setLabelFor(this.txtVisibleLimit);
        Mnemonics.setLocalizedText((JLabel)this.lblVisibleLimit, (String)NbBundle.getMessage(TypesPanel.class, (String)"TypesPanel.lblVisibleLimit.text"));
        this.txtVisibleLimit.setText(NbBundle.getMessage(TypesPanel.class, (String)"TypesPanel.txtVisibleLimit.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOptions, (String)NbBundle.getMessage(TypesPanel.class, (String)"TypesPanel.btnOptions.text"));
        this.btnOptions.setEnabled(false);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.scrollTypes, -1, 367, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnOptions)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lblVisibleLimit).addPreferredGap(0).add((Component)this.txtVisibleLimit, -2, 49, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.btnOptions).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.scrollTypes, -1, 158, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblVisibleLimit).add((Component)this.txtVisibleLimit, -2, -1, -2)))).addContainerGap()));
    }

    public TypesFilter getFilter() {
        if (this.filter != null) {
            for (int i = 0; i < this.providerState.length; ++i) {
                ScannerDescriptor tp = this.providers.get(i);
                this.filter.setEnabled(tp.getType(), this.providerState[i]);
            }
            this.filter.setTaskCountLimit(this.getVisibleLimit());
        }
        return this.filter;
    }

    private int getVisibleLimit() {
        int limit = null == this.filter ? 100 : this.filter.getTaskCountLimit();
        try {
            String strLimit = this.txtVisibleLimit.getText();
            int tmp = Integer.parseInt(strLimit);
            if (tmp > 0) {
                limit = tmp;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return limit;
    }

    private boolean checkVisibleLimit() {
        try {
            String strLimit = this.txtVisibleLimit.getText();
            int limit = Integer.parseInt(strLimit);
            return limit > 0;
        }
        catch (NumberFormatException nfE) {
            return false;
        }
    }
}

