/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.TaskComparator;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskList {
    private ArrayList<Task> sortedTasks = new ArrayList(0);
    private Set<Task> allTasks = new HashSet<Task>(0);
    private Map<PushTaskScanner, List<Task>> pushScanner2tasks = new HashMap<PushTaskScanner, List<Task>>(10);
    private Map<FileTaskScanner, List<Task>> fileScanner2tasks = new HashMap<FileTaskScanner, List<Task>>(10);
    private Map<TaskGroup, List<Task>> group2tasks = new HashMap<TaskGroup, List<Task>>(10);
    private WeakSet<Listener> listeners = new WeakSet(2);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Comparator<Task> comparator;

    void setTasks(PushTaskScanner scanner, FileObject resource, List<? extends Task> tasks, TaskFilter filter) {
        this.lock.writeLock().lock();
        List<Task> removed = this.clear(scanner, resource);
        ArrayList<Task> tasksToAdd = null;
        int currentCount = this.countTasks(scanner);
        for (Task task : tasks) {
            TaskGroup group;
            List<Task> groupTasks;
            List<Task> scannerTasks;
            if (!filter.accept(task) || filter.isTaskCountLimitReached(currentCount)) continue;
            ++currentCount;
            if (this.allTasks.contains(task)) continue;
            if (null == tasksToAdd) {
                tasksToAdd = new ArrayList<Task>(tasks.size());
            }
            if (null == (scannerTasks = this.pushScanner2tasks.get(scanner))) {
                scannerTasks = new LinkedList<Task>();
                this.pushScanner2tasks.put(scanner, scannerTasks);
            }
            if (null == (groupTasks = this.group2tasks.get(group = Accessor.getGroup(task)))) {
                groupTasks = new LinkedList<Task>();
                this.group2tasks.put(group, groupTasks);
            }
            tasksToAdd.add(task);
            scannerTasks.add(task);
            groupTasks.add(task);
            this.allTasks.add(task);
        }
        if (null != tasksToAdd) {
            this.sortedTasks.addAll(tasksToAdd);
            Collections.sort(this.sortedTasks, this.getComparator());
        }
        this.lock.writeLock().unlock();
        if (null != removed && !removed.isEmpty()) {
            this.fireTasksRemoved(removed);
        }
        if (null != tasksToAdd && !tasksToAdd.isEmpty()) {
            this.fireTasksAdded((List<Task>)tasksToAdd);
        }
    }

    void clear(PushTaskScanner scanner) {
        this.lock.writeLock().lock();
        List<Task> toRemove = this.pushScanner2tasks.get(scanner);
        this.pushScanner2tasks.remove(scanner);
        if (null != toRemove) {
            for (List<Task> groupTasks : this.group2tasks.values()) {
                groupTasks.removeAll(toRemove);
            }
            this.sortedTasks.removeAll(toRemove);
            this.allTasks.removeAll(toRemove);
        }
        this.lock.writeLock().unlock();
        if (null != toRemove && !toRemove.isEmpty()) {
            this.fireTasksRemoved(toRemove);
        }
    }

    private int countTasks(PushTaskScanner scanner) {
        List<Task> tasks = this.pushScanner2tasks.get(scanner);
        return null == tasks ? 0 : tasks.size();
    }

    private List<Task> clear(PushTaskScanner scanner, FileObject resource) {
        LinkedList<Task> toRemove = null;
        List<Task> tasks = this.pushScanner2tasks.get(scanner);
        if (null != tasks) {
            for (Task task : tasks) {
                if (!resource.equals(Accessor.getResource(task))) continue;
                if (null == toRemove) {
                    toRemove = new LinkedList<Task>();
                }
                toRemove.add(task);
            }
        }
        if (null != toRemove) {
            this.sortedTasks.removeAll(toRemove);
            this.allTasks.removeAll(toRemove);
            tasks.removeAll(toRemove);
            for (List list : this.group2tasks.values()) {
                list.removeAll(toRemove);
            }
        }
        return toRemove;
    }

    void update(FileTaskScanner scanner, FileObject resource, List<Task> newTasks, TaskFilter filter) {
        this.lock.writeLock().lock();
        List<Task> removed = this.clear(scanner, resource);
        ArrayList<Task> tasksToAdd = new ArrayList<Task>(newTasks.size());
        for (Task t : newTasks) {
            TaskGroup group;
            List<Task> groupTasks;
            if (this.allTasks.contains(t) || filter.isTaskCountLimitReached(this.countTasks(scanner)) || !filter.accept(t)) continue;
            List<Task> scannerTasks = this.fileScanner2tasks.get(scanner);
            if (null == scannerTasks) {
                scannerTasks = new LinkedList<Task>();
                this.fileScanner2tasks.put(scanner, scannerTasks);
            }
            if (null == (groupTasks = this.group2tasks.get(group = Accessor.getGroup(t)))) {
                groupTasks = new LinkedList<Task>();
                this.group2tasks.put(group, groupTasks);
            }
            scannerTasks.add(t);
            groupTasks.add(t);
            tasksToAdd.add(t);
            this.allTasks.add(t);
        }
        if (!tasksToAdd.isEmpty()) {
            this.sortedTasks.addAll(tasksToAdd);
            Collections.sort(this.sortedTasks, this.getComparator());
        }
        this.lock.writeLock().unlock();
        if (null != removed && !removed.isEmpty()) {
            this.fireTasksRemoved(removed);
        }
        if (!tasksToAdd.isEmpty()) {
            this.fireTasksAdded(tasksToAdd);
        }
    }

    public int size() {
        int retValue = 0;
        this.lock.readLock().lock();
        retValue = this.sortedTasks.size();
        this.lock.readLock().unlock();
        return retValue;
    }

    public List<? extends Task> getTasks() {
        return new ArrayList<Task>(this.sortedTasks);
    }

    int countTasks(FileTaskScanner scanner) {
        List<Task> tasks = this.fileScanner2tasks.get(scanner);
        return null == tasks ? 0 : tasks.size();
    }

    public int countTasks(TaskGroup group) {
        List<Task> groupTasks = this.group2tasks.get(group);
        return null == groupTasks ? 0 : groupTasks.size();
    }

    public Task getTask(int index) {
        Task retValue = null;
        this.lock.readLock().lock();
        if (index >= 0 && index < this.sortedTasks.size()) {
            retValue = this.sortedTasks.get(index);
        }
        this.lock.readLock().unlock();
        return retValue;
    }

    void clear(FileTaskScanner scanner) {
        this.lock.writeLock().lock();
        List<Task> toRemove = this.fileScanner2tasks.get(scanner);
        this.fileScanner2tasks.remove(scanner);
        if (null != toRemove) {
            for (List<Task> groupTasks : this.group2tasks.values()) {
                groupTasks.removeAll(toRemove);
            }
            this.sortedTasks.removeAll(toRemove);
            this.allTasks.removeAll(toRemove);
        }
        this.lock.writeLock().unlock();
        if (null != toRemove && !toRemove.isEmpty()) {
            this.fireTasksRemoved(toRemove);
        }
    }

    void clear(FileTaskScanner scanner, FileObject ... resources) {
        this.lock.readLock().lock();
        ArrayList<Task> toRemove = null;
        List<Task> tasks = this.fileScanner2tasks.get(scanner);
        if (null != tasks) {
            for (Task task : tasks) {
                for (FileObject rc : resources) {
                    if (!rc.equals(Accessor.getResource(task))) continue;
                    if (null == toRemove) {
                        toRemove = new ArrayList<Task>(resources.length);
                    }
                    toRemove.add(task);
                }
            }
        }
        this.lock.readLock().unlock();
        if (null != toRemove && !toRemove.isEmpty()) {
            this.lock.writeLock().lock();
            this.sortedTasks.removeAll(toRemove);
            this.allTasks.removeAll(toRemove);
            tasks.removeAll(toRemove);
            for (List list : this.group2tasks.values()) {
                list.removeAll(toRemove);
            }
            this.lock.writeLock().unlock();
            this.fireTasksRemoved(toRemove);
        }
    }

    private List<Task> clear(FileTaskScanner scanner, FileObject resource) {
        List<Task> tasks = this.fileScanner2tasks.get(scanner);
        if (null == tasks) {
            return null;
        }
        LinkedList<Task> toRemove = null;
        for (Task task : tasks) {
            if (!resource.equals(Accessor.getResource(task))) continue;
            if (null == toRemove) {
                toRemove = new LinkedList<Task>();
            }
            toRemove.add(task);
        }
        if (null != toRemove) {
            this.sortedTasks.removeAll(toRemove);
            this.allTasks.removeAll(toRemove);
            tasks.removeAll(toRemove);
            for (List list : this.group2tasks.values()) {
                list.removeAll(toRemove);
            }
        }
        return toRemove;
    }

    void clear(FileObject resource) {
        LinkedList<Task> toRemove = null;
        this.lock.writeLock().lock();
        for (List<Task> scannerTasks : this.fileScanner2tasks.values()) {
            for (Task t : scannerTasks) {
                if (!resource.equals(Accessor.getResource(t))) continue;
                if (null == toRemove) {
                    toRemove = new LinkedList<Task>();
                }
                toRemove.add(t);
            }
        }
        if (null != toRemove) {
            this.sortedTasks.removeAll(toRemove);
            this.allTasks.removeAll(toRemove);
            for (List<Task> scannerTasks : this.fileScanner2tasks.values()) {
                scannerTasks.removeAll(toRemove);
            }
            for (List<Task> groupTasks : this.group2tasks.values()) {
                groupTasks.removeAll(toRemove);
            }
        }
        this.lock.writeLock().unlock();
        if (null != toRemove) {
            this.fireTasksRemoved(toRemove);
        }
    }

    void clear() {
        this.lock.writeLock().lock();
        this.sortedTasks.clear();
        this.allTasks.clear();
        this.fileScanner2tasks.clear();
        this.pushScanner2tasks.clear();
        this.group2tasks.clear();
        this.lock.writeLock().unlock();
        this.fireCleared();
    }

    public void addListener(Listener l) {
        this.listeners.add((Object)l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove((Object)l);
    }

    public int indexOf(Task t) {
        return this.sortedTasks.indexOf(t);
    }

    private Comparator<Task> getComparator() {
        if (null == this.comparator) {
            this.comparator = TaskComparator.getDefault();
        }
        return this.comparator;
    }

    public void setComparator(Comparator<Task> comparator) {
        if (((Object)this.getComparator()).equals(comparator)) {
            return;
        }
        this.lock.writeLock().lock();
        this.comparator = comparator;
        Collections.sort(this.sortedTasks, this.getComparator());
        this.lock.writeLock().unlock();
    }

    private void fireTasksAdded(List<Task> tasks) {
        ArrayList<Listener> tmp = new ArrayList<Listener>((Collection<Listener>)this.listeners);
        Iterator<Listener> i = tmp.iterator();
        while (i.hasNext()) {
            i.next().tasksAdded(tasks);
        }
    }

    private void fireTasksRemoved(List<Task> tasks) {
        ArrayList<Listener> tmp = new ArrayList<Listener>((Collection<Listener>)this.listeners);
        Iterator<Listener> i = tmp.iterator();
        while (i.hasNext()) {
            i.next().tasksRemoved(tasks);
        }
    }

    private void fireCleared() {
        ArrayList<Listener> tmp = new ArrayList<Listener>((Collection<Listener>)this.listeners);
        Iterator<Listener> i = tmp.iterator();
        while (i.hasNext()) {
            i.next().cleared();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Listener {
        public void tasksAdded(List<? extends Task> var1);

        public void tasksRemoved(List<? extends Task> var1);

        public void cleared();
    }
}

