/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.FileScanningWorker;
import org.netbeans.modules.tasklist.impl.ScannerList;
import org.netbeans.modules.tasklist.impl.TaskCache;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.trampoline.TaskManager;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskManagerImpl
extends TaskManager {
    public static final String PROP_SCOPE = "taskScanningScope";
    public static final String PROP_FILTER = "filter";
    public static final String PROP_WORKING_STATUS = "workingStatus";
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport((Object)this);
    private FileScanningWorker worker;
    private TaskCache taskCache = new TaskCache();
    private TaskList taskList = new TaskList();
    private TaskScanningScope scope = Accessor.getEmptyScope();
    private TaskFilter filter = TaskFilter.EMPTY;
    private static TaskManagerImpl theInstance;
    private Set<PushTaskScanner> workingScanners = new HashSet<PushTaskScanner>(10);
    private boolean fileScannerWorking = false;
    private boolean workingStatus = false;
    private FileChangeListener fileListener = null;

    public static TaskManagerImpl getInstance() {
        if (null == theInstance) {
            theInstance = new TaskManagerImpl();
        }
        return theInstance;
    }

    public void observe(final TaskScanningScope newScope, final TaskFilter newFilter) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                TaskManagerImpl.this.doObserve(newScope, newFilter);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doObserve(TaskScanningScope newScope, TaskFilter newFilter) {
        TaskScanningScope oldScope = this.scope;
        TaskFilter oldFilter = this.filter;
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            if (null == newScope || Accessor.getEmptyScope().equals(newScope)) {
                this.scope.attach(null);
                this.stopWorker();
                this.listenToFileSystemChanges(this.scope, false);
                this.workingScanners.clear();
                this.fileScannerWorking = false;
                for (PushTaskScanner pushTaskScanner : ScannerList.getPushScannerList().getScanners()) {
                    pushTaskScanner.setScope(null, null);
                }
                for (FileTaskScanner fileTaskScanner : ScannerList.getFileScannerList().getScanners()) {
                    fileTaskScanner.attach(null);
                }
                this.scope = Accessor.getEmptyScope();
                this.filter = TaskFilter.EMPTY;
                this.setWorkingStatus(false);
            } else {
                if (null == newFilter) {
                    newFilter = TaskFilter.EMPTY;
                }
                if (!this.scope.equals(newScope) || !this.filter.equals(newFilter)) {
                    this.taskList.clear();
                    if (!newScope.equals(this.scope)) {
                        this.scope.attach(null);
                        newScope.attach(Accessor.createCallback((TaskManager)this, newScope));
                    }
                    this.workingScanners.clear();
                    this.fileScannerWorking = false;
                    this.setWorkingStatus(false);
                    this.scope = newScope;
                    this.filter = newFilter;
                    this.attachFileScanners(newFilter, this.filter);
                    this.attachPushScanners(newScope, newFilter, this.filter);
                    this.listenToFileSystemChanges(this.scope, true);
                    this.startWorker();
                    this.worker.scan(this.scope.iterator(), this.filter);
                }
            }
        }
        this.propertySupport.firePropertyChange(PROP_SCOPE, oldScope, newScope);
        this.propertySupport.firePropertyChange(PROP_FILTER, oldFilter, newFilter);
    }

    private void attachFileScanners(TaskFilter newFilter, TaskFilter oldFilter) {
        for (FileTaskScanner fileTaskScanner : this.getFileScanners()) {
            if (oldFilter.isEnabled(fileTaskScanner) && !newFilter.isEnabled(fileTaskScanner)) {
                fileTaskScanner.attach(null);
                continue;
            }
            if (!newFilter.isEnabled(fileTaskScanner)) continue;
            fileTaskScanner.attach(Accessor.createCallback((TaskManager)this, fileTaskScanner));
        }
    }

    private void attachPushScanners(TaskScanningScope newScope, TaskFilter newFilter, TaskFilter oldFilter) {
        for (PushTaskScanner pushTaskScanner : this.getPushScanners()) {
            if (oldFilter.isEnabled(pushTaskScanner) && !newFilter.isEnabled(pushTaskScanner)) {
                pushTaskScanner.setScope(null, null);
                continue;
            }
            if (!newFilter.isEnabled(pushTaskScanner)) continue;
            pushTaskScanner.setScope(newScope, Accessor.createCallback((TaskManager)this, pushTaskScanner));
        }
    }

    Iterable<? extends FileTaskScanner> getFileScanners() {
        return ScannerList.getFileScannerList().getScanners();
    }

    Iterable<? extends PushTaskScanner> getPushScanners() {
        return ScannerList.getPushScannerList().getScanners();
    }

    public void abort() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                TaskManagerImpl.this.doAbort();
            }
        });
    }

    private void doAbort() {
        if (null != this.worker) {
            this.worker.abort();
        }
        for (PushTaskScanner scanner : ScannerList.getPushScannerList().getScanners()) {
            scanner.setScope(null, null);
        }
        this.workingScanners.clear();
        this.fileScannerWorking = false;
        this.setWorkingStatus(false);
    }

    boolean isObserved() {
        return !Accessor.getEmptyScope().equals(this.getScope());
    }

    public TaskScanningScope getScope() {
        return this.scope;
    }

    public TaskList getTasks() {
        return this.taskList;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propName, listener);
    }

    private void startWorker() {
        if (null == this.worker) {
            this.worker = new FileScanningWorker(this.taskCache, this.taskList, this.filter, new FileScannerProgress());
            RequestProcessor.getDefault().post((Runnable)this.worker);
        }
    }

    private void stopWorker() {
        if (null != this.worker) {
            this.worker.kill();
            this.worker = null;
        }
    }

    private void maybeScanResource(final FileObject rc, final boolean clearCache) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (TaskManagerImpl.this.isObserved() && TaskManagerImpl.this.scope.isInScope(rc)) {
                    TaskManagerImpl taskManagerImpl = TaskManagerImpl.this;
                    synchronized (taskManagerImpl) {
                        if (clearCache) {
                            TaskManagerImpl.this.taskCache.clear(rc);
                            TaskManagerImpl.this.taskList.clear(rc);
                        }
                        TaskManagerImpl.this.startWorker();
                        TaskManagerImpl.this.worker.priorityScan(rc);
                    }
                }
            }
        });
    }

    private FileChangeListener getFileChangeListener() {
        if (null == this.fileListener) {
            this.fileListener = new FileChangeListener(){

                public void fileFolderCreated(FileEvent fe) {
                    TaskManagerImpl.this.maybeScanResource(fe.getFile(), false);
                }

                public void fileDataCreated(FileEvent fe) {
                    TaskManagerImpl.this.maybeScanResource(fe.getFile(), false);
                }

                public void fileChanged(FileEvent fe) {
                    FileObject rc = fe.getFile();
                    TaskManagerImpl.this.maybeScanResource(rc, true);
                }

                public void fileDeleted(final FileEvent fe) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            TaskManagerImpl taskManagerImpl = TaskManagerImpl.this;
                            synchronized (taskManagerImpl) {
                                FileObject rc = fe.getFile();
                                TaskManagerImpl.this.taskCache.clear(rc);
                                TaskManagerImpl.this.taskList.clear(rc);
                            }
                        }
                    });
                }

                public void fileRenamed(FileRenameEvent fe) {
                    TaskManagerImpl.this.maybeScanResource(fe.getFile(), false);
                }

                public void fileAttributeChanged(FileAttributeEvent fe) {
                }
            };
        }
        return this.fileListener;
    }

    private void listenToFileSystemChanges(TaskScanningScope scanningScope, boolean addListener) {
        FileSystem fs = this.getFileSystem(scanningScope);
        if (null != fs) {
            if (addListener) {
                fs.addFileChangeListener(this.getFileChangeListener());
            } else if (null != this.fileListener) {
                fs.removeFileChangeListener(this.getFileChangeListener());
                this.fileListener = null;
            }
        }
    }

    private FileSystem getFileSystem(TaskScanningScope scanningScope) {
        Iterator resources;
        if (null != scanningScope && (resources = scanningScope.iterator()).hasNext()) {
            try {
                FileObject rc = (FileObject)resources.next();
                if (null != rc) {
                    return rc.getFileSystem();
                }
            }
            catch (FileStateInvalidException fsiE) {
                this.getLogger().log(Level.WARNING, fsiE.getMessage(), fsiE);
            }
        }
        return null;
    }

    public TaskFilter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(final FileTaskScanner scanner, FileObject ... resources) {
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            this.taskCache.clear(scanner, resources);
            this.taskList.clear(scanner, resources);
            if (this.isObserved() && this.isEnabled(scanner)) {
                final ArrayList<FileObject> resourcesInScope = new ArrayList<FileObject>(resources.length);
                for (int i = 0; i < resources.length && null != this.scope; ++i) {
                    if (!this.scope.isInScope(resources[i])) continue;
                    resourcesInScope.add(resources[i]);
                }
                if (!resourcesInScope.isEmpty()) {
                    Runnable r = new Runnable(){

                        public void run() {
                            TaskManagerImpl.this.startWorker();
                            TaskManagerImpl.this.worker.priorityScan(scanner, resourcesInScope.toArray(new FileObject[resourcesInScope.size()]));
                        }
                    };
                    RequestProcessor.getDefault().post(r);
                }
            }
        }
    }

    private boolean isEnabled(FileTaskScanner scanner) {
        return this.getFilter().isEnabled(scanner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(FileTaskScanner scanner) {
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            this.taskCache.clear(scanner);
            this.taskList.clear(scanner);
            if (this.isObserved() && this.isEnabled(scanner)) {
                Runnable r = new Runnable(){

                    public void run() {
                        TaskManagerImpl.this.startWorker();
                        TaskManagerImpl.this.worker.scan(TaskManagerImpl.this.scope.iterator(), TaskManagerImpl.this.filter);
                    }
                };
                RequestProcessor.getDefault().post(r);
            }
        }
    }

    public void refresh(final TaskScanningScope scopeToRefresh) {
        if (this.scope.equals(scopeToRefresh)) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    TaskManagerImpl.this.doRefresh(scopeToRefresh);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefresh(TaskScanningScope scopeToRefresh) {
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            if (this.scope.equals(scopeToRefresh)) {
                this.listenToFileSystemChanges(this.scope, false);
                this.listenToFileSystemChanges(this.scope, true);
                this.taskList.clear();
                if (this.isObserved()) {
                    for (PushTaskScanner scanner : ScannerList.getPushScannerList().getScanners()) {
                        scanner.setScope(null, null);
                        if (!this.getFilter().isEnabled(scanner)) continue;
                        scanner.setScope(scopeToRefresh, Accessor.createCallback((TaskManager)this, scanner));
                    }
                    this.startWorker();
                    this.worker.scan(this.scope.iterator(), this.filter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started(PushTaskScanner scanner) {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            this.workingScanners.add(scanner);
            this.setWorkingStatus(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(PushTaskScanner scanner) {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            this.workingScanners.remove(scanner);
            this.setWorkingStatus(this.isWorking());
        }
    }

    public void setTasks(PushTaskScanner scanner, FileObject resource, List<? extends Task> tasks) {
        if (this.isObserved() && this.scope.isInScope(resource)) {
            this.taskList.setTasks(scanner, resource, tasks, this.filter);
        }
    }

    public void clearAllTasks(PushTaskScanner scanner) {
        this.taskList.clear(scanner);
    }

    private Logger getLogger() {
        return Logger.getLogger(TaskManagerImpl.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWorkingStatus(boolean newStatus) {
        if (newStatus != this.workingStatus) {
            boolean oldStatus = this.workingStatus;
            this.workingStatus = newStatus;
            this.propertySupport.firePropertyChange(PROP_WORKING_STATUS, oldStatus, newStatus);
            if (!this.workingStatus) {
                Set<PushTaskScanner> set = this.workingScanners;
                synchronized (set) {
                    this.workingScanners.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWorking() {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            return !this.workingScanners.isEmpty() || this.fileScannerWorking;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitFinished() {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            try {
                this.workingScanners.wait();
            }
            catch (InterruptedException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    class FileScannerProgress {
        FileScannerProgress() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void started() {
            Set set = TaskManagerImpl.this.workingScanners;
            synchronized (set) {
                TaskManagerImpl.this.fileScannerWorking = true;
                TaskManagerImpl.this.setWorkingStatus(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            Set set = TaskManagerImpl.this.workingScanners;
            synchronized (set) {
                TaskManagerImpl.this.fileScannerWorking = false;
                TaskManagerImpl.this.setWorkingStatus(TaskManagerImpl.this.isWorking());
            }
        }
    }
}

