/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.TaskComparator;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.modules.tasklist.ui.Settings;
import org.netbeans.modules.tasklist.ui.TaskListModel;
import org.netbeans.spi.tasklist.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FoldingTaskListModel
extends TaskListModel {
    private LinkedList<FoldingGroup> groups = new LinkedList();
    private HashMap<String, FoldingGroup> groupMap = new HashMap(10);

    public FoldingTaskListModel(TaskList taskList) {
        super(taskList);
        this.sortTaskList();
        this.tasksAdded(taskList.getTasks());
    }

    @Override
    public int getRowCount() {
        if (null == this.list) {
            return 0;
        }
        int count = 0;
        for (FoldingGroup g : this.groups) {
            count += g.getRowCount();
        }
        return count;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (0 == column) {
            return FoldingGroup.class;
        }
        return super.getColumnClass(column);
    }

    @Override
    protected Task getTaskAtRow(int row) {
        if (this.isGroupRow(row)) {
            return null;
        }
        int groupRow = 0;
        for (FoldingGroup g : this.groups) {
            if (row < groupRow + g.getRowCount()) {
                return g.getTaskAt(row - groupRow - 1);
            }
            groupRow += g.getRowCount();
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int col) {
        FoldingGroup group = this.getGroupAtRow(row);
        if (null != group) {
            switch (col) {
                case 0: {
                    return group;
                }
            }
            return null;
        }
        return super.getValueAt(row, col);
    }

    FoldingGroup getGroupAtRow(int row) {
        int groupRow = 0;
        for (FoldingGroup g : this.groups) {
            if (g.isEmpty()) continue;
            if (row == groupRow) {
                return g;
            }
            groupRow += g.getRowCount();
        }
        return null;
    }

    private Map<FoldingGroup, List<Task>> divideByGroup(List<? extends Task> tasks) {
        HashMap<FoldingGroup, List<Task>> grouppedTasksMap = new HashMap<FoldingGroup, List<Task>>(this.groupMap.size());
        for (Task task : tasks) {
            LinkedList<Task> tasksInGroup;
            TaskGroup tg = Accessor.getGroup(task);
            FoldingGroup group = this.groupMap.get(tg.getName());
            if (null == group) {
                group = new FoldingGroup(tg);
                this.groupMap.put(tg.getName(), group);
                this.groups.add(group);
                Collections.sort(this.groups);
            }
            if (null == (tasksInGroup = (LinkedList<Task>)grouppedTasksMap.get(group))) {
                tasksInGroup = new LinkedList<Task>();
                grouppedTasksMap.put(group, tasksInGroup);
            }
            tasksInGroup.add(task);
        }
        return grouppedTasksMap;
    }

    @Override
    public void tasksAdded(List<? extends Task> tasks) {
        if (tasks.isEmpty()) {
            return;
        }
        Map<FoldingGroup, List<Task>> grouppedTasksMap = this.divideByGroup(tasks);
        for (FoldingGroup fg : grouppedTasksMap.keySet()) {
            List<Task> tasksInGroup = grouppedTasksMap.get(fg);
            fg.add(tasksInGroup);
        }
    }

    @Override
    public void tasksRemoved(List<? extends Task> tasks) {
        if (tasks.isEmpty()) {
            return;
        }
        Map<FoldingGroup, List<Task>> grouppedTasksMap = this.divideByGroup(tasks);
        for (FoldingGroup fg : grouppedTasksMap.keySet()) {
            List<Task> tasksInGroup = grouppedTasksMap.get(fg);
            fg.remove(tasksInGroup);
        }
    }

    @Override
    public void cleared() {
        for (FoldingGroup fg : this.groups) {
            fg.clear();
        }
    }

    public boolean isGroupRow(int row) {
        return null != this.getGroupAtRow(row);
    }

    public void toggleGroupExpanded(int row) {
        FoldingGroup fg = this.getGroupAtRow(row);
        if (null != fg) {
            fg.toggleExpanded();
        }
    }

    private int getFoldingGroupStartingRow(FoldingGroup fg) {
        if (fg.isEmpty()) {
            return -1;
        }
        int startingRow = 0;
        int groupIndex = this.groups.indexOf(fg);
        for (int i = 0; i < groupIndex; ++i) {
            startingRow += this.groups.get(i).getRowCount();
        }
        return startingRow;
    }

    @Override
    protected void sortTaskList() {
        Comparator<Task> comparator = null;
        switch (this.sortingCol) {
            case 1: {
                comparator = TaskComparator.getDescriptionComparator(this.ascending);
                break;
            }
            case 3: {
                comparator = TaskComparator.getLineComparator(this.ascending);
                break;
            }
            case 4: {
                comparator = TaskComparator.getLocationComparator(this.ascending);
                break;
            }
            case 2: {
                comparator = TaskComparator.getFileComparator(this.ascending);
                break;
            }
            default: {
                comparator = TaskComparator.getDefault();
            }
        }
        if (null != this.groups) {
            for (FoldingGroup fg : this.groups) {
                fg.setComparator(comparator);
            }
            Settings.getDefault().setSortingColumn(this.sortingCol);
            Settings.getDefault().setAscendingSort(this.ascending);
        }
        this.fireTableDataChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FoldingGroup
    implements Comparable<FoldingGroup> {
        private TaskGroup tg;
        private ArrayList<Task> tasks = new ArrayList(100);
        private boolean isExpanded;
        private Comparator<Task> comparator;

        public FoldingGroup(TaskGroup tg) {
            this.tg = tg;
            this.isExpanded = Settings.getDefault().isGroupExpanded(tg.getName());
        }

        public void add(List<Task> newTasks) {
            boolean wasEmpty = this.isEmpty();
            this.tasks.addAll(newTasks);
            Collections.sort(this.tasks, this.getComparator());
            int startingRow = FoldingTaskListModel.this.getFoldingGroupStartingRow(this);
            if (wasEmpty) {
                FoldingTaskListModel.this.fireTableRowsInserted(startingRow, startingRow + this.getRowCount());
            } else {
                if (this.isExpanded) {
                    int firstRow = Integer.MAX_VALUE;
                    int lastRow = Integer.MIN_VALUE;
                    for (Task t : newTasks) {
                        int index = this.tasks.indexOf(t);
                        if (index < firstRow) {
                            firstRow = index;
                        }
                        if (index <= lastRow) continue;
                        lastRow = index;
                    }
                    FoldingTaskListModel.this.fireTableRowsInserted(firstRow + startingRow + 1, lastRow + startingRow + 1);
                }
                FoldingTaskListModel.this.fireTableCellUpdated(startingRow, 1);
            }
        }

        public void remove(List<Task> removedTasks) {
            int firstRow = Integer.MAX_VALUE;
            int lastRow = Integer.MIN_VALUE;
            int rowCount = this.getRowCount();
            if (this.isExpanded) {
                for (Task t : removedTasks) {
                    int index = this.tasks.indexOf(t);
                    if (index < firstRow) {
                        firstRow = index;
                    }
                    if (index <= lastRow) continue;
                    lastRow = index;
                }
            }
            this.tasks.removeAll(removedTasks);
            int startingRow = FoldingTaskListModel.this.getFoldingGroupStartingRow(this);
            if (this.isEmpty()) {
                FoldingTaskListModel.this.fireTableRowsDeleted(startingRow, startingRow + rowCount);
            } else {
                if (this.isExpanded) {
                    FoldingTaskListModel.this.fireTableRowsDeleted(firstRow + startingRow + 1, lastRow + startingRow + 1);
                }
                FoldingTaskListModel.this.fireTableCellUpdated(startingRow, 1);
            }
        }

        public void clear() {
            if (this.isEmpty()) {
                return;
            }
            int rowCount = this.getRowCount();
            int startingRow = FoldingTaskListModel.this.getFoldingGroupStartingRow(this);
            this.tasks.clear();
            FoldingTaskListModel.this.fireTableRowsDeleted(startingRow, startingRow + rowCount);
        }

        public boolean isEmpty() {
            return this.tasks.isEmpty();
        }

        public void setExpanded(boolean expand) {
            if (this.isExpanded == expand) {
                return;
            }
            this.toggleExpanded();
        }

        public void toggleExpanded() {
            this.isExpanded = !this.isExpanded;
            Settings.getDefault().setGroupExpanded(this.tg.getName(), this.isExpanded);
            int firstRow = 0;
            int groupIndex = FoldingTaskListModel.this.groups.indexOf(this);
            for (int i = 0; i < groupIndex; ++i) {
                firstRow += ((FoldingGroup)FoldingTaskListModel.this.groups.get(i)).getRowCount();
            }
            int lastRow = firstRow + this.getTaskCount();
            ++firstRow;
            if (this.isExpanded) {
                FoldingTaskListModel.this.fireTableRowsInserted(firstRow, lastRow);
            } else {
                FoldingTaskListModel.this.fireTableRowsDeleted(firstRow, lastRow);
            }
            FoldingTaskListModel.this.fireTableCellUpdated(firstRow - 1, 0);
        }

        public int getRowCount() {
            return this.isEmpty() ? 0 : (this.isExpanded ? 1 + this.tasks.size() : 1);
        }

        public int getTaskCount() {
            return this.tasks.size();
        }

        public Task getTaskAt(int index) {
            return this.tasks.get(index);
        }

        @Override
        public int compareTo(FoldingGroup other) {
            List groupList = TaskGroup.getGroups();
            int myIndex = groupList.indexOf(this.tg);
            int otherIndex = groupList.indexOf(other.tg);
            return myIndex - otherIndex;
        }

        public boolean isExpanded() {
            return this.isExpanded;
        }

        public TaskGroup getGroup() {
            return this.tg;
        }

        private Comparator<Task> getComparator() {
            if (null == this.comparator) {
                this.comparator = TaskComparator.getDefault();
            }
            return this.comparator;
        }

        private void setComparator(Comparator<Task> newComparator) {
            if (((Object)this.getComparator()).equals(newComparator)) {
                return;
            }
            this.comparator = newComparator;
            if (!this.tasks.isEmpty()) {
                Collections.sort(this.tasks, this.getComparator());
                if (this.isExpanded()) {
                    int firstRow = 0;
                    int groupIndex = FoldingTaskListModel.this.groups.indexOf(this);
                    for (int i = 0; i < groupIndex; ++i) {
                        firstRow += ((FoldingGroup)FoldingTaskListModel.this.groups.get(i)).getRowCount();
                    }
                    int lastRow = firstRow + this.getTaskCount();
                    FoldingTaskListModel.this.fireTableRowsUpdated(++firstRow, lastRow);
                }
            }
        }
    }
}

