/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.BindingDescriptor;
import org.netbeans.modules.form.BindingDesignSupport;
import org.netbeans.modules.form.BindingProperty;
import org.netbeans.modules.form.ComboBoxWithTree;
import org.netbeans.modules.form.DataImporter;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.ListSelector;
import org.netbeans.modules.form.MetaBinding;
import org.netbeans.modules.form.RADComponent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class BindingCustomizer
extends JPanel {
    private BindingDesignSupport designSupport;
    private RADComponent bindingComponent;
    private BindingDescriptor bindingDescriptor;
    private MetaBinding binding;
    private RADComponent selectedComponent;
    private List<RADComponent> allComponents;
    private FormProperty nullValueProperty;
    private FormProperty incompletePathValueProperty;
    private FormProperty converterProperty;
    private FormProperty validatorProperty;
    private FormProperty.ValueWithEditor oldNullValue;
    private FormProperty.ValueWithEditor oldIncompletePathValue;
    private FormProperty.ValueWithEditor oldConverter;
    private FormProperty.ValueWithEditor oldValidator;
    private ComboBoxWithTree expressionCombo;
    private ComboBoxWithTree displayExpressionCombo;
    private ListSelector columnSelector;
    private DefaultTreeModel expressionModel = new DefaultTreeModel(new DefaultMutableTreeNode(null, false));
    private DefaultTreeModel displayExpressionModel = new DefaultTreeModel(new DefaultMutableTreeNode(null, false));
    private Dialog dialog;
    private ActionListener dialogListener;
    private JButton okButton;
    private JButton cancelButton;
    private PropertyChangeSupport typeChangeSupport = new PropertyChangeSupport(this);
    JPanel advancedPanel;
    JPanel bindingPanel;
    JLabel conversionLabel;
    JLabel converterLabel;
    JLabel converterMessage;
    PropertyPanel converterPanel;
    JPanel detailPanel;
    JLabel displayExpressionLabel;
    JLabel displayValuesLabel;
    JLabel expressionLabel;
    JButton importDataButton;
    JCheckBox incompletePathValueCheckBox;
    PropertyPanel incompletePathValuePanel;
    JLabel infoLabel;
    JCheckBox nullValueCheckBox;
    PropertyPanel nullValuePanel;
    JComboBox sourceCombo;
    JLabel sourceLabel;
    JLabel specialValuesLabel;
    JTabbedPane tabbedPane;
    JComboBox treeCombo;
    JComboBox treeCombo2;
    JLabel updateLabel;
    JComboBox updateModeCombo;
    JLabel updateModeLabel;
    JLabel updatePropertiesLabel;
    JComboBox updateWhenCombo;
    JLabel updateWhenLabel;
    JLabel validationLabel;
    JLabel validatorLabel;
    JLabel validatorMessage;
    PropertyPanel validatorPanel;

    public BindingCustomizer(BindingProperty property) {
        this.bindingComponent = property.getBindingComponent();
        this.bindingDescriptor = property.getBindingDescriptor();
        this.designSupport = FormEditor.getBindingSupport(this.bindingComponent.getFormModel());
        this.initExpressionCombo();
        this.initComponents();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(FormUtils.getBundleString("MSG_BindingCustomizer_UpdateMode1"));
        model.addElement(FormUtils.getBundleString("MSG_BindingCustomizer_UpdateMode2"));
        model.addElement(FormUtils.getBundleString("MSG_BindingCustomizer_UpdateMode3"));
        this.updateModeCombo.setModel(model);
        boolean showUpdateWhen = this.showUpdateWhen();
        this.updateWhenLabel.setVisible(showUpdateWhen);
        this.updateWhenCombo.setVisible(showUpdateWhen);
        if (showUpdateWhen) {
            model = new DefaultComboBoxModel();
            model.addElement(FormUtils.getBundleString("MSG_BindingCustomizer_UpdateWhen1"));
            model.addElement(FormUtils.getBundleString("MSG_BindingCustomizer_UpdateWhen2"));
            model.addElement(FormUtils.getBundleString("MSG_BindingCustomizer_UpdateWhen3"));
            this.updateWhenCombo.setModel(model);
        }
        this.importDataButton.setVisible(this.showImportData());
        if (this.showColumnSelector()) {
            this.columnSelector = new ListSelector();
            ((GroupLayout)this.bindingPanel.getLayout()).replace((Component)this.detailPanel, (Component)this.columnSelector);
        }
        boolean showDisplayExpression = this.showDisplayExpression();
        this.displayExpressionLabel.setVisible(showDisplayExpression);
        this.displayExpressionCombo.setVisible(showDisplayExpression);
        this.nullValueProperty = property.getNullValueProperty();
        if (this.nullValueProperty != null) {
            this.nullValuePanel.setProperty((Node.Property)this.nullValueProperty);
        }
        this.incompletePathValueProperty = property.getIncompleteValueProperty();
        if (this.incompletePathValueProperty != null) {
            this.incompletePathValuePanel.setProperty((Node.Property)this.incompletePathValueProperty);
        }
        this.converterProperty = property.getConverterProperty();
        if (this.converterProperty != null) {
            this.converterPanel.setProperty((Node.Property)this.converterProperty);
        }
        this.validatorProperty = property.getValidatorProperty();
        if (this.validatorProperty != null) {
            this.validatorPanel.setProperty((Node.Property)this.validatorProperty);
        }
        this.updatePropertiesLabel.setMinimumSize(this.updatePropertiesLabel.getPreferredSize());
        this.conversionLabel.setMinimumSize(this.conversionLabel.getPreferredSize());
        this.validatorLabel.setMinimumSize(this.validatorLabel.getPreferredSize());
        this.specialValuesLabel.setMinimumSize(this.specialValuesLabel.getPreferredSize());
        this.updatePropertiesLabel.setMaximumSize(this.updatePropertiesLabel.getPreferredSize());
        this.conversionLabel.setMaximumSize(this.conversionLabel.getPreferredSize());
        this.validatorLabel.setMaximumSize(this.validatorLabel.getPreferredSize());
        this.specialValuesLabel.setMaximumSize(this.specialValuesLabel.getPreferredSize());
    }

    private boolean showUpdateWhen() {
        String path = this.bindingDescriptor.getPath();
        return "text".equals(path) && JTextComponent.class.isAssignableFrom(this.bindingComponent.getBeanClass());
    }

    private boolean showImportData() {
        String path = this.bindingDescriptor.getPath();
        Class clazz = this.bindingComponent.getBeanClass();
        return "elements".equals(path) && (JList.class.isAssignableFrom(clazz) || JComboBox.class.isAssignableFrom(clazz) || JTable.class.isAssignableFrom(clazz)) && Lookup.getDefault().lookup(DataImporter.class) != null;
    }

    private boolean showDisplayExpression() {
        String path = this.bindingDescriptor.getPath();
        Class clazz = this.bindingComponent.getBeanClass();
        return "elements".equals(path) && (JList.class.isAssignableFrom(clazz) || JComboBox.class.isAssignableFrom(clazz));
    }

    private boolean showColumnSelector() {
        return "elements".equals(this.bindingDescriptor.getPath()) && JTable.class.isAssignableFrom(this.bindingComponent.getBeanClass());
    }

    public MetaBinding getBinding() {
        return this.binding;
    }

    public void setBinding(MetaBinding binding) {
        this.binding = binding;
        String info = MessageFormat.format(this.infoLabel.getText(), this.bindingComponent.getName(), this.bindingDescriptor.getPath(), this.bindingDescriptor.getValueType().getName());
        this.infoLabel.setText(info);
        this.setBindingToUI();
    }

    public Dialog getDialog(ActionListener listener) {
        if (this.dialog == null) {
            ResourceBundle bundle = NbBundle.getBundle(BindingCustomizer.class);
            this.initButtons(bundle);
            String pattern = bundle.getString("MSG_BindingCustomizer_Binding");
            String title = MessageFormat.format(pattern, this.bindingComponent.getName(), this.bindingDescriptor.getPath());
            DialogDescriptor dd = new DialogDescriptor((Object)this, title, true, (Object[])new JButton[]{this.okButton, this.cancelButton}, (Object)this.okButton, 0, HelpCtx.DEFAULT_HELP, null);
            dd.setClosingOptions((Object[])new JButton[]{this.okButton, this.cancelButton});
            this.dialog = DialogDisplayer.getDefault().createDialog(dd);
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent e) {
                    this.restore(BindingCustomizer.this.nullValueProperty, BindingCustomizer.this.oldNullValue);
                    this.restore(BindingCustomizer.this.incompletePathValueProperty, BindingCustomizer.this.oldIncompletePathValue);
                    this.restore(BindingCustomizer.this.converterProperty, BindingCustomizer.this.oldConverter);
                    this.restore(BindingCustomizer.this.validatorProperty, BindingCustomizer.this.oldValidator);
                }

                private void restore(FormProperty property, Object value) {
                    if (value != null) {
                        try {
                            property.setValue(value);
                        }
                        catch (IllegalAccessException iaex) {
                            iaex.printStackTrace();
                        }
                        catch (InvocationTargetException itex) {
                            itex.printStackTrace();
                        }
                    }
                }
            });
        }
        this.dialogListener = listener;
        this.updatePropertyPanels();
        return this.dialog;
    }

    public JComponent getBindingPanel() {
        this.infoLabel.setVisible(false);
        if (this.columnSelector.getParent() != null) {
            this.detailPanel.setVisible(false);
            ((GroupLayout)this.bindingPanel.getLayout()).replace((Component)this.columnSelector, (Component)this.detailPanel);
        }
        return this.bindingPanel;
    }

    public ComboBoxWithTree getSubExpressionCombo() {
        return this.displayExpressionCombo;
    }

    public TreeModel getSubExpressionModel() {
        return this.displayExpressionModel;
    }

    private void initButtons(ResourceBundle bundle) {
        this.okButton = new JButton(bundle.getString("MSG_BindingCustomizer_OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (BindingCustomizer.this.getBindingFromUI()) {
                    BindingCustomizer.this.oldNullValue = null;
                    BindingCustomizer.this.oldIncompletePathValue = null;
                    BindingCustomizer.this.oldConverter = null;
                    BindingCustomizer.this.oldValidator = null;
                    if (BindingCustomizer.this.dialogListener != null) {
                        BindingCustomizer.this.dialogListener.actionPerformed(ev);
                    }
                }
            }
        });
        this.cancelButton = new JButton(bundle.getString("MSG_BindingCustomizer_Cancel"));
    }

    private FormModel getFormModel() {
        return this.bindingComponent.getFormModel();
    }

    private void setBindingToUI() {
        this.fillSourceComponentsCombo();
        if (this.binding != null) {
            int index = this.allComponents.indexOf(this.binding.getSource());
            if (index >= 0) {
                this.sourceCombo.setSelectedIndex(index + 1);
                this.setSelectedComponent(this.binding.getSource());
                String sourcePath = this.binding.getSourcePath();
                this.expressionCombo.setSelectedItem(sourcePath == null ? "null" : sourcePath);
            }
            this.updateModeCombo.setSelectedIndex(this.binding.getUpdateStratedy());
            if (this.showUpdateWhen()) {
                int updateWhen = 0;
                String value = this.binding.getParameter("javax.swing.binding.SwingBindingSupport.TextChangeStrategyParameter");
                if ("javax.swing.binding.SwingBindingSupport.TextChangeStrategy.CHANGE_ON_ACTION_OR_FOCUS_LOST".equals(value)) {
                    updateWhen = 0;
                } else if ("javax.swing.binding.SwingBindingSupport.TextChangeStrategy.CHANGE_ON_FOCUS_LOST".equals(value)) {
                    updateWhen = 1;
                } else if ("javax.swing.binding.SwingBindingSupport.TextChangeStrategy.CHANGE_ON_TYPE".equals(value)) {
                    updateWhen = 2;
                }
                this.updateWhenCombo.setSelectedIndex(updateWhen);
            }
            if (this.showDisplayExpression()) {
                String subPath = null;
                if (this.binding.hasSubBindings()) {
                    MetaBinding subBinding = this.binding.getSubBindings().iterator().next();
                    subPath = subBinding.getSourcePath();
                }
                this.displayExpressionCombo.setSelectedItem(subPath == null ? "null" : subPath);
            }
            this.updateColumnSelector();
            if (this.columnSelector != null && this.binding.hasSubBindings()) {
                TreeMap<Integer, String> columns = new TreeMap<Integer, String>();
                for (MetaBinding subBinding : this.binding.getSubBindings()) {
                    String value = subBinding.getParameter("javax.swing.binding.SwingBindingSupport.TableColumnParameter");
                    if (value == null) continue;
                    columns.put(new Integer(value.toString()), subBinding.getSourcePath());
                }
                LinkedList available = new LinkedList(this.columnSelector.getSelectedItems());
                LinkedList<String> selected = new LinkedList<String>();
                Iterator iter = columns.values().iterator();
                while (iter.hasNext()) {
                    String column = iter.next().toString();
                    if (!available.contains(column = BindingDesignSupport.unwrapSimpleExpression(column))) continue;
                    selected.add(column);
                    available.remove(column);
                }
                this.columnSelector.setItems(available, selected);
            }
            this.nullValueCheckBox.setSelected(this.binding.isNullValueSpecified());
            this.incompletePathValueCheckBox.setSelected(this.binding.isIncompletePathValueSpecified());
            if (this.binding.isNullValueSpecified()) {
                this.oldNullValue = this.propertyValue(this.nullValueProperty);
            }
            if (this.binding.isIncompletePathValueSpecified()) {
                this.oldIncompletePathValue = this.propertyValue(this.incompletePathValueProperty);
            }
            if (this.binding.isConverterSpecified()) {
                this.oldConverter = this.propertyValue(this.converterProperty);
            }
            if (this.binding.isValidatorSpecified()) {
                this.oldValidator = this.propertyValue(this.validatorProperty);
            }
        } else {
            this.sourceCombo.setSelectedIndex(0);
            this.updateModeCombo.setSelectedIndex(0);
            if (this.showUpdateWhen()) {
                this.updateWhenCombo.setSelectedIndex(0);
            }
            this.nullValueCheckBox.setSelected(false);
            this.incompletePathValueCheckBox.setSelected(false);
            this.oldNullValue = null;
            this.oldIncompletePathValue = null;
            this.oldConverter = null;
            this.oldValidator = null;
        }
        this.updatePropertyPanels();
    }

    private void updatePropertyPanels() {
        if (this.binding != null) {
            this.nullValuePanel.setEnabled(this.nullValueCheckBox.isSelected());
            this.incompletePathValuePanel.setEnabled(this.incompletePathValueCheckBox.isSelected());
        } else {
            this.nullValuePanel.setEnabled(false);
            this.incompletePathValuePanel.setEnabled(false);
        }
    }

    private FormProperty.ValueWithEditor propertyValue(FormProperty property) {
        FormProperty.ValueWithEditor value = null;
        try {
            value = new FormProperty.ValueWithEditor(property.getValue(), property.getCurrentEditor());
        }
        catch (IllegalAccessException iaex) {
            iaex.printStackTrace();
        }
        catch (InvocationTargetException itex) {
            itex.printStackTrace();
        }
        return value;
    }

    private void fillSourceComponentsCombo() {
        FormModel formModel = this.getFormModel();
        List<RADComponent> nonvisualList = formModel.getNonVisualComponents();
        List<RADComponent> visualList = formModel.getVisualComponents();
        RADComponent topcomp = formModel.getTopRADComponent();
        nonvisualList.remove(topcomp);
        visualList.remove(topcomp);
        RADComponentComparator c = new RADComponentComparator();
        Collections.sort(nonvisualList, c);
        Collections.sort(visualList, c);
        this.allComponents = new ArrayList<RADComponent>(nonvisualList.size() + visualList.size() + 1);
        this.allComponents.addAll(nonvisualList);
        this.allComponents.addAll(visualList);
        this.allComponents.add(topcomp);
        this.sourceCombo.removeAllItems();
        String select = NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_None");
        this.sourceCombo.addItem(select);
        for (RADComponent metacomp : this.allComponents) {
            this.sourceCombo.addItem(metacomp.getName());
        }
    }

    private void setSelectedComponent(RADComponent metacomp) {
        if (metacomp != this.selectedComponent) {
            this.selectedComponent = metacomp;
        }
    }

    public boolean getBindingFromUI() {
        if (this.selectedComponent != null) {
            String sourcePath = this.expressionCombo.getSelectedItem().toString();
            if ("null".equals(sourcePath)) {
                sourcePath = null;
            }
            this.binding = new MetaBinding(this.selectedComponent, sourcePath, this.bindingComponent, this.bindingDescriptor.getPath());
            this.binding.setNullValueSpecified(this.nullValueCheckBox.isSelected());
            this.binding.setIncompletePathValueSpecified(this.incompletePathValueCheckBox.isSelected());
            this.binding.setUpdateStrategy(this.updateModeCombo.getSelectedIndex());
            if (this.showUpdateWhen()) {
                int index = this.updateWhenCombo.getSelectedIndex();
                String updateWhen = null;
                switch (index) {
                    case 0: {
                        updateWhen = null;
                        break;
                    }
                    case 1: {
                        updateWhen = "javax.swing.binding.SwingBindingSupport.TextChangeStrategy.CHANGE_ON_FOCUS_LOST";
                        break;
                    }
                    case 2: {
                        updateWhen = "javax.swing.binding.SwingBindingSupport.TextChangeStrategy.CHANGE_ON_TYPE";
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                this.binding.setParameter("javax.swing.binding.SwingBindingSupport.TextChangeStrategyParameter", updateWhen);
            }
            if (this.showDisplayExpression()) {
                String displayExpression = this.displayExpressionCombo.getSelectedItem().toString();
                if ("null".equals(displayExpression)) {
                    displayExpression = null;
                }
                if (displayExpression != null) {
                    this.binding.addSubBinding(displayExpression, null);
                }
            }
            if (this.columnSelector != null && this.columnSelector.isVisible()) {
                this.binding.setBindImmediately(true);
                List items = this.columnSelector.getSelectedItems();
                for (int i = 0; i < items.size(); ++i) {
                    MetaBinding subBinding = this.binding.addSubBinding(BindingDesignSupport.elWrap(items.get(i).toString()), null);
                    subBinding.setParameter("javax.swing.binding.SwingBindingSupport.TableColumnParameter", i + "");
                }
            }
        } else {
            this.binding = null;
        }
        return true;
    }

    private void initExpressionCombo() {
        TreeComboRenderer renderer = new TreeComboRenderer(FormUtils.getBundleString("MSG_BindingCustomizer_NullExpression"));
        this.expressionCombo = new ComboBoxWithTree(this.expressionModel, renderer, new Converter(this.expressionModel));
        this.expressionCombo.setSelectedItem("null");
        renderer = new TreeComboRenderer(FormUtils.getBundleString("MSG_BindingCustomizer_NullDisplayExpression"));
        this.displayExpressionCombo = new ComboBoxWithTree(this.displayExpressionModel, renderer, new Converter(this.displayExpressionModel));
        this.displayExpressionCombo.setSelectedItem("null");
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.bindingPanel = new JPanel();
        this.infoLabel = new JLabel();
        this.sourceLabel = new JLabel();
        this.sourceCombo = new JComboBox();
        this.expressionLabel = new JLabel();
        this.treeCombo = this.expressionCombo;
        this.importDataButton = new JButton();
        this.displayExpressionLabel = new JLabel();
        this.treeCombo2 = this.displayExpressionCombo;
        this.detailPanel = new JPanel();
        this.advancedPanel = new JPanel();
        this.updatePropertiesLabel = new JLabel();
        this.updateModeLabel = new JLabel();
        this.updateModeCombo = new JComboBox();
        this.updateWhenLabel = new JLabel();
        this.updateWhenCombo = new JComboBox();
        this.nullValuePanel = new PropertyPanel();
        this.incompletePathValuePanel = new PropertyPanel();
        this.nullValueCheckBox = new JCheckBox();
        this.displayValuesLabel = new JLabel();
        this.incompletePathValueCheckBox = new JCheckBox();
        this.conversionLabel = new JLabel();
        this.validationLabel = new JLabel();
        this.validatorLabel = new JLabel();
        this.converterLabel = new JLabel();
        this.converterPanel = new PropertyPanel();
        this.validatorPanel = new PropertyPanel();
        this.specialValuesLabel = new JLabel();
        this.updateLabel = new JLabel();
        this.converterMessage = new JLabel();
        this.validatorMessage = new JLabel();
        FormListener formListener = new FormListener();
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Bind"));
        Mnemonics.setLocalizedText((JLabel)this.sourceLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Source"));
        this.sourceCombo.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.expressionLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Expression"));
        this.treeCombo.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.importDataButton, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_ImportData"));
        this.importDataButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.displayExpressionLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_DisplayExpression"));
        GroupLayout detailPanelLayout = new GroupLayout((Container)this.detailPanel);
        this.detailPanel.setLayout((LayoutManager)detailPanelLayout);
        detailPanelLayout.setHorizontalGroup((GroupLayout.Group)detailPanelLayout.createParallelGroup(1).add(0, 452, Short.MAX_VALUE));
        detailPanelLayout.setVerticalGroup((GroupLayout.Group)detailPanelLayout.createParallelGroup(1).add(0, 228, Short.MAX_VALUE));
        GroupLayout bindingPanelLayout = new GroupLayout((Container)this.bindingPanel);
        this.bindingPanel.setLayout((LayoutManager)bindingPanelLayout);
        bindingPanelLayout.setHorizontalGroup((GroupLayout.Group)bindingPanelLayout.createParallelGroup(1).add((GroupLayout.Group)bindingPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)bindingPanelLayout.createParallelGroup(1).add((Component)this.detailPanel, -1, -1, Short.MAX_VALUE).add((Component)this.infoLabel).add((GroupLayout.Group)bindingPanelLayout.createSequentialGroup().add((GroupLayout.Group)bindingPanelLayout.createParallelGroup(1).add((Component)this.expressionLabel).add((Component)this.sourceLabel)).addPreferredGap(0).add((GroupLayout.Group)bindingPanelLayout.createParallelGroup(1).add((GroupLayout.Group)bindingPanelLayout.createSequentialGroup().add((Component)this.sourceCombo, 0, 204, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.importDataButton)).add((Component)this.treeCombo, 0, 355, Short.MAX_VALUE))).add((GroupLayout.Group)bindingPanelLayout.createSequentialGroup().add((Component)this.displayExpressionLabel).addPreferredGap(0).add((Component)this.treeCombo2, 0, 355, Short.MAX_VALUE))).addContainerGap()));
        bindingPanelLayout.setVerticalGroup((GroupLayout.Group)bindingPanelLayout.createParallelGroup(1).add((GroupLayout.Group)bindingPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.infoLabel).addPreferredGap(0).add((GroupLayout.Group)bindingPanelLayout.createParallelGroup(3).add((Component)this.sourceLabel).add((Component)this.sourceCombo, -2, -1, -2).add((Component)this.importDataButton)).addPreferredGap(0).add((GroupLayout.Group)bindingPanelLayout.createParallelGroup(3).add((Component)this.expressionLabel).add((Component)this.treeCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)bindingPanelLayout.createParallelGroup(3).add((Component)this.displayExpressionLabel).add((Component)this.treeCombo2, -2, -1, -2)).addPreferredGap(0).add((Component)this.detailPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.tabbedPane.addTab(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_BindingTab"), this.bindingPanel);
        Mnemonics.setLocalizedText((JLabel)this.updatePropertiesLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_UpdateProperties"));
        Mnemonics.setLocalizedText((JLabel)this.updateModeLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_UpdateMode"));
        Mnemonics.setLocalizedText((JLabel)this.updateWhenLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_UpdateWhen"));
        this.nullValuePanel.setEnabled(false);
        this.nullValuePanel.setPreferences(8);
        GroupLayout nullValuePanelLayout = new GroupLayout((Container)this.nullValuePanel);
        this.nullValuePanel.setLayout((LayoutManager)nullValuePanelLayout);
        nullValuePanelLayout.setHorizontalGroup((GroupLayout.Group)nullValuePanelLayout.createParallelGroup(1).add(0, 317, Short.MAX_VALUE));
        nullValuePanelLayout.setVerticalGroup((GroupLayout.Group)nullValuePanelLayout.createParallelGroup(1).add(0, 24, Short.MAX_VALUE));
        this.incompletePathValuePanel.setEnabled(false);
        this.incompletePathValuePanel.setPreferences(8);
        GroupLayout incompletePathValuePanelLayout = new GroupLayout((Container)this.incompletePathValuePanel);
        this.incompletePathValuePanel.setLayout((LayoutManager)incompletePathValuePanelLayout);
        incompletePathValuePanelLayout.setHorizontalGroup((GroupLayout.Group)incompletePathValuePanelLayout.createParallelGroup(1).add(0, 317, Short.MAX_VALUE));
        incompletePathValuePanelLayout.setVerticalGroup((GroupLayout.Group)incompletePathValuePanelLayout.createParallelGroup(1).add(0, 24, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.nullValueCheckBox, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_NullValue"));
        this.nullValueCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.nullValueCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.nullValueCheckBox.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.displayValuesLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_DisplayValues"));
        Mnemonics.setLocalizedText((AbstractButton)this.incompletePathValueCheckBox, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_IncompletePathValue"));
        this.incompletePathValueCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.incompletePathValueCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.incompletePathValueCheckBox.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.conversionLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Conversion"));
        Mnemonics.setLocalizedText((JLabel)this.validationLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Validation"));
        Mnemonics.setLocalizedText((JLabel)this.validatorLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Validator"));
        Mnemonics.setLocalizedText((JLabel)this.converterLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Converter"));
        this.converterPanel.setPreferences(8);
        GroupLayout converterPanelLayout = new GroupLayout((Container)this.converterPanel);
        this.converterPanel.setLayout((LayoutManager)converterPanelLayout);
        converterPanelLayout.setHorizontalGroup((GroupLayout.Group)converterPanelLayout.createParallelGroup(1).add(0, 395, Short.MAX_VALUE));
        converterPanelLayout.setVerticalGroup((GroupLayout.Group)converterPanelLayout.createParallelGroup(1).add(0, 24, Short.MAX_VALUE));
        this.validatorPanel.setPreferences(8);
        GroupLayout validatorPanelLayout = new GroupLayout((Container)this.validatorPanel);
        this.validatorPanel.setLayout((LayoutManager)validatorPanelLayout);
        validatorPanelLayout.setHorizontalGroup((GroupLayout.Group)validatorPanelLayout.createParallelGroup(1).add(0, 395, Short.MAX_VALUE));
        validatorPanelLayout.setVerticalGroup((GroupLayout.Group)validatorPanelLayout.createParallelGroup(1).add(0, 24, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((JLabel)this.specialValuesLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_SpecialValues"));
        Mnemonics.setLocalizedText((JLabel)this.updateLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Update"));
        Mnemonics.setLocalizedText((JLabel)this.converterMessage, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_ConversionTxt"));
        Mnemonics.setLocalizedText((JLabel)this.validatorMessage, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_ValidationTxt"));
        GroupLayout advancedPanelLayout = new GroupLayout((Container)this.advancedPanel);
        this.advancedPanel.setLayout((LayoutManager)advancedPanelLayout);
        advancedPanelLayout.setHorizontalGroup((GroupLayout.Group)advancedPanelLayout.createParallelGroup(1).add((GroupLayout.Group)advancedPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)advancedPanelLayout.createParallelGroup(1).add((Component)this.converterLabel).add((Component)this.validatorLabel)).addPreferredGap(0).add((GroupLayout.Group)advancedPanelLayout.createParallelGroup(1).add((Component)this.converterPanel, -1, -1, Short.MAX_VALUE).add((Component)this.validatorPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()).add((GroupLayout.Group)advancedPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.validationLabel).addContainerGap(406, Short.MAX_VALUE)).add((GroupLayout.Group)advancedPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.validatorMessage).addContainerGap(349, Short.MAX_VALUE)).add((GroupLayout.Group)advancedPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.converterMessage).addContainerGap(266, Short.MAX_VALUE)).add((GroupLayout.Group)advancedPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.conversionLabel).addContainerGap(368, Short.MAX_VALUE)).add((GroupLayout.Group)advancedPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.displayValuesLabel).addContainerGap(155, Short.MAX_VALUE)).add((GroupLayout.Group)advancedPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)advancedPanelLayout.createParallelGroup(1).add((Component)this.nullValueCheckBox).add((Component)this.incompletePathValueCheckBox)).addPreferredGap(0).add((GroupLayout.Group)advancedPanelLayout.createParallelGroup(1).add((Component)this.incompletePathValuePanel, -1, -1, Short.MAX_VALUE).add((Component)this.nullValuePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()).add((GroupLayout.Group)advancedPanelLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.updatePropertiesLabel).addContainerGap(359, Short.MAX_VALUE)).add((GroupLayout.Group)advancedPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)advancedPanelLayout.createParallelGroup(1).add((Component)this.updateModeLabel).add((Component)this.updateWhenLabel)).addPreferredGap(0).add((GroupLayout.Group)advancedPanelLayout.createParallelGroup(1).add((Component)this.updateWhenCombo, 0, 378, Short.MAX_VALUE).add((Component)this.updateModeCombo, 0, 378, Short.MAX_VALUE)).add(10, 10, 10)).add((GroupLayout.Group)advancedPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.specialValuesLabel).addContainerGap(368, Short.MAX_VALUE)).add((GroupLayout.Group)advancedPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.updateLabel).addContainerGap(234, Short.MAX_VALUE)));
        advancedPanelLayout.setVerticalGroup((GroupLayout.Group)advancedPanelLayout.createParallelGroup(1).add((GroupLayout.Group)advancedPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.updatePropertiesLabel).addPreferredGap(0).add((Component)this.updateLabel).addPreferredGap(0).add((GroupLayout.Group)advancedPanelLayout.createParallelGroup(3).add((Component)this.updateModeLabel).add((Component)this.updateModeCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)advancedPanelLayout.createParallelGroup(3).add((Component)this.updateWhenLabel).add((Component)this.updateWhenCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.conversionLabel).addPreferredGap(0).add((Component)this.converterMessage).addPreferredGap(0).add((GroupLayout.Group)advancedPanelLayout.createParallelGroup(1).add(4, (Component)this.converterLabel).add(4, (Component)this.converterPanel, -2, -1, -2)).addPreferredGap(0).add((Component)this.validationLabel).addPreferredGap(0).add((Component)this.validatorMessage).addPreferredGap(0).add((GroupLayout.Group)advancedPanelLayout.createParallelGroup(1).add(4, (Component)this.validatorLabel).add(4, (Component)this.validatorPanel, -2, -1, -2)).addPreferredGap(0).add((Component)this.specialValuesLabel).addPreferredGap(0).add((Component)this.displayValuesLabel).addPreferredGap(0).add((GroupLayout.Group)advancedPanelLayout.createParallelGroup(1).add(4, (Component)this.nullValueCheckBox).add(4, (Component)this.nullValuePanel, -2, -1, -2)).add(7, 7, 7).add((GroupLayout.Group)advancedPanelLayout.createParallelGroup(1).add(4, (Component)this.incompletePathValueCheckBox).add(4, (Component)this.incompletePathValuePanel, -2, -1, -2)).addContainerGap(13, Short.MAX_VALUE)));
        this.tabbedPane.addTab(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_AdvancedTab"), this.advancedPanel);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.tabbedPane, -1, 477, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.tabbedPane));
    }

    private void importDataButtonActionPerformed(ActionEvent evt) {
        RADComponent data;
        DataImporter importer = (DataImporter)Lookup.getDefault().lookup(DataImporter.class);
        if (importer != null && (data = importer.importData(this.bindingComponent.getFormModel())) != null) {
            this.fillSourceComponentsCombo();
            this.sourceCombo.setSelectedItem(data.getName());
        }
    }

    private void treeComboActionPerformed(ActionEvent evt) {
        this.updateColumnSelector();
        this.fireTypeChange();
    }

    private void incompletePathValueCheckBoxActionPerformed(ActionEvent evt) {
        this.incompletePathValuePanel.setEnabled(this.incompletePathValueCheckBox.isSelected());
    }

    private void nullValueCheckBoxActionPerformed(ActionEvent evt) {
        this.nullValuePanel.setEnabled(this.nullValueCheckBox.isSelected());
    }

    private void sourceComboActionPerformed(ActionEvent evt) {
        int index = this.sourceCombo.getSelectedIndex();
        if (index >= 0) {
            this.setSelectedComponent(index > 0 ? this.allComponents.get(index - 1) : null);
            if (index > 0) {
                this.expressionModel.setRoot(new ExpressionNode(this.allComponents.get(index - 1)));
            } else {
                this.expressionCombo.setSelectedItem("null");
                this.expressionModel.setRoot(new DefaultMutableTreeNode(null, false));
            }
            if (this.tabbedPane.getTabCount() > 1) {
                this.tabbedPane.setEnabledAt(1, index > 0);
            }
        }
        this.expressionCombo.setEnabled(index > 0);
        this.displayExpressionCombo.setEnabled(index > 0);
        this.updateColumnSelector();
        this.fireTypeChange();
    }

    public FormUtils.TypeHelper getSelectedType() {
        FormUtils.TypeHelper type = null;
        if (this.selectedComponent != null) {
            String path;
            Object value = this.expressionCombo.getSelectedItem();
            type = value == null || "null".equals(value) ? BindingDesignSupport.determineType(this.selectedComponent) : (BindingDesignSupport.isSimpleExpression(path = value.toString()) ? this.designSupport.determineType(this.selectedComponent, BindingDesignSupport.unwrapSimpleExpression(path)) : new FormUtils.TypeHelper((Type)((Object)String.class)));
        }
        return type;
    }

    private void updateColumnSelector() {
        boolean showDisplayExpression = this.showDisplayExpression();
        if (!showDisplayExpression && this.columnSelector == null) {
            return;
        }
        FormUtils.TypeHelper type = this.getSelectedType();
        if (type != null && Collection.class.isAssignableFrom(FormUtils.typeToClass(type))) {
            FormUtils.TypeHelper elemType = BindingDesignSupport.typeOfElement(type);
            if (this.columnSelector != null) {
                List<BindingDescriptor> descriptors = this.designSupport.getAllBindingDescriptors(elemType);
                this.columnSelector.setVisible(descriptors.size() > 0);
                LinkedList<String> available = new LinkedList<String>();
                for (BindingDescriptor desc : descriptors) {
                    available.add(desc.getPath());
                }
                this.columnSelector.setItems(Collections.EMPTY_LIST, available);
            }
            this.displayExpressionModel.setRoot(new ExpressionNode(elemType));
        } else {
            if (this.columnSelector != null) {
                this.columnSelector.setVisible(false);
            } else {
                this.displayExpressionCombo.setSelectedItem("null");
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(null, true);
            node.add(new DefaultMutableTreeNode(null, false));
            this.displayExpressionModel.setRoot(node);
        }
    }

    public void addTypeChangeListener(PropertyChangeListener listener) {
        this.typeChangeSupport.addPropertyChangeListener(listener);
    }

    public void removeTypeChangeListener(PropertyChangeListener listener) {
        this.typeChangeSupport.removePropertyChangeListener(listener);
    }

    private void fireTypeChange() {
        this.typeChangeSupport.firePropertyChange(null, null, null);
    }

    private static class BDComparator
    implements Comparator {
        private BDComparator() {
        }

        public int compare(Object o1, Object o2) {
            String path1 = ((BindingDescriptor)o1).getPath();
            String path2 = ((BindingDescriptor)o2).getPath();
            return path1.compareToIgnoreCase(path2);
        }
    }

    private static class Converter
    implements ComboBoxWithTree.Converter {
        private DefaultTreeModel treeModel;

        Converter(DefaultTreeModel treeModel) {
            this.treeModel = treeModel;
        }

        public String pathToString(TreePath path) {
            String value;
            StringBuilder sb = new StringBuilder();
            Object[] items = path.getPath();
            for (int i = 1; i < items.length; ++i) {
                sb.append(items[i]).append('.');
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return "null".equals(value = sb.toString().trim()) ? "null" : BindingDesignSupport.elWrap(sb.toString());
        }

        public TreePath stringToPath(String value) {
            int index;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeModel.getRoot();
            if (!BindingDesignSupport.isSimpleExpression(value)) {
                if ("null".equals(value)) {
                    return new TreePath(new Object[]{node, node.getChildAt(0)});
                }
                return null;
            }
            value = BindingDesignSupport.unwrapSimpleExpression(value);
            LinkedList<DefaultMutableTreeNode> path = new LinkedList<DefaultMutableTreeNode>();
            path.add(node);
            while ((index = value.indexOf(46)) != -1) {
                String item = value.substring(0, index);
                if ((node = this.findNode(node, item)) == null) {
                    return null;
                }
                path.add(node);
                value = value.substring(index + 1);
            }
            if ((node = this.findNode(node, value)) == null) {
                return null;
            }
            path.add(node);
            return new TreePath(path.toArray());
        }

        private DefaultMutableTreeNode findNode(DefaultMutableTreeNode parent, String userObject) {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(i);
                if (!userObject.equals(child.getUserObject())) continue;
                return child;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpressionNode
    extends JTree.DynamicUtilTreeNode {
        private BindingDescriptor descriptor;
        private RADComponent comp;
        private int category;

        ExpressionNode(RADComponent comp) {
            this(new FormUtils.TypeHelper(comp.getBeanClass()));
            this.comp = comp;
        }

        ExpressionNode(FormUtils.TypeHelper type) {
            super((Object)"root", BindingCustomizer.this.designSupport.getBindingDescriptors(type));
            this.setAllowsChildren(true);
        }

        private ExpressionNode(BindingDescriptor descriptor) {
            super((Object)descriptor.getPath(), BindingCustomizer.this.designSupport.getBindingDescriptors(descriptor.getGenericValueType()));
            this.descriptor = descriptor;
            this.updateLeafStatus();
        }

        private ExpressionNode() {
            super(null, null);
        }

        private void updateLeafStatus() {
            boolean leaf = true;
            if (this.childValue instanceof List[]) {
                List[] lists = (List[])this.childValue;
                for (int i = 0; i < lists.length; ++i) {
                    if (lists[i].size() <= 0) continue;
                    leaf = false;
                    break;
                }
            }
            this.setAllowsChildren(!leaf);
        }

        BindingDescriptor getDescriptor() {
            return this.descriptor;
        }

        int getCategory() {
            return this.category;
        }

        @Override
        protected void loadChildren() {
            this.loadedChildren = true;
            if ("root".equals(this.getUserObject())) {
                this.add(new ExpressionNode());
            }
            if (this.childValue instanceof List[]) {
                List[] lists = (List[])this.childValue;
                for (int i = 0; i < lists.length; ++i) {
                    this.loadChildren(lists[i], i);
                }
            }
        }

        private void loadChildren(List<BindingDescriptor> descriptors, int category) {
            for (BindingDescriptor descriptor : descriptors) {
                ExpressionNode child;
                if (descriptor.isValueTypeRelative()) {
                    StringBuilder sb = new StringBuilder(descriptor.getPath());
                    ExpressionNode node = this;
                    while (node.comp == null) {
                        sb.insert(0, node.getDescriptor().getPath() + ".");
                        node = (ExpressionNode)this.getParent();
                    }
                    FormUtils.TypeHelper type = BindingCustomizer.this.designSupport.determineType(node.comp, sb.toString());
                    child = new ExpressionNode(new BindingDescriptor(descriptor.getPath(), type));
                } else {
                    child = new ExpressionNode(descriptor);
                }
                child.category = category;
                this.add(child);
            }
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == BindingCustomizer.this.sourceCombo) {
                BindingCustomizer.this.sourceComboActionPerformed(evt);
            } else if (evt.getSource() == BindingCustomizer.this.treeCombo) {
                BindingCustomizer.this.treeComboActionPerformed(evt);
            } else if (evt.getSource() == BindingCustomizer.this.nullValueCheckBox) {
                BindingCustomizer.this.nullValueCheckBoxActionPerformed(evt);
            } else if (evt.getSource() == BindingCustomizer.this.incompletePathValueCheckBox) {
                BindingCustomizer.this.incompletePathValueCheckBoxActionPerformed(evt);
            } else if (evt.getSource() == BindingCustomizer.this.importDataButton) {
                BindingCustomizer.this.importDataButtonActionPerformed(evt);
            }
        }
    }

    private static class RADComponentComparator
    implements Comparator {
        private RADComponentComparator() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = ((RADComponent)o1).getName();
            String name2 = ((RADComponent)o2).getName();
            return name1.compareToIgnoreCase(name2);
        }
    }

    private static class TreeComboRenderer
    extends DefaultTreeCellRenderer {
        private String nullString;
        private int baseSize;

        TreeComboRenderer(String nullString) {
            this.nullString = nullString;
            this.baseSize = new JLabel().getFont().getSize() + 1;
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            Object object;
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof ExpressionNode) {
                ExpressionNode node2 = (ExpressionNode)value;
                Object object2 = node2.getUserObject();
                if (object2 == null) {
                    TreeComboRenderer.updateFont(label, this.baseSize);
                    label.setText(this.nullString);
                } else {
                    BindingDescriptor descriptor = node2.getDescriptor();
                    if (descriptor != null) {
                        TreeComboRenderer.updateFont(label, this.baseSize - node2.getCategory());
                        label.setText("<html><b>" + descriptor.getPath() + "</b> " + this.nameOfClass(descriptor.getValueType()));
                    }
                }
            } else if (value instanceof DefaultMutableTreeNode && (object = (node = (DefaultMutableTreeNode)value).getUserObject()) == null) {
                TreeComboRenderer.updateFont(label, this.baseSize);
                label.setText("null");
            }
            return label;
        }

        private static void updateFont(JLabel label, int size) {
            if (label.getFont().getSize() != size) {
                label.setFont(label.getFont().deriveFont((float)size));
            }
        }

        private String nameOfClass(Class clazz) {
            String name = clazz.getName();
            StringBuilder sb = new StringBuilder();
            if (name.startsWith("[")) {
                while (name.startsWith("[")) {
                    sb.append("[]");
                    name = name.substring(1);
                }
                if ("Z".equals(name)) {
                    sb.insert(0, "boolean");
                } else if ("B".equals(name)) {
                    sb.insert(0, "byte");
                } else if ("C".equals(name)) {
                    sb.insert(0, "char");
                } else if ("D".equals(name)) {
                    sb.insert(0, "double");
                } else if ("F".equals(name)) {
                    sb.insert(0, "float");
                } else if ("I".equals(name)) {
                    sb.insert(0, "int");
                } else if ("J".equals(name)) {
                    sb.insert(0, "long");
                } else if ("S".equals(name)) {
                    sb.insert(0, "short");
                } else {
                    sb.insert(0, name.substring(1, name.length() - 1));
                }
                return sb.toString();
            }
            return name;
        }
    }
}

