/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.beans.binding.Binding;
import javax.beans.binding.BindingContext;
import javax.beans.binding.BindingConverter;
import javax.beans.binding.BindingValidator;
import javax.beans.binding.PropertyResolverException;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.binding.SwingBindingSupport;
import org.netbeans.modules.form.BindingDescriptor;
import org.netbeans.modules.form.BindingProperty;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.CreationFactory;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaBinding;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingDesignSupport {
    private FormModel formModel;
    private Map<MetaBinding, List<Binding>> bindingsMap = new HashMap<MetaBinding, List<Binding>>();
    private Map<MetaBinding, Binding> modelBindings = new HashMap<MetaBinding, Binding>();
    private BindingContext bindingContext;
    private static Map<Class, Object> classToInstance = new WeakHashMap<Class, Object>();
    private static Object NO_INSTANCE = new Object();

    public BindingDesignSupport(FormModel model) {
        this.formModel = model;
        this.bindingContext = new BindingContext();
        this.bindingContext.bind();
        this.formModel.addFormModelListener(new ModelListener());
    }

    private void changeBinding(MetaBinding oldBinding, MetaBinding newBinding) {
        if (oldBinding != null) {
            this.removeBindings(oldBinding);
        }
    }

    public void changeBindingInModel(MetaBinding oldBinding, MetaBinding newBinding) {
        if (oldBinding != null) {
            this.removeBindingInModel(oldBinding);
        }
        if (newBinding != null) {
            this.addBindingInModel(newBinding);
        }
    }

    public static String elWrap(String path) {
        return path == null ? null : "${" + path + "}";
    }

    public static boolean isSimpleExpression(String expression) {
        return expression.startsWith("${") && expression.endsWith("}");
    }

    public static String unwrapSimpleExpression(String expression) {
        if (BindingDesignSupport.isSimpleExpression(expression)) {
            expression = expression.substring(2, expression.length() - 1);
        }
        return expression;
    }

    private static boolean hasRelativeType(Class clazz, String property) {
        return !(!"elements".equals(property) && !"selectedElement".equals(property) && !"selectedElements".equals(property) || !JTable.class.isAssignableFrom(clazz) && !JList.class.isAssignableFrom(clazz) && !JComboBox.class.isAssignableFrom(clazz));
    }

    public List<BindingDescriptor>[] getBindingDescriptors(RADComponent component) {
        BeanDescriptor beanDescriptor = component.getBeanInfo().getBeanDescriptor();
        return this.getBindingDescriptors(null, beanDescriptor, component.getBeanInstance());
    }

    private List<BindingDescriptor>[] getBindingDescriptors(FormUtils.TypeHelper type, BeanDescriptor beanDescriptor, Object instance) {
        Iterable<FeatureDescriptor> fds;
        LinkedList<BindingDescriptor> bindingList = new LinkedList<BindingDescriptor>();
        LinkedList prefList = new LinkedList();
        LinkedList observableList = new LinkedList();
        LinkedList nonObservableList = new LinkedList();
        Class<?> beanClass = beanDescriptor.getBeanClass();
        Object[] propsCats = FormUtils.getPropertiesCategoryClsf(beanClass, beanDescriptor);
        if (instance == NO_INSTANCE) {
            PropertyDescriptor[] pd;
            try {
                pd = FormUtils.getBeanInfo(beanClass).getPropertyDescriptors();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                pd = new PropertyDescriptor[]{};
            }
            List<PropertyDescriptor> pds = Arrays.asList(pd);
            fds = pds;
        } else {
            fds = this.bindingContext.getFeatureDescriptors(instance);
        }
        for (FeatureDescriptor fd : fds) {
            BindingDescriptor bd;
            LinkedList<BindingDescriptor> list;
            if (Boolean.TRUE.equals(fd.getValue("PreferredBindingProperty"))) {
                list = bindingList;
            } else {
                PropertyDescriptor pd;
                Object propCat = FormUtils.getPropertyCategory(fd, propsCats);
                if (propCat == FormUtils.PROP_HIDDEN) continue;
                list = fd instanceof PropertyDescriptor ? ((pd = (PropertyDescriptor)fd).isBound() ? (propCat == FormUtils.PROP_PREFERRED ? prefList : observableList) : nonObservableList) : observableList;
            }
            PropertyDescriptor pd = null;
            if (fd instanceof PropertyDescriptor) {
                pd = (PropertyDescriptor)fd;
            }
            if (pd == null) {
                bd = new BindingDescriptor(fd.getName(), (Type)((Object)Object.class));
            } else {
                Type retType;
                Method method = pd.getReadMethod();
                if (method != null && "getClass".equals(method.getName())) continue;
                Type type2 = retType = method == null ? pd.getPropertyType() : method.getGenericReturnType();
                if (type == null) {
                    bd = new BindingDescriptor(pd.getName(), retType);
                } else {
                    FormUtils.TypeHelper t = new FormUtils.TypeHelper(retType, type.getActualTypeArgs()).normalize();
                    bd = new BindingDescriptor(pd.getName(), t);
                }
                bd.setDisplayName(pd.getDisplayName());
                bd.setShortDescription(pd.getShortDescription());
            }
            if (BindingDesignSupport.hasRelativeType(beanClass, bd.getPath())) {
                bd.markTypeAsRelative();
            }
            list.add(bd);
        }
        if (bindingList.isEmpty()) {
            bindingList = prefList;
        } else {
            observableList.addAll(prefList);
        }
        Comparator bdComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                String path1 = ((BindingDescriptor)o1).getPath();
                String path2 = ((BindingDescriptor)o2).getPath();
                return path1.compareToIgnoreCase(path2);
            }
        };
        Collections.sort(bindingList, bdComparator);
        Collections.sort(observableList, bdComparator);
        Collections.sort(nonObservableList, bdComparator);
        return new List[]{bindingList, observableList, nonObservableList};
    }

    public List<BindingDescriptor> getAllBindingDescriptors(FormUtils.TypeHelper type) {
        List<BindingDescriptor>[] descs = this.getBindingDescriptors(type);
        LinkedList<BindingDescriptor> list = new LinkedList<BindingDescriptor>();
        for (int i = 0; i < descs.length; ++i) {
            list.addAll(descs[i]);
        }
        return list;
    }

    public List<BindingDescriptor>[] getBindingDescriptors(FormUtils.TypeHelper type) {
        List<BindingDescriptor>[] list;
        Class clazz = FormUtils.typeToClass(type);
        if (clazz.getName().startsWith("java.lang.") || Collection.class.isAssignableFrom(clazz) || clazz.isArray()) {
            return new List[]{Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST};
        }
        try {
            BeanInfo beanInfo = FormUtils.getBeanInfo(clazz);
            list = this.getBindingDescriptors(type, beanInfo.getBeanDescriptor(), BindingDesignSupport.getInstance(clazz));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            list = new List[]{Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST};
        }
        return list;
    }

    static FormUtils.TypeHelper determineType(RADComponent comp) {
        Class clazz;
        Class t = null;
        HashMap<String, Class> newMap = null;
        t = clazz = comp.getBeanClass();
        if (clazz.getTypeParameters().length == 1) {
            try {
                String type;
                Object value = comp.getSyntheticProperty("typeParameters").getValue();
                if (value instanceof String && (type = (String)value).startsWith("<")) {
                    type = type.substring(1, type.length() - 1);
                    try {
                        Class elemType = ClassPathUtils.loadClass(type, FormEditor.getFormDataObject(comp.getFormModel()).getFormFile());
                        newMap = new HashMap<String, Class>();
                        newMap.put(clazz.getTypeParameters()[0].getName(), elemType);
                    }
                    catch (ClassNotFoundException cnfex) {
                        cnfex.printStackTrace();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return new FormUtils.TypeHelper(t, newMap);
    }

    FormUtils.TypeHelper determineType(RADComponent comp, String sourcePath) {
        String[] path = BindingDesignSupport.parsePath(sourcePath);
        FormUtils.TypeHelper type = BindingDesignSupport.determineType(comp);
        for (int i = 0; i < path.length; ++i) {
            String pathItem = path[i];
            List<BindingDescriptor> descriptors = this.getAllBindingDescriptors(type);
            BindingDescriptor descriptor = BindingDesignSupport.findDescriptor(descriptors, pathItem);
            if (descriptor == null) {
                return new FormUtils.TypeHelper();
            }
            type = descriptor.getGenericValueType();
            if (type != null || !JTable.class.isAssignableFrom(comp.getBeanClass()) && !JList.class.isAssignableFrom(comp.getBeanClass()) && !JComboBox.class.isAssignableFrom(comp.getBeanClass())) continue;
            MetaBinding binding = (MetaBinding)comp.getBindingProperty("elements").getValue();
            if (binding != null) {
                RADComponent subComp = binding.getSource();
                String subSourcePath = binding.getSourcePath();
                FormUtils.TypeHelper t = this.determineType(subComp, subSourcePath);
                if ("selectedElement".equals(pathItem)) {
                    type = BindingDesignSupport.typeOfElement(t);
                    continue;
                }
                if (!"selectedElements".equals(pathItem) && !"elements".equals(pathItem)) continue;
                type = t;
                continue;
            }
            type = new FormUtils.TypeHelper();
        }
        return type;
    }

    private static BindingDescriptor findDescriptor(List<BindingDescriptor> descriptors, String path) {
        for (BindingDescriptor descriptor : descriptors) {
            if (!descriptor.getPath().equals(path)) continue;
            return descriptor;
        }
        return null;
    }

    private static String[] parsePath(String path) {
        int index;
        if (path == null) {
            return new String[0];
        }
        LinkedList<String> pathItems = new LinkedList<String>();
        while ((index = path.indexOf(46)) != -1) {
            pathItems.add(path.substring(0, index));
            path = path.substring(index + 1);
        }
        pathItems.add(path);
        return pathItems.toArray(new String[pathItems.size()]);
    }

    static FormUtils.TypeHelper typeOfElement(FormUtils.TypeHelper type) {
        Type t = type.getType();
        FormUtils.TypeHelper elemType = new FormUtils.TypeHelper();
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            Type[] args = pt.getActualTypeArguments();
            if (args.length == 1) {
                Type tt = args[0];
                elemType = new FormUtils.TypeHelper(tt, type.getActualTypeArgs());
            }
        } else if (t instanceof Class) {
            Type tt;
            Class classa = (Class)t;
            TypeVariable<Class<T>>[] tvar = classa.getTypeParameters();
            Map<String, Type> actualTypeArgs = type.getActualTypeArgs();
            if (actualTypeArgs != null && tvar.length == 1 && (tt = actualTypeArgs.get(tvar[0].getName())) != null) {
                elemType = new FormUtils.TypeHelper(tt, actualTypeArgs);
            }
        }
        return elemType;
    }

    private static Object getSourceValue(RADComponent source, String path) {
        RADProperty prop = source.getBeanProperty(path);
        if (prop != null) {
            try {
                return prop.getRealValue();
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return null;
    }

    public void establishUpdatedBindings(RADComponent metacomp, boolean recursive, Map map, BindingContext context, boolean inModel) {
        for (MetaBinding bindingDef : BindingDesignSupport.collectBindingDefs(metacomp, recursive)) {
            Object target;
            RADComponent sourceComp = bindingDef.getSource();
            RADComponent targetComp = bindingDef.getTarget();
            if (!sourceComp.isInModel() || !targetComp.isInModel()) continue;
            if (inModel) {
                this.addBindingInModel(bindingDef);
                continue;
            }
            Object source = null;
            if (map != null) {
                source = map.get(sourceComp.getId());
            }
            if (source == null) {
                source = sourceComp.getBeanInstance();
            }
            Object object = target = map != null ? map.get(targetComp.getId()) : targetComp.getBeanInstance();
            if (source == null || target == null) continue;
            this.addBinding(bindingDef, source, target, context, false);
        }
    }

    public static void establishOneOffBindings(RADComponent metacomp, boolean recursive, Map map, BindingContext context) {
        for (MetaBinding bindingDef : BindingDesignSupport.collectBindingDefs(metacomp, recursive)) {
            Object target;
            RADComponent sourceComp = bindingDef.getSource();
            RADComponent targetComp = bindingDef.getTarget();
            Object source = null;
            if (map != null) {
                source = map.get(sourceComp.getId());
            }
            if (source == null) {
                source = sourceComp.getBeanInstance();
            }
            Object object = target = map != null ? map.get(targetComp.getId()) : targetComp.getBeanInstance();
            if (source == null || target == null) continue;
            BindingDesignSupport.createBinding(bindingDef, source, target, context);
        }
    }

    private void releaseBindings(RADComponent metacomp, boolean recursive) {
        for (MetaBinding bindingDef : BindingDesignSupport.collectBindingDefs(metacomp, recursive)) {
            this.removeBindings(bindingDef);
        }
    }

    private static Collection<MetaBinding> collectBindingDefs(RADComponent metacomp, boolean recursive) {
        List col = BindingDesignSupport.collectBindingDefs(metacomp, recursive, null);
        if (col == null) {
            col = Collections.EMPTY_LIST;
        }
        return col;
    }

    private static Collection<MetaBinding> collectBindingDefs(RADComponent metacomp, boolean recursive, Collection<MetaBinding> col) {
        for (BindingProperty bindingProperty : metacomp.getKnownBindingProperties()) {
            MetaBinding bindingDef = (MetaBinding)bindingProperty.getValue();
            if (bindingDef == null) continue;
            if (col == null) {
                col = new LinkedList<MetaBinding>();
            }
            col.add(bindingDef);
        }
        if (recursive && metacomp instanceof ComponentContainer) {
            for (RADComponent rADComponent : ((ComponentContainer)((Object)metacomp)).getSubBeans()) {
                col = BindingDesignSupport.collectBindingDefs(rADComponent, recursive, col);
            }
        }
        return col;
    }

    private void addBindingInModel(MetaBinding bindingDef) {
        this.addBinding(bindingDef, bindingDef.getSource().getBeanInstance(), bindingDef.getTarget().getBeanInstance(), this.bindingContext, true);
    }

    public void addBinding(MetaBinding bindingDef, Object source, Object target, BindingContext context, boolean inModel) {
        if (inModel) {
            if (this.modelBindings.get(bindingDef) == null) {
                this.modelBindings.put(bindingDef, BindingDesignSupport.createBinding(bindingDef, source, target, context));
            }
        } else {
            List<Binding> establishedBindings = this.bindingsMap.get(bindingDef);
            if (establishedBindings != null) {
                for (Binding binding : establishedBindings) {
                    if (binding.getSource() != source || binding.getTarget() != target) continue;
                    return;
                }
            } else {
                establishedBindings = new LinkedList<Binding>();
                this.bindingsMap.put(bindingDef, establishedBindings);
            }
            establishedBindings.add(BindingDesignSupport.createBinding(bindingDef, source, target, context));
        }
    }

    public static Class getBindingDescriptionType(MetaBinding bindingDef) {
        return Binding.class;
    }

    private static Binding createBinding(MetaBinding bindingDef, Object source, Object target, BindingContext context) {
        Object value;
        BindingProperty prop;
        Collection<MetaBinding> subBindings = bindingDef.getSubBindings();
        LinkedList<Object> parameters = new LinkedList<Object>();
        String changeStrategy = bindingDef.getParameter("javax.swing.binding.SwingBindingSupport.TextChangeStrategyParameter");
        if (changeStrategy != null) {
            SwingBindingSupport.TextChangeStrategy value2 = null;
            if ("javax.swing.binding.SwingBindingSupport.TextChangeStrategy.CHANGE_ON_ACTION_OR_FOCUS_LOST".equals(changeStrategy)) {
                value2 = SwingBindingSupport.TextChangeStrategy.CHANGE_ON_ACTION_OR_FOCUS_LOST;
            } else if ("javax.swing.binding.SwingBindingSupport.TextChangeStrategy.CHANGE_ON_FOCUS_LOST".equals(changeStrategy)) {
                value2 = SwingBindingSupport.TextChangeStrategy.CHANGE_ON_FOCUS_LOST;
            } else if ("javax.swing.binding.SwingBindingSupport.TextChangeStrategy.CHANGE_ON_TYPE".equals(changeStrategy)) {
                value2 = SwingBindingSupport.TextChangeStrategy.CHANGE_ON_TYPE;
            }
            if (value2 != null) {
                parameters.add(SwingBindingSupport.TextChangeStrategyParameter);
                parameters.add((Object)value2);
            }
        }
        Binding binding = new Binding(source, bindingDef.getSourcePath(), target, bindingDef.getTargetPath(), parameters.toArray());
        Binding.UpdateStrategy updateStrategy = null;
        switch (bindingDef.getUpdateStratedy()) {
            case 0: {
                updateStrategy = Binding.UpdateStrategy.READ_WRITE;
                break;
            }
            case 1: {
                updateStrategy = Binding.UpdateStrategy.READ_FROM_SOURCE;
                break;
            }
            case 2: {
                updateStrategy = Binding.UpdateStrategy.READ_ONCE;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        binding.setUpdateStrategy(updateStrategy);
        if (bindingDef.isNullValueSpecified()) {
            prop = bindingDef.getTarget().getBindingProperty(bindingDef.getTargetPath());
            FormProperty nullProp = prop.getNullValueProperty();
            try {
                value = nullProp.getRealValue();
                if (value != null) {
                    binding.setNullSourceValue(value);
                }
            }
            catch (IllegalAccessException iaex) {
                iaex.printStackTrace();
            }
            catch (InvocationTargetException itex) {
                itex.printStackTrace();
            }
        }
        if (bindingDef.isIncompletePathValueSpecified()) {
            prop = bindingDef.getTarget().getBindingProperty(bindingDef.getTargetPath());
            FormProperty incompleteProp = prop.getIncompleteValueProperty();
            try {
                value = incompleteProp.getRealValue();
                if (value != null) {
                    binding.setValueForIncompleteSourcePath(value);
                }
            }
            catch (IllegalAccessException iaex) {
                iaex.printStackTrace();
            }
            catch (InvocationTargetException itex) {
                itex.printStackTrace();
            }
        }
        if (bindingDef.isConverterSpecified()) {
            prop = bindingDef.getTarget().getBindingProperty(bindingDef.getTargetPath());
            FormProperty converterProp = prop.getConverterProperty();
            try {
                value = converterProp.getRealValue();
                if (value != null && value instanceof BindingConverter) {
                    binding.setConverter((BindingConverter)value);
                }
            }
            catch (IllegalAccessException iaex) {
                iaex.printStackTrace();
            }
            catch (InvocationTargetException itex) {
                itex.printStackTrace();
            }
        }
        if (bindingDef.isValidatorSpecified()) {
            prop = bindingDef.getTarget().getBindingProperty(bindingDef.getTargetPath());
            FormProperty validatorProp = prop.getValidatorProperty();
            try {
                value = validatorProp.getRealValue();
                if (value != null && value instanceof BindingValidator) {
                    binding.setValidator((BindingValidator)value);
                }
            }
            catch (IllegalAccessException iaex) {
                iaex.printStackTrace();
            }
            catch (InvocationTargetException itex) {
                itex.printStackTrace();
            }
        }
        if (bindingDef.hasSubBindings()) {
            for (MetaBinding sub : subBindings) {
                LinkedList<Object> subParameters = new LinkedList<Object>();
                String tableColumn = sub.getParameter("javax.swing.binding.SwingBindingSupport.TableColumnParameter");
                if (tableColumn != null) {
                    try {
                        int column = Integer.parseInt(tableColumn);
                        subParameters.add(SwingBindingSupport.TableColumnParameter);
                        subParameters.add(column);
                    }
                    catch (NumberFormatException nfex) {
                        nfex.printStackTrace();
                    }
                }
                binding.addBinding(sub.getSourcePath(), sub.getTargetPath(), subParameters.toArray());
            }
        }
        context.addBinding(binding);
        try {
            binding.bind();
        }
        catch (PropertyResolverException prex) {
            String message = prex.getMessage();
            int index = message.indexOf(91);
            if (index != -1) {
                index = message.lastIndexOf(32, index);
                message = message.substring(0, index + 1) + bindingDef.getTarget().getName() + message.substring(message.lastIndexOf(93) + 1);
            }
            System.err.println(message);
        }
        return binding;
    }

    private void removeBindings(MetaBinding bindingDef) {
        this.removeBindingInModel(bindingDef);
        List<Binding> establishedBindings = this.bindingsMap.get(bindingDef);
        if (establishedBindings != null) {
            for (Binding binding : establishedBindings) {
                BindingDesignSupport.removeBinding(binding);
            }
            this.bindingsMap.remove(bindingDef);
        }
    }

    private static void removeBinding(Binding binding) {
        BindingContext context = binding.getContext();
        binding.unbind();
        context.removeBinding(binding);
    }

    private void removeBindingInModel(MetaBinding bindingDef) {
        Binding binding = this.modelBindings.remove(bindingDef);
        if (binding != null) {
            BindingDesignSupport.removeBinding(binding);
        }
    }

    private static Object getInstance(Class clazz) {
        Object instance = classToInstance.get(clazz);
        if (instance instanceof Reference) {
            instance = ((Reference)instance).get();
        }
        if (instance == null) {
            try {
                instance = CreationFactory.createDefaultInstance(clazz);
            }
            catch (Exception ex) {
                instance = NO_INSTANCE;
            }
            classToInstance.put(clazz, instance == NO_INSTANCE ? instance : new WeakReference<Object>(instance));
        }
        return instance;
    }

    private class ModelListener
    implements FormModelListener {
        private ModelListener() {
        }

        public void formChanged(FormModelEvent[] events) {
            if (events == null) {
                return;
            }
            block5: for (int i = 0; i < events.length; ++i) {
                FormModelEvent ev = events[i];
                switch (ev.getChangeType()) {
                    case 16: {
                        BindingDesignSupport.this.changeBinding(ev.getOldBinding(), ev.getNewBinding());
                        continue block5;
                    }
                    case 8: {
                        BindingDesignSupport.this.releaseBindings(ev.getComponent(), true);
                        continue block5;
                    }
                    case 7: {
                        if (ev.getCreatedDeleted()) continue block5;
                        BindingDesignSupport.this.establishUpdatedBindings(ev.getComponent(), true, null, BindingDesignSupport.this.bindingContext, true);
                    }
                }
            }
        }
    }
}

