/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.netbeans.modules.form.FormDataLoader;
import org.netbeans.modules.form.FormDataNode;
import org.netbeans.modules.form.FormEditorSupport;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormDataObject
extends MultiDataObject {
    private transient FormEditorSupport formEditor;
    private transient OpenEdit openEdit;
    FileEntry formEntry;
    static final long serialVersionUID = -975322003627854168L;

    public FormDataObject(FileObject ffo, FileObject jfo, FormDataLoader loader) throws DataObjectExistsException {
        super(jfo, (MultiFileLoader)loader);
        this.formEntry = (FileEntry)this.registerEntry(ffo);
        this.getCookieSet().assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject folder, String fileName) throws IOException {
                FormDataObject.this.getFormEditorSupport().saveAs(folder, fileName);
            }
        }});
    }

    public <T extends Node.Cookie> T getCookie(Class<T> type) {
        Object retValue;
        if (OpenCookie.class.equals(type) || EditCookie.class.equals(type)) {
            if (this.openEdit == null) {
                this.openEdit = new OpenEdit();
            }
            retValue = (Node.Cookie)type.cast(this.openEdit);
        } else {
            retValue = type.isAssignableFrom(FormEditorSupport.class) ? this.getFormEditorSupport() : super.getCookie(type);
        }
        return (T)retValue;
    }

    public FileObject getFormFile() {
        return this.formEntry.getFile();
    }

    public boolean isReadOnly() {
        FileObject javaFO = this.getPrimaryFile();
        FileObject formFO = this.formEntry.getFile();
        return !javaFO.canWrite() || !formFO.canWrite();
    }

    public boolean formFileReadOnly() {
        return !this.formEntry.getFile().canWrite();
    }

    public synchronized FormEditorSupport getFormEditorSupport() {
        if (this.formEditor == null) {
            this.formEditor = new FormEditorSupport(this.getPrimaryEntry(), this, this.getCookieSet());
        }
        return this.formEditor;
    }

    public FormEditorSupport getFormEditor() {
        return this.getFormEditorSupport();
    }

    FileEntry getFormEntry() {
        return this.formEntry;
    }

    protected Node createNodeDelegate() {
        FormDataNode node = new FormDataNode(this);
        return node;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
    }

    protected DataObject handleCopyRename(DataFolder df, String name, String ext) throws IOException {
        FileObject fo = this.getPrimaryEntry().copyRename(df.getPrimaryFile(), name, ext);
        return DataObject.find((FileObject)fo);
    }

    private class OpenEdit
    implements OpenCookie,
    EditCookie {
        private OpenEdit() {
        }

        public void open() {
            FormDataObject.this.getFormEditorSupport().openFormEditor(true);
        }

        public void edit() {
            FormDataObject.this.getFormEditorSupport().open();
        }
    }
}

