/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.FormLoaderSettings;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class FormEditorCustomizer
extends JPanel
implements ActionListener,
ChangeListener {
    private JCheckBox cbFold = new JCheckBox();
    private JCheckBox cbAssistant = new JCheckBox();
    private JComboBox cbModifier = new JComboBox();
    private JRadioButton rbGenerateLocals = new JRadioButton();
    private JRadioButton rbGenerateFields = new JRadioButton();
    private JComboBox cbListenerStyle = new JComboBox();
    private JComboBox cbAutoI18n = new JComboBox();
    private boolean changed = false;
    private boolean listen = false;

    public FormEditorCustomizer() {
        ButtonGroup group = new ButtonGroup();
        FormEditorCustomizer.loc(this.cbFold, "Fold");
        this.cbFold.setBackground(Color.white);
        FormEditorCustomizer.loc(this.cbAssistant, "Assistant");
        this.cbAssistant.setBackground(Color.white);
        FormEditorCustomizer.loc(this.rbGenerateLocals, "Generate_Locals");
        this.rbGenerateLocals.setBackground(Color.white);
        group.add(this.rbGenerateLocals);
        FormEditorCustomizer.loc(this.rbGenerateFields, "Generate_Fields");
        this.rbGenerateFields.setBackground(Color.white);
        group.add(this.rbGenerateFields);
        this.cbModifier.addItem(FormEditorCustomizer.loc("Public_Modifier"));
        this.cbModifier.addItem(FormEditorCustomizer.loc("Default_Modifier"));
        this.cbModifier.addItem(FormEditorCustomizer.loc("Protected_Modifier"));
        this.cbModifier.addItem(FormEditorCustomizer.loc("Private_Modifier"));
        this.cbListenerStyle.addItem(FormEditorCustomizer.loc("Anonymous"));
        this.cbListenerStyle.addItem(FormEditorCustomizer.loc("InnerClass"));
        this.cbListenerStyle.addItem(FormEditorCustomizer.loc("MainClass"));
        this.cbAutoI18n.addItem(FormEditorCustomizer.loc("CTL_AUTO_RESOURCE_DEFAULT"));
        this.cbAutoI18n.addItem(FormEditorCustomizer.loc("CTL_AUTO_RESOURCE_ON"));
        this.cbAutoI18n.addItem(FormEditorCustomizer.loc("CTL_AUTO_RESOURCE_OFF"));
        JLabel generateComponetsLabel = new JLabel(FormEditorCustomizer.loc("Generate_Components"));
        JLabel variableModifierLabel = new JLabel(FormEditorCustomizer.loc("Variable_Modifier"));
        JLabel listenerStyleLabel = new JLabel(FormEditorCustomizer.loc("Listener_Style"));
        JLabel autoI18nLabel = new JLabel(FormEditorCustomizer.loc("Auto_I18n"));
        generateComponetsLabel.setToolTipText(FormEditorCustomizer.loc("Generate_Components_Hint"));
        variableModifierLabel.setToolTipText(FormEditorCustomizer.loc("HINT_VARIABLES_MODIFIER"));
        listenerStyleLabel.setToolTipText(FormEditorCustomizer.loc("HINT_LISTENER_GENERATION_STYLE"));
        autoI18nLabel.setToolTipText(FormEditorCustomizer.loc("HINT_AUTO_RESOURCE_GLOBAL"));
        this.cbFold.setToolTipText(FormEditorCustomizer.loc("HINT_FOLD_GENERATED_CODE"));
        this.cbAssistant.setToolTipText(FormEditorCustomizer.loc("HINT_ASSISTANT_SHOWN"));
        variableModifierLabel.setLabelFor(this.cbModifier);
        listenerStyleLabel.setLabelFor(this.cbListenerStyle);
        autoI18nLabel.setLabelFor(this.cbAutoI18n);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)generateComponetsLabel).add((Component)variableModifierLabel).add((Component)listenerStyleLabel).add((Component)autoI18nLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.rbGenerateLocals).add((Component)this.rbGenerateFields).add((Component)this.cbFold).add((Component)this.cbAssistant).add((Component)this.cbModifier, -1, -1, Short.MAX_VALUE).add((Component)this.cbListenerStyle, -1, -1, Short.MAX_VALUE).add((Component)this.cbAutoI18n, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)generateComponetsLabel).add((Component)this.rbGenerateLocals)).addPreferredGap(0).add((Component)this.rbGenerateFields).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)variableModifierLabel).add((Component)this.cbModifier)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)listenerStyleLabel).add((Component)this.cbListenerStyle)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)autoI18nLabel).add((Component)this.cbAutoI18n)).addPreferredGap(0).add((Component)this.cbFold).add((Component)this.cbAssistant).addContainerGap());
        this.setBorder(new TitledBorder(FormEditorCustomizer.loc("Code_Generation")));
        this.setBackground(Color.white);
        this.cbFold.addActionListener(this);
        this.cbAssistant.addActionListener(this);
        this.cbListenerStyle.addActionListener(this);
        this.cbModifier.addActionListener(this);
        this.rbGenerateFields.addActionListener(this);
        this.rbGenerateLocals.addActionListener(this);
        this.cbAutoI18n.addActionListener(this);
    }

    private static String loc(String key) {
        return NbBundle.getMessage(FormEditorCustomizer.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)FormEditorCustomizer.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)FormEditorCustomizer.loc(key));
        }
    }

    void update() {
        this.listen = false;
        FormLoaderSettings options = FormLoaderSettings.getInstance();
        this.cbFold.setSelected(options.getFoldGeneratedCode());
        this.cbAssistant.setSelected(options.getAssistantShown());
        this.rbGenerateLocals.setSelected(options.getVariablesLocal());
        this.rbGenerateFields.setSelected(!options.getVariablesLocal());
        if ((options.getVariablesModifier() & 1) > 0) {
            this.cbModifier.setSelectedIndex(0);
        } else if ((options.getVariablesModifier() & 4) > 0) {
            this.cbModifier.setSelectedIndex(2);
        } else if ((options.getVariablesModifier() & 2) > 0) {
            this.cbModifier.setSelectedIndex(3);
        } else {
            this.cbModifier.setSelectedIndex(1);
        }
        this.cbListenerStyle.setSelectedIndex(options.getListenerGenerationStyle());
        this.cbAutoI18n.setSelectedIndex(options.getI18nAutoMode());
        this.listen = true;
        this.changed = false;
    }

    void applyChanges() {
        FormLoaderSettings options = FormLoaderSettings.getInstance();
        options.setFoldGeneratedCode(this.cbFold.isSelected());
        options.setAssistantShown(this.cbAssistant.isSelected());
        options.setListenerGenerationStyle(this.cbListenerStyle.getSelectedIndex());
        options.setI18nAutoMode(this.cbAutoI18n.getSelectedIndex());
        options.setVariablesLocal(this.rbGenerateLocals.isSelected());
        switch (this.cbModifier.getSelectedIndex()) {
            case 0: {
                options.setVariablesModifier(1);
                break;
            }
            case 1: {
                options.setVariablesModifier(0);
                break;
            }
            case 2: {
                options.setVariablesModifier(4);
                break;
            }
            case 3: {
                options.setVariablesModifier(2);
            }
        }
        this.changed = false;
    }

    void cancel() {
        this.changed = false;
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.changed;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.listen) {
            this.changed = true;
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (this.listen) {
            this.changed = true;
        }
    }
}

