/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.beans.Introspector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormJavaSource {
    private final FormDataObject formDataObject;
    private List<String> fields = null;
    private static final String[] PROPERTY_PREFIXES = new String[]{"get", "is"};

    public FormJavaSource(FormDataObject formDataObject) {
        this.formDataObject = formDataObject;
    }

    public void refresh() {
        this.fields = Collections.emptyList();
        this.runUserActionTask(new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController controller) throws Exception {
                controller.toPhase(JavaSource.Phase.PARSED);
                FormJavaSource.this.fields = FormJavaSource.this.getFieldNames(controller);
            }
        });
    }

    private void runUserActionTask(CancellableTask<CompilationController> task) {
        FileObject javaFileObject = this.formDataObject.getPrimaryFile();
        JavaSource js = JavaSource.forFileObject((FileObject)javaFileObject);
        if (js != null) {
            try {
                js.runUserActionTask(task, true);
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public boolean containsField(String name, boolean refresh) {
        if (refresh) {
            this.refresh();
        }
        return this.fields != null && this.fields.contains(name);
    }

    private ClassTree findClassTree(CompilationController controller) {
        String fileName = this.formDataObject.getPrimaryFile().getName();
        for (Tree tree : controller.getCompilationUnit().getTypeDecls()) {
            if (tree.getKind() != Tree.Kind.CLASS || !fileName.equals(((ClassTree)tree).getSimpleName().toString())) continue;
            return (ClassTree)tree;
        }
        return null;
    }

    private List<String> findMethodsByReturnType(CompilationController controller, TypeElement celem, Class returnType) {
        ArrayList<String> methods = new ArrayList<String>();
        String returnTypeName = returnType.getName();
        TypeElement returnTypeElm = controller.getElements().getTypeElement(returnTypeName);
        for (Element element : celem.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement method = (ExecutableElement)element;
            TypeMirror methodRT = method.getReturnType();
            if (!controller.getTypes().isAssignable(returnTypeElm.asType(), methodRT)) continue;
            methods.add(method.getSimpleName().toString());
        }
        return methods;
    }

    public String[] getMethodNames(final Class returnType) {
        final Object[] result = new Object[1];
        this.runUserActionTask(new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController controller) throws Exception {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassTree ct = FormJavaSource.this.findClassTree(controller);
                if (ct != null) {
                    TreePath cpath = controller.getTrees().getPath(controller.getCompilationUnit(), ct);
                    TypeElement celem = (TypeElement)controller.getTrees().getElement(cpath);
                    List names = FormJavaSource.this.findMethodsByReturnType(controller, celem, returnType);
                    result[0] = FormJavaSource.toArray(names);
                }
            }
        });
        return result[0] == null ? new String[]{} : (String[])result[0];
    }

    public String[] getPropertyReadMethodNames(Class returnType) {
        String[] names = this.getMethodNames(returnType);
        ArrayList<String> result = new ArrayList<String>(names.length);
        for (String name : names) {
            if (FormJavaSource.extractPropertyName(name).equals("")) continue;
            result.add(name);
        }
        return FormJavaSource.toArray(result);
    }

    public static String extractPropertyName(String methodName) {
        for (int i = 0; i < PROPERTY_PREFIXES.length; ++i) {
            if (!methodName.startsWith(PROPERTY_PREFIXES[i]) || methodName.length() <= PROPERTY_PREFIXES[i].length()) continue;
            return Introspector.decapitalize(methodName.substring(PROPERTY_PREFIXES[i].length()));
        }
        return "";
    }

    private List<String> getFieldNames(final CompilationController controller) {
        SimpleSection variablesSection = this.formDataObject.getFormEditorSupport().getVariablesSection();
        if (variablesSection == null) {
            return null;
        }
        final int genVariablesStartOffset = variablesSection.getStartPosition().getOffset();
        final int genVariablesEndOffset = variablesSection.getEndPosition().getOffset();
        final SourcePositions positions = controller.getTrees().getSourcePositions();
        TreeScanner<Void, List<String>> scan = new TreeScanner<Void, List<String>>(){

            @Override
            public Void visitClass(ClassTree node, List<String> p) {
                long startOffset = positions.getStartPosition(controller.getCompilationUnit(), node);
                long endOffset = positions.getEndPosition(controller.getCompilationUnit(), node);
                if ((long)genVariablesStartOffset > startOffset && (long)genVariablesEndOffset < endOffset) {
                    for (Tree tree : node.getMembers()) {
                        if (tree.getKind() != Tree.Kind.VARIABLE) continue;
                        this.testVariable((VariableTree)tree, p);
                    }
                }
                return null;
            }

            private void testVariable(VariableTree node, List<String> p) {
                long startOffset = positions.getStartPosition(controller.getCompilationUnit(), node);
                if (startOffset >= (long)genVariablesEndOffset || startOffset <= (long)genVariablesStartOffset) {
                    p.add(node.getName().toString());
                }
            }
        };
        ArrayList<String> fields = new ArrayList<String>();
        scan.scan(controller.getCompilationUnit(), fields);
        return fields;
    }

    private boolean isAssignableFrom(String typeName, Class returnType) {
        Class clazz = this.getClassByName(typeName);
        return clazz != null ? returnType.isAssignableFrom(clazz) : false;
    }

    private Class getClassByName(String className) {
        Class clazz = null;
        try {
            clazz = ClassPathUtils.loadClass(className, this.formDataObject.getPrimaryFile());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (LinkageError ex) {
            ex.printStackTrace();
        }
        return clazz;
    }

    private static String[] toArray(List list) {
        return list.toArray(new String[list.size()]);
    }

    public static boolean isInDefaultPackage(FormModel formModel) {
        FileObject fdo = FormEditor.getFormDataObject(formModel).getPrimaryFile();
        ClassPath cp = ClassPath.getClassPath((FileObject)fdo, (String)"classpath/source");
        String name = cp.getResourceName(fdo);
        return name.indexOf(47) < 0;
    }
}

