/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.ResourceSupport;
import org.netbeans.modules.form.project.ClassPathUtils;

public class FormSettings {
    private static final String SESSION_PREFIX = "Session_";
    private FormModel formModel;
    private Map settings = new TreeMap();
    private static final String PROP_AUTO_I18N = "i18nAutoMode";

    FormSettings(FormModel formModel) {
        this.formModel = formModel;
        int variablesModifier = FormLoaderSettings.getInstance().getVariablesModifier();
        this.settings.put("variablesModifier", new Integer(variablesModifier));
        boolean localVariables = FormLoaderSettings.getInstance().getVariablesLocal();
        this.settings.put("variablesLocal", localVariables);
        boolean generateMnemonicsCode = FormLoaderSettings.getInstance().getGenerateMnemonicsCode();
        this.settings.put("generateMnemonicsCode", generateMnemonicsCode);
        int listenerGenerationStyle = FormLoaderSettings.getInstance().getListenerGenerationStyle();
        this.settings.put("listenerGenerationStyle", new Integer(listenerGenerationStyle));
    }

    public int getVariablesModifier() {
        Integer variablesModifier = (Integer)this.settings.get("variablesModifier");
        return variablesModifier;
    }

    public void setVariablesModifier(int value) {
        this.settings.put("variablesModifier", new Integer(value));
    }

    public boolean getVariablesLocal() {
        Boolean variablesLocal = (Boolean)this.settings.get("variablesLocal");
        return variablesLocal;
    }

    public void setVariablesLocal(boolean value) {
        this.settings.put("variablesLocal", value);
    }

    public boolean getGenerateMnemonicsCode() {
        Boolean generateMnemonicsCode = (Boolean)this.settings.get("generateMnemonicsCode");
        return generateMnemonicsCode;
    }

    public void setGenerateMnemonicsCode(boolean value) {
        this.settings.put("generateMnemonicsCode", value);
    }

    public int getListenerGenerationStyle() {
        Integer listenerGenerationStyle = (Integer)this.settings.get("listenerGenerationStyle");
        return listenerGenerationStyle;
    }

    public void setListenerGenerationStyle(int value) {
        this.settings.put("listenerGenerationStyle", new Integer(value));
    }

    public int getLayoutCodeTarget() {
        return this.checkLayoutCodeTarget();
    }

    public void setLayoutCodeTarget(int value) {
        this.settings.put("layoutCodeTarget", new Integer(value));
    }

    private int checkLayoutCodeTarget() {
        int layoutCodeTarget;
        Integer lctSetting = (Integer)this.settings.get("layoutCodeTarget");
        if (lctSetting != null) {
            layoutCodeTarget = lctSetting;
        } else {
            int n = layoutCodeTarget = FormEditor.getFormEditor(this.formModel).needPostCreationUpdate() ? 0 : 2;
        }
        if (layoutCodeTarget == 0) {
            int globalLCT = FormLoaderSettings.getInstance().getLayoutCodeTarget();
            layoutCodeTarget = globalLCT == 0 ? (ClassPathUtils.isJava6ProjectPlatform(FormEditor.getFormDataObject(this.formModel).getPrimaryFile()) ? 1 : 2) : globalLCT;
            this.setLayoutCodeTarget(layoutCodeTarget);
        } else if (lctSetting == null) {
            this.setLayoutCodeTarget(layoutCodeTarget);
        }
        return layoutCodeTarget;
    }

    void setResourceAutoMode(int value) {
        this.settings.put("autoResourcing", value);
        this.settings.put(PROP_AUTO_I18N, value == 1);
    }

    int getResourceAutoMode() {
        Integer resSetting = (Integer)this.settings.get("autoResourcing");
        int resAutoMode = 0;
        if (resSetting != null) {
            resAutoMode = resSetting;
        } else {
            Boolean i18nSetting = (Boolean)this.settings.get(PROP_AUTO_I18N);
            if (i18nSetting != null) {
                if (Boolean.TRUE.equals(i18nSetting)) {
                    resAutoMode = 1;
                }
            } else {
                if (FormEditor.getFormEditor(this.formModel).needPostCreationUpdate()) {
                    int globalResAutoMode = FormLoaderSettings.getInstance().getI18nAutoMode();
                    if (globalResAutoMode == 1) {
                        ResourceSupport resourceSupport = FormEditor.getResourceSupport(this.formModel);
                        resAutoMode = resourceSupport.projectUsesResources() ? 2 : 1;
                    } else if (globalResAutoMode == 0) {
                        ResourceSupport resourceSupport = FormEditor.getResourceSupport(this.formModel);
                        if (resourceSupport.projectUsesResources()) {
                            resAutoMode = 2;
                        } else if (resourceSupport.isDefaultInternationalizableProject()) {
                            resAutoMode = 1;
                        }
                    }
                }
                this.setResourceAutoMode(resAutoMode);
            }
        }
        return resAutoMode;
    }

    public boolean isI18nAutoMode() {
        return this.getResourceAutoMode() == 1;
    }

    public void setFormBundle(String bundleName) {
        this.settings.put("formBundle", bundleName);
    }

    public String getFormBundle() {
        return (String)this.settings.get("formBundle");
    }

    public void set(String name, Object value) {
        this.set(name, value, false);
    }

    public void set(String name, Object value, boolean session) {
        if (session) {
            name = SESSION_PREFIX + name;
        }
        this.settings.put(name, value);
    }

    public Object get(String name) {
        Object value = this.settings.containsKey(name) ? this.settings.get(name) : this.settings.get(SESSION_PREFIX + name);
        return value;
    }

    boolean isSessionSetting(String name) {
        return name.startsWith(SESSION_PREFIX);
    }

    Map allSettings() {
        return Collections.unmodifiableMap(this.settings);
    }
}

