/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.JTextComponent;

class InPlaceEditLayer
extends JPanel {
    private boolean layerEditing = true;
    private boolean changeDone = false;
    private String editedText;
    private String oldText;
    private Component editedComp;
    private Container superContainer;
    private JTextComponent editingTextComp;
    private InPlaceTextField inPlaceField;
    private ComponentListener layerResizeListener;
    private KeyListener compKeyListener;
    private FocusListener compFocusListener;
    private ActionListener compActionListener;
    private ArrayList listeners;
    private Cursor defaultCursor;

    InPlaceEditLayer() {
        this.setLayout(null);
        this.defaultCursor = this.getCursor();
    }

    void setEditedComponent(Component comp, String text) {
        if (!comp.isShowing() || comp.getParent() == null) {
            throw new IllegalArgumentException();
        }
        this.editedComp = comp;
        this.editedText = text;
        if (this.inPlaceField != null) {
            this.remove(this.inPlaceField);
            this.inPlaceField = null;
        }
        if (comp instanceof JLabel || comp instanceof AbstractButton || comp instanceof JTabbedPane) {
            this.layerEditing = true;
            this.superContainer = null;
            this.createInPlaceField();
        } else if (comp instanceof JTextField || comp instanceof JTextArea) {
            this.layerEditing = false;
            Container cont = this.superContainer = comp.getParent();
            do {
                if (!(cont.getParent() instanceof JLayeredPane)) continue;
                this.superContainer = cont;
                break;
            } while ((cont = cont.getParent()) != null);
            this.editingTextComp = (JTextComponent)this.editedComp;
            this.oldText = this.editingTextComp.getText();
            this.editingTextComp.setText(this.editedText);
            this.editingTextComp.setFocusable(true);
        } else {
            throw new IllegalArgumentException();
        }
        this.attachListeners();
    }

    static boolean supportsEditingFor(Class compClass, boolean layerRequired) {
        return JLabel.class.isAssignableFrom(compClass) || AbstractButton.class.isAssignableFrom(compClass) || JTabbedPane.class.isAssignableFrom(compClass) || !layerRequired && (JTextField.class.isAssignableFrom(compClass) || JTextArea.class.isAssignableFrom(compClass));
    }

    boolean isEditingInitialized() {
        return this.editingTextComp != null;
    }

    boolean isLayerEditing() {
        return this.layerEditing;
    }

    String getEditedText() {
        return this.editedText;
    }

    boolean isTextChanged() {
        return this.changeDone;
    }

    void finishEditing(boolean applyChanges) {
        if (applyChanges) {
            String text = this.editingTextComp.getText();
            if (text.equals(this.editedText)) {
                applyChanges = false;
            } else {
                this.editedText = text;
            }
        } else if (!this.isLayerEditing()) {
            this.editingTextComp.setText(this.oldText);
            this.editingTextComp.setFocusable(false);
        }
        this.editingTextComp.removeKeyListener(this.compKeyListener);
        this.editingTextComp.removeFocusListener(this.compFocusListener);
        if (this.editingTextComp instanceof JTextField) {
            ((JTextField)this.editingTextComp).removeActionListener(this.compActionListener);
        }
        this.editingTextComp = null;
        this.changeDone = applyChanges;
        this.fireEditingFinished();
    }

    private void createInPlaceField() {
        if (this.editedComp instanceof JLabel) {
            JLabel label = (JLabel)this.editedComp;
            this.inPlaceField = new InPlaceTextField(this.editedText);
            this.inPlaceField.setFont(label.getFont());
            this.inPlaceField.setHorizontalAlignment(label.getHorizontalAlignment());
        } else if (this.editedComp instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)this.editedComp;
            this.inPlaceField = new InPlaceTextField(this.editedText);
            this.inPlaceField.setFont(button.getFont());
            this.inPlaceField.setHorizontalAlignment(button.getHorizontalAlignment());
        } else if (this.editedComp instanceof JTabbedPane) {
            this.inPlaceField = new InPlaceTextField(this.editedText);
            this.inPlaceField.setFont(((JTabbedPane)this.editedComp).getFont());
            this.inPlaceField.setHorizontalAlignment(0);
            Insets insets = this.inPlaceField.getInsets();
            this.inPlaceField.setMargin(new Insets(0, insets.left, 0, insets.right));
        } else {
            return;
        }
        this.editingTextComp = this.inPlaceField;
        this.add(this.inPlaceField);
        this.placeInPlaceField();
    }

    private void attachListeners() {
        if (this.layerResizeListener != null) {
            this.removeComponentListener(this.layerResizeListener);
        } else {
            this.createListeners();
        }
        if (this.isLayerEditing()) {
            this.addComponentListener(this.layerResizeListener);
        }
        this.editingTextComp.addKeyListener(this.compKeyListener);
        this.editingTextComp.addFocusListener(this.compFocusListener);
        if (this.editingTextComp instanceof JTextField) {
            ((JTextField)this.editingTextComp).addActionListener(this.compActionListener);
        }
    }

    private void createListeners() {
        MouseInputListener layerMouseListener = new MouseInputListener(){

            public void mouseClicked(MouseEvent e) {
                InPlaceEditLayer.this.processMouse(e);
            }

            public void mousePressed(MouseEvent e) {
                InPlaceEditLayer.this.processMouse(e);
            }

            public void mouseReleased(MouseEvent e) {
                InPlaceEditLayer.this.processMouse(e);
            }

            public void mouseEntered(MouseEvent e) {
                InPlaceEditLayer.this.processMouse(e);
            }

            public void mouseExited(MouseEvent e) {
                InPlaceEditLayer.this.processMouse(e);
            }

            public void mouseDragged(MouseEvent e) {
                InPlaceEditLayer.this.processMouse(e);
            }

            public void mouseMoved(MouseEvent e) {
                InPlaceEditLayer.this.processMouse(e);
            }
        };
        this.addMouseListener(layerMouseListener);
        this.addMouseMotionListener(layerMouseListener);
        this.layerResizeListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (InPlaceEditLayer.this.isVisible()) {
                    InPlaceEditLayer.this.placeInPlaceField();
                }
            }
        };
        this.compKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    InPlaceEditLayer.this.finishEditing(false);
                } else if (e.getModifiers() == 2 && (e.getKeyCode() == 10 || e.getKeyCode() == 10)) {
                    InPlaceEditLayer.this.finishEditing(true);
                }
            }
        };
        this.compFocusListener = new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                InPlaceEditLayer.this.finishEditing(true);
            }
        };
        this.compActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InPlaceEditLayer.this.finishEditing(true);
            }
        };
    }

    private void processMouse(MouseEvent e) {
        if (!this.isEditingInitialized()) {
            return;
        }
        if (this.isLayerEditing()) {
            if (e.getID() == 501) {
                this.finishEditing(true);
            }
        } else {
            Container cont;
            Point p = SwingUtilities.convertPoint(this, e.getPoint(), this.superContainer);
            Component comp = SwingUtilities.getDeepestComponentAt(this.superContainer, p.x, p.y);
            if (!(comp == this.editedComp || comp == (cont = this.editedComp.getParent()) && cont instanceof JScrollPane)) {
                comp = null;
            }
            if (comp != null) {
                comp.dispatchEvent(SwingUtilities.convertMouseEvent(this, e, comp));
                if (e.getID() == 503) {
                    Cursor cursor = comp.getCursor();
                    if (this.getCursor() != cursor) {
                        this.setCursor(cursor);
                    }
                }
            } else if (e.getID() == 501) {
                this.finishEditing(true);
            } else if (e.getID() == 503 && this.getCursor() != this.defaultCursor) {
                this.setCursor(this.defaultCursor);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void placeInPlaceField() {
        Rectangle tR;
        Insets editingIns;
        Rectangle bounds;
        block27: {
            int hA;
            block25: {
                int hTP;
                block29: {
                    block28: {
                        block26: {
                            String text;
                            int itGap;
                            Icon icon;
                            int vTP;
                            int vA;
                            bounds = SwingUtilities.convertRectangle(this.editedComp.getParent(), this.editedComp.getBounds(), this);
                            Insets editedIns = ((JComponent)this.editedComp).getInsets();
                            editingIns = this.inPlaceField.getInsets();
                            if (this.editedComp instanceof JLabel) {
                                JLabel label = (JLabel)this.editedComp;
                                hA = label.getHorizontalAlignment();
                                hTP = label.getHorizontalTextPosition();
                                vA = label.getVerticalAlignment();
                                vTP = label.getVerticalTextPosition();
                                icon = label.getIcon();
                                itGap = icon != null ? label.getIconTextGap() : 0;
                                text = label.getText();
                            } else if (this.editedComp instanceof AbstractButton) {
                                Integer gap;
                                AbstractButton button = (AbstractButton)this.editedComp;
                                hA = button.getHorizontalAlignment();
                                hTP = button.getHorizontalTextPosition();
                                vA = button.getVerticalAlignment();
                                vTP = button.getVerticalTextPosition();
                                icon = button.getIcon();
                                itGap = icon != null ? ((gap = (Integer)UIManager.get("Button.textIconGap")) != null ? gap : 4) : 0;
                                text = button.getText();
                                if (this.editedComp instanceof JCheckBox || this.editedComp instanceof JRadioButton) {
                                    ComponentUI cui;
                                    if (icon == null && (cui = UIManager.getUI((JComponent)this.editedComp)) instanceof BasicRadioButtonUI) {
                                        icon = ((BasicRadioButtonUI)cui).getDefaultIcon();
                                        itGap = ((BasicRadioButtonUI)cui).getDefaultTextIconGap(button);
                                    }
                                    if (hA == 2 || hA == 10) {
                                        editedIns.right += editedIns.left;
                                        editedIns.left = 0;
                                    } else if (hA == 4 || hA == 11) {
                                        editedIns.left += editedIns.right;
                                        editedIns.right = 0;
                                    }
                                    if (vA == 1) {
                                        editedIns.bottom += editedIns.top;
                                        editedIns.top = 0;
                                    } else if (vA == 3) {
                                        editedIns.top += editedIns.bottom;
                                        editedIns.bottom = 0;
                                    }
                                }
                                if (this.editedComp instanceof JMenuItem && this.editedComp.getParent() != null && this.editedComp.getParent() instanceof JMenuBar) {
                                    // empty if block
                                }
                            } else {
                                if (!(this.editedComp instanceof JTabbedPane)) {
                                    return;
                                }
                                JTabbedPane tabbedPane = (JTabbedPane)this.editedComp;
                                int index = tabbedPane.getSelectedIndex();
                                text = tabbedPane.getTitleAt(index);
                                Rectangle relBounds = tabbedPane.getBoundsAt(index);
                                relBounds.x += bounds.x + 4;
                                relBounds.y += bounds.y;
                                bounds = relBounds;
                                bounds.width -= 8;
                                icon = tabbedPane.getIconAt(index);
                                itGap = UIManager.getInt("TabbedPane.textIconGap");
                                vTP = 0;
                                hA = 0;
                                vA = 0;
                                hTP = 11;
                                editedIns = new Insets(0, 0, 0, 0);
                            }
                            bounds.x += editedIns.left;
                            bounds.y += editedIns.top;
                            bounds.width -= editedIns.left + editedIns.right;
                            bounds.height -= editedIns.top + editedIns.bottom;
                            Rectangle iR = new Rectangle();
                            tR = new Rectangle();
                            SwingUtilities.layoutCompoundLabel((JComponent)this.editedComp, this.editedComp.getGraphics().getFontMetrics(), text, icon, vA, hA, vTP, hTP, bounds, iR, tR, itGap);
                            if (icon == null || hTP == 0) break block25;
                            if (hA != 2 && hA != 10) break block26;
                            if (hTP == 4 || hTP == 11) {
                                bounds.width -= tR.x - bounds.x;
                                bounds.x = tR.x;
                                this.inPlaceField.setHorizontalAlignment(2);
                                break block27;
                            } else if (hTP == 2 || hTP == 10) {
                                bounds.width = tR.width;
                                this.inPlaceField.setHorizontalAlignment(4);
                            }
                            break block27;
                        }
                        if (hA != 4 && hA != 11) break block28;
                        if (hTP == 4 || hTP == 11) {
                            bounds.x = tR.x;
                            bounds.width = tR.width;
                            this.inPlaceField.setHorizontalAlignment(2);
                        }
                        if (hTP == 2 || hTP == 10) {
                            bounds.width = tR.x - bounds.x + tR.width;
                            this.inPlaceField.setHorizontalAlignment(4);
                        }
                        break block27;
                    }
                    if (hTP != 4 && hTP != 11) break block29;
                    bounds.width -= tR.x - bounds.x;
                    bounds.x = tR.x;
                    this.inPlaceField.setHorizontalAlignment(2);
                    break block27;
                }
                if (hTP == 2 || hTP == 10) {
                    bounds.width = tR.x - bounds.x + tR.width;
                    this.inPlaceField.setHorizontalAlignment(4);
                    break block27;
                } else if (bounds.width > tR.width) {
                    ++bounds.x;
                    --bounds.width;
                }
                break block27;
            }
            if (hA == 0 && bounds.width > tR.width) {
                ++bounds.x;
                --bounds.width;
            }
        }
        bounds.x -= editingIns.left;
        bounds.width += editingIns.left + editingIns.right + 1;
        if (bounds.width < 10) {
            bounds.width = 10;
        }
        bounds.y = tR.y - editingIns.top;
        bounds.height = this.inPlaceField.getPreferredSize().height;
        this.inPlaceField.setBounds(bounds);
        this.inPlaceField.baseBounds = bounds;
        if (!this.inPlaceField.getText().equals(this.editedText)) {
            this.inPlaceField.adjustSize();
        }
    }

    public void requestFocus() {
        if (this.editingTextComp != null) {
            this.editingTextComp.requestFocus();
            int n = this.editingTextComp.getText().length();
            this.editingTextComp.setCaretPosition(n);
            this.editingTextComp.moveCaretPosition(0);
        } else {
            super.requestFocus();
        }
    }

    public boolean isOpaque() {
        return false;
    }

    public synchronized void addFinishListener(FinishListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public synchronized void removeFinishListener(FinishListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEditingFinished() {
        ArrayList targets;
        InPlaceEditLayer inPlaceEditLayer = this;
        synchronized (inPlaceEditLayer) {
            if (this.listeners == null) {
                return;
            }
            targets = (ArrayList)this.listeners.clone();
        }
        int n = targets.size();
        for (int i = 0; i < n; ++i) {
            ((FinishListener)targets.get(i)).editingFinished(this.changeDone);
        }
    }

    static interface FinishListener
    extends EventListener {
        public void editingFinished(boolean var1);
    }

    class InPlaceTextField
    extends JTextField {
        Rectangle baseBounds;

        public InPlaceTextField() {
        }

        public InPlaceTextField(String text) {
            super(text);
        }

        protected void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 9 || e.getKeyChar() == '\t') {
                e.consume();
            } else {
                super.processKeyEvent(e);
                if (e.getID() == 400) {
                    this.adjustSize();
                }
            }
        }

        void adjustSize() {
            int prefWidth = this.getPreferredSize().width + 1;
            if (prefWidth < this.baseBounds.width) {
                prefWidth = this.baseBounds.width;
            }
            Rectangle bounds = this.getBounds();
            if (prefWidth != bounds.width) {
                Rectangle newBounds;
                if (prefWidth == this.baseBounds.width) {
                    newBounds = this.baseBounds;
                } else {
                    int layerWidth = InPlaceEditLayer.this.getSize().width;
                    int leftX = this.baseBounds.x < 0 ? this.baseBounds.x : 0;
                    int rightX = this.baseBounds.x + this.baseBounds.width > layerWidth ? this.baseBounds.x + this.baseBounds.width : layerWidth;
                    newBounds = new Rectangle(bounds);
                    int hA = this.getHorizontalAlignment();
                    if (hA == 2 || hA == 10) {
                        newBounds.x = rightX - prefWidth;
                        if (newBounds.x < this.baseBounds.x) {
                            if (newBounds.x < leftX) {
                                newBounds.x = leftX;
                            }
                            newBounds.width = rightX - newBounds.x;
                        } else {
                            newBounds.x = this.baseBounds.x;
                            newBounds.width = prefWidth;
                        }
                    } else if (hA == 4 || hA == 11) {
                        newBounds.x = this.baseBounds.x + this.baseBounds.width - prefWidth;
                        if (newBounds.x < leftX) {
                            newBounds.x = leftX;
                            newBounds.width = prefWidth > rightX - leftX ? rightX - leftX : prefWidth;
                        } else {
                            newBounds.width = prefWidth;
                        }
                    } else {
                        int cX = this.baseBounds.x + this.baseBounds.width / 2;
                        int dX1 = prefWidth / 2;
                        int dX2 = prefWidth - dX1;
                        int over2 = cX - leftX < dX1 ? dX1 - (cX - leftX) : 0;
                        int over1 = rightX - cX < dX2 ? dX2 - (rightX - cX) : 0;
                        dX1 = cX - leftX < dX1 + over1 ? cX - leftX : (dX1 += over1);
                        dX2 = rightX - cX < dX2 + over2 ? rightX - cX : (dX2 += over2);
                        newBounds.x = cX - dX1;
                        newBounds.width = dX1 + dX2;
                    }
                }
                if (!newBounds.equals(bounds)) {
                    this.setBounds(newBounds);
                }
            }
        }
    }
}

