/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.ExternalValue;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.I18nService;
import org.netbeans.modules.form.I18nValue;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.ResourcePanel;
import org.netbeans.modules.form.ResourceService;
import org.netbeans.modules.form.ResourceValue;
import org.netbeans.modules.form.ResourceWrapperEditor;
import org.netbeans.modules.form.editors.EnumEditor;
import org.netbeans.modules.form.editors.IconEditor;
import org.netbeans.modules.form.editors2.BorderDesignSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSupport {
    private FormModel formModel;
    private ResourceService resourceService;
    private I18nService i18nService;
    private String designLocale = "";
    private static Map<DataObject, String> rememberedLocales = new WeakHashMap<DataObject, String>();
    private Map droppedValues;
    private static final String EXCLUDE_FROM_RESOURCING = "does not want to be a resource";
    private static final String EXCLUSION_DETERMINED = "already consulted with exclusion filters";
    static final String PROP_AUTO_RESOURCING = "autoResourcing";
    static final int AUTO_OFF = 0;
    static final int AUTO_I18N = 1;
    static final int AUTO_RESOURCING = 2;
    static final int AUTO_INJECTION = 3;
    static final String PROP_FORM_BUNDLE = "formBundle";
    private static final String PROP_DESIGN_LOCALE = "designLocale";
    private static final String DEFAULT_BUNDLE_NAME = "Bundle";
    private String defaultI18nBundle;
    private static final int PLAIN_VALUE = 1;
    private static final int UNDEFINED_RESOURCE = 2;
    private static final int VALID_RESOURCE_VALUE = 4;

    ResourceSupport(FormModel formModel) {
        this.formModel = formModel;
        formModel.addFormModelListener(new ModelListener());
    }

    void init() {
        String locale = rememberedLocales.get(this.getSrcDataObject());
        if (locale != null) {
            this.designLocale = locale;
            if (!locale.equals("") && this.formModel.isFormLoaded()) {
                this.updateDesignLocale();
            }
        }
    }

    private ResourceService getResourceService() {
        if (this.resourceService == null) {
            this.resourceService = (ResourceService)Lookup.getDefault().lookup(ResourceService.class);
        }
        return this.resourceService;
    }

    private I18nService getI18nService() {
        if (this.i18nService == null) {
            this.i18nService = (I18nService)Lookup.getDefault().lookup(I18nService.class);
        }
        return this.i18nService;
    }

    private static ResourceSupport getResourceSupport(FormProperty property) {
        return FormEditor.getResourceSupport(property.getPropertyContext().getFormModel());
    }

    private static ResourceSupport getResourceSupport(RADComponent metacomp) {
        return FormEditor.getResourceSupport(metacomp.getFormModel());
    }

    public static Object makeResource(Object value, FormProperty property) {
        if (!ResourceSupport.isResourceableProperty(property)) {
            return value;
        }
        ResourceSupport support = ResourceSupport.getResourceSupport(property);
        if (ResourceSupport.isResourceType(property.getValueType())) {
            value = support.makeResource0(value, property);
        } else {
            for (FormProperty prop : support.getNestedResourceProperties(value, property, 1)) {
                boolean fire = prop.isChangeFiring();
                prop.setChangeFiring(false);
                try {
                    Object val = prop.getValue();
                    Object resValue = support.makeResource0(val, prop);
                    if (resValue != val) {
                        prop.setValue(resValue);
                    }
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                prop.setChangeFiring(fire);
            }
        }
        return value;
    }

    private Object makeResource0(Object value, FormProperty property) {
        Object prevValue;
        if (value instanceof ExternalValue) {
            ExternalValue eValue = (ExternalValue)value;
            if (eValue.getKey() == "#auto") {
                String key = ResourceSupport.getDefaultKey(property);
                if (value instanceof I18nValue && this.getI18nService() != null) {
                    eValue = this.i18nService.changeKey((I18nValue)value, key);
                } else if (value instanceof ResourceValue && this.getResourceService() != null) {
                    eValue = this.resourceService.changeKey((ResourceValue)value, key);
                }
            }
            return eValue;
        }
        if (value == null || !ResourceSupport.isConvertibleToResource(value) || this.isExcludedProperty0(property)) {
            return value;
        }
        try {
            prevValue = property.getValue();
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return value;
        }
        if (prevValue instanceof I18nValue) {
            if (this.getI18nService() != null) {
                value = this.i18nService.changeValue((I18nValue)prevValue, value.toString());
            }
        } else if (prevValue instanceof ResourceValue) {
            if (this.getResourceService() != null) {
                value = this.resourceService.changeValue((ResourceValue)prevValue, value, ResourceSupport.getStringValue(property, value));
            }
        } else if (this.isI18nAutoMode()) {
            if (value instanceof String) {
                I18nValue i18nValue = this.searchDroppedI18nValue((Object)property, value.toString());
                if (i18nValue == null) {
                    i18nValue = this.i18nService.create(ResourceSupport.getDefaultKey(property), value.toString(), this.getSrcDataObject());
                }
                value = new FormProperty.ValueWithEditor((Object)i18nValue, this.i18nService.getPropertyEditor(property.getValueType(), property.getCurrentEditor()));
            }
        } else if (this.isResourceAutoMode()) {
            ResourceValue resValue = this.searchDroppedResourceValue((Object)property, value);
            value = resValue == null ? this.resourceService.create(ResourceSupport.getDefaultKey(property), property.getValueType(), value, ResourceSupport.getStringValue(property, value), this.getSourceFile()) : resValue;
        }
        return value;
    }

    private I18nValue searchDroppedI18nValue(Object key, String expectedValue) {
        I18nValue i18nValue;
        Object value;
        if (this.droppedValues != null && (value = this.droppedValues.get(key)) instanceof I18nValue && (i18nValue = (I18nValue)value).getValue().equals(expectedValue)) {
            return i18nValue;
        }
        return null;
    }

    private ResourceValue searchDroppedResourceValue(Object key, Object expectedValue) {
        ResourceValue resValue;
        Object value;
        if (this.droppedValues != null && (value = this.droppedValues.get(key)) instanceof ResourceValue && (resValue = (ResourceValue)value).getValue().equals(expectedValue)) {
            return resValue;
        }
        return null;
    }

    public static void switchComponentToResources(RADComponent metacomp) {
        ResourceSupport support = ResourceSupport.getResourceSupport(metacomp);
        if (support.isAutoMode()) {
            support.switchComponentToResources(metacomp, false, true);
        }
    }

    private void switchComponentToResources(RADComponent metacomp, boolean update, boolean recursive) {
        int valueType = 3;
        for (FormProperty prop : this.getComponentResourceProperties(metacomp, valueType, recursive)) {
            boolean fire = prop.isChangeFiring();
            prop.setChangeFiring(false);
            try {
                Object resValue = this.makeResource0(prop.getValue(), prop);
                prop.setValue(resValue);
                if (update) {
                    resValue = prop.getValue();
                    if (resValue instanceof I18nValue) {
                        this.getI18nService().update(null, (I18nValue)resValue, this.getSrcDataObject(), this.getI18nBundleName(), this.designLocale, true);
                    } else if (resValue instanceof ResourceValue) {
                        this.getResourceService().update(null, (ResourceValue)resValue, this.getSourceFile(), this.designLocale);
                    }
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            prop.setChangeFiring(fire);
        }
        if (this.getAutoName() && metacomp != this.formModel.getTopRADComponent()) {
            ResourceSupport.setupNameProperty(metacomp, true, recursive);
        }
    }

    private static void setupNameProperty(RADComponent metacomp, boolean set, boolean recursive) {
        FormProperty nameProp = ResourceSupport.getNameProperty(metacomp);
        if (nameProp != null) {
            try {
                if (set && !nameProp.isChanged()) {
                    nameProp.setValue(metacomp.getName());
                } else if (!set && nameProp.isChanged() && metacomp.getName().equals(nameProp.getValue())) {
                    nameProp.restoreDefaultValue();
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        if (recursive && metacomp instanceof ComponentContainer) {
            for (RADComponent subcomp : ((ComponentContainer)((Object)metacomp)).getSubBeans()) {
                ResourceSupport.setupNameProperty(subcomp, set, recursive);
            }
        }
    }

    private static FormProperty getNameProperty(RADComponent metacomp) {
        if (metacomp.getBeanInstance() instanceof Component) {
            return (FormProperty)metacomp.getPropertyByName("name");
        }
        return null;
    }

    void switchFormToResources() {
        for (RADComponent metacomp : this.formModel.getAllComponents()) {
            this.switchComponentToResources(metacomp, true, false);
        }
        if (this.droppedValues != null) {
            this.droppedValues.clear();
        }
    }

    private void switchFormToPlainValues(boolean cancelInjection) {
        for (RADComponent metacomp : this.formModel.getAllComponents()) {
            for (FormProperty prop : this.getComponentResourceProperties(metacomp, 4, false)) {
                Object value = ResourceSupport.getAutoValue(prop);
                if (value == null) continue;
                boolean fire = prop.isChangeFiring();
                prop.setChangeFiring(false);
                try {
                    if (value instanceof I18nValue) {
                        I18nValue i18nValue = (I18nValue)value;
                        prop.setValue(new FormProperty.ValueWithEditor((Object)i18nValue.getValue(), prop.findDefaultEditor()));
                        this.i18nService.update(i18nValue, null, this.getSrcDataObject(), this.getI18nBundleName(), null, true);
                    } else if (value instanceof ResourceValue) {
                        Object plainValue;
                        ResourceValue resValue = (ResourceValue)value;
                        PropertyEditor prEd = prop.getCurrentEditor();
                        if (prEd instanceof ResourceWrapperEditor) {
                            prEd.setValue(value);
                            plainValue = ((ResourceWrapperEditor)((Object)prEd)).getUnwrappedValue();
                        } else {
                            plainValue = resValue.getValue();
                        }
                        prop.setValue(plainValue);
                        this.resourceService.update(resValue, null, this.getSourceFile(), this.designLocale);
                    }
                    this.addDroppedValue(prop, value);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                prop.setChangeFiring(fire);
            }
            if (!cancelInjection || metacomp == this.formModel.getTopRADComponent()) continue;
            ResourceSupport.setupNameProperty(metacomp, false, false);
        }
    }

    private void addDroppedValue(FormProperty property, Object value) {
        if (this.droppedValues == null) {
            this.droppedValues = new HashMap();
        }
        this.droppedValues.put(property, value);
    }

    public static void componentRenamed(RADComponent metacomp, String newName) {
        FormProperty nameProp;
        ResourceSupport support = ResourceSupport.getResourceSupport(metacomp);
        if (support.isAutoMode()) {
            support.renameDefaultKeys(metacomp, newName);
        }
        if ((nameProp = ResourceSupport.getNameProperty(metacomp)) != null && nameProp.isChanged()) {
            try {
                Object name = nameProp.getValue();
                String oldName = metacomp.getName();
                if (oldName.equals(name)) {
                    nameProp.setValue(newName);
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    private void renameDefaultKeys(RADComponent metacomp, String newName) {
        assert (metacomp != metacomp.getFormModel().getTopRADComponent());
        String oldName = metacomp.getName();
        for (FormProperty prop : this.getComponentResourceProperties(metacomp, 4, false)) {
            ExternalValue eValue = null;
            String oldKey = null;
            String oldDefaultKey = null;
            try {
                ExternalValue val = (ExternalValue)prop.getValue();
                oldKey = eValue.getKey();
                oldDefaultKey = ResourceSupport.getDefaultKey(prop);
                if (ResourceSupport.isAutoKey(oldKey, oldDefaultKey)) {
                    eValue = val;
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            if (eValue == null) continue;
            String oldPath = prop.getPropertyContext().getContextPath();
            int idx = oldPath.indexOf(oldName);
            String newPath = oldPath.substring(0, idx) + newName + oldPath.substring(idx + oldName.length());
            String newKey = ResourceSupport.getDefaultKey(newPath, prop.getName());
            if (oldKey.length() > oldDefaultKey.length()) {
                newKey = newKey + oldKey.substring(oldDefaultKey.length());
            }
            boolean fire = prop.isChangeFiring();
            prop.setChangeFiring(false);
            try {
                if (eValue instanceof I18nValue) {
                    I18nValue oldI18nValue = (I18nValue)eValue;
                    I18nValue newI18nValue = this.i18nService.changeKey(oldI18nValue, newKey);
                    prop.setValue(newI18nValue);
                    this.i18nService.update(oldI18nValue, newI18nValue, this.getSrcDataObject(), this.getI18nBundleName(), this.designLocale, true);
                } else if (eValue instanceof ResourceValue) {
                    ResourceValue oldResValue = (ResourceValue)eValue;
                    ResourceValue newResValue = this.resourceService.changeKey(oldResValue, newKey);
                    prop.setValue(newResValue);
                    this.resourceService.update(oldResValue, newResValue, this.getSourceFile(), this.designLocale);
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            prop.setChangeFiring(fire);
        }
    }

    public static void loadInjectedResources(RADComponent metacomp) {
        ResourceSupport support = ResourceSupport.getResourceSupport(metacomp);
        if (support != null && support.getAutoName()) {
            support.loadInjectedResources0(metacomp);
        }
    }

    private void loadInjectedResources0(RADComponent metacomp) {
        if (this.getResourceService() == null) {
            return;
        }
        String keyEx = metacomp.getName() + "\\.\\w+";
        Collection<String> compResources = this.resourceService.findKeys(keyEx, this.getSourceFile());
        if (compResources.size() > 0) {
            String[] propNames = new String[compResources.size()];
            int compPrefixLength = metacomp.getName().length() + 1;
            int i = 0;
            for (String key : compResources) {
                propNames[i++] = key.substring(compPrefixLength);
            }
            RADProperty[] properties = metacomp.getBeanProperties(propNames);
            i = 0;
            for (String key : compResources) {
                RADProperty prop;
                if ((prop = properties[i++]) == null || !ResourceSupport.isResourceType(prop.getValueType())) continue;
                try {
                    ((FormProperty)prop).setValue(this.resourceService.get(key, prop.getValueType(), this.designLocale, this.getSourceFile()));
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
    }

    public static void updateStoredValue(Object oldValue, Object newValue, FormProperty property) {
        if (!ResourceSupport.isResourceableProperty(property)) {
            return;
        }
        ResourceSupport support = ResourceSupport.getResourceSupport(property);
        if (ResourceSupport.isResourceType(property.getValueType())) {
            support.updateStoredValue0(oldValue, newValue, property);
        } else {
            Collection<FormProperty> colOld = support.getNestedResourceProperties(oldValue, property, 4);
            Collection<FormProperty> colNew = support.getNestedResourceProperties(newValue, property, 4);
            for (FormProperty oProp : colOld) {
                boolean foundInNew = false;
                Iterator<FormProperty> it = colNew.iterator();
                while (it.hasNext()) {
                    FormProperty nProp = it.next();
                    if (!oProp.getName().equals(nProp.getName()) || !oProp.getPropertyContext().getContextPath().equals(nProp.getPropertyContext().getContextPath())) continue;
                    try {
                        support.updateStoredValue0(oProp.getValue(), nProp.getValue(), nProp);
                    }
                    catch (Exception ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    it.remove();
                    foundInNew = true;
                    break;
                }
                if (foundInNew) continue;
                try {
                    support.updateStoredValue0(oProp.getValue(), null, oProp);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            for (FormProperty nProp : colNew) {
                try {
                    support.updateStoredValue0(null, nProp.getValue(), nProp);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
    }

    private void updateStoredValue0(Object oldValue, Object newValue, FormProperty property) {
        if (oldValue instanceof I18nValue) {
            this.updateI18nValue(oldValue, newValue, property);
            if (newValue instanceof ResourceValue) {
                this.updateResourceValue(oldValue, newValue, property);
            }
        } else if (oldValue instanceof ResourceValue) {
            this.updateResourceValue(oldValue, newValue, property);
            if (newValue instanceof I18nValue) {
                this.updateI18nValue(oldValue, newValue, property);
            }
        } else if (newValue instanceof I18nValue) {
            this.updateI18nValue(oldValue, newValue, property);
        } else if (newValue instanceof ResourceValue) {
            this.updateResourceValue(oldValue, newValue, property);
        }
    }

    private void updateI18nValue(Object oldValue, Object newValue, FormProperty property) {
        if (this.getI18nService() != null) {
            I18nValue oldVal = oldValue instanceof I18nValue ? (I18nValue)oldValue : null;
            I18nValue newVal = newValue instanceof I18nValue ? (I18nValue)newValue : null;
            try {
                this.i18nService.update(oldVal, newVal, this.getSrcDataObject(), this.getI18nBundleName(), this.designLocale, ResourceSupport.isAutoValue(oldValue, ResourceSupport.getDefaultKey(property)));
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    private void updateResourceValue(Object oldValue, Object newValue, FormProperty property) {
        if (this.getResourceService() != null) {
            ResourceValue oldVal = oldValue instanceof ResourceValue ? (ResourceValue)oldValue : null;
            ResourceValue newVal = newValue instanceof ResourceValue ? (ResourceValue)newValue : null;
            try {
                this.resourceService.update(oldVal, newVal, this.getSourceFile(), this.designLocale);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    public static ResourceValue findResource(String key, FormProperty property) {
        if (!ResourceSupport.isResourceableProperty(property)) {
            return null;
        }
        return ResourceSupport.getResourceSupport(property).findResource0(key, property);
    }

    private ResourceValue findResource0(String key, FormProperty prop) {
        return this.getResourceService() != null ? this.resourceService.get(key, prop.getValueType(), this.designLocale, this.getSourceFile()) : null;
    }

    public static boolean isResourceableProperty(FormProperty prop) {
        return prop.getPropertyContext().useMultipleEditors();
    }

    public static boolean isPropertyForResourcing(FormProperty prop) {
        if (!ResourceSupport.isResourceableProperty(prop)) {
            return false;
        }
        ResourceSupport support = ResourceSupport.getResourceSupport(prop);
        return !support.isExcludedProperty0(prop) && support.isResourceAutoMode();
    }

    public static boolean isExcludedProperty(FormProperty prop) {
        assert (ResourceSupport.isResourceableProperty(prop));
        return Boolean.TRUE.equals(prop.getValue(EXCLUDE_FROM_RESOURCING)) ? true : ResourceSupport.getResourceSupport(prop).isExcludedProperty1(prop);
    }

    private boolean isExcludedProperty0(FormProperty prop) {
        return Boolean.TRUE.equals(prop.getValue(EXCLUDE_FROM_RESOURCING)) ? true : this.isExcludedProperty1(prop);
    }

    private boolean isExcludedProperty1(FormProperty prop) {
        if (!Boolean.TRUE.equals(prop.getValue(EXCLUSION_DETERMINED))) {
            if (this.getResourceService() == null) {
                return false;
            }
            prop.setValue(EXCLUSION_DETERMINED, true);
            boolean excl = this.resourceService.isExcludedProperty(prop.getPropertyContext().getParentObjectType(), prop.getName());
            prop.setValue(EXCLUDE_FROM_RESOURCING, excl);
            return excl;
        }
        return false;
    }

    public static void setExcludedProperty(FormProperty prop, boolean excl) {
        if (ResourceSupport.isResourceableProperty(prop) && excl != ResourceSupport.isExcludedProperty(prop)) {
            prop.setValue(EXCLUDE_FROM_RESOURCING, excl);
        }
    }

    public static String getInjectionCode(RADComponent metacomp, String compGenName) {
        return ResourceSupport.getResourceSupport(metacomp).getInjectionCode0(metacomp, compGenName);
    }

    private String getInjectionCode0(RADComponent metacomp, String compGenName) {
        return this.getAutoName() && this.getResourceService() != null ? this.resourceService.getInjectionCode(metacomp.getBeanInstance(), compGenName, this.getSourceFile()) : null;
    }

    public static boolean isInjectedProperty(FormProperty prop) {
        ResourceSupport support;
        if (ResourceSupport.isResourceableProperty(prop) && (support = ResourceSupport.getResourceSupport(prop)).getAutoName()) {
            try {
                String key;
                Object value = prop.getValue();
                if (value instanceof ResourceValue && (key = ((ResourceValue)value).getKey()) != null && ResourceSupport.getDefaultKey(prop).equals(key)) {
                    return true;
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return false;
    }

    public boolean isDefaultInternationalizableProject() {
        if (this.getI18nService() != null) {
            return this.i18nService.isDefaultInternationalizableProject(this.getSourceFile());
        }
        return false;
    }

    public boolean projectUsesResources() {
        if (this.getResourceService() != null) {
            return this.resourceService.projectUsesResources(this.getSourceFile());
        }
        return false;
    }

    public boolean projectCanUseResources() {
        if (this.getResourceService() != null) {
            return this.resourceService.projectCanUseResources(this.getSourceFile());
        }
        return false;
    }

    private void changeBundle(String newBundle) {
        this.switchFormToPlainValues(false);
        this.formModel.getSettings().setFormBundle(newBundle);
        String oldLocale = this.designLocale;
        this.setDesignLocale("");
        FormEditor.getFormEditor(this.formModel).getFormRootNode().firePropertyChangeHelper(PROP_DESIGN_LOCALE, oldLocale, this.designLocale);
        this.switchFormToResources();
    }

    String getDesignLocale() {
        return this.designLocale;
    }

    private void changeDesignLocale(String designLocale) {
        this.setDesignLocale(designLocale);
        this.updateDesignLocale();
        this.formModel.fireEvents(null);
    }

    private void setDesignLocale(String locale) {
        this.designLocale = locale;
        rememberedLocales.put(this.getSrcDataObject(), locale);
    }

    private void updateDesignLocale() {
        Collection<FormProperty> props = this.getAllResourceProperties(4);
        ArrayList<Object> values = new ArrayList<Object>(props.size());
        for (FormProperty prop : props) {
            try {
                values.add(prop.getValue());
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        Iterator it = values.iterator();
        for (FormProperty prop : props) {
            Object value = it.next();
            boolean fire = prop.isChangeFiring();
            prop.setChangeFiring(false);
            try {
                if (value instanceof I18nValue) {
                    prop.setValue(this.i18nService.switchLocale((I18nValue)value, this.designLocale));
                } else if (value instanceof ResourceValue) {
                    prop.setValue(this.resourceService.switchLocale((ResourceValue)value, this.designLocale));
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            prop.setChangeFiring(fire);
        }
    }

    public static ResourcePanel createResourcePanel(FormProperty property, boolean force) {
        if (!ResourceSupport.isResourceableProperty(property)) {
            return null;
        }
        return ResourceSupport.getResourceSupport(property).createResourcePanel0(property, force);
    }

    private ResourcePanel createResourcePanel0(FormProperty prop, boolean force) {
        if (this.getResourceService() != null && (force || !this.isI18nAutoMode() && (this.isResourceAutoMode() || this.resourceService.projectUsesResources(this.getSourceFile())))) {
            return this.resourceService.createResourcePanel(prop.getValueType(), this.getSourceFile());
        }
        return null;
    }

    private Collection<FormProperty> getAllResourceProperties(int valueType) {
        Collection<RADComponent> components = this.formModel.getAllComponents();
        ArrayList<FormProperty> propList = new ArrayList<FormProperty>(components.size());
        for (RADComponent metacomp : components) {
            this.collectResourceProperties(metacomp, valueType, false, propList);
        }
        return propList;
    }

    private Collection<FormProperty> getComponentResourceProperties(RADComponent metacomp, int valueType, boolean recursive) {
        Collection<FormProperty> col = this.collectResourceProperties(metacomp, valueType, recursive, null);
        if (col == null) {
            col = Collections.emptyList();
        }
        return col;
    }

    private Collection<FormProperty> getNestedResourceProperties(Object value, FormProperty prop, int valueType) {
        Collection<FormProperty> col = this.collectNestedResourceProperties(value, prop, valueType, null);
        if (col == null) {
            col = Collections.emptyList();
        }
        return col;
    }

    /*
     * WARNING - void declaration
     */
    private Collection<FormProperty> collectResourceProperties(RADComponent metacomp, int valueType, boolean recursive, Collection<FormProperty> col) {
        Node.Property[] propertyArray;
        for (RADProperty rADProperty : metacomp.getKnownBeanProperties()) {
            if (!rADProperty.isChanged() || !ResourceSupport.isResourceableProperty(rADProperty) || this.isExcludedProperty0(rADProperty)) continue;
            col = this.collectNestedResourceProperties(rADProperty, valueType, col);
        }
        if (metacomp instanceof RADVisualComponent && (propertyArray = ((RADVisualComponent)metacomp).getConstraintsProperties()) != null) {
            void var8_14;
            Node.Property[] arr$ = propertyArray;
            int len$ = arr$.length;
            boolean bl = false;
            while (var8_14 < len$) {
                FormProperty prop;
                Node.Property p = arr$[var8_14];
                if (p instanceof FormProperty && (prop = (FormProperty)p).isChanged() && ResourceSupport.isResourceableProperty(prop) && !this.isExcludedProperty0(prop)) {
                    col = this.collectNestedResourceProperties(prop, valueType, col);
                }
                ++var8_14;
            }
        }
        if (recursive && metacomp instanceof ComponentContainer) {
            for (RADComponent rADComponent : ((ComponentContainer)((Object)metacomp)).getSubBeans()) {
                col = this.collectResourceProperties(rADComponent, valueType, recursive, col);
            }
        }
        return col;
    }

    private Collection<FormProperty> collectNestedResourceProperties(Object value, FormProperty property, int valueType, Collection<FormProperty> col) {
        Node.Property[] nestedProps = ResourceSupport.getNestedProperties(value);
        if (nestedProps == null) {
            if ((valueType != 1 || ResourceSupport.isResourceType(property.getValueType())) && ResourceSupport.isWanted(valueType, value)) {
                if (col == null) {
                    col = new LinkedList<FormProperty>();
                }
                col.add(property);
            }
            return col;
        }
        for (Node.Property p : nestedProps) {
            FormProperty prop;
            if (!(p instanceof FormProperty) || !(prop = (FormProperty)p).isChanged() || !ResourceSupport.isResourceableProperty(prop) || this.isExcludedProperty0(prop)) continue;
            col = this.collectNestedResourceProperties(prop, valueType, col);
        }
        return col;
    }

    private Collection<FormProperty> collectNestedResourceProperties(FormProperty property, int valueType, Collection<FormProperty> col) {
        try {
            return this.collectNestedResourceProperties(property.getValue(), property, valueType, col);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return col;
        }
    }

    private static Node.Property[] getNestedProperties(Object value) {
        if (value instanceof BorderDesignSupport) {
            return ((BorderDesignSupport)value).getProperties();
        }
        return null;
    }

    private static boolean isWanted(int valueType, Object value) {
        String key;
        if (value instanceof ExternalValue) {
            key = ((ExternalValue)value).getKey();
            if (key == null) {
                key = "";
            }
        } else {
            key = null;
        }
        if (key == null) {
            return (valueType & 1) != 0 && !(value instanceof FormDesignValue);
        }
        if ((valueType & 2) != 0 && key.equals("#auto")) {
            return true;
        }
        return (valueType & 4) != 0 && !key.startsWith("#");
    }

    static String getDefaultKey(FormProperty prop) {
        return ResourceSupport.getDefaultKey(prop.getPropertyContext().getContextPath(), prop.getName());
    }

    private static String getDefaultKey(String path, String propName) {
        return path != null && !path.equals("") ? path + "." + propName : propName;
    }

    private FileObject getSourceFile() {
        FormDataObject dobj = FormEditor.getFormDataObject(this.formModel);
        return dobj != null ? dobj.getPrimaryFile() : null;
    }

    private DataObject getSrcDataObject() {
        return FormEditor.getFormDataObject(this.formModel);
    }

    private int getAutoMode() {
        return this.formModel.getSettings().getResourceAutoMode();
    }

    private boolean isAutoMode() {
        return this.getAutoMode() != 0;
    }

    private boolean isResourceAutoMode() {
        int mode = this.formModel.getSettings().getResourceAutoMode();
        return this.getResourceService() != null && (mode == 2 || mode == 3);
    }

    private boolean isI18nAutoMode() {
        return this.getI18nService() != null && this.formModel.getSettings().getResourceAutoMode() == 1;
    }

    private boolean getAutoName() {
        return this.getAutoMode() == 3;
    }

    private String getI18nBundleName() {
        String bundleName = this.formModel.getSettings().getFormBundle();
        if (bundleName == null) {
            if (this.defaultI18nBundle == null) {
                FileObject file = this.getSourceFile();
                ClassPath cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
                if (cp == null) {
                    return null;
                }
                String resName = cp.getResourceName(file.getParent());
                this.defaultI18nBundle = resName != null && resName.length() > 0 ? resName + "/" + DEFAULT_BUNDLE_NAME : DEFAULT_BUNDLE_NAME;
            }
            bundleName = this.defaultI18nBundle;
        }
        return bundleName;
    }

    private static boolean isResourceType(Class type) {
        return type == String.class || Font.class.isAssignableFrom(type) || Icon.class.isAssignableFrom(type) || Color.class.isAssignableFrom(type);
    }

    private static boolean isConvertibleToResource(Object value) {
        return value instanceof String || value instanceof Font || value instanceof IconEditor.NbImageIcon || value instanceof Color;
    }

    private static Object getAutoValue(FormProperty prop) {
        Object value;
        try {
            value = prop.getValue();
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
        return ResourceSupport.isAutoValue(value, ResourceSupport.getDefaultKey(prop)) ? value : null;
    }

    private static boolean isAutoValue(Object value, String defaultKey) {
        String key = value instanceof ExternalValue ? ((ExternalValue)value).getKey() : null;
        return key != null ? ResourceSupport.isAutoKey(key, defaultKey) : false;
    }

    private static boolean isAutoKey(String key, String defaultKey) {
        return key != null && key.startsWith(defaultKey);
    }

    private static String getStringValue(FormProperty prop, Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        PropertyEditor prEd = prop.getCurrentEditor();
        prEd.setValue(value);
        return prEd.getAsText();
    }

    Node.Property[] createFormProperties() {
        Node.Property[] propertyArray;
        PropertySupport.ReadWrite autoModeProp = new PropertySupport.ReadWrite(PROP_AUTO_RESOURCING, Integer.TYPE, FormUtils.getBundleString("PROP_AUTO_RESOURCE"), FormUtils.getBundleString("HINT_AUTO_RESOURCE_LOCAL")){

            public void setValue(Object value) {
                Integer oldValue = new Integer(ResourceSupport.this.getAutoMode());
                if (!oldValue.equals(value)) {
                    int autoMode = (Integer)value;
                    boolean wasInjection = ResourceSupport.this.getAutoMode() == 3;
                    ResourceSupport.this.formModel.getSettings().setResourceAutoMode(autoMode);
                    if (autoMode == 0) {
                        ResourceSupport.this.switchFormToPlainValues(wasInjection);
                    } else {
                        ResourceSupport.this.switchFormToResources();
                    }
                    ResourceSupport.this.formModel.fireSyntheticPropertyChanged(null, ResourceSupport.PROP_AUTO_RESOURCING, oldValue, value);
                    FormEditor.getFormEditor(ResourceSupport.this.formModel).getFormRootNode().firePropertyChangeHelper(ResourceSupport.PROP_AUTO_RESOURCING, oldValue, value);
                }
            }

            public Object getValue() {
                return ResourceSupport.this.getAutoMode();
            }

            public PropertyEditor getPropertyEditor() {
                return new EnumEditor(new Object[]{FormUtils.getBundleString("CTL_AUTO_OFF"), 0, "", FormUtils.getBundleString("CTL_AUTO_I18N"), 1, "", FormUtils.getBundleString("CTL_AUTO_RESOURCING"), 2, "", FormUtils.getBundleString("CTL_AUTO_INJECTION"), 3, ""});
            }
        };
        PropertySupport.ReadWrite formBundleProp = new PropertySupport.ReadWrite(PROP_FORM_BUNDLE, String.class, FormUtils.getBundleString("PROP_FORM_BUNDLE"), FormUtils.getBundleString("HINT_FORM_BUNDLE")){

            public void setValue(Object value) {
                String oldValue = ResourceSupport.this.getI18nBundleName();
                if (oldValue == null && value != null || !oldValue.equals(value)) {
                    String resourceName = (String)value;
                    if (resourceName != null && resourceName.toLowerCase().endsWith(".properties")) {
                        resourceName = resourceName.substring(0, resourceName.length() - ".properties".length());
                    }
                    ResourceSupport.this.changeBundle(resourceName);
                    ResourceSupport.this.formModel.fireSyntheticPropertyChanged(null, ResourceSupport.PROP_FORM_BUNDLE, oldValue, value);
                    FormEditor.getFormEditor(ResourceSupport.this.formModel).getFormRootNode().firePropertyChangeHelper(ResourceSupport.PROP_FORM_BUNDLE, oldValue, value);
                }
            }

            public Object getValue() {
                return ResourceSupport.this.getI18nBundleName();
            }

            public PropertyEditor getPropertyEditor() {
                return new BundleFilePropertyEditor();
            }
        };
        PropertySupport.ReadWrite localeProp = new PropertySupport.ReadWrite(PROP_DESIGN_LOCALE, String.class, FormUtils.getBundleString("PROP_DESIGN_LOCALE"), FormUtils.getBundleString("HINT_DESIGN_LOCALE")){

            public void setValue(Object value) {
                String oldValue = ResourceSupport.this.designLocale;
                ResourceSupport.this.changeDesignLocale((String)value);
                ResourceSupport.this.formModel.fireSyntheticPropertyChanged(null, ResourceSupport.PROP_DESIGN_LOCALE, oldValue, value);
                FormEditor.getFormEditor(ResourceSupport.this.formModel).getFormRootNode().firePropertyChangeHelper(ResourceSupport.PROP_DESIGN_LOCALE, oldValue, value);
            }

            public Object getValue() {
                return ResourceSupport.this.designLocale;
            }

            public PropertyEditor getPropertyEditor() {
                return new LocalePropertyEditor();
            }
        };
        int autoMode = this.getAutoMode();
        if (autoMode == 0 || autoMode == 1) {
            Node.Property[] propertyArray2 = new Node.Property[3];
            propertyArray2[0] = autoModeProp;
            propertyArray2[1] = formBundleProp;
            propertyArray = propertyArray2;
            propertyArray2[2] = localeProp;
        } else {
            Node.Property[] propertyArray3 = new Node.Property[2];
            propertyArray3[0] = autoModeProp;
            propertyArray = propertyArray3;
            propertyArray3[1] = localeProp;
        }
        return propertyArray;
    }

    private class BundleFilePropertyEditor
    extends PropertyEditorSupport {
        private BundleFilePropertyEditor() {
        }

        public boolean supportsCustomEditor() {
            return ResourceSupport.this.getI18nService() != null;
        }

        public Component getCustomEditor() {
            return ResourceSupport.this.getI18nService() != null ? ResourceSupport.this.i18nService.getBundleSelectionComponent(this, ResourceSupport.this.getSourceFile()) : null;
        }
    }

    private class LocalePropertyEditor
    extends PropertyEditorSupport {
        private String[][] tags;

        private LocalePropertyEditor() {
        }

        public String[] getTags() {
            FileObject srcFile;
            if (this.tags == null && (srcFile = ResourceSupport.this.getSourceFile()) != null) {
                if (ResourceSupport.this.isI18nAutoMode()) {
                    this.tags = ResourceSupport.this.i18nService.getAvailableLocales(srcFile, ResourceSupport.this.getI18nBundleName());
                } else if (ResourceSupport.this.isResourceAutoMode()) {
                    this.tags = ResourceSupport.this.resourceService.getAvailableLocales(srcFile);
                }
            }
            return this.tags != null ? this.tags[1] : null;
        }

        public void setAsText(String text) {
            this.getTags();
            if (this.tags != null) {
                int n = this.tags[0].length;
                for (int i = 0; i < n; ++i) {
                    if (!this.tags[1][i].equals(text)) continue;
                    this.setValue(this.tags[0][i]);
                    return;
                }
            }
            this.setValue(text);
        }

        public String getAsText() {
            Object value = this.getValue();
            this.getTags();
            if (this.tags != null) {
                int n = this.tags[0].length;
                for (int i = 0; i < n; ++i) {
                    if (!this.tags[0][i].equals(value)) continue;
                    return this.tags[1][i];
                }
            }
            return value != null ? value.toString() : null;
        }

        public boolean supportsCustomEditor() {
            return this.getTags() != null;
        }

        public Component getCustomEditor() {
            if (ResourceSupport.this.isI18nAutoMode()) {
                return ResourceSupport.this.i18nService.getCreateLocaleComponent(this, ResourceSupport.this.getSourceFile(), ResourceSupport.this.getI18nBundleName());
            }
            if (ResourceSupport.this.isResourceAutoMode()) {
                return ResourceSupport.this.resourceService.getCreateLocaleComponent(this, ResourceSupport.this.getSourceFile());
            }
            return null;
        }
    }

    private class ModelListener
    implements FormModelListener {
        private ModelListener() {
        }

        public void formChanged(FormModelEvent[] events) {
            if (events == null) {
                return;
            }
            ResourceSupport.this.getI18nService();
            ResourceSupport.this.getResourceService();
            if (ResourceSupport.this.i18nService == null && ResourceSupport.this.resourceService == null) {
                return;
            }
            block10: for (int i = 0; i < events.length; ++i) {
                FormModelEvent ev = events[i];
                switch (ev.getChangeType()) {
                    case 8: {
                        if (!ev.getCreatedDeleted()) continue block10;
                        for (FormProperty prop : ResourceSupport.this.getComponentResourceProperties(ev.getComponent(), 4, true)) {
                            Object value = ResourceSupport.getAutoValue(prop);
                            if (value == null) continue;
                            try {
                                if (value instanceof I18nValue && ResourceSupport.this.i18nService != null) {
                                    ResourceSupport.this.i18nService.update((I18nValue)value, null, ResourceSupport.this.getSrcDataObject(), ResourceSupport.this.getI18nBundleName(), null, true);
                                    continue;
                                }
                                if (!(value instanceof ResourceValue) || ResourceSupport.this.resourceService == null) continue;
                                ResourceSupport.this.resourceService.update((ResourceValue)value, null, ResourceSupport.this.getSourceFile(), null);
                            }
                            catch (IOException ex) {
                                ErrorManager.getDefault().notify(1, (Throwable)ex);
                            }
                        }
                        continue block10;
                    }
                    case 7: {
                        if (!ev.getCreatedDeleted()) continue block10;
                        RADComponent addedComp = ev.getComponent();
                        for (FormProperty prop : ResourceSupport.this.getComponentResourceProperties(addedComp, 4, true)) {
                            try {
                                Object value = prop.getValue();
                                if (value instanceof I18nValue && ResourceSupport.this.i18nService != null) {
                                    ResourceSupport.this.i18nService.update(null, (I18nValue)value, ResourceSupport.this.getSrcDataObject(), ResourceSupport.this.getI18nBundleName(), ResourceSupport.this.designLocale, false);
                                    continue;
                                }
                                if (!(value instanceof ResourceValue) || ResourceSupport.this.resourceService == null) continue;
                                ResourceSupport.this.resourceService.update(null, (ResourceValue)value, ResourceSupport.this.getSourceFile(), ResourceSupport.this.designLocale);
                            }
                            catch (Exception ex) {
                                ErrorManager.getDefault().notify(1, (Throwable)ex);
                            }
                        }
                        if (ResourceSupport.this.getAutoMode() != 3 || addedComp == ResourceSupport.this.formModel.getTopRADComponent()) continue block10;
                        ResourceSupport.setupNameProperty(addedComp, true, true);
                        continue block10;
                    }
                    case 2: {
                        if (ResourceSupport.this.i18nService != null) {
                            ResourceSupport.this.i18nService.autoSave(ResourceSupport.this.getSrcDataObject());
                        }
                        if (ResourceSupport.this.resourceService == null) continue block10;
                        ResourceSupport.this.resourceService.autoSave(ResourceSupport.this.getSourceFile());
                        continue block10;
                    }
                    case 3: {
                        if (ResourceSupport.this.i18nService != null) {
                            ResourceSupport.this.i18nService.close(ResourceSupport.this.getSrcDataObject());
                        }
                        if (ResourceSupport.this.resourceService == null) continue block10;
                        ResourceSupport.this.resourceService.close(ResourceSupport.this.getSourceFile());
                    }
                }
            }
        }
    }
}

