/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class AlignAction
extends NodeAction {
    private JMenuItem[] items;
    private ActionListener menuItemListener;

    protected boolean enable(Node[] nodes) {
        List<RADComponent> comps = FormUtils.getSelectedLayoutComponents(nodes);
        return comps != null && comps.size() > 1;
    }

    public String getName() {
        return NbBundle.getMessage(AlignAction.class, (String)"ACT_Align");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void performAction(Node[] activatedNodes) {
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        JMenu popupMenu = new JMenu(NbBundle.getMessage(AlignAction.class, (String)"ACT_Align"));
        popupMenu.setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)popupMenu, (String)AlignAction.class.getName());
        popupMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                JMenu menu = (JMenu)e.getSource();
                AlignAction.this.createAlignSubmenu(menu);
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
        return popupMenu;
    }

    private void createAlignSubmenu(JMenu menu) {
        Node[] nodes = this.getActivatedNodes();
        List<RADComponent> components = FormUtils.getSelectedLayoutComponents(nodes);
        if (menu.getMenuComponentCount() <= 0) {
            ResourceBundle bundle = NbBundle.getBundle(AlignAction.class);
            AlignMenuItem leftGroupItem = new AlignMenuItem(bundle.getString("CTL_GroupLeft"), components, 0);
            AlignMenuItem rightGroupItem = new AlignMenuItem(bundle.getString("CTL_GroupRight"), components, 1);
            AlignMenuItem centerHGroupItem = new AlignMenuItem(bundle.getString("CTL_GroupHCenter"), components, 2);
            AlignMenuItem upGroupItem = new AlignMenuItem(bundle.getString("CTL_GroupUp"), components, 3);
            AlignMenuItem downGroupItem = new AlignMenuItem(bundle.getString("CTL_GroupDown"), components, 4);
            AlignMenuItem centerVGroupItem = new AlignMenuItem(bundle.getString("CTL_GroupVCenter"), components, 5);
            AlignMenuItem leftItem = new AlignMenuItem(bundle.getString("CTL_AlignLeft"), components, 6);
            AlignMenuItem rightItem = new AlignMenuItem(bundle.getString("CTL_AlignRight"), components, 7);
            AlignMenuItem centerHItem = new AlignMenuItem(bundle.getString("CTL_AlignHCenter"), components, 8);
            AlignMenuItem upItem = new AlignMenuItem(bundle.getString("CTL_AlignUp"), components, 9);
            AlignMenuItem downItem = new AlignMenuItem(bundle.getString("CTL_AlignDown"), components, 10);
            AlignMenuItem centerVItem = new AlignMenuItem(bundle.getString("CTL_AlignVCenter"), components, 11);
            this.items = new JMenuItem[]{leftGroupItem, rightGroupItem, centerHGroupItem, upGroupItem, downGroupItem, centerVGroupItem, leftItem, rightItem, centerHItem, upItem, downItem, centerVItem};
            for (int i = 0; i < this.items.length; ++i) {
                this.items[i].addActionListener(this.getMenuItemListener());
                this.items[i].setEnabled(false);
                HelpCtx.setHelpIDString((JComponent)this.items[i], (String)AlignAction.class.getName());
                menu.add(this.items[i]);
                if (i + 1 != this.items.length / 2) continue;
                menu.addSeparator();
            }
        }
        this.updateState(components);
    }

    private void updateState(List components) {
        if (components == null || components.size() < 2) {
            return;
        }
        RADComponent rc = (RADComponent)components.get(0);
        FormDesigner formDesigner = FormEditor.getFormDesigner(rc.getFormModel());
        Collection col = formDesigner.getDesignerActions(true);
        int n = col.size();
        assert (n == this.items.length / 2);
        Action[] actions = col.toArray(new Action[n]);
        for (int i = 0; i < n; ++i) {
            this.items[i].setEnabled(actions[i].isEnabled());
            this.items[i + n].setEnabled(actions[i].isEnabled());
        }
    }

    private ActionListener getMenuItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new AlignMenuItemListener();
        }
        return this.menuItemListener;
    }

    private static class AlignMenuItem
    extends JMenuItem {
        private int direction;
        private List components;

        AlignMenuItem(String text, List components, int direction) {
            super(text);
            this.components = components;
            this.direction = direction;
        }

        int getDirection() {
            return this.direction;
        }

        List getRADComponents() {
            return this.components;
        }
    }

    private static class AlignMenuItemListener
    implements ActionListener {
        private AlignMenuItemListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (!(source instanceof AlignMenuItem)) {
                return;
            }
            AlignMenuItem mi = (AlignMenuItem)source;
            if (!mi.isEnabled()) {
                return;
            }
            int index = mi.getDirection();
            RADComponent radC = (RADComponent)mi.getRADComponents().get(0);
            FormModel fm = radC.getFormModel();
            FormDesigner fd = FormEditor.getFormDesigner(fm);
            ((Action)fd.getDesignerActions(false).toArray()[index]).actionPerformed(evt);
        }
    }
}

