/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.modules.form.BindingCustomizer;
import org.netbeans.modules.form.BindingProperty;
import org.netbeans.modules.form.MetaBinding;
import org.netbeans.modules.form.RADComponentCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CookieAction;

public class BindAction
extends CookieAction {
    protected int mode() {
        return 8;
    }

    protected Class[] cookieClasses() {
        return new Class[]{RADComponentCookie.class};
    }

    public String getName() {
        return "Bind";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void performAction(Node[] activatedNodes) {
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        JMenu popupMenu = new JMenu("Bind");
        popupMenu.setEnabled(this.isEnabled());
        popupMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                JMenu menu = (JMenu)e.getSource();
                BindAction.this.createBindingsSubmenu(menu);
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
        return popupMenu;
    }

    private void createBindingsSubmenu(JMenu menu) {
        BindingProperty[][] bindingProps;
        Node[] nodes;
        if (menu.getMenuComponentCount() > 0) {
            menu.removeAll();
        }
        if ((nodes = this.getActivatedNodes()).length != 1) {
            return;
        }
        RADComponentCookie radCookie = (RADComponentCookie)nodes[0].getCookie(RADComponentCookie.class);
        if (radCookie == null) {
            return;
        }
        BindingProperty[] props = bindingProps[(bindingProps = radCookie.getRADComponent().getBindingProperties())[0].length == 0 ? 1 : 0];
        if (props.length > 0) {
            for (BindingProperty prop : props) {
                BindingMenuItem mi = new BindingMenuItem(prop);
                mi.addActionListener(mi);
                menu.add(mi);
            }
        } else {
            menu.setEnabled(false);
        }
    }

    private static class BindingMenuItem
    extends JMenuItem
    implements ActionListener {
        private BindingProperty bindingProperty;

        private BindingMenuItem(BindingProperty prop) {
            this.bindingProperty = prop;
            this.setText(prop.getDisplayName());
            this.updateFont();
        }

        private void updateFont() {
            Font font = this.getFont();
            if (this.bindingProperty.getValue() != null) {
                this.setFont(font.deriveFont(font.getStyle() | 1));
            } else {
                this.setFont(font.deriveFont(font.getStyle() & 0xFFFFFFFE));
            }
        }

        public void actionPerformed(ActionEvent ev) {
            MetaBinding binding = (MetaBinding)this.bindingProperty.getValue();
            final BindingCustomizer customizer = new BindingCustomizer(this.bindingProperty);
            customizer.setBinding(binding);
            customizer.getDialog(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    BindingMenuItem.this.bindingProperty.setValue(customizer.getBinding());
                    BindingMenuItem.this.updateFont();
                }
            }).setVisible(true);
        }
    }
}

